//
//  HWMInputInfoTitleCell.h
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/27.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "HWMLoginInputInfoModel.h"
#import "HWMFormatter.h"
NS_ASSUME_NONNULL_BEGIN

@protocol HWMInputInfoTitleCellDelegate <NSObject>

- (void)inputInfoCellDidEdite:(NSString *)content index:(NSInteger)index;

@end

@interface HWMInputInfoTitleCell : NSTableCellView

+ (instancetype)inputInfoTitleCell:(NSTableView *)tableView ower:(id)ower;

/// 下标
@property (nonatomic, assign) NSInteger index;
/// model
@property (nonatomic, strong) HWMLoginInputInfoModel *model;
/// title
@property (nonatomic, copy) NSString *title;
/// placeholder
@property (nonatomic, copy) NSString *placeholder;
@property (nonatomic, copy) NSString *content;
/// 代理
@property (nonatomic, weak) id<HWMInputInfoTitleCellDelegate> delegate;

@property (nonatomic, assign) BOOL enabled;

@property (nonatomic, assign) HWMFormatterStyle formatterStyle;

@end

NS_ASSUME_NONNULL_END
