//
//  HWMMainPageViewController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/24.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMMainPageViewController.h"
#import "HWMConsoleView.h"
#import "HWMFunctionListView.h"
#import "HWMMainPageNavigationView.h"
#import "HWMNavigationController.h"

@interface HWMMainPageViewController ()
/// 控制台
@property (nonatomic, strong) HWMConsoleView *consoleView;
/// 功能列表
@property (nonatomic, strong) HWMFunctionListView *listView;
/// 导航
@property (nonatomic, strong) HWMMainPageNavigationView *navigationView;
/// 内容
@property (nonatomic, strong) NSView *contentView;
/// 正在展示的View
@property (nonatomic, strong) NSView *selectedView;

@end

@implementation HWMMainPageViewController

- (void)loadView {
    self.view = [[NSView alloc] initWithFrame:NSMakeRect(0, 0, 900, 680)];
    self.view.wantsLayer = YES;
    self.view.layer.backgroundColor = [NSColor colorWithRGB:0xF3F5F9].CGColor;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
    [self setupChildControllers];
    [self setupChildView];
}

- (void)dealloc {
}

#pragma mark - UI

- (void)setupUI {
    [self.view addSubview:self.consoleView];
    [self.view addSubview:self.listView];
    [self.view addSubview:self.contentView];

    [self.consoleView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.and.trailing.and.bottom.equalTo(self.view);
        make.height.mas_equalTo(200);
    }];

    [self.listView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.view);
        make.top.equalTo(self.view);
        make.bottom.equalTo(self.consoleView.mas_top);
        make.width.mas_equalTo(240);
    }];

    [self.contentView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.listView.mas_trailing).offset(5);
        make.top.equalTo(self.view).offset(5);
        make.trailing.equalTo(self.view).offset(-5);
        make.bottom.equalTo(self.consoleView.mas_top).offset(-5);
    }];
}

- (void)setupChildControllers {
    NSArray *childVCArr = @[@"HWMInitViewController",
                            @"HWMLoginViewController",
                            @"HWMLoginIdViewController",
                            @"HWMLoginBySSOViewController",
                            @"HWMLoginByNonceViewController",
                            @"HWMCreateConfViewController",
                            @"HWMJoinConfViewController",
                            @"HWMJoinConfByLinkViewController",
                            @"HWMJoinConfByNonceViewController",
                            @"HWMLoginOutController",
                            @"HWMBookConfViewController",
                            @"HWMBookCycleConfViewController",
                            @"HWMConfListViewController",
                            @"HWMVrmListViewController",
                            @"HWMLeaveConfController",
                            @"HWMSetHeaderViewController",
                            @"HWMAddAttendeesController",
                            @"HWMAttendeeListInjectController",
                            @"HWMIncomingCallAnswerViewController",
                            @"HWMGlobalConfigController",
                            @"HWMUserStateController",
                            @"HWMToolBarItemConfigController",
                            @"HWMGetAttendeeListController",
                            @"HWMHwndInfoListController",
                            @"HWMWaterMarkController",
                            @"HWMSettingConfigController",
                            @"HWMSDKCapabilityController",
                            @"HWMContactInfoController",
                            @"HWMVirtualBackgroundConfigController",
                            @"HWMSetConfMuteController",
                            @"HWMSetConfBarMenuController",
                            @"HWMSetConfInfoController",
                            @"HWMStartP2PConfController",
                            @"HWMStartProjectionController",
                            @"HWMSetAVDeviceController",
                            @"HWMGeneralWatchController",
                            @"HWMToastAndMainViewSizeController",
                            @"HWMInterruptShareController",
                            @"HWMConfCtrlViewController"
    ];

    for (NSString *name in childVCArr) {
        [self createChildController:name];
    }
}

- (void)createChildController:(NSString *)childVCName {
    Class childClass = NSClassFromString(childVCName);
    NSViewController *childVC = [childClass new];
    HWMNavigationController *nav = [[HWMNavigationController alloc] initWithRootViewController:childVC];
    [self addChildViewController:nav];
}

- (void)setupChildView {
    NSView *childView = self.childViewControllers.firstObject.view;
    [self.contentView addSubview:childView];
    [childView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.contentView);
    }];
}

#pragma mark - Event
- (void)updateContentViewWithFunctionType:(HWMFunctionType)type {
    NSView *displayView = self.childViewControllers[type].view;
    if ([self.contentView.subviews containsObject:displayView]) {
        displayView.hidden = NO;
    }else {
        [self.contentView addSubview:displayView];
        [displayView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.equalTo(self.contentView);
        }];
    }
    self.selectedView.hidden = YES;
    self.selectedView = displayView;
}

#pragma mark - Lazy

- (HWMConsoleView *)consoleView {
    if (!_consoleView) {
        _consoleView = [[HWMConsoleView alloc] init];
    }
    return _consoleView;
}

- (HWMFunctionListView *)listView {
    if (!_listView) {
        _listView = [[HWMFunctionListView alloc] init];
        @weakify(self)
        [_listView setFunctionSelectTypeHandler:^(HWMFunctionType type) {
            @strongify(self);
            [self updateContentViewWithFunctionType:type];
        }];
    }
    return _listView;
}

- (HWMMainPageNavigationView *)navigationView {
    if (!_navigationView) {
        _navigationView = [[HWMMainPageNavigationView alloc] init];
    }
    return _navigationView;
}

- (NSView *)contentView {
    if (!_contentView) {
        _contentView = [[NSView alloc] init];
        _contentView.wantsLayer = YES;
        _contentView.layer.backgroundColor = [NSColor whiteColor].CGColor;
        _contentView.layer.cornerRadius = 8.0;
        _contentView.layer.masksToBounds = YES;
        _contentView.layer.borderColor = [NSColor colorWithRGB:0xEEEEEE].CGColor;
        _contentView.layer.borderWidth = 1.0;
    }
    return _contentView;
}

@end
