//
//  HWMMainPageWindowController.m
//  HWMUISDKNativeDemo
//
//  Created by HuLinjie on 2020/10/21.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMMainPageWindowController.h"
#import "HWMMainPageViewController.h"

@interface HWMMainPageWindowController ()
///window
@property (nonatomic, strong) NSWindow *defaultWindow;
@end

@implementation HWMMainPageWindowController

- (void)windowDidLoad {
    [super windowDidLoad];

    // Implement this method to handle any initialization after your window controller's window has been loaded from its nib file.
}

- (NSWindow *)createDefaultWindow {
    if (self.defaultWindow) {
        return self.defaultWindow;
    }
    NSWindowStyleMask style = NSWindowStyleMaskBorderless | NSWindowStyleMaskTitled  | NSWindowStyleMaskClosable | NSWindowStyleMaskMiniaturizable;
    NSWindow *defaultWindow = [[NSWindow alloc]initWithContentRect:CGRectZero styleMask:style backing:NSBackingStoreBuffered defer:YES];
    HWMMainPageViewController *viewController = [[HWMMainPageViewController alloc] init];
    defaultWindow.contentViewController = viewController;
    defaultWindow.title = @"HWMUI SDK Demo";
    defaultWindow.titlebarAppearsTransparent = YES;
    defaultWindow.releasedWhenClosed = YES;
    [defaultWindow setTitleVisibility:(NSWindowTitleHidden)];
    [defaultWindow center];
    self.defaultWindow = defaultWindow;
    return self.defaultWindow;
}

@end
