//
//  HWMFunctionListView.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/24.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMFunctionListView.h"
#import "HWMFunctionListCell.h"

@interface HWMFunctionListView ()<NSTableViewDelegate, NSTableViewDataSource>

/// 列表
@property (nonatomic, strong) NSTableView *listView;
/// 滚动视图
@property (nonatomic, strong) NSScrollView *scrollView;
/// data
@property (nonatomic, strong) NSMutableArray *dataArr;
/// 选中的cell
@property (nonatomic, strong) HWMFunctionModel *selectModel;

@end

@implementation HWMFunctionListView

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        [self setupData];
        [self setupUI];
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];
    
    // Drawing code here.
}

#pragma mark - Data
- (void)setupData {
    NSArray *titles = @[@"初始化(使用所有功能前必须初始化)",
                        @"登录",
                        @"APPID登录",
                        @"SSO登录",
                        @"nonce登录",
                        @"创建会议",
                        @"加入会议",
                        @"链接入会",
                        @"nonce入会",
                        @"登出",
                        @"预约会议",
                        @"预约周期会议",
                        @"会议列表",
                        @"虚拟会议室列表",
                        @"离开会议",
                        @"设置头像",
                        @"添加与会者",
                        @"与会者列表注入",
                        @"来电接听策略",
                        @"全局配置",
                        @"用户状态",
                        @"会控栏按钮配置",
                        @"获取与会者列表",
                        @"获取窗口句柄列表",
                        @"自定义水印",
                        @"会议设置配置",
                        @"开启特性支持",
                        @"通讯录注入",
                        @"虚拟背景配置",
                        @"MMR会议会中静音设置",
                        @"会中录制bar定制",
                        @"会中会议信息页面定制",
                        @"立即会议",
                        @"发起投屏",
                        @"音视频设备设置",
                        @"视频窗口",
                        @"toast和获取主窗口大小",
                        @"拦截共享",
                        @"会控接口"
    ];
    self.dataArr = @[].mutableCopy;
    for (NSInteger i = 0; i < titles.count; i++) {
        HWMFunctionModel *model = [[HWMFunctionModel alloc] init];
        model.name = titles[i];
        model.type = i;
        if (i == 0) {
            model.selected = YES;
            self.selectModel = model;
        }
        [self.dataArr addObject:model];
    }
}

#pragma mark - UI
- (void)setupUI {
    self.wantsLayer = YES;
    self.layer.backgroundColor = [NSColor whiteColor].CGColor;
    
    self.scrollView = [[NSScrollView alloc] init];
    [self.scrollView setHasVerticalScroller:YES];
    [self.scrollView setHasHorizontalScroller:NO];
    [self.scrollView setBorderType:NSNoBorder];
    [self.scrollView setDrawsBackground:NO];
    [self.scrollView setAutohidesScrollers:YES];
    [self.scrollView setHorizontalScrollElasticity:NSScrollElasticityNone];
    [self.scrollView setVerticalScrollElasticity:NSScrollElasticityNone];
    [self addSubview:self.scrollView];
    
    self.listView = [[NSTableView alloc] init];
    self.listView.autoresizingMask = YES;
    self.listView.delegate = self;
    self.listView.dataSource = self;
    self.listView.backgroundColor = [NSColor whiteColor];
    self.listView.selectionHighlightStyle = NSTableViewSelectionHighlightStyleNone;
    NSTableHeaderView *headerView = [[NSTableHeaderView alloc] initWithFrame:NSZeroRect];
    self.listView.headerView = headerView;
    NSTableColumn *colum = [[NSTableColumn alloc] initWithIdentifier:@"FunctionListColum"];
    [self.listView addTableColumn:colum];
    
    self.scrollView.documentView = self.listView;
    
    [self.scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self);
    }];
}

#pragma mark - Delegate & Datasource

- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return self.dataArr.count;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    
    HWMFunctionListCell *cell = [tableView makeViewWithIdentifier:NSStringFromClass([HWMFunctionListCell class]) owner:self];
    if (!cell) {
        cell = [[HWMFunctionListCell alloc] initWithFrame:NSMakeRect(0, 0, tableView.frame.size.width, 50.0)];
        cell.identifier = NSStringFromClass([HWMFunctionListCell class]);
    }
    cell.model = self.dataArr[row];
    @weakify(self)
    [cell setFunctionClickDownHandler:^(HWMFunctionModel * _Nonnull model) {
        @strongify(self)
        if (!model.isSelected) {
            model.selected = !model.selected;
            self.selectModel.selected = NO;
            self.selectModel = model;
            [self.listView reloadData];
            if (self.functionSelectTypeHandler) {
                self.functionSelectTypeHandler(model.type);
            }
        }
    }];
    return cell;
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    
    return 50;
}

@end
