//
//  NSButton+HWMExtension.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/26.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "NSButton+HWMExtension.h"

@implementation NSButton (HWMExtension)

+ (instancetype)buttonWithTitle:(NSString *)title font:(NSFont *)font fontColor:(NSColor * _Nullable)color target:(id)target action:(SEL)action {
    NSMutableAttributedString *att = [[NSMutableAttributedString alloc] initWithString:title];
    NSFont *tmpFont = font ? font : [NSFont systemFontOfSize:13];
    NSMutableParagraphStyle *paraStyle = [[NSMutableParagraphStyle alloc] init];
    paraStyle.alignment = NSTextAlignmentCenter;
    [att addAttributes:@{NSFontAttributeName : tmpFont, NSForegroundColorAttributeName : color, NSParagraphStyleAttributeName : paraStyle} range:NSMakeRange(0, title.length)];
    NSButton *button = [self new];
    button.bordered = NO;
    button.alignment = NSTextAlignmentCenter;
    button.attributedTitle = att;
    button.target = target;
    button.action = action;
    button.wantsLayer = YES;
    button.bezelStyle = NSBezelStyleTexturedSquare;
    button.buttonType = NSButtonTypeMomentaryPushIn;
    button.focusRingType = NSFocusRingTypeNone;
    return button;
}

+ (instancetype)buttonWithTitle:(NSString *)title target:(id)target action:(SEL)action stateValueOn:(BOOL)state {
    NSButton * button = [self new];
    button = [[NSButton alloc] init];
    button.bordered = NO;
    button.font = [NSFont systemFontOfSize:12];
    button.bezelStyle = NSBezelStyleRegularSquare;
    button.state = state ? NSControlStateValueOn : NSControlStateValueOff;
    [button setButtonType:NSButtonTypeRadio];
    [button setTitle:title];
    button.target = target;
    button.action =action;
    return button;
}

@end
