/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
 * @file cmvp_check_randomness.h
 * Description: 随机数随机性检测头文件
 * Author: Hisec-ICT TLS
 * Create: 2024-02-20
 */

#ifndef OPENSSL_CMVP_CHECK_RANDOMNESS_H
# define OPENSSL_CMVP_CHECK_RANDOMNESS_H
#ifdef OPENSSL_PRAGMA_ONCE
# pragma once
#endif

# ifndef OPENSSL_NO_GM_CMVP
#include <openssl/e_os2.h>
#  ifdef  __cplusplus
extern "C" {
#  endif

#   define CMVP_RANDOMNESS_OP_BIT(n)  ((uint64_t)1 << (uint64_t)n)

#   define CMVP_NO_POKER_CHECK CMVP_RANDOMNESS_OP_BIT(0)
#   define CMVP_NO_MONOBIT_CHECK CMVP_RANDOMNESS_OP_BIT(1)

int CMVP_randomness_check(const uint8_t *data, uint32_t len, uint64_t options);

#  ifdef  __cplusplus
}
#  endif

# endif /* OPENSSL_NO_GM_CMVP */
#endif
