/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
 * @file cmvp_gm.h
 * Description: 国密自检头文件
 * Author: Hisec-ICT TLS
 * Create: 2024-02-20
 */

#ifndef OPENSSL_CMVP_H
# define OPENSSL_CMVP_H
#ifdef OPENSSL_PRAGMA_ONCE
# pragma once
#endif

# ifndef OPENSSL_NO_GM_CMVP
#include <openssl/e_os2.h>
#  ifdef  __cplusplus
extern "C" {
#  endif

#define CMVP_SM2_SELF_CHECK_ERROR (1 << 1)
#define CMVP_SM3_SELF_CHECK_ERROR (1 << 2)
#define CMVP_SM4_SELE_CHECK_ERROR (1 << 3)
#define CMVP_DRBG_SELE_CHECK_ERROR (1 << 4)
#define CMVP_MAC_SELE_CHECK_ERROR (1 << 5)
#define CMVP_KDF_SELE_CHECK_ERROR (1 << 6)

int CMVP_gm_cipher_self_check(void);
int CMVP_gm_asym_self_check(void);
int CMVP_gm_digest_self_check(void);
int CMVP_gm_kdf_self_check(void);
int CMVP_gm_mac_self_check(void);
int CMVP_gm_drbg_self_check(void);
int CMVP_gm_self_check(void);
int CMVP_keypair_consistency_check(void);

#  ifdef  __cplusplus
}
#  endif

# endif /* OPENSSL_NO_GM_CMVP */
#endif
