﻿// OperateLocalRecord.cpp: 实现文件
//

#include "stdafx.h"
#include "OperateLocalRecord.h"
#include "afxdialogex.h"
#include "demo.h"
#include "demoTools.h"
#include "HwmSdkAgent.h"


// OperateLocalRecord 对话框

IMPLEMENT_DYNAMIC(OperateLocalRecord, CDialogEx)

OperateLocalRecord::OperateLocalRecord(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_OPERATE_LOCAL_RECORD_DIALOG, pParent)
{

}

OperateLocalRecord::~OperateLocalRecord()
{
}

void OperateLocalRecord::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_COMBO_OPERATE_TYPE, m_operateTypeCombo);
}

BOOL OperateLocalRecord::OnInitDialog()
{
    CDialog::OnInitDialog();

    m_operateTypeCombo.SetWindowText(_T("start"));
    m_operateTypeCombo.InsertString(0, _T("start"));
    m_operateTypeCombo.InsertString(1, _T("stop"));
    m_operateTypeCombo.InsertString(2, _T("pause"));
    m_operateTypeCombo.InsertString(3, _T("resume"));

    return TRUE;
}

int OperateLocalRecord::ClickOperateLocalRecord()
{
    hwmsdkagent::HwmLocalRecordOperateType type = hwmsdkagent::HwmLocalRecordOperateType::LOCAL_RECORD_OPERATE_TYPE_START;
    CString strOperateType;
    m_operateTypeCombo.GetWindowText(strOperateType);
    if (_T("stop") == strOperateType)
    {
        type = hwmsdkagent::HwmLocalRecordOperateType::LOCAL_RECORD_OPERATE_TYPE_STOP;
    }
    else if (_T("pause") == strOperateType)
    {
        type = hwmsdkagent::HwmLocalRecordOperateType::LOCAL_RECORD_OPERATE_TYPE_PAUSE;
    }
    else if (_T("resume") == strOperateType)
    {
        type = hwmsdkagent::HwmLocalRecordOperateType::LOCAL_RECORD_OPERATE_TYPE_RESUME;
    }

    int ret = hwmsdkagent::OperateLocalRecord(type);
    return ret;
}

void OperateLocalRecord::OnBnClickedOk()
{
    int ret = ClickOperateLocalRecord();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("OperateLocalRecord error");
        return;
    }
    CDialogEx::OnOK();
}


BEGIN_MESSAGE_MAP(OperateLocalRecord, CDialogEx)
    ON_BN_CLICKED(IDOK, &OperateLocalRecord::OnBnClickedOk)
END_MESSAGE_MAP()


// OperateLocalRecord 消息处理程序
