﻿// demoBookConfDlg.cpp: 实现文件
//

#include "stdafx.h"
#include "demo.h"
#include "demoBookConfDlg.h"
#include "afxdialogex.h"
#include "demoAddCycleConf.h"
#include "demoData.h"
#include "HwmSdkAgent.h"
#include "demoTools.h"
#include "demoCustomMessage.h"

// demoBookConfDlg 对话框


IMPLEMENT_DYNAMIC(demoBookConfDlg, CDialogEx)

demoBookConfDlg::demoBookConfDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_BOOK_CONF_WITH_ATTENDEE_DIALOG, pParent)
    , m_cycleConfParam{0}
    , m_customInfo(_T(""))
{

}

demoBookConfDlg::~demoBookConfDlg()
{
}

void demoBookConfDlg::OnBnClickedCancel()
{
    CDialogEx::OnCancel();
}

void demoBookConfDlg::OnBnClickedOk()
{
    CTime beginDate;
    m_confStartDateCtrl.GetTime(beginDate);
    CTime beginTime;
    m_confStartTimeCtrl.GetTime(beginTime);
    CTime confStart(beginDate.GetYear(), beginDate.GetMonth(), beginDate.GetDay(), beginTime.GetHour(), beginTime.GetMinute(), 0);
    const auto now = time(nullptr);
    if (now > confStart.GetTime() && (m_conferenceType.GetCurSel() == 0))
    {
        AfxMessageBox(_T("conference start time earlier than now!"));
        return;
    }

    UpdateData(1);
    int ret = BookConf();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        AfxMessageBox(_T("book conference error"));
        return;
    }
    CDialogEx::OnOK();
}

void demoBookConfDlg::OnBnClickedAddAttendee()
{
    bool isAddSuc = m_addAttendeeLogic.AddAttendee();
    if (isAddSuc)
    {
        fillAttendees();
    }
}

void demoBookConfDlg::OnBnClickedDeleteAttendee()
{
    CString input;
    m_editDeleteAttendee.GetWindowText(input);
    bool isDeleteSuc = m_addAttendeeLogic.DeleteAttendee(input);
    if (isDeleteSuc)
    {
        fillAttendees();
    }
}

void demoBookConfDlg::OnComboConfIdTypeChange()
{
    int select = m_confIdTypeCtrl.GetCurSel();
    if(select > 0)
    {
        if (select - 1 < vmrList.size())
        {
            if (strlen(vmrList[select - 1].guestPwd) > 0)
            {
                m_confPassEdit.SetWindowTextW(CTools::UTF2UNICODE(vmrList[select - 1].guestPwd).c_str());
            }
            else
            {
                m_confPassEdit.SetWindowText(_T("no guest pass"));
            }
            // 不为随机Id的时候才需要赋值
            if (m_vmrConfIdTypeCtrl.GetCurSel() != 1)
            {
                hwmsdkagent::HwmJoinConfPermissionType joinConfRestrictionType = vmrList[select - 1].joinConfRestrictionType;
                if (joinConfRestrictionType == 0)
                {
                    m_confAdmissionCtrl.SetCurSel(0);
                }
                else
                {
                    m_confAdmissionCtrl.SetCurSel(joinConfRestrictionType - 1);
                }
                m_openWaitingRoomCheck.SetCheck(vmrList[select - 1].isOpenWaitingRoom);
            }
            
            if (vmrList[select - 1].type == hwmsdkagent::HwmVmrIdType::CLOUD_MEETING_ROOM_ID) // 云会议室
            {
                m_needPasswordCheck.EnableWindow(1);
                m_vmrConfIdTypeCtrl.EnableWindow(1);
                m_allowGuestBeforeJoinTimeCtrl.EnableWindow(1);

                auto vmrIdConfIdTypeselect = m_vmrConfIdTypeCtrl.GetCurSel();
                if (vmrIdConfIdTypeselect == 1)
                {
                    // 随机id
                    m_confPassEdit.SetWindowText(_T("random guest pass"));
                    m_confPassEdit.EnableWindow(1);
                    m_allowGuestBeforeJoinTimeCtrl.EnableWindow(1);

                }
                else
                {
                    // 固定id
                    m_confPassEdit.EnableWindow(0);
                    m_allowGuestBeforeJoinTimeCtrl.EnableWindow(0);
                }
            }
            else // 个人会议室
            {
                m_needPasswordCheck.EnableWindow(0);
                m_vmrConfIdTypeCtrl.EnableWindow(0);
                m_confPassEdit.EnableWindow(0);
                m_allowGuestBeforeJoinTimeCtrl.EnableWindow(0);
                m_allowGuestBeforeJoinTimeCtrl.SetCurSel(0);
            }
        }
        else
        {
            // 共享vmr
            m_confPassEdit.SetWindowText(_T("random guest pass"));
            m_needPasswordCheck.EnableWindow(1);
            m_confPassEdit.EnableWindow(1);
            m_vmrConfIdTypeCtrl.SetCurSel(1);
            m_vmrConfIdTypeCtrl.EnableWindow(0);
            m_allowGuestBeforeJoinTimeCtrl.EnableWindow(m_allowGuestbeforeJoinCheckBox.GetCheck() == 1);
            return;
        }
    }
    else
    {
        m_confPassEdit.SetWindowText(_T("random guest pass"));
        m_needPasswordCheck.EnableWindow(1);
        m_confPassEdit.EnableWindow(1);
        m_vmrConfIdTypeCtrl.EnableWindow(0);
        m_allowGuestBeforeJoinTimeCtrl.EnableWindow(m_allowGuestbeforeJoinCheckBox.GetCheck() == 1);
    }

    // 会议类型变动,则vmrConfIdType重置成固定id
    m_vmrConfIdTypeCtrl.SetCurSel(0);
}

void demoBookConfDlg::OnComboVmrConfIdTypeChange()
{
    int select = m_confIdTypeCtrl.GetCurSel();
    if (select > 0)
    {
        if (select - 1 < vmrList.size())
        {
            if (strlen(vmrList[select - 1].guestPwd) > 0)
            {
                m_confPassEdit.SetWindowTextW(CTools::UTF2UNICODE(vmrList[select - 1].guestPwd).c_str());
            }
            else
            {
                m_confPassEdit.SetWindowText(_T("no guest pass"));
            }

            // 不为随机Id的时候才需要赋值
            if (m_vmrConfIdTypeCtrl.GetCurSel() != 1)
            {
                hwmsdkagent::HwmJoinConfPermissionType joinConfRestrictionType = vmrList[select - 1].joinConfRestrictionType;
                if (joinConfRestrictionType == 0)
                {
                    m_confAdmissionCtrl.SetCurSel(0);
                }
                else
                {
                    m_confAdmissionCtrl.SetCurSel(joinConfRestrictionType - 1);
                }
                m_openWaitingRoomCheck.SetCheck(vmrList[select - 1].isOpenWaitingRoom);
            }
        }


        auto vmrIdConfIdTypeselect = m_vmrConfIdTypeCtrl.GetCurSel();
        if (vmrIdConfIdTypeselect == 1)
        {
            // 随机id
            m_confPassEdit.SetWindowText(_T("random guest pass"));
            m_confPassEdit.EnableWindow(1);
            m_allowGuestBeforeJoinTimeCtrl.EnableWindow(1);

        }
        else
        {
            // 固定id
            m_confPassEdit.EnableWindow(0);
            m_allowGuestBeforeJoinTimeCtrl.EnableWindow(0);
        }
    }
}

LRESULT demoBookConfDlg::OnVmrList(WPARAM wparam, LPARAM lparam)
{
    vmrList = demoData::GetInstance().GetVmrList();
    m_confIdTypeCtrl.ResetContent();
    int i = 0;
    m_confIdTypeCtrl.InsertString(0, _T("随机会议id"));
    m_confPassEdit.SetWindowText(_T("random guest pass"));
    if(!vmrList.empty())
    {
        m_confIdTypeCtrl.InsertString(1, _T("个人会议id"));
    }
    for (int i = 1; i < vmrList.size(); i++)
    {
        const auto text = CTools::UTF2UNICODE(std::string(vmrList[i].name) + "(" + std::to_string(vmrList[i].maxParties) + ") " 
            + std::string(vmrList[i].vmrConferenceId));
        m_confIdTypeCtrl.InsertString(i + 1, text.c_str());
        m_allowGuestbeforeJoinCheckBox.SetCheck(vmrList[i].allowGuestStartConf);
    }
    // 共享云会议室
    if (demoData::GetInstance().GetIsEnableShareVmr())
    {
        m_confIdTypeCtrl.InsertString(vmrList.size() + 1, _T("共享云会议室"));
    }
    m_confIdTypeCtrl.SetCurSel(0);
    return 0;
}

BOOL demoBookConfDlg::OnInitDialog()
{
    const auto ret = CDialogEx::OnInitDialog();

    m_conferenceType.InsertString(0, _T("common conf"));
    m_conferenceType.InsertString(1, _T("cycle conf"));
    m_conferenceType.SetCurSel(0);

    m_confTypeCombo.InsertString(0, _T("Video"));
    m_confTypeCombo.InsertString(1, _T("Audio"));
    m_confTypeCombo.SetCurSel(0);
    m_confSubjectEdit.SetWindowText(_T("默认会议主题"));
    m_conCurrentParticipantsEdit.SetWindowText(_T("0"));
    const auto &timeZoneList = demoData::GetInstance().GetTimeZoneList();
    for (int i = 0; i < timeZoneList.size(); i++)
    {
        m_timeZoneCtrl.InsertString(i, CTools::UTF2UNICODE(timeZoneList[i].first).c_str());
    }
    m_timeZoneCtrl.SetCurSel(55);
    
    for (int i = 0; i < 24; i ++)
    {
        CString item;
        item.Format(_T("%d小时"), i);
        m_durationHourCtrl.InsertString(i, item);
    }
    m_durationHourCtrl.SetCurSel(0);

    m_durationMinuteCtrl.InsertString(0, _T("0分钟"));
    m_durationMinuteCtrl.InsertString(1, _T("15分钟"));
    m_durationMinuteCtrl.InsertString(2, _T("30分钟"));
    m_durationMinuteCtrl.InsertString(3, _T("45分钟"));
    m_durationMinuteCtrl.SetCurSel(2);

    m_confAdmissionCtrl.InsertString(0, _T("所有用户"));
    m_confAdmissionCtrl.InsertString(1, _T("企业内部"));
    m_confAdmissionCtrl.InsertString(2, _T("仅被邀请的人"));
    m_confAdmissionCtrl.SetCurSel(0);

    m_confIdTypeCtrl.InsertString(0, _T("随机会议id"));
    m_confIdTypeCtrl.SetCurSel(0);

    // 云会议室id类型默认是固定id,vmr默认不是云会议室,所以这个id类型选择框置灰
    m_vmrConfIdTypeCtrl.InsertString(0, _T("固定id"));
    m_vmrConfIdTypeCtrl.InsertString(1, _T("随机id"));
    m_vmrConfIdTypeCtrl.SetCurSel(0);
    m_vmrConfIdTypeCtrl.EnableWindow(0);

    m_allowGuestbeforeJoinCheckBox.SetCheck(1);
    m_allowGuestBeforeJoinTimeCtrl.InsertString(0, _T("任何时间"));
    m_allowGuestBeforeJoinTimeCtrl.InsertString(1, _T("5分钟"));
    m_allowGuestBeforeJoinTimeCtrl.InsertString(2, _T("10分钟"));
    m_allowGuestBeforeJoinTimeCtrl.InsertString(3, _T("15分钟"));
    m_allowGuestBeforeJoinTimeCtrl.InsertString(4, _T("30分钟"));
    m_allowGuestBeforeJoinTimeCtrl.SetCurSel(0);

    m_softTerminalAutoMuteCtrl.InsertString(0, _T("Default"));
    m_softTerminalAutoMuteCtrl.InsertString(1, _T("Mute"));
    m_softTerminalAutoMuteCtrl.InsertString(2, _T("UnMute"));
    m_softTerminalAutoMuteCtrl.SetCurSel(0);
    m_hardTerminalAutoMuteCtrl.InsertString(0, _T("Default"));
    m_hardTerminalAutoMuteCtrl.InsertString(1, _T("Mute"));
    m_hardTerminalAutoMuteCtrl.InsertString(2, _T("UnMute"));
    m_hardTerminalAutoMuteCtrl.SetCurSel(0);

    if (!demoData::GetInstance().HasRecordPermission())
    {
        m_isAutoRecordCheck.EnableWindow(0);
		m_allowRecordCheck.EnableWindow(0);
    }
    m_autoPublishSummary.SetCheck(1);
    if (!demoData::GetInstance().GetCorpEnableSummary())
    {
        m_defaultSummaryState.EnableWindow(0);
        m_autoPublishSummary.EnableWindow(0);
    }
    if (!demoData::GetInstance().IsSmsEnable())
    {
        m_sendMsgCheck.EnableWindow(0);
    }

    hwmsdkagent::GetVmrList();
    demoData::GetInstance().subscribeVmrList(m_hWnd);

    //时间延迟10分钟方便测试
    CTime startTime = CTime::GetCurrentTime() + (10 * 60);
    m_confStartDateCtrl.SetTime(&startTime);
    m_confStartTimeCtrl.SetTime(&startTime);
	m_confPassEdit.SetLimitText(16);
    return ret;
}

void demoBookConfDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);

    DDX_Control(pDX, IDC_EDIT_BOOK_MEETING_WITH_MEMBERS_SUBJECT, m_confSubjectEdit);
    DDX_Control(pDX, IDC_COMBO_BOOK_MEETING_WITH_MEMBERS_TYPE, m_confTypeCombo);
    DDX_Control(pDX, IDC_EDIT_BOOK_MEETING_ATTENDEE_LIST, m_attendeesEdit);
    DDX_Control(pDX, IDC_CHECK_BOOK_MEETING_WITH_MEMBERS_NEED_PASSWORD, m_needPasswordCheck);
    DDX_Control(pDX, IDC_CHECK_BOOK_CONF_IS_AUTORECORD, m_isAutoRecordCheck);
    DDX_Control(pDX, IDC_CHECK_BOOK_CONF_DEFAULT_SUMMARY_STATE, m_defaultSummaryState);
    DDX_Control(pDX, IDC_CHECK_BOOK_CONF_AUTO_PUBLISH_SUMMARY, m_autoPublishSummary);
    DDX_Control(pDX, IDC_CHECK_BOOK_CONF_ALLOW_RECORD, m_allowRecordCheck);
    DDX_Control(pDX, IDC_DATE_BOOK_MEETING_START_TIME, m_confStartDateCtrl);
    DDX_Control(pDX, IDC_TIME_BOOK_MEETING_START_TIME, m_confStartTimeCtrl);
    DDX_Control(pDX, IDC_COMBO_BOOK_MEETING_TIME_ZONE, m_timeZoneCtrl);
    DDX_Control(pDX, IDC_COMBO_BOOK_MEETING_DURATION_HOUR, m_durationHourCtrl);
    DDX_Control(pDX, IDC_COMBO_BOOK_MEETING_DURATION_MINUTE, m_durationMinuteCtrl);
    DDX_Control(pDX, IDC_COMBO_BOOK_CONF_CONF_ID_TYPE, m_confIdTypeCtrl);
    DDX_Control(pDX, IDC_COMBO_VMR_CONF_ID_TYPE, m_vmrConfIdTypeCtrl);
    DDX_Control(pDX, IDC_COMBO_BOOK_MEETING_ADMISSION, m_confAdmissionCtrl);
    DDX_Control(pDX, IDC_CHECK_BOOK_MEETING_SEND_MESSAGE, m_sendMsgCheck);
    DDX_Control(pDX, IDC_CHECK_BOOK_MEETING_SEND_EMAIL, m_sendEmailCheck);
    DDX_Control(pDX, IDC_CHECK_BOOK_MEETING_MAIL_CALENDAR, m_sendCalendarCheck);
    DDX_Control(pDX, IDC_CHECK_BOOK_WAITING_ROOM, m_openWaitingRoomCheck);
    DDX_Control(pDX, IDC_EDIT_BOOK_MEETING_PASS, m_confPassEdit);
    DDX_Control(pDX, IDC_BUTTON_BOOK_CONF_ADD_ATTENDEE, m_btnAddAttendee);
    DDX_Control(pDX, IDC_BUTTON_BOOK_CONF_DELETE_ATTENDEE, m_btnDeleteAttendee);
    DDX_Control(pDX, IDC_EDIT_BOOK_CONF_DELETE_ATTENDEE, m_editDeleteAttendee);
    DDX_Control(pDX, IDC_BOOK_CONF_TYPE, m_conferenceType);
    DDX_Control(pDX, IDC_EDIT_BOOK_MEETING_CONCURRENTPARTICIPANTS, m_conCurrentParticipantsEdit);
    DDX_Control(pDX, IDC_COMBO_SOFT_AUTO_MUTE2, m_softTerminalAutoMuteCtrl);
    DDX_Control(pDX, IDC_COMBO_HARD_AUTO_MUTE2, m_hardTerminalAutoMuteCtrl);

    DDX_Control(pDX, IDC_COMBO_BOOK_MEETING_GUESTS_JOIN_TIME, m_allowGuestBeforeJoinTimeCtrl);
    DDX_Control(pDX, IDC_CHECK_FORBIDDEN_SCREEN_SHOTS, m_forbiddenScreenShots);
    DDX_Control(pDX, IDC_ALLOW_GUESTS_BEFORE_JOIN_BOOK_MEETING, m_allowGuestbeforeJoinCheckBox);
    DDX_Control(pDX, IDC_CHECK_CONF_WATERMARK, m_supportWatermark);
    DDX_Control(pDX, IDC_CHECK_BOOK_CONF_EXCLUDE_SELF, m_attendeesExcludeSelf);
    DDX_Text(pDX, IDC_EDIT1, m_customInfo);
	DDV_MaxChars(pDX, m_customInfo, 64);
}

int demoBookConfDlg::BookConf()
{
    hwmsdkagent::HwmBookConfParam data{};

    CString tempCString;

    m_confSubjectEdit.GetWindowText(tempCString);
    const auto meetingSubjectStr = CTools::UNICODE2UTF(tempCString.GetString());
    errno_t err = strcpy_s(data.subject, HWM_MAX_SUBJECT_LEN, meetingSubjectStr.c_str());
    if (err != S_OK)
    {
        AfxMessageBox(_T("String Copy Error!"));
    }
    const int confType = m_confTypeCombo.GetCurSel();
    data.confType = hwmsdkagent::HWM_VIDEO_AND_DATA;
    if (confType == 1)
    {
        data.confType = hwmsdkagent::HWM_AUDIO_AND_DATA;
    }

    data.isNeedConfPwd = m_needPasswordCheck.GetCheck() == 1 ? true : false;
    data.isAutoRecordOn = m_isAutoRecordCheck.GetCheck() == 1 ? true : false;
    data.isRecordOn = m_allowRecordCheck.GetCheck() == 1 ? true : false;
    data.defaultSummaryState = m_defaultSummaryState.GetCheck() == 1 ? hwmsdkagent::SUMMARY_STATE_OPEN : hwmsdkagent::SUMMARY_STATE_CLOSE;
    data.autoPublishSummary = m_autoPublishSummary.GetCheck() == 1 ? true : false;

    CTime beginDate;
    m_confStartDateCtrl.GetTime(beginDate);
    CTime beginTime;
    m_confStartTimeCtrl.GetTime(beginTime);
    CTime confStart(beginDate.GetYear(), beginDate.GetMonth(), beginDate.GetDay(), beginTime.GetHour(), beginTime.GetMinute(), 0);

    data.startTimeStamp = confStart.GetTime();
    if (m_conferenceType.GetCurSel() == 1)
    {
        m_cycleConfParam.startTimeStamp = data.startTimeStamp; // 周期会议的开始日期同开始时间
    }
    
    int hour = m_durationHourCtrl.GetCurSel();
    int minute = m_durationMinuteCtrl.GetCurSel() * 15;
    data.duration = hour * 60 + minute;
    data.timeZone = m_timeZoneCtrl.GetCurSel() + 1;

    CString conCurrentParticipants;
    m_conCurrentParticipantsEdit.GetWindowText(conCurrentParticipants);
    data.concurrentParticipants = _ttoi(conCurrentParticipants);

    // combobox框内不显示匿名入会用户限制
    if (m_confAdmissionCtrl.GetCurSel() == 0)
    {
        data.joinConfRestrictionType = static_cast<hwmsdkagent::HwmJoinConfPermissionType>(m_confAdmissionCtrl.GetCurSel());
    }
    else
    {
        data.joinConfRestrictionType = static_cast<hwmsdkagent::HwmJoinConfPermissionType>(m_confAdmissionCtrl.GetCurSel() + 1);
    }
    
    const auto vrmIdSelect = m_confIdTypeCtrl.GetCurSel();
    // 选择随机会议时,会议密码可修改
    if (vrmIdSelect == 0)
    {
        CString tempCString;
        m_confPassEdit.GetWindowText(tempCString);
        if (tempCString.Compare(_T("random guest pass")) != 0)
        {
            auto confPassStr = CTools::UNICODE2UTF(tempCString.GetString());
            err = strcpy_s(data.guestPwd, HWM_MAX_CONF_PASSWORD_LEN, confPassStr.c_str());
            if (err != S_OK)
            {
                AfxMessageBox(_T("String Copy Error!"));
            }
            confPassStr.assign(confPassStr.length(), '\0');
        }
    }

    // 选择vmr会议
    if (vrmIdSelect > 0 && vrmIdSelect - 1 < vmrList.size())
    {
        data.vmrFlag = true;
        err = strcpy_s(data.vmrId, HWM_MAX_VMR_CONF_ID_LEN, vmrList[vrmIdSelect - 1].vmrId);
        if (err != S_OK)
        {
            AfxMessageBox(_T("String Copy Error!"));
        }
    }
    // 共享vmr(vrmIdSelect==0是随机会议号，最后一个是共享vmr)
    else if (vrmIdSelect >= vmrList.size())
    {
        data.vmrFlag = false;
        data.confResType = hwmsdkagent::HWM_CONF_RESTYPE_SHARE_VMR;
    }
    
    // 选择云会议室的conf id类型
    auto vmrConfIdTypeSelect = m_vmrConfIdTypeCtrl.GetCurSel();
    if (vmrConfIdTypeSelect == 1)
    {
        // 选择随机id
        data.vmrConfIdType = hwmsdkagent::HwmVmrConfIdType::HWM_VMR_CONF_ID_TYPE_RANDOM;
        CString tempCString;
        m_confPassEdit.GetWindowText(tempCString);
        if (tempCString.Compare(_T("random guest pass")) != 0)
        {
            auto confPassStr = CTools::UNICODE2UTF(tempCString.GetString());
            err = strcpy_s(data.guestPwd, HWM_MAX_CONF_PASSWORD_LEN, confPassStr.c_str());
            if (err != S_OK)
            {
                AfxMessageBox(_T("String Copy Error!"));
            }
            confPassStr.assign(confPassStr.length(), '\0');
        }
    }

    std::vector<hwmsdkagent::HwmAttendeeInfo>& attendeeList = m_addAttendeeLogic.GetAttendeeList();
    if (!attendeeList.empty())
    {
        data.attendees = attendeeList.data();
        data.attendeeLen = attendeeList.size();
    }

    data.isSmsOn = m_sendMsgCheck.GetCheck() == 1 ? true : false;
    data.isMailOn = m_sendEmailCheck.GetCheck() == 1 ? true : false;
    data.isEmailCalendarOn = m_sendCalendarCheck.GetCheck() == 1 ? true : false;
    data.isOpenWaitingRoom = m_openWaitingRoomCheck.GetCheck() == 1 ? true : false;
    data.autoMuteMode = static_cast<hwmsdkagent::HwmAutoMuteType>(m_softTerminalAutoMuteCtrl.GetCurSel());
    data.hardTerminalAutoMuteMode = static_cast<hwmsdkagent::HwmAutoMuteType>(m_hardTerminalAutoMuteCtrl.GetCurSel());
    data.allowGuestStartConf = m_allowGuestbeforeJoinCheckBox.GetCheck() == 1;
    data.forbiddenScreenShots = m_forbiddenScreenShots.GetCheck() == 1;
    data.supportWatermark = m_supportWatermark.GetCheck() == 1 ? true : false;
    data.attendeesExcludeSelf = m_attendeesExcludeSelf.GetCheck() == 1 ? true : false;
    ChangeVmrInfo(data.vmrFlag, data.vmrId);
    switch (m_allowGuestBeforeJoinTimeCtrl.GetCurSel())
    {
    case 0:
    case 1:
    case 2:
    case 3:
    {
        data.allowGuestStartConfTime = m_allowGuestBeforeJoinTimeCtrl.GetCurSel() * 5;
    }
    break;
    case 4:
    {
        data.allowGuestStartConfTime = 30;
    }
    break;
    default:
        data.allowGuestStartConfTime = 0;
    }

    if (!m_customInfo.IsEmpty())
    {
        auto customInfo = CTools::UNICODE2UTF(m_customInfo.GetString());
        if (customInfo.length() >= HWM_MAX_CUSTOM_INFO_LEN)
        {
            AfxMessageBox(_T("content too long: not more than 64 byte in utf-8 encoding."));
            return -1;
        }
        errno_t err = strcpy_s(data.customInfo, HWM_MAX_CUSTOM_INFO_LEN, customInfo.c_str());
        if (err != 0)
        {
            AfxMessageBox(_T("String Copy Error!"));
        }
    }

    if (m_conferenceType.GetCurSel() == 1)
    {
        hwmsdkagent::HwmBookCycleConfParam bookCycleConfParam{};
        bookCycleConfParam.bookConfParam = data;
        bookCycleConfParam.cycleParam = m_cycleConfParam;
        return hwmsdkagent::BookCycleConf(&bookCycleConfParam);
    }
    return hwmsdkagent::BookConf(&data);
}

void demoBookConfDlg::fillAttendees()
{
    std::string attendeeStr = m_addAttendeeLogic.GetAttendeeStr();
    if (attendeeStr.empty())
    {
        attendeeStr.assign("Please add at least one attendee. The first one added will be the chariman of the conf. So add yourself first");
    }
    m_attendeesEdit.SetWindowTextW(CTools::UTF2UNICODE(attendeeStr).c_str());
}

BEGIN_MESSAGE_MAP(demoBookConfDlg, CDialogEx)
    ON_MESSAGE(WM_VMRLIST_UPDATE, &demoBookConfDlg::OnVmrList)

    ON_BN_CLICKED(IDC_BUTTON_BOOK_MEETING_SUBMIT, &demoBookConfDlg::OnBnClickedOk)
    ON_BN_CLICKED(IDC_BUTTON_BOOK_MEETING_CANCEL, &demoBookConfDlg::OnBnClickedCancel)
    ON_BN_CLICKED(IDC_BUTTON_BOOK_CONF_ADD_ATTENDEE, &demoBookConfDlg::OnBnClickedAddAttendee)
    ON_BN_CLICKED(IDC_BUTTON_BOOK_CONF_DELETE_ATTENDEE, &demoBookConfDlg::OnBnClickedDeleteAttendee)
    ON_CBN_SELCHANGE(IDC_COMBO_BOOK_CONF_CONF_ID_TYPE, &demoBookConfDlg::OnComboConfIdTypeChange)
    ON_CBN_SELCHANGE(IDC_COMBO_VMR_CONF_ID_TYPE,&demoBookConfDlg::OnComboVmrConfIdTypeChange)
    ON_CBN_SELCHANGE(IDC_BOOK_CONF_TYPE, &demoBookConfDlg::OnCbnSelchangeCombo1)
    ON_BN_CLICKED(IDC_ALLOW_GUESTS_BEFORE_JOIN_BOOK_MEETING, &demoBookConfDlg::OnBnClickedAllowGuestsBeforeJoinBookMeeting)
END_MESSAGE_MAP()


// demoBookConfDlg 消息处理程序


void demoBookConfDlg::ChangeVmrInfo(bool isVmrConf, const std::string & vmrId)
{
    if (isVmrConf && !vmrId.empty() && !demoData::GetInstance().GetVmrList().empty())
    {
        for (auto &vmrInfo : demoData::GetInstance().GetVmrList())
        {
            if (std::string(vmrInfo.vmrId) == vmrId)
            {
                vmrInfo.allowGuestStartConf = m_allowGuestbeforeJoinCheckBox.GetCheck() == 1;
                hwmsdkagent::ChangeVmrInfoParam info{};
                errno_t err = strcpy_s(info.vmrId, sizeof info.vmrId, vmrInfo.vmrId);
                err += strcpy_s(info.chairPwd, sizeof info.chairPwd, vmrInfo.chairmanPwd);
                err += strcpy_s(info.guestPwd, sizeof info.guestPwd, vmrInfo.guestPwd);
                err += strcpy_s(info.vmrName, sizeof info.vmrName, vmrInfo.name);
                if (err != S_OK)
                {
                    AfxMessageBox(_T("String Copy Error!"));
                }
                info.allowGuestStartConf = m_allowGuestbeforeJoinCheckBox.GetCheck() == 1;
                // 这两个值不需要改变
                info.joinConfRestrictionType = vmrInfo.joinConfRestrictionType;
                info.isOpenWaitingRoom = vmrInfo.isOpenWaitingRoom;
                hwmsdkagent::ChangeVmrInfo(&info);
            }
        }
    }
}

void demoBookConfDlg::OnCbnSelchangeCombo1()
{
    // TODO: 在此添加控件通知处理程序代码
    if(m_conferenceType.GetCurSel() == 1)
    {
        demoAddCycleConf dlg;
        const auto ret = dlg.DoModal();
        if (ret == IDOK)
        {
             m_cycleConfParam = dlg.GetCycleConfParam();
        }
    }
}


void demoBookConfDlg::OnBnClickedAllowGuestsBeforeJoinBookMeeting()
{
    m_allowGuestBeforeJoinTimeCtrl.EnableWindow(m_allowGuestbeforeJoinCheckBox.GetCheck() == 1);
}
