﻿#pragma once
#include <HwmAgentCallback.h>
#include <vector>
#include "AddAttendeeLogic.h"
#include "demoAddAttendeeDlg2.h"


// demoBookConfDlg 对话框

class demoBookConfDlg : public CDialogEx
{
	DECLARE_DYNAMIC(demoBookConfDlg)

public:
	demoBookConfDlg(CWnd* pParent = nullptr);   // 标准构造函数
	virtual ~demoBookConfDlg();

// 对话框数据
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_BOOK_CONF_WITH_ATTENDEE_DIALOG };
#endif

    afx_msg void OnBnClickedCancel();
    afx_msg void OnBnClickedOk();
    afx_msg void OnBnClickedAddAttendee();
    afx_msg void OnBnClickedDeleteAttendee();
    afx_msg void OnComboConfIdTypeChange();
    // vmr的confid type切换响应函数
    afx_msg void OnComboVmrConfIdTypeChange();
    afx_msg LRESULT OnVmrList(WPARAM wparam, LPARAM lparam);

    virtual BOOL OnInitDialog();

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 支持

	DECLARE_MESSAGE_MAP()

    int BookConf();
    void fillAttendees();

protected:
    CEdit m_confSubjectEdit;
    CComboBox m_confTypeCombo;
    CButton m_needPasswordCheck;
    CButton m_allowRecordCheck;
    CButton m_isAutoRecordCheck; // 是否自动录制会议checkBox
    CButton m_defaultSummaryState; // 会议云录制是否包含纪要，初始值
    CButton m_autoPublishSummary; // 是否自动发布纪要
    CDateTimeCtrl m_confStartDateCtrl;
    CDateTimeCtrl m_confStartTimeCtrl;
    CComboBox m_timeZoneCtrl;
    CComboBox m_durationHourCtrl;
    CComboBox m_durationMinuteCtrl;
    CComboBox m_confIdTypeCtrl;
    CComboBox m_vmrConfIdTypeCtrl;  // 云会议室的会议Id类型
    CComboBox m_confAdmissionCtrl;
    CButton m_sendMsgCheck;
    CButton m_sendEmailCheck;
    CButton m_sendCalendarCheck;
    CButton m_openWaitingRoomCheck; // 是否开启等候室
    CEdit m_attendeesEdit;
    CEdit m_confPassEdit;
    CButton m_btnAddAttendee;
    CButton m_btnDeleteAttendee;
    CEdit m_editDeleteAttendee;
    CComboBox m_conferenceType;
    CComboBox m_allowGuestBeforeJoinTimeCtrl;
    CButton m_allowGuestbeforeJoinCheckBox;
    CButton m_forbiddenScreenShots; // 是否禁止截屏
    CString m_customInfo;
    CEdit m_conCurrentParticipantsEdit;
    CComboBox m_softTerminalAutoMuteCtrl; // 软终端自动静音
    CComboBox m_hardTerminalAutoMuteCtrl; // 硬终端自动静音
    CButton m_supportWatermark;  // 是否支持水印
    CButton m_attendeesExcludeSelf;  // 与会者列表是否排除自己
private:

    std::vector<hwmsdkagent::HwmVmrInfo> vmrList;
    hwmsdkagent::HwmCycleConfParam m_cycleConfParam;
    void ChangeVmrInfo(bool isVmrConf, const std::string& vmrId);

    AddAttendeeLogic<hwmsdkagent::HwmAttendeeInfo, demoAddAttendeeDlg2> m_addAttendeeLogic;
public:
    afx_msg void OnCbnSelchangeCombo1();
    afx_msg void OnBnClickedAllowGuestsBeforeJoinBookMeeting();
};
