//
//  demoNotifyAndCallBackProc.h
//  EC_SDK_DEMO
//
//  Created by EC Open support team.
//  Copyright(C), 2018, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
//

#pragma once

#include "HwmAgentCallback.h"
using namespace hwmsdkagent;

class demoCallbackProc : public HwmAgentCallback
{
public:
    demoCallbackProc();
    ~demoCallbackProc();
public:
    /**
    * @brief [en] Callback of Init interface.
    *        [cn] ʼص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnInitResult(hwmsdk::HwmErrCode ret, const char* reason, HwmSdkInfo *sdkInfo);

    /**
    * @brief [en] Callback of Exit interface.
    *        [cn] ˳ص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnExitResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of Config interface.
    *        [cn] öƻص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnConfigResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of CleanConfig interface.
    *        [cn] ƻص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnCleanConfigResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of EnableFeature interface.
    *        [cn] عܿýӿڻص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnEnableFeature(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of SetLanguage interface.
    *        [cn] Իص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnSetLanguageResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of RenameSelf interface.
    *        [cn] û᳡ص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnRenameSelfResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of Login interface.
    *        [cn] ¼ص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnLoginResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmLoginResult* loginResult);
    /**
    * @brief [en] Callback of Logout interface.
    *        [cn] ǳص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnLogoutResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmLogoutResult* logoutResult);

    /**
    * @brief [en] Callback of CreateConf interface.
    *        [cn] ص
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnCreateConfResult(hwmsdk::HwmErrCode ret, const char* reason, HwmConfInfo *confInfo);

    /**
    * @brief [en] Callback of JoinConfById interface.
    *        [cn] ͨidص
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnJoinConfByIdResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of JoinConfByRandom interface.
    *        [cn] ͨrandomص
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnJoinConfByRandomResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of AddAttendee interface.
    *        [cn] ߻ص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnAddAttendeeResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of LeaveConf interface.
    *        [cn] 뿪ص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnLeaveConfResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of EndConf interface.
    *        [cn] ص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnEndConfResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of StartShare interface.
    *        [cn] ص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnStartShareResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of StopShare interface.
    *        [cn] ֹͣص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnStopShareResult(hwmsdk::HwmErrCode ret, const char* reason);

    virtual void OnBookConfResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmConfDetail* confDetail) override;
    virtual void OnCancelConfResult(hwmsdk::HwmErrCode ret, const char* reason) override;
    virtual void OnEditConfResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    virtual void OnGetVmrInfoListResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmVmrListInfo* vmrListInfo) override;
    virtual void OnGetConfDetailResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmConfDetail* confDetail) override;
    virtual void OnChangeVmrInfoResult(hwmsdk::HwmErrCode ret, const char* reason) override;
	
	/**
    * @brief [en] Callback of SetWaterMarkInjectInfo interface.
    *        [cn] ˮӡעϢص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnSetWaterMarkInjectInfoResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of StartCall interface.
    *        [cn] лص
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnStartCallResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of set file save path.
    *        [cn] û·ص
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnSetUserSavePath(hwmsdk::HwmErrCode ret, const char* reason);
    /**
    * @brief [en] Callback of StartP2pConf interface.
    *        [cn] Եص
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    * @param [in] HwmConfInfo *confInfo             [en] Conf info
    *                                               [cn] Ϣ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnStartP2pConfResult(hwmsdk::HwmErrCode ret, const char* reason, HwmConfInfo *confInfo) override;

    /**
    * @brief [en] Callback of GetUserState interface.
    *        [cn] ȡû״̬ص
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    * @param [in] HwmUserState userState            [en] user state
    *                                               [cn] û״̬
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnGetUserStateResult(hwmsdk::HwmErrCode ret, const char* reason, HwmUserState userState);
    
    /**
    * @brief [en]  Callback of SetShareStrategy interface.
    *        [cn]  ĻԽӿڻص
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnSetShareStrategyResult(hwmsdk::HwmErrCode ret, const char* reason) ;

    /**
    * @brief [en]  Callback of SetShareAudio interface.
    *        [cn]  ùƵӿڻص
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnSetShareAudioResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en]  Callback of AVDeviceCtrl interface.
    *        [cn]  Ƶؿƽӿڻص
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    * @param [in] HwmDeviceType deviceType          [en] Device type
    *                                               [cn] 豸
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnAVDeviceCtrlResult(hwmsdk::HwmErrCode ret, const char* reason, HwmDeviceType deviceType);

    /**
    * @brief [en] Callback of GetAttendeeList interface.
    *        [cn] ȡбӿڻص
    * @param [in] HwmAttendeeInfo* audidenceList                [en] б
    *                                                           [cn] attendeeList
    * @param [in] unsigned int length                           [en] б
    *                                                           [cn] attendee Number
    **/
    virtual void OnGetAttendeeListResult(const HwmAttendeeInfo* attendeeList, unsigned int length) override;

    /**
    * @brief [en] Callback of GetAudienceList interface.
    *        [cn] ȡбӿڻص
    * @param [in] HwmAttendeeInfo* audidenceList                [en] б
    *                                                           [cn] audidenceList
    * @param [in] unsigned int length                           [en] ڸ
    *                                                           [cn] audidence Number
    **/
    virtual void OnGetAudienceListResult(const HwmAttendeeInfo* audidenceList, unsigned int length) override;

    /**
    * @brief [en] Callback of OnSetAudioRawDataOutputConfigResult interface.
    *        [cn] رսƵӿڻص
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    **/
    virtual void OnSetAudioRawDataOutputConfigResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief
    * [en]
    * [cn]ڻĽص
    *
    * @param result [type:HwmErrCode][cs_allowNull:N]
    * [en]
    * [cn]
    * @see HwmErrCode
    *
    * @param reasonDesc [type:char*][cs_allowNull:N]
    * [en]
    * [cn]
    */
    virtual void OnBookCycleConfResult(hwmsdk::HwmErrCode result, const char* reasonDesc, const HwmConfDetail* confDetail) override;

    /**
    * @brief
    * [en]
    * [cn]༭ڻĽص
    *
    * @param result [type:HwmErrCode][cs_allowNull:N]
    * [en]
    * [cn]
    * @see HwmErrCode
    *
    * @param reasonDesc [type:char*][cs_allowNull:N]
    * [en]
    * [cn]
    */
    virtual void OnModifyCycleConfResult(hwmsdk::HwmErrCode  result, const char* reasonDesc)  override;

    /**
    * @brief
    * [en]
    * [cn]༭ӻĽص
    *
    * @param result [type:HwmErrCode][cs_allowNull:N]
    * [en]
    * [cn]
    * @see HwmErrCode
    *
    * @param reasonDesc [type:char*][cs_allowNull:N]
    * [en]
    * [cn]
    */
    virtual void OnModifySubCycleConfResult(hwmsdk::HwmErrCode result, const char* reasonDesc) override;

    /**
    * @brief
    * [en]
    * [cn]ȡڻĽص
    *
    * @param result [type:HwmErrCode][cs_allowNull:N]
    * [en]
    * [cn]
    * @see HwmErrCode
    *
    * @param reasonDesc [type:char*][cs_allowNull:N]
    * [en]
    * [cn]
    */
    virtual void OnCancelCycleConfResult(hwmsdk::HwmErrCode result, const char* reasonDesc) override;

    /**
    * @brief
    * [en]
    * [cn]ȡӻĽص
    *
    * @param result [type:HwmErrCode][cs_allowNull:N]
    * [en]
    * [cn]
    * @see HwmErrCode
    *
    * @param reasonDesc [type:char*][cs_allowNull:N]
    * [en]
    * [cn]
    */
    virtual void OnCancelSubCycleConfResult(hwmsdk::HwmErrCode result, const char* reasonDesc) override;

    /**
    * @brief [en] Callback of SetNetworkMode interface.
    *        [cn] ģʽص
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    **/
    virtual void OnSetNetworkModeResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief [en] Callback of SetRawDataExternalConfig interface.
    *        [cn] ö˵˼ܽӿϢص
    *
    * @param [in] hwmsdk::HwmErrCode ret             [en] Return code
    *                                                [cn] ֵ
    * @param [in] const char* reason                 [en] Fail reason
    *                                                [cn] ʧԭ
    **/
    virtual void OnSetRawDataExternalConfigResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief
    * [en] Callback of ConfigSettingWindow interface.
    * [cn] ýĽص
    *
    * @param result [type:HwmErrCode][cs_allowNull:N]
    * [en]
    * [cn]
    * @see HwmErrCode
    *
    * @param reasonDesc [type:char*][cs_allowNull:N]
    * [en]
    * [cn]
    */
    virtual void OnConfigSettingWindowResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief [en] Callback of ShowSettingWindow interface.
    *        [cn] ʾýӿڽص
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnShowSettingWindowResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief
    * [en] Callback of GetMainWindowInfo interface
    * [cn] Ϣ֪ͨȡϢ󷵻
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 
    *
    * @param mainWindowInfo [type:HwmMainWindowInfo*]
    * [en] Main window info
    * [cn] Ϣ
    */
    virtual void OnGetMainWindowInfoResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmMainWindowInfo* mainWindowInfo) override;

    /**
    * @brief
    * [en] Callback of SetAvatarStyle interface.
    * [cn] ͷص
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 
    **/
    virtual void OnSetAvatarStyleResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /*********************************************ǱĽӿڻص*********************************************/
    /**
    * @brief [en] Callback of SetServerAddress interface.
    *        [cn] õ¼ַϢص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] Reserved
    *            [cn] ӿڻص
    **/
    virtual void OnSetServerAddressResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of SetProxyInfo interface.
    *        [cn] ôϢص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] Reserved
    *            [cn] ӿڻص
    **/
    virtual void OnSetProxyInfoResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of LoginByToken interface.
    *        [cn] token¼ӿڻص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] Reserved
    *            [cn] ӿڻص
    **/
    virtual void OnLoginByTokenResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of EnablePair interface.
    *        [cn] رԹܻص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] Reserved
    *            [cn] ӿڻص
    **/
    virtual void OnEnablePairResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of SetTransparentWnd interface.
    *        [cn] ͸ڽӿڻص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] Reserved
    *            [cn] ӿڻص
    **/
    virtual void OnSetTransparentWndResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
   * @brief [en] Callback of SetCustomUIText interface.
   *        [cn] ûԶİ
   *
   * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
   *                                       [cn] ֵ
   * @param [in] const char* reason        [en] Fail reason
   *                                       [cn] ʧԭ
   * @attention [en] Reserved
   *            [cn] ӿڻص
   **/
    virtual void OnSetCustomUITextResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en] Callback of JoinConfByLink interface.
    *        [cn] ͨص
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    * @attention [en] Reserved
    *            [cn] ӿڻص
    **/
    virtual void OnJoinConfByLinkResult(hwmsdk::HwmErrCode ret, const char* reason);
    /**
    * @brief [en]  Callback of SetFrameWndTopmost interface.
    *        [cn] ÿܴöԻص
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    * @attention [en] Reserved
    *            [cn] ӿڻص
    **/
    virtual void OnSetFrameWndTopmostResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en]  Callback of SetCallIncomingAnswerResult interface.
    *        [cn] úӦص
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    * @attention [en] Reserved
    *            [cn] ӿڻص
    **/
    virtual void OnSetCallIncomingAnswerResult(hwmsdk::HwmErrCode ret, const char* reason);

    /**
    * @brief [en]  Callback of SetConfIncomingAnswerResult interface.
    *        [cn] ûӦص
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    * @attention [en] Reserved
    *            [cn] ӿڻص
    **/
    virtual void OnSetConfIncomingAnswerResult(hwmsdk::HwmErrCode ret, const char* reason);


    /**
    * @brief [en]  Callback of ShowMeetingWindow interface.
    *        [cn]  ʾ鴰
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    * @attention [en] Reserved
    *            [cn] ӿڻص
    **/
    virtual void OnShowMeetingWindowResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief [en] window handle list callback.when call GetHwndInfoList, will receive this calback
    *        [cn] ھбصGetRenderWindowInfoList 󷵻
    *
    * @param [in] hwmsdk::HwmErrCode ret                    [en] Return code
    *                                                       [cn] ֵ
    * @param [in] const char* reason                        [en] Fail reason
    *                                                       [cn] ʧԭ
    * @param [in] const HwmHwndListInfo* hwndInfo           [en] window handle info
    *                                                       [cn] ھϢ
    */
    virtual void OnGetRenderWindowInfoListResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmHwndListInfo* hwndInfo) override;
    /**
    * @brief [en] Callback of GetSSOAuthorizeUrl interface.
    *        [cn] ҵȡȨUrl ӿ ص
    *
    * @param [in] hwmsdk::HwmErrCode ret                    [en] Return code
    *                                                       [cn] ֵ
    * @param [in] const char* reason                        [en] Fail reason
    *                                                       [cn] ʧԭ
    * @param [in] const char* ssoAuthorizeUrl               [en] SSO Authorize Url
    *                                                       [cn] ȨUrl
    */
    virtual void OnGetSSOAuthorizeUrlResult(hwmsdk::HwmErrCode ret, const char* reason, const char* ssoAuthorizeUrl);

    /**
    * @brief [en] Callback of LoginBySSO interface.
    *        [cn] SSO¼ص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnLoginBySSOResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmLoginResult* loginResult);

    /**
    * @brief [en]  Callback of UpdateCustomButtonInfo interface.
    *        [cn]  Զ尴ťӿڻص
    *
    * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
    *                                               [cn] ֵ
    * @param [in] const char* reason                [en] Fail reason
    *                                               [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnUpdateCustomButtonInfoResult(hwmsdk::HwmErrCode ret, const char* reason);
    /*********************************************ǱĽӿڻص*********************************************/
    
    /**
    * @brief [en] Callback of DisableVoicePrompts interface.
    *        [cn] ʾӿڽص
    *
    * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
    *                                       [cn] ֵ
    * @param [in] const char* reason        [en] Fail reason
    *                                       [cn] ʧԭ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnDisableVoicePromptsResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief
    * [en] Callback of UploadSelfAvatar interface.
    * [cn] ϴͷص
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 
    **/
    virtual void OnUploadSelfAvatarResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief
    * [en] Callback of DeleteSelfAvatar interface.
    * [cn] ɾͷص
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 
    **/
    virtual void OnDeleteSelfAvatarResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief
    * [en] Callback of set file save path.
    * [cn] û·ص
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 
    *
    * @param pathInfo [type:HwmUserSavePathInfo*]
    * [en] Save path info
    * [cn] ·Ϣ
    *
    * @mac:disable
    **/
    virtual void OnGetUserSavePathResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmUserSavePathInfo* pathInfo) override;


    /**
    * @brief
    * [en] Callback of GeneralWatch interface.
    * [cn] ѡӿڻص
    *
    * @param ret [type:SDKERR][cs_allowNull:N]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*][cs_allowNull:N]
    * [en] Reason
    * [cn] 
    *
    **/
    virtual void OnGeneralWatchResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief
    * [en] Callback of StartAnnotation interface.
    * [cn] עӿڻص
    *
    * @param ret [type:SDKERR][cs_allowNull:N]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*][cs_allowNull:N]
    * [en] Reason
    * [cn] 
    **/
    virtual void OnStartAnnotationResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief
    * [en] Callback of SetAnnotationWindow interface.
    * [cn] ñעڽӿڻص
    *
    * @param ret [type:SDKERR][cs_allowNull:N]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*][cs_allowNull:N]
    * [en] Reason
    * [cn] 
    **/
    virtual void OnSetAnnotationWindowResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief
    * [en] Callback of SaveAnnotation interface.
    * [cn] עӿڻص
    *
    * @param ret [type:SDKERR][cs_allowNull:N]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*][cs_allowNull:N]
    * [en] Reason
    * [cn] 
    **/
    virtual void OnSaveAnnotationResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief
    * [en] Callback of StopAnnotation interface.
    * [cn] ֹͣעӿڻص
    *
    * @param ret [type:SDKERR][cs_allowNull:N]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*][cs_allowNull:N]
    * [en] Reason
    * [cn] 
    **/
    virtual void OnStopAnnotationResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief [en] Callback of StartProjection interface.
    *        [cn] Ͷص
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 
    *
    * @param startProjectionResult [type:HwmStartProjectionResult]
    * [en] Start projection result
    * [cn] Ͷ
    **/
    virtual void OnStartProjectionResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmStartProjectionResult* startProjectionResult) override;

    /**
    * @brief [en] Callback of SetCAVerifyInfo interface.
    *        [cn] ֤УϢص
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 
    *
    **/
    virtual void OnSetCAVerifyInfoResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief
    * [en] Callback of SetAnswerType interface.
    * [cn] Ӧص
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 
    **/
    virtual void OnSetAnswerTypeResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief
    * [en] Callback of AcceptConf interface.
    * [cn] ܻص
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 
    */
    virtual void OnAcceptConfResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief
    * [en] Callback of RejectConf interface.
    * [cn] ܾص
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 
    */
    virtual void OnRejectConfResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief [en] Callback of SetGlobalGuaranteedIpAddresses interface.
    *        [cn] ùӦıipַص
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 
    *
    **/
    virtual void OnSetGlobalGuaranteedIpAddressesResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    /**
    * @brief
    * [en] Callback of GetSelfShareState interface.
    * [cn] ȡԼĿ״̬ص
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 
    *
    * @param selfShareStateInfo [type:HwmSelfShareStateInfo]
    * [en] Self share state info
    * [cn] Լ״̬Ϣ
    **/
    virtual void OnGetSelfShareStateResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmSelfShareStateInfo* selfShareStateInfo) override;

    /**
    * @brief [en] Callback of GetLoginState interface.
    *        [cn] ȡ¼״̬ӿڻص
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 
    *
    * @param loginStateInfo [type:HwmLoginStateInfo*]
    * [en] login state info
    * [cn] ¼״̬Ϣ
    **/
    virtual void OnGetLoginStateResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmLoginStateInfo* loginStateInfo) override;

    /**
    * @brief [en] Callback of GetLoginToken interface.
    *        [cn] ȡ¼tokenӿڻص
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 
    *
    * @param loginTokenInfo [type:HwmLoginTokenInfo*]
    * [en] login token info
    * [cn] ¼tokenϢ
    **/
    virtual void OnGetLoginTokenResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmLoginTokenInfo* loginTokenInfo) override;
    
    // /رĻص
    virtual void OnOpenSubtitleResult(hwmsdk::HwmErrCode ret, const char* reason, bool isOpen) override;

    // /رյȺһص
    virtual void OnOpenWaitingRoomResult(hwmsdk::HwmErrCode ret, const char* reason, bool isOpen) override;

    // ¼ƻص
    virtual void OnOperateLocalRecordResult(hwmsdk::HwmErrCode ret, const char* reason, HwmLocalRecordOperateType type) override;

    // ⱳûص
    virtual void OnOpenVirtualBackgroundSettingPageResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    // ȡ¼״̬ص
    virtual void OnGetConfLocalRecordStatusResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmLocalRecordStatusInfo* state) override;

    // ȡ¼Ȩ޽ص
    virtual void OnGetSelfHasLocalRecordPermissionResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmLocalRecordPermissionInfo* permission) override;

    // 뱾¼Ȩ޻ص
    virtual void OnRequestLocalRecordPermissionResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    // ˻ص
    virtual void OnApplyHostRoleResult(hwmsdk::HwmErrCode ret, const char* reason) override;

    // ȡĻ״̬ص
    virtual void OnGetSubtitlePageOpenedResult(hwmsdk::HwmErrCode ret, const char* reason, bool isOpen) override;

    // ȡȺ״̬ص
    virtual void OnGetWaitingRoomOpenedResult(hwmsdk::HwmErrCode ret, const char* reason, bool isOpen) override;

    // ȡⱳý״̬ص
    virtual void OnGetVirtualBackgroundSettingPageOpenedResult(hwmsdk::HwmErrCode ret, const char* reason, bool isOpen) override;

    // Ļ
    virtual void OnSubscribeSubtitleLanguageResult(hwmsdk::HwmErrCode ret, const char* reason, HwmTargetLanguageType targetLanguageType) override;

    // /ȡĻ
    virtual void OnSubscribeSubtitleResult(hwmsdk::HwmErrCode ret, const char* reason, bool isSubscirbe) override;

    // ȡĻб
    virtual void OnGetSubtitleSupportLanguageResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmTargetLanguageTypeList* targetLanguageTypeList) override;
};
