﻿// demoConfListDlg.cpp: 实现文件
//
#include "stdafx.h"
#include "demo.h"
#include "demoConfListDlg.h"
#include "afxdialogex.h"
#include "demoData.h"
#include "demoTools.h"
#include "HwmSdkAgent.h"
#include "demoCustomMessage.h"
#include "demoEditConfDlg.h"

// demoConfListDlg 对话框

IMPLEMENT_DYNAMIC(demoConfListDlg, CDialogEx)

demoConfListDlg::demoConfListDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_CONF_LIST_DIALOG, pParent), m_isCycleConf(false)
{

}

demoConfListDlg::~demoConfListDlg()
{
}

void demoConfListDlg::updateData()
{
    confList = demoData::GetInstance().GetConfList();
	conflistCtrl.SetExtendedStyle(conflistCtrl.GetExtendedStyle()|LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);
    for (int i = 0; i < confList.size(); ++i)
    {
        conflistCtrl.InsertItem(i, _T(""));
        conflistCtrl.SetItemText(i, 0, CTools::UTF2UNICODE(confList[i].confId).c_str());
        conflistCtrl.SetItemText(i, 1, CTools::UTF2UNICODE(confList[i].vmrConferenceId).c_str());
        conflistCtrl.SetItemText(i, 2, CTools::UTF2UNICODE(confList[i].confSubject).c_str());
        CTime startTime = confList[i].startTimeStamp;
        conflistCtrl.SetItemText(i, 3, startTime.Format(_T("%Y-%m-%d %H:%M")));
        CTime endTime = confList[i].endTimeStamp;
        conflistCtrl.SetItemText(i, 4, endTime.Format(_T("%Y-%m-%d %H:%M")));
        conflistCtrl.SetItemText(i, 5, confList[i].conferenceType == 0 ? _T("common conf") : _T("cycle conf"));
    }
}

void demoConfListDlg::OnBnEditConf()
{
    CString confId;
    editConfEdit.GetWindowText(confId);
    if (confId.IsEmpty())
    {
        AfxMessageBox(_T("invalid conf id"));
        return;
    }
    demoEditConfDlg dlg;
    dlg.setConfId(CTools::UNICODE2UTF(confId.GetString()));
    dlg.DoModal();
}

LRESULT demoConfListDlg::OnConfListUpdate(WPARAM wparam, LPARAM lparam)
{
    conflistCtrl.DeleteAllItems();
    updateData();
    return 0;
}

void demoConfListDlg::OnBnCancelConf()
{
    CString confId;
    cancelConfEdit.GetWindowText(confId);
    if (confId.IsEmpty())
    {
        AfxMessageBox(_T("invalid conf id"));
        return;
    }

    char confIdParam[HWM_MAX_CONF_ID_LEN];
    const auto ret = strcpy_s(confIdParam, HWM_MAX_CONF_ID_LEN, CTools::UNICODE2UTF(confId.GetString()).c_str());
    if (ret != 0)
    {
         AfxMessageBox(_T("conf id copy error"));
    }

    if(m_isCycleConf)
    {
        hwmsdkagent::HwmCancelCycleConfParam cycleConfParam{};
        const auto ret = strcpy_s(cycleConfParam.confId, sizeof(cycleConfParam.confId), CTools::UNICODE2UTF(confId.GetString()).c_str());
        if (ret != 0)
        {
            AfxMessageBox(_T("conf id copy error"));
        }
        cycleConfParam.endOnlineConf = true;
        hwmsdkagent::CancelCycleConf(&cycleConfParam);
        return;
    }
    hwmsdkagent::CancelConf(confIdParam);
}

void demoConfListDlg::OnNMClick(NMHDR* pNMHDR, LRESULT* pResult)
{
    int select = conflistCtrl.GetSelectionMark();
    CString confId;
    if (select >= 0 && select < confList.size())
    {
        confId = CTools::UTF2UNICODE(confList[select].confId).c_str();
        m_isCycleConf = (confList[select].conferenceType == hwmsdkagent::CONF_TYPE_CYCLE);
    }
    editConfEdit.SetWindowTextW(confId);
    cancelConfEdit.SetWindowTextW(confId);
}

void demoConfListDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);

    DDX_Control(pDX, IDC_LIST_CONF_LIST, conflistCtrl);
    DDX_Control(pDX, IDC_EDIT_CONF_LIST_EDIT_CONF, editConfEdit);
    DDX_Control(pDX, IDC_EDIT_CONF_LIST_CANCEL_CONF, cancelConfEdit);
}

BOOL demoConfListDlg::OnInitDialog()
{
    const auto ret = CDialogEx::OnInitDialog();
    conflistCtrl.InsertColumn(0, _T("会议id"), LVCFMT_CENTER, 100);
    conflistCtrl.InsertColumn(1, _T("VMR id"), LVCFMT_CENTER, 100);
    conflistCtrl.InsertColumn(2, _T("会议主题"), LVCFMT_CENTER, 100);
    conflistCtrl.InsertColumn(3, _T("开始时间"), LVCFMT_CENTER, 100);
    conflistCtrl.InsertColumn(4, _T("结束时间"), LVCFMT_CENTER, 100);
    conflistCtrl.InsertColumn(5, _T("会议类型"), LVCFMT_CENTER, 100);

    updateData();

    demoData::GetInstance().subscribeConfList(m_hWnd);

    return ret;
}



BEGIN_MESSAGE_MAP(demoConfListDlg, CDialogEx)
    ON_MESSAGE(WM_CONFLIST_UPDATE, &demoConfListDlg::OnConfListUpdate)

    ON_BN_CLICKED(IDC_BUTTON_CONF_LIST_EDIT_CONF, &demoConfListDlg::OnBnEditConf)
    ON_BN_CLICKED(IDC_BUTTON_CONF_LIST_CANCEL_CONF, &demoConfListDlg::OnBnCancelConf)
    ON_NOTIFY(NM_CLICK, IDC_LIST_CONF_LIST, OnNMClick)
END_MESSAGE_MAP()


// demoConfListDlg 消息处理程序
