// demoCreateConfWithAttendeeDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "demo.h"
#include "demoCreateConfWithAttendeeDlg.h"
#include "afxdialogex.h"
#include "demoData.h"
#include "demoTools.h"
#include "HwmSdkAgent.h"
#include "demoCustomMessage.h"

// demoCreateConfWithAttendeeDlg Ի

IMPLEMENT_DYNAMIC(demoCreateConfWithAttendeeDlg, CDialogEx)

demoCreateConfWithAttendeeDlg::demoCreateConfWithAttendeeDlg(CWnd* pParent /*=NULL*/)
    : CDialogEx(IDD_CREATE_CONF_WITH_ATTENDEE_DIALOG, pParent)
    , m_customInfo(_T(""))
{

}

demoCreateConfWithAttendeeDlg::~demoCreateConfWithAttendeeDlg()
{
}

void demoCreateConfWithAttendeeDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_CREAT_MEETING_WITH_MEMBERS_SUBJECT, m_confSubjectEdit);
    DDX_Control(pDX, IDC_COMBO_CREAT_MEETING_WITH_MEMBERS_TYPE, m_confTypeCombo);
    DDX_Control(pDX, IDC_COMBO_CREAT_MEETING_WITH_CONF_ADMISSION, m_confAdmissionCombo);
    DDX_Control(pDX, IDC_COMBO_CREAT_MEETING_WITH_CONF_ID_TYPE, m_confIdTypeCombo);
    DDX_Control(pDX, IDC_COMBO_VMR_CONF_ID_TYPE3, m_vmrConfIdTypeCtrl);    
    DDX_Control(pDX, IDC_EDIT_CREAT_MEETING_PASS, m_confPassEdit);
    DDX_Control(pDX, IDC_CHECK_NEED_PASSWORD_WITH_MEMBERS, m_needPasswordCheck);
    DDX_Control(pDX, IDC_CHECK_ALLOW_RECORD, m_allowRecord);
    DDX_Control(pDX, IDC_CHECK_IS_AUTORECORD, m_isAutoRecord);
    DDX_Control(pDX, IDC_CHECK_BOOK_WAITING_ROOM3, m_openWaitingRoomCheck);
    DDX_Control(pDX, IDC_COMBO_CREATE_MEETING_DURATION_HOUR, m_durationHourCtrl);
    DDX_Control(pDX, IDC_COMBO_CREATE_MEETING_DURATION_MINUTE, m_durationMinuteCtrl);
    DDX_Text(pDX, IDC_EDIT1, m_customInfo);
    DDX_Control(pDX, IDC_EDIT_CREAT_MEETING_CONCURRENTPARTICIPANTS, m_conCurrentParticipantsEdit);
    DDX_Control(pDX, IDC_CHECK_DEFAULT_SUMMARY_STATE, m_defaultSummaryState);
    DDX_Control(pDX, IDC_CHECK_AUTO_PUBLISH_SUMMARY, m_autoPublishSummary);
    DDX_Control(pDX, IDC_CHECK_CONF_WATERMARK3, m_supportWatermark);
    DDX_Control(pDX, IDC_CHECK_FORBIDDEN_SCREEN_SHOTS2, m_forbiddenScreenShots);
    DDX_Control(pDX, IDC_COMBO_SOFT_AUTO_MUTE1, m_softTerminalAutoMuteCtrl);
    DDX_Control(pDX, IDC_COMBO_HARD_AUTO_MUTE1, m_hardTerminalAutoMuteCtrl);
	DDV_MaxChars(pDX, m_customInfo, 64);
    DDX_Control(pDX, IDC_EDIT_DELETE_HWM_CONF_ATTENDEE, m_editDeleteAttendee);
    DDX_Control(pDX, IDC_EDIT_ADD_HWM_CONF_ATTENDEE_LIST, m_attendeesEdit);
}

BOOL demoCreateConfWithAttendeeDlg::OnInitDialog()
{
    CDialog::OnInitDialog();

    m_confTypeCombo.InsertString(0, _T("Video"));
    m_confTypeCombo.InsertString(1, _T("Audio"));
    m_confTypeCombo.SetWindowText(_T("Video"));
    m_confSubjectEdit.SetWindowText(_T("ʱ"));
    m_conCurrentParticipantsEdit.SetWindowText(_T("0"));


    m_confAdmissionCombo.InsertString(0, _T("û"));
    m_confAdmissionCombo.InsertString(1, _T("ҵڲ"));
    m_confAdmissionCombo.InsertString(2, _T(""));
    m_confAdmissionCombo.SetCurSel(0);

    m_confIdTypeCombo.InsertString(0, _T("id"));
    m_confIdTypeCombo.SetCurSel(0);

    // ƻidĬǹ̶id,vmrĬϲƻ,idѡû
    m_vmrConfIdTypeCtrl.InsertString(0, _T("̶id"));
    m_vmrConfIdTypeCtrl.InsertString(1, _T("id"));
    m_vmrConfIdTypeCtrl.SetCurSel(0);
    m_vmrConfIdTypeCtrl.EnableWindow(0);

    for (int i = 0; i < 24; i++)
    {
        CString item;
        item.Format(_T("%dСʱ"), i);
        m_durationHourCtrl.InsertString(i, item);
    }
    m_durationHourCtrl.SetCurSel(0);

    m_durationMinuteCtrl.InsertString(0, _T("0"));
    m_durationMinuteCtrl.InsertString(1, _T("15"));
    m_durationMinuteCtrl.InsertString(2, _T("30"));
    m_durationMinuteCtrl.InsertString(3, _T("45"));
    m_durationMinuteCtrl.SetCurSel(2);

    m_softTerminalAutoMuteCtrl.InsertString(0, _T("Default"));
    m_softTerminalAutoMuteCtrl.InsertString(1, _T("Mute"));
    m_softTerminalAutoMuteCtrl.InsertString(2, _T("UnMute"));
    m_softTerminalAutoMuteCtrl.SetCurSel(0);
    m_hardTerminalAutoMuteCtrl.InsertString(0, _T("Default"));
    m_hardTerminalAutoMuteCtrl.InsertString(1, _T("Mute"));
    m_hardTerminalAutoMuteCtrl.InsertString(2, _T("UnMute"));
    m_hardTerminalAutoMuteCtrl.SetCurSel(0);

    if (!demoData::GetInstance().HasRecordPermission())
    {
        m_allowRecord.EnableWindow(0);
        m_isAutoRecord.EnableWindow(0);
    }

    m_autoPublishSummary.SetCheck(1);
    if (!demoData::GetInstance().GetCorpEnableSummary())
    {
        m_defaultSummaryState.EnableWindow(0);
        m_autoPublishSummary.EnableWindow(0);
    }

    hwmsdkagent::GetVmrList();
    demoData::GetInstance().subscribeVmrList(m_hWnd);
	m_confPassEdit.SetLimitText(16);
    return TRUE;
}

BEGIN_MESSAGE_MAP(demoCreateConfWithAttendeeDlg, CDialogEx)
    ON_MESSAGE(WM_VMRLIST_UPDATE, &demoCreateConfWithAttendeeDlg::OnVmrList)
    ON_BN_CLICKED(IDCANCEL, &demoCreateConfWithAttendeeDlg::OnBnClickedCancel)
    ON_BN_CLICKED(IDOK, &demoCreateConfWithAttendeeDlg::OnBnClickedOk)
    ON_CBN_SELCHANGE(IDC_COMBO_CREAT_MEETING_WITH_CONF_ID_TYPE, &demoCreateConfWithAttendeeDlg::OnComboConfIdTypeChange)
    ON_CBN_SELCHANGE(IDC_COMBO_VMR_CONF_ID_TYPE3, &demoCreateConfWithAttendeeDlg::OnComboVmrConfIdTypeChange)
    ON_BN_CLICKED(IDC_BUTTON_ADD_HWM_CONF_ATTENDEE, &demoCreateConfWithAttendeeDlg::OnBnClickedButtonAddHwmConfAttendee)
    ON_BN_CLICKED(IDC_BUTTON_DELETE_HWM_CONF_ATTENDEE, &demoCreateConfWithAttendeeDlg::OnBnClickedButtonDeleteHwmConfAttendee)
END_MESSAGE_MAP()


// demoCreateConfWithAttendeeDlg Ϣ

int demoCreateConfWithAttendeeDlg::clickCreatConfWithAttendee()
{
    int ret;
    hwmsdkagent::HwmCreateConfInfo data{};

    CString tempCString;
    m_confSubjectEdit.GetWindowText(tempCString);
    string meetingSubjectStr = CTools::UNICODE2UTF(tempCString.GetString());
    strncpy_s(data.subject, meetingSubjectStr.c_str(), HWM_MAX_SUBJECT_LEN);

    m_confTypeCombo.GetWindowText(tempCString);
    hwmsdkagent::HwmConfMediaType type = hwmsdkagent::HWM_VIDEO_AND_DATA;
    if (_T("Video") == tempCString)
    {
        data.mediaType = hwmsdkagent::HWM_VIDEO_AND_DATA;
    }
    else if (_T("Audio") == tempCString)
    {
        data.mediaType = hwmsdkagent::HWM_AUDIO_AND_DATA;
    }

    CString conCurrentParticipants;
    m_conCurrentParticipantsEdit.GetWindowText(conCurrentParticipants);

    data.concurrentParticipants = _ttoi(conCurrentParticipants);
    data.needPassword = m_needPasswordCheck.GetCheck() == 1 ? true : false;
    data.isAutoRecord = m_isAutoRecord.GetCheck() == 1 ? true : false;
    data.allowRecord = m_allowRecord.GetCheck() == 1 ? true : false;
    data.isOpenWaitingRoom = m_openWaitingRoomCheck.GetCheck() == 1 ? true : false;
    data.defaultSummaryState = m_defaultSummaryState.GetCheck() == 1 ? hwmsdkagent::SUMMARY_STATE_OPEN : hwmsdkagent::SUMMARY_STATE_CLOSE;
    data.autoPublishSummary = m_autoPublishSummary.GetCheck() == 1 ? true : false;
    data.autoMuteMode = static_cast<hwmsdkagent::HwmAutoMuteType>(m_softTerminalAutoMuteCtrl.GetCurSel());
    data.hardTerminalAutoMuteMode = static_cast<hwmsdkagent::HwmAutoMuteType>(m_hardTerminalAutoMuteCtrl.GetCurSel());
    data.supportWatermark = m_supportWatermark.GetCheck() == 1 ? true : false;
    data.forbiddenScreenShots = m_forbiddenScreenShots.GetCheck() == 1 ? true : false;

    //comboboxڲʾû
    if (m_confAdmissionCombo.GetCurSel() == 0)
    {
        data.callInRestriction = (hwmsdkagent::HwmJoinConfPermissionType)m_confAdmissionCombo.GetCurSel();
    }
    else
    {
        data.callInRestriction = (hwmsdkagent::HwmJoinConfPermissionType)(m_confAdmissionCombo.GetCurSel() + 1);
    }


    const auto vrmIdSelect = m_confIdTypeCombo.GetCurSel();
    // ѡʱ,޸
    errno_t err = S_OK;
    if (vrmIdSelect == 0)
    {
        CString tempCString;
        m_confPassEdit.GetWindowText(tempCString);
        if (tempCString.Compare(_T("random guest pass")) != 0)
        {
            auto confPassStr = CTools::UNICODE2UTF(tempCString.GetString());
            err = strcpy_s(data.guestPwd, HWM_MAX_CONF_PASSWORD_LEN, confPassStr.c_str());
            confPassStr.assign(confPassStr.length(), '\0');
        }
        int len = tempCString.GetLength();
        for (int idx = 0; idx < len; ++idx)
        {
            tempCString.SetAt(idx, 0);
        }
    }

    // ѡvmr
    if (vrmIdSelect > 0 && vrmIdSelect - 1 < vmrList.size())
    {
        err += strcpy_s(data.vmrId, HWM_MAX_VMR_CONF_ID_LEN, vmrList[vrmIdSelect - 1].vmrId);
    }
    // vmr(vrmIdSelect==0ţһǹvmr)
    else if (vrmIdSelect >= vmrList.size())
    {;
        data.confResType = hwmsdkagent::HWM_CONF_RESTYPE_SHARE_VMR;
    }


    // ѡƻҵconf id
    auto vmrConfIdTypeSelect = m_vmrConfIdTypeCtrl.GetCurSel();
    if (vmrConfIdTypeSelect == 1)
    {
        // ѡid
        data.vmrConfIdType = hwmsdkagent::HwmVmrConfIdType::HWM_VMR_CONF_ID_TYPE_RANDOM;
        CString tempCString;
        m_confPassEdit.GetWindowText(tempCString);
        if (tempCString.Compare(_T("random guest pass")) != 0)
        {
            auto confPassStr = CTools::UNICODE2UTF(tempCString.GetString());
            err += strcpy_s(data.guestPwd, HWM_MAX_CONF_PASSWORD_LEN, confPassStr.c_str());
        }
    }

    if (err != S_OK)
    {
        AfxMessageBox(_T("String Copy Error!"));
    }

    int hour = m_durationHourCtrl.GetCurSel();
    int minute = m_durationMinuteCtrl.GetCurSel() * 15;
    data.duration = hour * 60 + minute;

    m_attendeesEdit.GetWindowText(tempCString);
    string tempString = CTools::UNICODE2UTF(tempCString.GetString());
    vector<string> list = CTools::split(tempString, ';');
    vector<string> temp;
    int count = list.size();

    hwmsdkagent::HwmConfAttendee* participants = nullptr;
    unsigned int realCount = 0;
    std::vector<hwmsdkagent::HwmConfAttendee>& attendeeList = m_addAttendeeLogic.GetAttendeeList();
    if (!attendeeList.empty())
    {
        participants = attendeeList.data();
        realCount = attendeeList.size();
    }

    if (!m_customInfo.IsEmpty())
    {
        auto customInfo = CTools::UNICODE2UTF(m_customInfo.GetString());
        if (customInfo.length() >= HWM_MAX_CUSTOM_INFO_LEN)
        {
            AfxMessageBox(_T("content too long: not more than 64 byte in utf-8 encoding."));
            return -1;
        }
        errno_t err = strcpy_s(data.customInfo, HWM_MAX_CUSTOM_INFO_LEN, customInfo.c_str());
        if (err != 0)
        {
            AfxMessageBox(_T("String Copy Error!"));
        }
    }
    ret = hwmsdkagent::CreateConf(&data, participants, realCount);
    
    // ڴ
    memset(&data, 0, sizeof(hwmsdkagent::HwmCreateConfInfo));
    return ret;
}

void demoCreateConfWithAttendeeDlg::OnBnClickedCancel()
{
    // TODO: ڴӿؼ֪ͨ
    CDialogEx::OnCancel();
}


void demoCreateConfWithAttendeeDlg::OnBnClickedOk()
{
    // TODO: ڴӿؼ֪ͨ
    UpdateData(1);
    int ret = clickCreatConfWithAttendee();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("Create conf with attendee error");
        return;
    }
    CDialogEx::OnOK();
}

void demoCreateConfWithAttendeeDlg::OnComboConfIdTypeChange()
{
    int select = m_confIdTypeCombo.GetCurSel();
    if (select > 0)
    {
        if (select - 1 < vmrList.size())
        {
            if (strlen(vmrList[select - 1].guestPwd) > 0)
            {
                m_confPassEdit.SetWindowTextW(CTools::UTF2UNICODE(vmrList[select - 1].guestPwd).c_str());
            }
            else
            {
                m_confPassEdit.SetWindowText(_T("no guest pass"));
            }

            // ΪIdʱҪֵ
            if (m_vmrConfIdTypeCtrl.GetCurSel() != 1)
            {
                hwmsdkagent::HwmJoinConfPermissionType joinConfRestrictionType = vmrList[select - 1].joinConfRestrictionType;
                if (joinConfRestrictionType == 0)
                {
                    m_confAdmissionCombo.SetCurSel(0);
                }
                else
                {
                    m_confAdmissionCombo.SetCurSel(joinConfRestrictionType - 1);
                }
                m_openWaitingRoomCheck.SetCheck(vmrList[select - 1].isOpenWaitingRoom);
            }

            if (vmrList[select - 1].type == hwmsdkagent::HwmVmrIdType::CLOUD_MEETING_ROOM_ID) // ƻ
            {
                m_needPasswordCheck.EnableWindow(1);
                m_vmrConfIdTypeCtrl.EnableWindow(1);

                auto vmrIdConfIdTypeselect = m_vmrConfIdTypeCtrl.GetCurSel();
                if (vmrIdConfIdTypeselect == 1)
                {
                    // id
                    m_confPassEdit.SetWindowText(_T("random guest pass"));
                    m_confPassEdit.EnableWindow(1);
                }
                else
                {
                    // ̶id
                    m_confPassEdit.EnableWindow(0);
                }
            }
            else // ˻
            {
                m_needPasswordCheck.EnableWindow(0);
                m_vmrConfIdTypeCtrl.EnableWindow(0);
                m_confPassEdit.EnableWindow(0);
            }
        }
        else
        {
            // vmr
            m_confPassEdit.SetWindowText(_T("random guest pass"));
            m_needPasswordCheck.EnableWindow(1);
            m_confPassEdit.EnableWindow(1);
            m_vmrConfIdTypeCtrl.SetCurSel(1);
            m_vmrConfIdTypeCtrl.EnableWindow(0);
            return;
        }
    }
    else
    {
        m_confPassEdit.SetWindowText(_T("random guest pass"));
        m_needPasswordCheck.EnableWindow(1);
        m_confPassEdit.EnableWindow(1);
        m_vmrConfIdTypeCtrl.EnableWindow(0);
    }

    // ͱ䶯,vmrConfIdTypeóɹ̶id
    m_vmrConfIdTypeCtrl.SetCurSel(0);
}

void demoCreateConfWithAttendeeDlg::OnComboVmrConfIdTypeChange()
{
    int select = m_confIdTypeCombo.GetCurSel();
    if (select > 0)
    {
        if (select - 1 < vmrList.size())
        {
            if (strlen(vmrList[select - 1].guestPwd) > 0)
            {
                m_confPassEdit.SetWindowTextW(CTools::UTF2UNICODE(vmrList[select - 1].guestPwd).c_str());
            }
            else
            {
                m_confPassEdit.SetWindowText(_T("no guest pass"));
            }

            // ΪIdʱҪֵ
            if (m_vmrConfIdTypeCtrl.GetCurSel() != 1)
            {
                hwmsdkagent::HwmJoinConfPermissionType joinConfRestrictionType = vmrList[select - 1].joinConfRestrictionType;
                if (joinConfRestrictionType == 0)
                {
                    m_confAdmissionCombo.SetCurSel(0);
                }
                else
                {
                    m_confAdmissionCombo.SetCurSel(joinConfRestrictionType - 1);
                }
                m_openWaitingRoomCheck.SetCheck(vmrList[select - 1].isOpenWaitingRoom);
            }
        }

        auto vmrIdConfIdTypeselect = m_vmrConfIdTypeCtrl.GetCurSel();
        if (vmrIdConfIdTypeselect == 1)
        {
            // id
            m_confPassEdit.SetWindowText(_T("random guest pass"));
            m_confPassEdit.EnableWindow(1);
        }
        else
        {
            // ̶id
            m_confPassEdit.EnableWindow(0);
        }
    }
}

LRESULT demoCreateConfWithAttendeeDlg::OnVmrList(WPARAM wparam, LPARAM lparam)
{
    vmrList = demoData::GetInstance().GetVmrList();
    m_confIdTypeCombo.ResetContent();
    m_confIdTypeCombo.InsertString(0, _T("id"));
    m_confPassEdit.SetWindowText(_T("random guest pass"));
    if (!vmrList.empty())
    {
        m_confIdTypeCombo.InsertString(1, _T("˻id"));
    }
    for (int i = 1; i < vmrList.size(); i++)
    {
        const auto text = CTools::UTF2UNICODE(std::string(vmrList[i].name) + "(" + std::to_string(vmrList[i].maxParties) + ") "
            + std::string(vmrList[i].vmrConferenceId));
        m_confIdTypeCombo.InsertString(i + 1, text.c_str());
    }
    // ƻ
    if (demoData::GetInstance().GetIsEnableShareVmr())
    {
        m_confIdTypeCombo.InsertString(vmrList.size() + 1, _T("ƻ"));
    }
    m_confIdTypeCombo.SetCurSel(0);
    return 0;
}


void demoCreateConfWithAttendeeDlg::OnBnClickedButtonAddHwmConfAttendee()
{
    bool isAddSuc = m_addAttendeeLogic.AddAttendee();
    if (isAddSuc)
    {
        fillAttendees();
    }
}


void demoCreateConfWithAttendeeDlg::OnBnClickedButtonDeleteHwmConfAttendee()
{
    CString input;
    m_editDeleteAttendee.GetWindowText(input);
    bool isDeleteSuc = m_addAttendeeLogic.DeleteAttendee(input);
    if (isDeleteSuc)
    {
        fillAttendees();
    }
}

void demoCreateConfWithAttendeeDlg::fillAttendees()
{
    std::string attendeeStr = m_addAttendeeLogic.GetAttendeeStr();
    m_attendeesEdit.SetWindowTextW(CTools::UTF2UNICODE(attendeeStr).c_str());
}