﻿#include "stdafx.h"
#include "demoData.h"
#include "demoCustomMessage.h"

demoData demoData::instance;

demoData& demoData::GetInstance()
{
    return instance;
}

void demoData::UpdateConfList(const std::vector<hwmsdkagent::HwmConfListInfo>& newConfList)
{
    {
        std::lock_guard<std::mutex> lock(confListMutex);
        confList = newConfList;
    }
    publish(confListObservors, WM_CONFLIST_UPDATE);
}

std::vector<hwmsdkagent::HwmConfListInfo> demoData::GetConfList()
{
    std::lock_guard<std::mutex> lock(confListMutex);
    return confList;
}

void demoData::subscribeConfList(HWND hwnd)
{
    confListObservors.insert(hwnd);
}

void demoData::unsubscribeConfList(HWND hwnd)
{
    const auto it = confListObservors.find(hwnd);
    if(it != confListObservors.end())
    {
        confListObservors.erase(it);
    }
}

void demoData::UpdateVmrListInfo(const VmrListInfo& newVmrListInfo)
{
    vmrListInfo = newVmrListInfo;
    publish(vmrListObservors, WM_VMRLIST_UPDATE);
}

std::vector<hwmsdkagent::HwmVmrInfo> demoData::GetVmrList()
{
    return vmrListInfo.vmrList;
}

bool demoData::GetIsEnableShareVmr()
{
    return vmrListInfo.isEnableShareVmr;
}

void demoData::subscribeVmrList(HWND hwnd)
{
    vmrListObservors.insert(hwnd);
}

void demoData::SetConfDetail(const hwmsdkagent::HwmConfDetail& newConfDetail)
{
    attendees.clear();
    attendees.insert(attendees.end(), newConfDetail.attendees, newConfDetail.attendees + newConfDetail.attendeeLen);
    confDetail = newConfDetail;
    confDetail.attendees = attendees.data();
    confDetail.attendeeLen = attendees.size();
    m_subCycleConf.clear();
    if(confDetail.confListInfo.conferenceType == hwmsdkagent::CONF_TYPE_CYCLE && nullptr != confDetail.confListInfo.subConfParam)
    {
        m_subCycleConf.insert(m_subCycleConf.end(), confDetail.confListInfo.subConfParam, confDetail.confListInfo.subConfParam + confDetail.confListInfo.subConfSize);
    }
    
    if(IsWindow(confDetailHwnd))
    {
        PostMessage(confDetailHwnd, WM_CONFDETAIL_UPDATE, 0, 0);
    }
}

hwmsdkagent::HwmConfDetail demoData::GetConfDetail()
{
    return confDetail;
}

void demoData::subscribeConfDetail(HWND hwnd)
{
    confDetailHwnd = hwnd;
}

void demoData::subscribeWindowHandle(HWND hwnd)
{
    m_windowHandle = hwnd;
}

void demoData::SetTargetLanguageTypeList(const hwmsdkagent::HwmTargetLanguageTypeList &targetLanguageTypeList)
{
    m_targetLanguageTypeList.clear();
    for (int i = 0; i < targetLanguageTypeList.targetLanguageTypeSize; i++)
    {
        m_targetLanguageTypeList.push_back(targetLanguageTypeList.targetLanguageTypes[i].targetLanguageType);
    }

    if (IsWindow(m_subtitleSettingHWnd))
    {
        PostMessage(m_subtitleSettingHWnd, WM_UPDATE_SUBTITLE_LANGUAGE_LIST, 0, 0);
    }
}

std::vector<hwmsdkagent::HwmTargetLanguageType> demoData::GetTargetLanguageTypeList()
{
    return m_targetLanguageTypeList;
}

const std::string demoData::GetLanguageName(hwmsdkagent::HwmTargetLanguageType type)
{
    return m_languageTypeMap.count(type) ? m_languageTypeMap[type] : "";
}

void demoData::subscribeSubtitleSettingHandle(HWND hwnd)
{
    m_subtitleSettingHWnd = hwnd;
}

void demoData::SetConfInfo(const hwmsdkagent::HwmConfInfo & newConfInfo)
{
    confInfo = newConfInfo;
    if (IsWindow(confInfoHwnd))
    {
        PostMessage(confInfoHwnd, WM_CONFINFO_UPDATE,0,0);
    }
}

hwmsdkagent::HwmConfInfo demoData::GetConfInfo()
{
    return confInfo;
}

void demoData::subscribeConfInfo(HWND hwnd)
{
    confInfoHwnd = hwnd;
}

void demoData::SetWindowHandleInfo(int msgId, hwmsdkagent::HwmHwndListInfo info)
{
    if (IsWindow(m_windowHandle))
    {
        hwmsdkagent::HwmHwndListInfo* hwndInfo = new(std::nothrow) hwmsdkagent::HwmHwndListInfo{info};
        if (hwndInfo != nullptr)
        {
            if (msgId == WM_WINDLE_HANDLE_UPDATE)
            {
                PostMessage(m_windowHandle, WM_WINDLE_HANDLE_UPDATE, reinterpret_cast<WPARAM>(hwndInfo), 0);
            }
            else if (msgId == WM_WINDLE_HANDLE_NOTIFY)
            {
                PostMessage(m_windowHandle, WM_WINDLE_HANDLE_NOTIFY, reinterpret_cast<WPARAM>(hwndInfo), 0);
            }
            else
            {
                delete hwndInfo;
                hwndInfo = nullptr;
            }
        }
    }
}
const std::vector<hwmsdkagent::HwmSubCycleConfParam> demoData::GetSubCycleConfInfo()
{
    return m_subCycleConf;
}

std::vector<hwmsdkagent::HwmWatchItem>& demoData::ModifyWatchList()
{
    return m_watchList;
}

std::vector<hwmsdkagent::HwmWatchItem> demoData::GetWatchList()
{
    return m_watchList;
}

void demoData::SetAnnoWnd(CustomWnd* annoWnd)
{
    m_annoWnd = annoWnd;
}

CustomWnd* demoData::GetAnnoWnd()
{
    return m_annoWnd;
}

void demoData::SetStartProjectionHwnd(HWND hwnd)
{
    m_startProjectionHwnd = hwnd;
}

HWND demoData::GetStartProjectionHwnd()
{
    return m_startProjectionHwnd;
}

void demoData::publish(std::unordered_set<HWND>& observerList, unsigned msgId)
{
    std::vector<HWND> clearList;
    for (const auto item : observerList)
    {
        if(IsWindow(item))
        {
            PostMessage(item, msgId, 0, 0);
        }
        else
        {
            clearList.push_back(item);
        }
    }
    for (const auto item : clearList)
    {
        const auto it = observerList.find(item);
        if(it != observerList.end())
        {
            observerList.erase(it);
        }
    }
}

demoData::demoData() :
    confDetailHwnd(nullptr), 
    m_subtitleSettingHWnd(nullptr),
    confDetail{ 0 }, 
    hasRecordPermission(false),
    isSMSEnable(false),
    m_confInfoDlg(NULL),
    confInfoHwnd(NULL),
    m_windowHandle(NULL),
    m_SSOHandle(nullptr),
    confInfo{ 0 }, 
    timeZoneList{
    {"(GMT-12:00) Eniwetok, Kwajalein", -12 * 60 }
    , {"(GMT-11:00) Midway Island, Samoa", -11 * 60 }
    , {"(GMT-10:00) Hawaii", -10 * 60 }
    , {"(GMT-09:00) Alaska", -9 * 60 }
    , {"(GMT-08:00) Pacific Time(US&Canada);Tijuana", -8 * 60 }
    , {"(GMT-07:00) Arizona", -7 * 60 }
    , {"(GMT-07:00) Mountain Time(US&Canada)", -7 * 60 }
    , {"(GMT-06:00) Central America", -6 * 60 }
    , {"(GMT-06:00) Central Time(US&Canada)", -6 * 60 }
    , {"(GMT-06:00) Mexico City", -6 * 60 }
    , {"(GMT-06:00) Saskatchewan", -6 * 60 }
    , {"(GMT-05:00) Bogota, Lima, Quito", -5 * 60 }
    , {"(GMT-05:00) Eastern Time(US&Canada)", -5 * 60 }
    , {"(GMT-05:00) Indiana(East)", -5 * 60 }
    , {"(GMT-04:00) Atlantic time(Canada)", -4 * 60 }
    , {"(GMT-04:00) Caracas, La Paz", -4 * 60 }
    , {"(GMT-04:00) Santiago", -4 * 60 }
    , {"(GMT-03:30) Newfoundland", -3 * 60 }
    , {"(GMT-03:00) Brasilia", -3 * 60 }
    , {"(GMT-03:00) Buenos Aires, Georgetown", -3 * 60 }
    , {"(GMT-03:00) Greenland", -3 * 60 }
    , {"(GMT-02:00) Mid-Atlantic", -2 * 60 }
    , {"(GMT-01:00) Azores", -1 * 60 }
    , {"(GMT-01:00) Cape Verde Is.", -1 * 60 }
    , {"(GMT) Casablanca, Monrovia", 0 }
    , {"(GMT) Greenwich Mean Time:Dublin, Edinburgh, Lisbon, London", 0 }
    , {"(GMT+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna", 1 * 60 }
    , {"(GMT+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague", 1 * 60 }
    , {"(GMT+01:00) Brussels, Copenhagen, Madrid, Paris", 1 * 60 }
    , {"(GMT+01:00) Sarajevo, Skopje, Sofija, Warsaw, Zagreb", 1 * 60 }
    , {"(GMT+01:00) West Central Africa", 1 * 60 }
    , {"(GMT+02:00) Athens, Istanbul, Vilnius", 2 * 60 }
    , {"(GMT+02:00) Bucharest", 2 * 60 }
    , {"(GMT+02:00) Cairo", 2 * 60 }
    , {"(GMT+02:00) Harare, Pretoria", 2 * 60 }
    , {"(GMT+02:00) Helsinki, Riga, Tallinn", 2 * 60 }
    , {"(GMT+02:00) Jerusalem", 2 * 60 }
    , {"(GMT+03:00) Baghdad, Minsk", 3 * 60 }
    , {"(GMT+03:00) Kuwait, Riyadh", 3 * 60 }
    , {"(GMT+03:00) Moscow, St. Petersburg, Volgograd", 3 * 60 }
    , {"(GMT+03:00) Nairobi", 3 * 60 }
    , {"(GMT+03:30) Tehran", 3 * 60 + 30 }
    , {"(GMT+04:00) Abu Dhabi, Muscat", 4 * 60 }
    , {"(GMT+04:00) Baku, Tbilisi, Yerevan", 4 * 60 }
    , {"(GMT+04:30) Kabul", 4 * 60 + 30 }
    , {"(GMT+05:00) Ekaterinburg", 5 * 60 }
    , {"(GMT+05:00) Islamabad, Karachi, Tashkent", 5 * 60 }
    , {"(GMT+05:30) Calcutta, Chennai, Mumbai, New Delhi", 5 * 60 }
    , {"(GMT+05:45) Kathmandu", 5 * 60 + 45 }
    , {"(GMT+06:00) Almaty, Novosibirsk", 6 * 60 }
    , {"(GMT+06:00) Astana, Dhaka", 6 * 60 }
    , {"(GMT+06:00) Sri Jayawardenepura", 6 * 60 }
    , {"(GMT+06:30) Rangoon", 6 * 60 + 30}
    , {"(GMT+07:00) Bangkok, Hanoi, Jakarta", 7 * 60 }
    , {"(GMT+07:00) Krasnoyarsk", 7 * 60 }
    , {"(GMT+08:00) Beijing, Chongqing, Hong Kong, Urumqi, Taipei", 8 * 60 }
    , {"(GMT+08:00) Irkutsk, Ulaan Bataar", 8 * 60 }
    , {"(GMT+08:00) Kuala Lumpur, Singapore", 8 * 60 }
    , {"(GMT+08:00) Perth", 8 * 60 }
    , {"(GMT+09:00) Osaka, Sapporo, Tokyo", 9 * 60 }
    , {"(GMT+09:00) Seoul", 9 * 60 }
    , {"(GMT+09:00) Yakutsk", 9 * 60 }
    , {"(GMT+09:30) Adelaide", 9 * 60 + 30 }
    , {"(GMT+09:30) Darwin", 9 * 60 +30 }
    , {"(GMT+10:00) Brisbane", 10 * 60 }
    , {"(GMT+10:00) Canberra, Melbourne, Sydney", 10 * 60 }
    , {"(GMT+10:00) Guam, Port Moresby", 10 * 60 }
    , {"(GMT+10:00) Hobart", 10 * 60 }
    , {"(GMT+10:00) Vladivostok", 10 * 60 }
    , {"(GMT+11:00) Magadan, Solomon Is., New Caledonia", 12 * 60 }
    , {"(GMT+12:00) Auckland, Welington", 12 * 60 }
    , {"(GMT+12:00) Fiji", 12 * 60 }
    , {"(GMT+13:00) Nuku'alofa", 13 * 60 }
    , {"(GMT+09:00) Irkutsk", 9 * 60 }
    , {"(GMT) Casablanca", 0 }
    , {"(GMT+04:00) Baku", 4 * 60 }
    , {"(GMT+12:00) Kamchatka, Marshall Is.", 12 * 60 }
    },
    m_languageTypeMap{
        {hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_DEFAULT, "DEFAULT"},
        {hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_CN,      "CN"},    
        {hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_EN,      "EN"},   
        {hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_GE,      "GE"},     
        {hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_FR,      "FR"},
        {hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_RU,      "RU"},
        {hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_JA,      "JA"},
        {hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_KO,      "KO"},
        {hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_ES,      "ES"},
        {hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_PT,      "PT"},
        {hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_AR,      "AR"},
        {hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_IT,      "IT"},
        {hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_TH,      "TH"},
        {hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_ID,      "ID"},
        {hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_MS,      "MS"},
        {hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_TR,      "TR"},
    }
{
}