﻿#pragma once

#include <HwmAgentCallback.h>
#include <mutex>
#include <vector>
#include <unordered_set>
#include <unordered_map>
#include "demoConfInfoDlg.h"
#include "CustomWnd.h"

struct VmrListInfo
{
    std::vector<hwmsdkagent::HwmVmrInfo> vmrList;
    bool isEnableShareVmr;
};

class demoData
{
public:
    ~demoData() = default;
    static demoData &GetInstance();

    void UpdateConfList(const std::vector<hwmsdkagent::HwmConfListInfo> &newConfList);
    std::vector<hwmsdkagent::HwmConfListInfo> GetConfList();
    void subscribeConfList(HWND hwnd);
    void unsubscribeConfList(HWND hwnd);

    void UpdateVmrListInfo(const VmrListInfo& vmrListInfo);
    std::vector<hwmsdkagent::HwmVmrInfo> GetVmrList();
    bool GetIsEnableShareVmr();
    void subscribeVmrList(HWND hwnd);

    void SetConfDetail(const hwmsdkagent::HwmConfDetail &newConfDetail);
    hwmsdkagent::HwmConfDetail GetConfDetail();
    void subscribeConfDetail(HWND hwnd);
    // 设置WindowHandle的窗口句柄
    void subscribeWindowHandle(HWND hwnd);
    void SetTargetLanguageTypeList(const hwmsdkagent::HwmTargetLanguageTypeList &targetLanguageTypeList);
    std::vector<hwmsdkagent::HwmTargetLanguageType> GetTargetLanguageTypeList();
    const std::string GetLanguageName(hwmsdkagent::HwmTargetLanguageType type);
    void subscribeSubtitleSettingHandle(HWND hwnd);
    // 设置会议信息
    void SetConfInfo(const hwmsdkagent::HwmConfInfo &newConfInfo);
	// 获取会议信息
    hwmsdkagent::HwmConfInfo GetConfInfo();
	// 设置窗口句柄
    void subscribeConfInfo(HWND hwnd);
    // 根据消息Id设置不同类型的窗口句柄信息
    void SetWindowHandleInfo(int msgId, hwmsdkagent::HwmHwndListInfo info);
    const std::vector<std::pair<std::string, int>> &GetTimeZoneList() const {return timeZoneList;}
	// 获取外部会议信息框对象
    demoConfInfoDlg* GetConfInfoDlgObj() const
    {
        return m_confInfoDlg;
    }
	// 设置外部会议信息框对象
    void SetConfInfoDlgObj(demoConfInfoDlg *obj)
    {
        m_confInfoDlg = obj;
    }

    bool HasRecordPermission() const
    {
        return hasRecordPermission;
    }
    void SetHasRecordPermission(bool recordPermission)
    {
        hasRecordPermission = recordPermission;
    }
    bool IsSmsEnable() const
    {
        return isSMSEnable;
    }
    void SetIsSmsEnable(bool smsEnable)
    {
        isSMSEnable = smsEnable;
    }
    bool GetCorpEnableSummary() const
    {
        return m_corpEnableSummary;
    }
    void SetCorpEnableSummary(bool value)
    {
        m_corpEnableSummary = value;
    }
    // 设置SSO登录对话框窗口句柄
    void SetSSOHwnd(HWND hwnd)
    {
        m_SSOHandle = hwnd;
    }
    HWND GetSSOHwnd() const
    {
        return m_SSOHandle;
    }
    const std::vector<hwmsdkagent::HwmSubCycleConfParam> GetSubCycleConfInfo();

    std::vector<hwmsdkagent::HwmWatchItem>& ModifyWatchList();
    std::vector<hwmsdkagent::HwmWatchItem> GetWatchList();

    void SetAnnoWnd(CustomWnd* annoWnd);
    CustomWnd* GetAnnoWnd();

    // 设置和保存开启投屏接口窗口句柄
    void SetStartProjectionHwnd(HWND hwnd);
    HWND GetStartProjectionHwnd();
protected:
    void publish(std::unordered_set<HWND> &observerList, unsigned msgId);

private:
    demoData();
    static demoData instance;

private:
    std::mutex confListMutex;
    std::vector<hwmsdkagent::HwmConfListInfo> confList;
    std::unordered_set<HWND> confListObservors;

    VmrListInfo vmrListInfo;
    std::unordered_set<HWND> vmrListObservors;

    hwmsdkagent::HwmConfDetail confDetail;
    std::vector<hwmsdkagent::HwmAttendeeInfo> attendees;
    std::vector<hwmsdkagent::HwmSubCycleConfParam> m_subCycleConf;
    HWND confDetailHwnd;
    std::vector<hwmsdkagent::HwmTargetLanguageType> m_targetLanguageTypeList;
    HWND m_subtitleSettingHWnd;
    std::unordered_map<hwmsdkagent::HwmTargetLanguageType, std::string> m_languageTypeMap;

    std::vector<std::pair<std::string, int>> timeZoneList;
    demoConfInfoDlg* m_confInfoDlg;
	// 会议信息对象
    hwmsdkagent::HwmConfInfo confInfo;
	// 会议信息句柄
    HWND confInfoHwnd;

    // Window Handle 窗口句柄
    HWND m_windowHandle;
    bool hasRecordPermission;
    bool isSMSEnable;
    bool m_corpEnableSummary;
    // SSO登录对话框窗口句柄
    HWND m_SSOHandle;
    std::vector<hwmsdkagent::HwmWatchItem> m_watchList;  // 选看列表
    CustomWnd* m_annoWnd{ nullptr };        // 标注窗口
    HWND m_startProjectionHwnd{ NULL };     // 开启投屏窗口
};
