﻿// demoEditVmrInfoDialog.cpp: 实现文件
//

#include "stdafx.h"
#include "demo.h"
#include "demoEditVmrInfoDialog.h"
#include <HwmSdkAgent.h>
#include "afxdialogex.h"
#include "demoData.h"
#include "demoTools.h"
#include "demoCustomMessage.h"


// demoEditVmrInfoDialog 对话框

IMPLEMENT_DYNAMIC(demoEditVmrInfoDialog, CDialogEx)

demoEditVmrInfoDialog::demoEditVmrInfoDialog(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_EDIT_VMR_INFO_DIALOG, pParent)
{

}

demoEditVmrInfoDialog::~demoEditVmrInfoDialog()
{
}

BOOL demoEditVmrInfoDialog::OnInitDialog()
{
    const auto ret = CDialogEx::OnInitDialog();
    vmrList = demoData::GetInstance().GetVmrList();
    updateData();
    return ret;
}

LRESULT demoEditVmrInfoDialog::OnVmrList(WPARAM wparam, LPARAM lparam)
{
    vmrList = demoData::GetInstance().GetVmrList();
    updateData();
    return 0;
}

void demoEditVmrInfoDialog::OnVmrChange()
{
    int select = m_vmrCombo.GetCurSel();
    if (select >= 0 && select < vmrList.size())
    {
        m_vmrNameEdit.SetWindowTextW(CTools::UTF2UNICODE(vmrList[select].name).c_str());
        m_vmrChairPassEdit.SetWindowTextW(CTools::UTF2UNICODE(vmrList[select].chairmanPwd).c_str());
        m_vmrGuestPassEdit.SetWindowTextW(CTools::UTF2UNICODE(vmrList[select].guestPwd).c_str());
        hwmsdkagent::HwmJoinConfPermissionType joinConfRestrictionType = vmrList[select].joinConfRestrictionType;
        if (joinConfRestrictionType == 0)
        {
            m_confAdmissionCtrl.SetCurSel(0);
        }
        else
        {
            m_confAdmissionCtrl.SetCurSel(joinConfRestrictionType - 1);
        }
        m_allowGuestStartConf.SetCheck(vmrList[select].allowGuestStartConf);
        m_openWaitingroom.SetCheck(vmrList[select].isOpenWaitingRoom);
    }
}

void demoEditVmrInfoDialog::updateData()
{
    int enable = 0;
    m_vmrCombo.ResetContent();
    if (!vmrList.empty())
    {
        enable = 1;
        for (int i = 0; i < vmrList.size(); ++i)
        {
            const auto &item = vmrList[i];
            m_vmrCombo.InsertString(i, CTools::UTF2UNICODE(item.vmrConferenceId).c_str());
        }
        m_vmrCombo.SetCurSel(0);
        m_vmrNameEdit.SetWindowTextW(CTools::UTF2UNICODE(vmrList[0].name).c_str());
        m_vmrChairPassEdit.SetWindowTextW(CTools::UTF2UNICODE(vmrList[0].chairmanPwd).c_str());
        m_vmrGuestPassEdit.SetWindowTextW(CTools::UTF2UNICODE(vmrList[0].guestPwd).c_str());

        m_confAdmissionCtrl.ResetContent();
        m_confAdmissionCtrl.InsertString(0, _T("所有用户"));
        m_confAdmissionCtrl.InsertString(1, _T("企业内部"));
        m_confAdmissionCtrl.InsertString(2, _T("仅被邀请的人"));
        hwmsdkagent::HwmJoinConfPermissionType joinConfRestrictionType = vmrList[0].joinConfRestrictionType;
        if (joinConfRestrictionType == 0)
        {
            m_confAdmissionCtrl.SetCurSel(0);
        }
        else
        {
            m_confAdmissionCtrl.SetCurSel(joinConfRestrictionType - 1);
        }
        m_allowGuestStartConf.SetCheck(vmrList[0].allowGuestStartConf);
        m_openWaitingroom.SetCheck(vmrList[0].isOpenWaitingRoom);
    }
    m_vmrCombo.EnableWindow(enable);
    m_vmrNameEdit.EnableWindow(enable);
    m_vmrChairPassEdit.EnableWindow(enable);
    m_vmrGuestPassEdit.EnableWindow(enable);
    m_allowGuestStartConf.EnableWindow(enable);
    m_confAdmissionCtrl.EnableWindow(enable);
    m_openWaitingroom.EnableWindow(enable);
}

void demoEditVmrInfoDialog::OnOK()
{
    if (vmrList.empty())
    {
        CDialog::OnCancel();
        return;
    }

    int select = m_vmrCombo.GetCurSel();
    if (select >= 0 && select < vmrList.size())
    {
        hwmsdkagent::ChangeVmrInfoParam infoParam = {0};

        auto ret = strcpy_s(infoParam.vmrId, sizeof(infoParam.vmrId), vmrList[select].vmrId);
        CString input;
        m_vmrNameEdit.GetWindowText(input);
        if (input.IsEmpty())
        {
            AfxMessageBox(_T("Name Empty!"));
            return;
        }
        ret += strcpy_s(infoParam.vmrName, sizeof(infoParam.vmrName), CTools::UNICODE2UTF(input.GetString()).c_str());

        m_vmrChairPassEdit.GetWindowText(input);
        if (input.IsEmpty())
        {
            AfxMessageBox(_T("Chairman Password Empty!"));
            return;
        }
        ret += strcpy_s(infoParam.chairPwd, sizeof(infoParam.chairPwd), CTools::UNICODE2UTF(input.GetString()).c_str());

        m_vmrGuestPassEdit.GetWindowText(input);
        if (input.IsEmpty())
        {
            AfxMessageBox(_T("Guest Password Empty! There will be no guest password for the vmr!"));
        }
        ret += strcpy_s(infoParam.guestPwd, sizeof(infoParam.guestPwd), CTools::UNICODE2UTF(input.GetString()).c_str());
        
        // combobox框内不显示匿名入会用户限制
        if (m_confAdmissionCtrl.GetCurSel() == 0)
        {
            infoParam.joinConfRestrictionType = static_cast<hwmsdkagent::HwmJoinConfPermissionType>(m_confAdmissionCtrl.GetCurSel());
        }
        else
        {
            infoParam.joinConfRestrictionType = static_cast<hwmsdkagent::HwmJoinConfPermissionType>(m_confAdmissionCtrl.GetCurSel() + 1);
        }

        if (ret != 0)
        {
            AfxMessageBox(_T("String Copy Error!"));
        }
        infoParam.allowGuestStartConf = m_allowGuestStartConf.GetCheck() == 1;
        infoParam.isOpenWaitingRoom = m_openWaitingroom.GetCheck() == 1;
        
        hwmsdkagent::ChangeVmrInfo(&infoParam);
    }

    CDialog::OnOK();
}

void demoEditVmrInfoDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);

    DDX_Control(pDX, IDC_COMBO_VMR_LIST, m_vmrCombo);
    DDX_Control(pDX, IDC_EDIT_VMR_NAME, m_vmrNameEdit);
    DDX_Control(pDX, IDC_EDIT_VMR_CHAIR_PASS, m_vmrChairPassEdit);
    DDX_Control(pDX, IDC_EDIT_VMR_GUEST_PASS, m_vmrGuestPassEdit);
    DDX_Control(pDX, IDC_EDIT_VMR_ALLOW_GUEST_START_CONF, m_allowGuestStartConf);
    DDX_Control(pDX, IDC_COMBO_VMR_ADMISSION, m_confAdmissionCtrl);
    DDX_Control(pDX, IDC_EDIT_VMR_OPEN_WAITINGROOM, m_openWaitingroom);
    hwmsdkagent::GetVmrList();
    demoData::GetInstance().subscribeVmrList(m_hWnd);
}


BEGIN_MESSAGE_MAP(demoEditVmrInfoDialog, CDialogEx)
    ON_MESSAGE(WM_VMRLIST_UPDATE, &demoEditVmrInfoDialog::OnVmrList)

    ON_CBN_SELCHANGE(IDC_COMBO_VMR_LIST, &demoEditVmrInfoDialog::OnVmrChange)
END_MESSAGE_MAP()

