// demoInitDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "demo.h"
#include "demoInitDlg.h"
#include "afxdialogex.h"
#include "HwmSdkAgent.h"
#include "demoTools.h"
#include "demoNotifyProc.h"
#include "demoCallBackProc.h"

// demoInitDlg Ի

IMPLEMENT_DYNAMIC(demoInitDlg, CDialogEx)

demoInitDlg::demoInitDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_INIT_DIALOG, pParent)
    , m_radioAuthType(0)
    , m_isMultiAppLoginSupported(FALSE)
{

}

demoInitDlg::~demoInitDlg()
{
}

BOOL demoInitDlg::OnInitDialog()
{
    BOOL ret = CDialogEx::OnInitDialog();

    m_comboSiteType.InsertString(0, _T("йվ"));
    m_comboSiteType.InsertString(1, _T("վ"));
    m_comboSiteType.SetCurSel(0);

    m_comboLogLevel.InsertString(0, _T("INFO"));
    m_comboLogLevel.InsertString(1, _T("WARNING"));
    m_comboLogLevel.InsertString(2, _T("ERROR"));
    m_comboLogLevel.SetCurSel(0);

    CString defaultAppId = _T("");
    CTools::getIniConfigParam(_T("LoginConfig"), _T("defaultAppId"), defaultAppId);
    m_editAppId.SetWindowText(defaultAppId);
    m_editExeName.SetWindowText(_T("HwmSdk"));
    m_logKeepDays.SetWindowText(_T("0"));
    m_appVersion.SetWindowText(_T(""));

    return ret;
}

void demoInitDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_APP_ID, m_editAppId);
    DDX_Radio(pDX, IDC_RADIO_AUTH_TYPE_ACCOUNT, m_radioAuthType);
    DDX_Control(pDX, IDC_COMBO_SITE_TYPE, m_comboSiteType);
    DDX_Control(pDX, IDC_COMBO_LOG_LEVEL, m_comboLogLevel);
    DDX_Control(pDX, IDC_EDIT_EXE_NAME, m_editExeName);
    DDX_Control(pDX, IDC_EDIT_LOG_KEEP_DAYS_ID, m_logKeepDays);
    DDX_Control(pDX, IDC_EDIT_PREFERRED_CAMERA, m_preferredCamera);
    DDX_Control(pDX, IDC_EDIT_APP_VERSION, m_appVersion);
    DDX_Check(pDX, IDC_CHECK1, m_isMultiAppLoginSupported);
}

BEGIN_MESSAGE_MAP(demoInitDlg, CDialogEx)
    ON_BN_CLICKED(IDC_BUTTON_INIT_OK, &demoInitDlg::OnBnClickedButtonOk)
    ON_BN_CLICKED(IDC_RADIO_AUTH_TYPE_ACCOUNT, &demoInitDlg::OnBnClickedRadioAuthTypeAccount)
    ON_BN_CLICKED(IDC_RADIO_AUTH_TYPE_APPID, &demoInitDlg::OnBnClickedRadioAuthTypeAppid)
END_MESSAGE_MAP()

static demoNotifyProc *notifyObj = new(std::nothrow) demoNotifyProc();
//ûصӿ
static demoCallbackProc *callbackObj = new(std::nothrow) demoCallbackProc();

/**
*ʼӿڣӦ
*/
int demoInitDlg::Init()
{ 
    //װνṹ
    hwmsdkagent::HwmInitInfo initParam;
    memset(&initParam, 0, sizeof(hwmsdkagent::HwmInitInfo));

    //ȡsdk·
    TCHAR szFilePath[HWM_MAX_FILE_PATH_LEN] = { 0 };
    GetModuleFileName(NULL, szFilePath, HWM_MAX_FILE_PATH_LEN);
    if (_tcsrchr(szFilePath, _T('\\')) != NULL)
    {
        (_tcsrchr(szFilePath, _T('\\')))[1] = 0; // ɾļֻ·ִ
    }
    string temp = CTools::UNICODE2UTF(szFilePath) + "\\HwmSdk\\";
    // exeļ󣬸Զexeļƴexe·(UTF8ʽ)
    CString editExeNameCstr;
    m_editExeName.GetWindowText(editExeNameCstr);
    string exeName = CTools::UNICODE2UTF(editExeNameCstr.GetString());
    temp = temp + exeName + ".exe";
    errno_t err = strcpy_s(initParam.exePath, HWM_MAX_FILE_PATH_LEN, temp.c_str());
    // ָ־·û·ָappdata´Ĭ·
    string tempLogPath = CTools::UNICODE2UTF(szFilePath) + "\\log\\";
    err += strcpy_s(initParam.logPath, HWM_MAX_FILE_PATH_LEN, tempLogPath.c_str());
    string tempUserDataPath = tempLogPath + "\\UserData\\";
    err += strcpy_s(initParam.userDataPath, HWM_MAX_FILE_PATH_LEN, tempUserDataPath.c_str());
    //AppId(UTF8ʽ)
    CString editAppIdCstr;
    m_editAppId.GetWindowText(editAppIdCstr);
    string appId = CTools::UNICODE2UTF(editAppIdCstr.GetString());
    //AppIdϢAppId¼
    CTools::writeIniConfigParam(_T("LoginConfig"), _T("appId"), editAppIdCstr);
    err += strcpy_s(initParam.appId, HWM_MAX_APPID_LEN, appId.c_str());
    //ѡͷбڳѡͷ
    CString editpreferredCameraCstr;
    m_preferredCamera.GetWindowText(editpreferredCameraCstr);
    string preferredCamera = CTools::UNICODE2UTF(editpreferredCameraCstr.GetString());
    err += strcpy_s(initParam.preferredCamera, HWM_MAX_PREFERRED_CAMERA_LEN, preferredCamera.c_str());
    // Ӧð汾
    CString cAppVersion;
    m_appVersion.GetWindowText(cAppVersion);
    string appVersion = CTools::UNICODE2UTF(cAppVersion.GetString());
    err += strcpy_s(initParam.appVersion, HWM_MAX_APPVERSION_LEN, appVersion.c_str());
    if (err != S_OK)
    {
        AfxMessageBox(_T("String Copy Error!"));
    }
    //üȨ
    initParam.authType = (hwmsdkagent::HwmAuthType)m_radioAuthType;
    //ûص֪ͨ
    initParam.notify = notifyObj;
    initParam.callback = callbackObj;
    // ¼վ
    initParam.siteType = SITE_TYPE_CHINA;
    if (m_comboSiteType.GetCurSel() == 1)
    {
        initParam.siteType = SITE_TYPE_AP;
    }

    // ־
    initParam.logLevel = hwmsdkagent::HwmLogLevel::HWM_LOG_LEVEL_INFO;
    if (m_comboLogLevel.GetCurSel() == 1)
    {
        initParam.logLevel = hwmsdkagent::HwmLogLevel::HWM_LOG_LEVEL_WARNING;
    }
    else if (m_comboLogLevel.GetCurSel() == 2)
    {
        initParam.logLevel = hwmsdkagent::HwmLogLevel::HWM_LOG_LEVEL_ERROR;
    }

    // ־󱣴
    CString keepDays;
    m_logKeepDays.GetWindowText(keepDays);
    initParam.logKeepDays = static_cast<unsigned int>(_ttoi(keepDays));
    initParam.isSupportMultiAppLogin = m_isMultiAppLoginSupported;

    int ret = hwmsdkagent::Init(&initParam);
    return ret;
}


void demoInitDlg::OnBnClickedButtonOk()
{
    UpdateData(1);
    int ret = Init();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret) {
        CTools::OutputRetStr("Init error");
    }
    else {
        OnOK();
    }
}

void demoInitDlg::OnBnClickedRadioAuthTypeAccount()
{
    m_radioAuthType = 0;
}

void demoInitDlg::OnBnClickedRadioAuthTypeAppid()
{
    m_radioAuthType = 1;
}
