// demoJoinConfByIdAnonymousDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "demo.h"
#include "demoJoinConfByIdAnonymousDlg.h"
#include "afxdialogex.h"
#include "demoTools.h"
#include "HwmSdkAgent.h"

// demoJoinConfByIdAnonymousDlg Ի

IMPLEMENT_DYNAMIC(demoJoinConfByIdAnonymousDlg, CDialogEx)

demoJoinConfByIdAnonymousDlg::demoJoinConfByIdAnonymousDlg(CWnd* pParent /*=NULL*/)
    : CDialogEx(IDD_JOIN_CONF_BY_ID_ANONYMOUS_DIALOG, pParent)
    , m_enterType(0)
{

}

demoJoinConfByIdAnonymousDlg::~demoJoinConfByIdAnonymousDlg()
{
}

void demoJoinConfByIdAnonymousDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_JOIN_MEETING_ANONYMOUS_MEETING_ID, m_confIdEdit);
    DDX_Control(pDX, IDC_EDIT_JOIN_MEETING_ANONYMOUS_ACCESS_CODE, m_psdEdit);
    DDX_Control(pDX, IDC_EDIT_JOIN_MEETING_ANONYMOUS_NICKNAME, m_nicknameEdit);
    DDX_Control(pDX, IDC_EDIT_ANONYMOUS_JOIN_CONF_DOMAIN, m_domainEdit);
    DDX_Radio(pDX, IDC_RADIO_ENTER_TYPE_ACCOUNT, m_enterType);
    DDX_Control(pDX, IDC_CHECK_CAM, m_CamCheck);
    DDX_Control(pDX, IDC_CHECK_MIC, m_MicCheck);
    DDX_Control(pDX, IDC_CHECK_SPK, m_SpkCheck);
}


BEGIN_MESSAGE_MAP(demoJoinConfByIdAnonymousDlg, CDialogEx)
    ON_BN_CLICKED(IDC_BUTTON_JOIN_MEETING_ANONYMOUS_START, &demoJoinConfByIdAnonymousDlg::OnBnClickedJoinConfAnonymous)
    ON_BN_CLICKED(IDC_RADIO_ENTER_TYPE_ACCOUNT, &demoJoinConfByIdAnonymousDlg::OnBnClickedRadioEnterTypeAccount)
    ON_BN_CLICKED(IDC_RADIO_ENTER_TYPE_RANDOM, &demoJoinConfByIdAnonymousDlg::OnBnClickedRadioEnterTypeRandom)
END_MESSAGE_MAP()


// demoJoinConfByIdAnonymousDlg Ϣ

//
int demoJoinConfByIdAnonymousDlg::clickJoinConfAnonymous()
{
    CString m_confId;
    CString m_accessCode;
    CString m_nickname;
    CString m_domain;
    //ӿؼлȡ
    m_confIdEdit.GetWindowText(m_confId);
    m_psdEdit.GetWindowText(m_accessCode);
    m_nicknameEdit.GetWindowText(m_nickname);
    m_domainEdit.GetWindowText(m_domain);
    //ת
    string meetingID = CTools::UNICODE2UTF(m_confId.GetString());
    string accessCode = CTools::UNICODE2UTF(m_accessCode.GetString());
    string nickname = CTools::UNICODE2UTF(m_nickname.GetString());
    string domain = CTools::UNICODE2UTF(m_domain.GetString());

    bool isOpenCam = m_CamCheck.GetCheck() == 1 ? true : false;
    bool isOpenMic = m_MicCheck.GetCheck() == 1 ? true : false;
    bool isCloseSpk = m_SpkCheck.GetCheck() == 1 ? false : true;

    int ret = 0;
    if(m_enterType == 0){
        if (accessCode.length() > HWM_MAX_CONF_PASSWORD_LEN || meetingID.length() > HWM_MAX_CONF_ID_LEN || nickname.length() > HWM_MAX_DISPLAY_NAME_LEN) {
            return 1;
        }
        hwmsdkagent::HwmJoinConfByIdInfo data;
        memset(&data, 0, sizeof(hwmsdkagent::HwmJoinConfByIdInfo));
        strncpy_s(data.confId, meetingID.c_str(), HWM_MAX_CONF_ID_LEN);
        strncpy_s(data.password, accessCode.c_str(), HWM_MAX_CONF_PASSWORD_LEN);
        strncpy_s(data.name, nickname.c_str(), HWM_MAX_DISPLAY_NAME_LEN);
        data.isCloseSpk = isCloseSpk;
        //˷ͷ
        ret = EnableFeature(hwmsdkagent::HWM_ENABLE_FEATURE_TYPE_MIC_SWITCH, isOpenMic);
        if (hwmsdk::HWM_COMMON_SUCCESS != ret)
        {
            CTools::OutputRetStr("set enable micphone failed");
            return 1;
        }
        ret = EnableFeature(hwmsdkagent::HWM_ENABLE_FEATURE_TYPE_CAM_SWITCH, isOpenCam);
        if (hwmsdk::HWM_COMMON_SUCCESS != ret)
        {
            CTools::OutputRetStr("set enable camera failed");
            return 1;
        }
        
        ret = hwmsdkagent::JoinConfById(&data);
        memset(&data, 0, sizeof(hwmsdkagent::HwmJoinConfByIdInfo));
    } else {
        if (accessCode.length() > HWM_MAX_RANDOM_LEN || meetingID.length() > HWM_MAX_CONF_ID_LEN || nickname.length() > HWM_MAX_DISPLAY_NAME_LEN) {
            return 1;
        }
        hwmsdkagent::HwmJoinConfByRandomInfo data;
        memset(&data, 0, sizeof(hwmsdkagent::HwmJoinConfByRandomInfo));
        strncpy_s(data.confId, meetingID.c_str(), HWM_MAX_CONF_ID_LEN);
        strncpy_s(data.random, accessCode.c_str(), HWM_MAX_RANDOM_LEN);
        strncpy_s(data.name, nickname.c_str(), HWM_MAX_DISPLAY_NAME_LEN);
        strncpy_s(data.domain, domain.c_str(), HWM_MAX_DOMAIN_LEN);
        data.isCloseSpk = isCloseSpk;
        //˷ͷ
        ret = EnableFeature(hwmsdkagent::HWM_ENABLE_FEATURE_TYPE_MIC_SWITCH, isOpenMic);
        if (hwmsdk::HWM_COMMON_SUCCESS != ret)
        {
            CTools::OutputRetStr("set enable micphone failed");
            return 1;
        }
        ret = EnableFeature(hwmsdkagent::HWM_ENABLE_FEATURE_TYPE_CAM_SWITCH, isOpenCam);
        if (hwmsdk::HWM_COMMON_SUCCESS != ret)
        {
            CTools::OutputRetStr("set enable camera failed");
            return 1;
        }
        ret = hwmsdkagent::JoinConfByRandom(&data);
        memset(&data, 0, sizeof(hwmsdkagent::HwmJoinConfByRandomInfo));
    }
    accessCode.assign(accessCode.length(), '\0');

    return ret;
}

void demoJoinConfByIdAnonymousDlg::OnBnClickedJoinConfAnonymous()
{
    int ret = clickJoinConfAnonymous();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("Join meeting anonymous error");
    }
    else
    {
        //ӿڵóɹرմ
        OnOK();
    }
}

void demoJoinConfByIdAnonymousDlg::OnBnClickedRadioEnterTypeAccount()
{
    m_enterType = 0;
}



void demoJoinConfByIdAnonymousDlg::OnBnClickedRadioEnterTypeRandom()
{
    m_enterType = 1;
}


BOOL demoJoinConfByIdAnonymousDlg::OnInitDialog()
{
    CDialogEx::OnInitDialog();

    // TODO:  ڴӶĳʼ
    //˷硢Ĭϴ򿪣ͷĬϹر
    m_CamCheck.SetCheck(FALSE);
    m_MicCheck.SetCheck(TRUE);
    m_SpkCheck.SetCheck(TRUE);

    return TRUE;  // return TRUE unless you set the focus to a control
                  // 쳣: OCX ҳӦ FALSE
}
