// demoMainMenuDlg.cpp : ʵļ
//

#include "stdafx.h"
#include <map>
#include <tchar.h>
#include "demo.h"
#include "afxdialogex.h"
#include "demoMainMenuDlg.h"
#include "demoJoinConfByIdDlg.h"
#include "HwmSdkAgent.h"
#include "demoCustomMessage.h"
#include "demoTools.h"
#include "demoCreateConfWithAttendeeDlg.h"
#include "demoJoinConfByLinkDlg.h"
#include "demoSettingDlg.h"
#include "demoConfCtrlDlg.h"
#include "demoBookConfDlg.h"
#include "demoConfListDlg.h"
#include "demoEditVmrInfoDialog.h"
#include "demoConfInfoDlg.h"
#include "demoSetIncomingAnserTypeDlg.h"
#include "demoData.h"
#include "demoShowToastDlg.h"
#include "demoStartP2pConfDlg.h"
#include "demoWindowHandleTest.h"
#include "demoUploadSelfAvatarDlg.h"
#include "demoStartProjectionDlg.h"
#include "demoCustomSceneContentDlg.h"
#include "demoCustomSceneImageDlg.h"
#include "demoAcceptConfDlg.h"

// demoMainMenuDlg Ի
IMPLEMENT_DYNAMIC(demoMainMenuDlg, CDialogEx)

demoMainMenuDlg::demoMainMenuDlg(CWnd* pParent /*=NULL*/)
    : CDialogEx(IDD_MAIN_MENU_DIALOG, pParent)
    , m_bTracking(false)
{

}

demoMainMenuDlg::~demoMainMenuDlg()
{
}

BOOL demoMainMenuDlg::OnInitDialog()
{
    CDialogEx::OnInitDialog();
    // ʾʷ
    UpdateOutput();
    return TRUE;  // ǽõؼ򷵻 TRUE
}

void demoMainMenuDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_MAIN_OUTPUT, m_editMainOutput);
}


BEGIN_MESSAGE_MAP(demoMainMenuDlg, CDialogEx)
    ON_MESSAGE(WM_LOGOUT_RESULT, &demoMainMenuDlg::logoutCallBack)
    ON_MESSAGE(WM_SHOW_EXTERNAL_CONF_INFO_WND, &demoMainMenuDlg::OnShowExternalConfInfoWnd)
    ON_MESSAGE(WM_DESTROY_EXTERNAL_CONF_INFO_WND, &demoMainMenuDlg::OnDestroyExternalConfInfoWnd)

    ON_BN_CLICKED(IDC_BUTTON_CREAT_INSTANT_MEETING, &demoMainMenuDlg::OnBnClickedCreateConf)
    ON_BN_CLICKED(IDC_BUTTON_JOIN_MEETING, &demoMainMenuDlg::OnBnClickedJoinConf)
    ON_BN_CLICKED(IDC_BUTTON_LOGOUT, &demoMainMenuDlg::OnBnClickedLogout)
    ON_BN_CLICKED(IDC_BUTTON_JOIN_MEETING_BY_LINK2, &demoMainMenuDlg::OnBnClickedJoinConfByLink)
    ON_BN_CLICKED(IDC_BUTTON_SETTING, &demoMainMenuDlg::OnBnClickedButtonSetting)
    ON_BN_CLICKED(IDC_BUTTON_GO_CONF_CTRL, &demoMainMenuDlg::OnBnClickedButtonGoConfCtrl)
    ON_BN_CLICKED(IDC_BUTTON_BOOK_CONF, &demoMainMenuDlg::OnBnClickedBookConf)
    ON_BN_CLICKED(IDC_BUTTON_GET_CONF_LIST, &demoMainMenuDlg::OnBnClickedGetConfList)
    ON_BN_CLICKED(IDC_BUTTON_CHANGE_VMR_INFO, &demoMainMenuDlg::OnBnClickedEditVmrInfo)
    ON_BN_CLICKED(IDC_SET_INCOMING_ANSWER_TYPE, &demoMainMenuDlg::OnBnClickedSetIncomingAnswerType)
    ON_WM_TIMER()
    ON_BN_CLICKED(IDC_GET_USER_STATE2, &demoMainMenuDlg::OnBnClickedGetUserState2)
    ON_BN_CLICKED(IDC_WINDOW_HANDLE_TEST, &demoMainMenuDlg::OnBnClickedWindowHandle)
    ON_BN_CLICKED(IDC_SET_AUDIO_RAW_DATA, &demoMainMenuDlg::OnBnClickedSetAudioRawData)
    ON_BN_CLICKED(IDC_UPLOAD_SELF_AVATAR, &demoMainMenuDlg::OnBnClickedUploadSelfAvatar)
    ON_BN_CLICKED(IDC_BUTTON_START_P2PCONF, &demoMainMenuDlg::OnBnClickedButtonStartP2pconf)
    ON_BN_CLICKED(IDC_DELETE_SELF_AVATAR, &demoMainMenuDlg::OnBnClickedDeleteSelfAvatar)
    ON_BN_CLICKED(IDC_BUTTON_SHOW_TOAST, &demoMainMenuDlg::OnBnClickedButtonShowToast)
    ON_BN_CLICKED(IDC_BUTTON_GET_MAIN_WINDOW_INFO, &demoMainMenuDlg::OnBnClickedButtonGetMainWindowInfo)
    ON_BN_CLICKED(IDC_BUTTON_START_PROJECTION, &demoMainMenuDlg::OnBnClickedButtonStartProjection)
    ON_BN_CLICKED(IDC_BUTTON_CUSTOM_SCENE_CONTENT, &demoMainMenuDlg::OnBnClickedButtonCustomSceneContent)
    ON_BN_CLICKED(IDC_BUTTON_CUSTOM_SCENE_IMAGE, &demoMainMenuDlg::OnBnClickedButtonCustomSceneImage)
    ON_BN_CLICKED(IDC_BUTTON_ACCEPT_CONF, &demoMainMenuDlg::OnBnClickedButtonAcceptConf)
    ON_BN_CLICKED(IDC_BUTTON_REJECT_CONF, &demoMainMenuDlg::OnBnClickedButtonRejectConf)
    ON_BN_CLICKED(IDC_GET_LOGIN_STATE2, &demoMainMenuDlg::OnBnClickedGetLoginState2)
    ON_BN_CLICKED(IDC_GET_LOGIN_TOKEN, &demoMainMenuDlg::OnBnClickedGetLoginToken)
END_MESSAGE_MAP()

// demoMainMenuDlg Ϣ


/**
* 򿪴ᴰ
*/
void demoMainMenuDlg::OnBnClickedCreateConf()
{
    //򿪴ᴰ
    demoCreateConfWithAttendeeDlg dlg;
    INT_PTR nResponse = dlg.DoModal();
}

/**
* 򿪼鴰
*/
void demoMainMenuDlg::OnBnClickedJoinConf()
{
    //򿪻IDᴰ
    demoJoinConfByIdDlg dlg;
    INT_PTR nResponse = dlg.DoModal();
}

/**
* ǳصӿ
*/
afx_msg LRESULT demoMainMenuDlg::logoutCallBack(WPARAM wParam, LPARAM lParam)
{
    if (wParam == hwmsdk::HWM_COMMON_SUCCESS)
    {
        OnOK();
    }
    return 0L;
}

/**
* ע
*/
void demoMainMenuDlg::OnBnClickedLogout()
{
    //õ¼ӿ
    int ret = hwmsdkagent::Logout();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("Logout error");
    }
}

/**
* ᴰ
*/
void demoMainMenuDlg::OnBnClickedJoinConfByLink()
{
    // 
    demoJoinConfByLinkDlg dlg;
    INT_PTR nResponse = dlg.DoModal();
}

/**
* ô
*/
void demoMainMenuDlg::OnBnClickedButtonSetting()
{
    demoSettingDlg dlg;
    INT_PTR nResponse = dlg.DoModal();
}


void demoMainMenuDlg::OnBnClickedButtonGoConfCtrl()
{
    demoConfCtrlDlg dlg;
    INT_PTR nResponse = dlg.DoModal();
}

void demoMainMenuDlg::OnBnClickedBookConf()
{
    demoBookConfDlg dlg;
    INT_PTR nResponse = dlg.DoModal();
}

void demoMainMenuDlg::OnBnClickedGetConfList()
{
    demoConfListDlg dlg;
    dlg.DoModal();
}

void demoMainMenuDlg::OnBnClickedEditVmrInfo()
{
    demoEditVmrInfoDialog dlg;
    dlg.DoModal();
}

LRESULT demoMainMenuDlg::OnShowExternalConfInfoWnd(WPARAM wParam, LPARAM lParam)
{
    CPoint* pt = (CPoint*)wParam;
    if (pt == nullptr)
    {
        return S_FALSE;
    }
    demoConfInfoDlg* dlg = demoData::GetInstance().GetConfInfoDlgObj();
    if (dlg == nullptr)
    {
        try
        {
            dlg = new demoConfInfoDlg;
        }
        catch(...)
        {
            return S_FALSE;
        }
        dlg->Create(IDD_CONF_INFO_DIALOG, this);
        demoData::GetInstance().SetConfInfoDlgObj(dlg);
    }

    if (IsWindow(dlg->GetSafeHwnd()))
    {
        // ʱ֪ͨⴰ
        SetTimer(1, 2000, NULL);
    }

    CRect rectDlg(0, 0, 0, 0);
    dlg->GetClientRect(rectDlg);
    CRect rt(pt->x, pt->y, pt->x + rectDlg.Width(), pt->y + rectDlg.Height());
    dlg->MoveWindow(rt);
    dlg->SetWindowPos(&CWnd::wndTopMost, pt->x, pt->y, rectDlg.Width(), rectDlg.Height(), SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);
    dlg->ShowWindow(SW_SHOW);

    return 0;
}

LRESULT demoMainMenuDlg::OnDestroyExternalConfInfoWnd(WPARAM wParam, LPARAM lParam)
{
    demoConfInfoDlg* dlg = demoData::GetInstance().GetConfInfoDlgObj();
    if (dlg == NULL)
    {
        return 1;
    }

    dlg->CloseWindow();
    demoData::GetInstance().SetConfInfoDlgObj(NULL);
    delete dlg;
    dlg = NULL;
    return 0;
}

void demoMainMenuDlg::UpdateOutput()
{
    // ʾ
    if (IsWindow(m_editMainOutput) && !CStaticData::GetOutput().empty()) {
        m_editMainOutput.SetWindowTextW(CTools::UTF2UNICODE(CStaticData::GetOutput()).c_str());
        m_editMainOutput.SendMessage(WM_VSCROLL, SB_BOTTOM, 0);  // ײ
    }
}

void demoMainMenuDlg::OnTimer(UINT_PTR nIDEvent)
{
    // TODO: ڴϢ/Ĭֵ
    if (nIDEvent == 1)
    {
        demoConfInfoDlg* dlg = demoData::GetInstance().GetConfInfoDlgObj();
        if (dlg == NULL)
        {
            return;
        }

        if (IsWindow(dlg->m_hWnd))
        {
            CPoint ptMouse(0, 0);
            GetCursorPos(&ptMouse);
            
            CRect rtConfInfo(0,0,0,0);
            dlg->GetWindowRect(&rtConfInfo);
            // 겻ڻϢΧ
            if (!rtConfInfo.PtInRect(ptMouse))
            {
                dlg->CloseWindow();
                demoData::GetInstance().SetConfInfoDlgObj(NULL);
                delete dlg;
                dlg = NULL;
                KillTimer(nIDEvent);
            }
        }
    }
    CDialogEx::OnTimer(nIDEvent);
}

void demoMainMenuDlg::OnBnClickedSetIncomingAnswerType()
{
    // Ӧʹ
    demoSetIncomingAnserTypeDlg dlg;
    dlg.DoModal();
}


void demoMainMenuDlg::OnBnClickedGetUserState2()
{
    int ret = hwmsdkagent::GetUserState();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("GetUserState error");
    }
}

void demoMainMenuDlg::OnBnClickedWindowHandle()
{
    // һ
   demoWindowHandleTest dlg;
    dlg.DoModal();

}

void demoMainMenuDlg::OnBnClickedSetAudioRawData()
{
    isOpenAudioRawData = !isOpenAudioRawData;
    int ret = hwmsdkagent::SetAudioRawDataOutputConfig(isOpenAudioRawData);
    CTools::OutputRetStr("isOpenAudioRawData = " + std::to_string(isOpenAudioRawData));
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("SetAudioRawDataOutputConfig error " + std::to_string(ret));
        if(ret == hwmsdk::HWM_AGENT_ERR_NOT_SUPPORT_END)
        {
            CTools::OutputRetStr("Not supported in this release");
        }
    }
}

void demoMainMenuDlg::OnBnClickedUploadSelfAvatar()
{
    // һ
    demoUploadSelfAvatarDlg dlg;
    dlg.DoModal();
}


void demoMainMenuDlg::OnBnClickedButtonStartP2pconf()
{
    //򿪵Ե鴰
    demoStartP2pConfDlg dlg;
    INT_PTR nResponse = dlg.DoModal();
}


void demoMainMenuDlg::OnBnClickedDeleteSelfAvatar()
{
    if (MessageBoxW(L"Delete your custom avatar?", L"Confirm", MB_OKCANCEL) == IDOK)
    {
        hwmsdkagent::DeleteSelfAvatar();
    }
}


void demoMainMenuDlg::OnBnClickedButtonShowToast()
{
    //ShowToast
    demoShowToastDlg dlg;
    INT_PTR nResponse = dlg.DoModal();
}


void demoMainMenuDlg::OnBnClickedButtonGetMainWindowInfo()
{
    hwmsdkagent::GetMainWindowInfo();
}


void demoMainMenuDlg::OnBnClickedButtonStartProjection()
{
    demoStartProjectionDlg dlg;
    INT_PTR nResponse = dlg.DoModal();
}

void demoMainMenuDlg::OnBnClickedButtonCustomSceneContent()
{
    demoCustomSceneContentDlg dlg;
    INT_PTR nResponse = dlg.DoModal();
}

void demoMainMenuDlg::OnBnClickedButtonCustomSceneImage()
{
    demoCustomSceneImageDlg dlg;
    INT_PTR nResponse = dlg.DoModal();
}

void demoMainMenuDlg::OnBnClickedButtonAcceptConf()
{
    // 
    demoAcceptConfDlg dlg;
    INT_PTR nResponse = dlg.DoModal();
}


void demoMainMenuDlg::OnBnClickedButtonRejectConf()
{
    // ܽӻ
    int ret = hwmsdkagent::RejectConf();
    if (ret != hwmsdk::HWM_COMMON_SUCCESS)
    {
        AfxMessageBox(_T("Reject conf failed"));
    }
}

void demoMainMenuDlg::OnBnClickedGetLoginState2()
{
    int ret = hwmsdkagent::GetLoginState();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("GetLoginState error");
    }
}

void demoMainMenuDlg::OnBnClickedGetLoginToken()
{
    int ret = hwmsdkagent::GetLoginToken();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("GetLoginToken error");
    }
}
