#include "stdafx.h"
#include "demo.h"
#include "demoSetGuaranteedIpAddressesDlg.h"
#include "afxdialogex.h"
#include "HwmSdkAgent.h"
#include "demoTools.h"

IMPLEMENT_DYNAMIC(demoSetGuaranteedIpAddressesDlg, CDialogEx)

demoSetGuaranteedIpAddressesDlg::demoSetGuaranteedIpAddressesDlg(CWnd * pParent)
    : CDialogEx(IDD_SET_GUARANTEEDIP_DIALOG, pParent)
{
}

demoSetGuaranteedIpAddressesDlg::~demoSetGuaranteedIpAddressesDlg()
{
}

void demoSetGuaranteedIpAddressesDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_GUARANTEEDIP_ADDRESS, m_addressesEdit);
}

BEGIN_MESSAGE_MAP(demoSetGuaranteedIpAddressesDlg, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoSetGuaranteedIpAddressesDlg::OnBnClickedButtonOk)
END_MESSAGE_MAP()

void demoSetGuaranteedIpAddressesDlg::OnBnClickedButtonOk()
{
    CString tempCString;
    m_addressesEdit.GetWindowText(tempCString);
    string addressesString = CTools::UNICODE2UTF(tempCString.GetString());
    hwmsdk::HwmErrCode ret = hwmsdkagent::SetGuaranteedIpAddresses(addressesString.c_str());
    if (ret != hwmsdk::HWM_COMMON_SUCCESS)
    {
        CTools::OutputRetStr("SetGuaranteedIpAddresses error");
        return;
    }
    CTools::OutputRetStr("SetGuaranteedIpAddresses success");
    CDialogEx::OnOK();
}