// demoSetProxyInfoDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "resource.h"
#include "demoSetProxyInfoDlg.h"
#include "afxdialogex.h"
#include "demoTools.h"
#include "HwmSdkAgent.h"
#include <algorithm>
#include <thread>
#include "stdio.h"
#include <iostream>
#include <stdlib.h>
#include <Iphlpapi.h>

#pragma comment(lib,"Iphlpapi.lib") //ҪIphlpapi.lib

// demoSetProxyInfoDlg Ի

bool demoSetProxyInfoDlg::m_isinit = false;
bool demoSetProxyInfoDlg::m_isAutoSetProxy = false;
hwmsdkagent::HwmProxyInfo demoSetProxyInfoDlg::m_proxyInfo;
int demoSetProxyInfoDlg::m_currBtn = USER_SET;

IMPLEMENT_DYNAMIC(demoSetProxyInfoDlg, CDialogEx)

demoSetProxyInfoDlg::demoSetProxyInfoDlg(CWnd* pParent /*=NULL*/)
    : CDialogEx(IDD_SET_PROXY_INFO_DIALOG, pParent)
{

}

demoSetProxyInfoDlg::~demoSetProxyInfoDlg()
{
}

void demoSetProxyInfoDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_STATIC1, m_proxyText1);
    DDX_Control(pDX, IDC_STATIC2, m_proxyText2);
    DDX_Control(pDX, IDC_STATIC3, m_proxyText3);
    DDX_Control(pDX, IDC_STATIC4, m_proxyText4);
    DDX_Control(pDX, IDC_EDIT_PROXY_SERVER, m_proxyServerEdit);
    DDX_Control(pDX, IDC_EDIT_PROXY_PORT, m_proxyPortEdit);
    DDX_Control(pDX, IDC_EDIT_PROXY_NAME, m_proxyUserNameEdit);
    DDX_Control(pDX, IDC_EDIT_PROXY_PASSWORD, m_proxyPswEdit);
    DDX_Control(pDX, IDC_RADIO_PROXY_USER_SET, m_proxyUserSet);
    DDX_Control(pDX, IDC_RADIO_PROXY_AUTO_SET, m_proxyAutoSet);
    DDX_Control(pDX, IDC_RADIO_PROXY_NO_SET, m_proxyNoSet);
}


// demoLoginDlg Ϣ

BOOL demoSetProxyInfoDlg::OnInitDialog()
{
    CDialogEx::OnInitDialog();

    if (m_isinit == false)
    {
        m_isinit = true;
        memset(&m_proxyInfo, 0, sizeof(hwmsdkagent::HwmProxyInfo));
        m_currBtn = USER_SET;
    }
    switch (m_currBtn)
    {
        case AUTO_SET:
            m_proxyAutoSet.SetCheck(1);
            OnBnClickedRadioProxyAutoSet();
            break;
        case NO_SET:
            m_proxyNoSet.SetCheck(1);
            OnBnClickedRadioProxyNoSet();
            break;
        case USER_SET:
        default:
            m_proxyUserSet.SetCheck(1);
            OnBnClickedRadioProxyUserSet();
            break;
    }
    // ļȡϴε¼ʺ
    CString temp = _T("");
    CTools::getIniConfigParam(_T("LoginConfig"), _T("proxyServer"), temp);
    if (temp.IsEmpty())
    {
        AutoFillProxy();
        return TRUE;
    }
    m_proxyServerEdit.SetWindowText(temp);
    CTools::getIniConfigParam(_T("LoginConfig"), _T("proxyPort"), temp);
    m_proxyPortEdit.SetWindowText(temp);
    CTools::getIniConfigParam(_T("LoginConfig"), _T("proxyAccount"), temp);
    m_proxyUserNameEdit.SetWindowText(temp);

    return TRUE;  // ǽõؼ򷵻 TRUE
}

void demoSetProxyInfoDlg::AutoFillProxy()
{
    char proxySvr[512]{};
    if (hwmsdk::HWM_COMMON_SUCCESS == hwmsdkagent::GetSystemProxy(proxySvr, 512))
    {
        //޸Ĵȡȥhttp://ͷָaddrportһ:ָ
        CString csProxySvr(proxySvr);
        if (csProxySvr.Find(_T("http://")) == 0)
        {
            csProxySvr.Delete(0,7);
        }
        int ipos = -1;
        while (csProxySvr.Find(_T(":"), ipos+1) >= 0)
        {
            ipos = csProxySvr.Find(_T(":"), ipos+1);
        }
        CString addr = csProxySvr.Left(ipos);
        CString port = csProxySvr.Mid(ipos+1, csProxySvr.GetLength());
        m_proxyServerEdit.SetWindowText(addr);
        m_proxyPortEdit.SetWindowText(port);
    }
}

BEGIN_MESSAGE_MAP(demoSetProxyInfoDlg, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoSetProxyInfoDlg::OnBnClickedOk)
    ON_BN_CLICKED(IDC_RADIO_PROXY_USER_SET, &demoSetProxyInfoDlg::OnBnClickedRadioProxyUserSet)
    ON_BN_CLICKED(IDC_RADIO_PROXY_AUTO_SET, &demoSetProxyInfoDlg::OnBnClickedRadioProxyAutoSet)
    ON_BN_CLICKED(IDC_RADIO_PROXY_NO_SET, &demoSetProxyInfoDlg::OnBnClickedRadioProxyNoSet)
END_MESSAGE_MAP()


// demoSetProxyInfoDlg Ϣ

void demoSetProxyInfoDlg::userSet()
{
    CString serverCString;
    CString portCString;
    CString accountCString;
    CString pwdCString;
    m_proxyServerEdit.GetWindowText(serverCString);
    m_proxyPortEdit.GetWindowText(portCString);
    m_proxyUserNameEdit.GetWindowText(accountCString);
    m_proxyPswEdit.GetWindowText(pwdCString);

    hwmsdkagent::HwmProxyInfo proxyInfo{};
    proxyInfo.proxyConfigPolicy = hwmsdkagent::HWM_PROXY_CONFIG_POLICY_CUSTOM;
    string server = CTools::UNICODE2UTF(serverCString.GetString());
    strncpy_s(proxyInfo.server, server.c_str(), HWM_MAX_URL_LEN);
    // Զʱû
    int port = _ttoi(portCString);
    if (port > 65535 || port < 0)
    {
        MessageBox(L"˿ںϷΧΪ 0 ~ 65535");
        return;
    }
    proxyInfo.port = port;
    string account = CTools::UNICODE2UTF(accountCString.GetString());
    strncpy_s(proxyInfo.account, account.c_str(), HWM_MAX_ACCOUNT_LEN);

    string pwd = CTools::UNICODE2UTF(pwdCString.GetString());
    strncpy_s(proxyInfo.password, pwd.c_str(), HWM_MAX_PASSWORD_LEN);
    pwd.assign(pwd.length(), '\0');
    int ret = SetProxyInfoStatic(&proxyInfo);
    memset(&proxyInfo, 0, sizeof(proxyInfo));
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("Set proxy failed");
        return;
    }

    //ӿڵóɹ󽫵¼Ϣ浽ļ´ȡ
    CTools::writeIniConfigParam(_T("LoginConfig"), _T("proxyServer"), serverCString);
    CTools::writeIniConfigParam(_T("LoginConfig"), _T("proxyPort"), portCString);
    CTools::writeIniConfigParam(_T("LoginConfig"), _T("proxyAccount"), accountCString);
}

int demoSetProxyInfoDlg::SetProxyInfoStatic(hwmsdkagent::HwmProxyInfo *proxyInfo)
{
    memcpy_s(&m_proxyInfo, sizeof(hwmsdkagent::HwmProxyInfo), proxyInfo, sizeof(hwmsdkagent::HwmProxyInfo));

    int ret = hwmsdkagent::SetProxyInfo(proxyInfo);
    return ret;
}

int StringToWString(std::wstring &ws, const std::string &s)
{
    std::wstring wsTmp(s.begin(), s.end());

    ws = wsTmp;

    return 0;
}

void demoSetProxyInfoDlg::autoSet()
{
    m_isAutoSetProxy = true;
    hwmsdkagent::HwmProxyInfo proxyInfo{};
    proxyInfo.proxyConfigPolicy = hwmsdkagent::HWM_PROXY_CONFIG_POLICY_AUTO;
    int ret = SetProxyInfoStatic(&proxyInfo);
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("Set auto proxy failed");
    }
}

void demoSetProxyInfoDlg::noSet()
{
    hwmsdkagent::HwmProxyInfo proxyInfo{};
    proxyInfo.proxyConfigPolicy = hwmsdkagent::HWM_PROXY_CONFIG_POLICY_OFF;
    int ret = SetProxyInfoStatic(&proxyInfo);
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("Set no proxy failed");
    }
}

void demoSetProxyInfoDlg::OnBnClickedOk()
{
    if (m_proxyUserSet.GetCheck()) {
        m_currBtn = USER_SET;
        userSet();
    }
    else if (m_proxyAutoSet.GetCheck()) {
        m_currBtn = AUTO_SET;
        autoSet();
    }
    else if (m_proxyNoSet.GetCheck()) {
        m_currBtn = NO_SET;
        noSet();
    }
    
    CDialogEx::OnOK();
}

void demoSetProxyInfoDlg::OnBnClickedRadioProxyUserSet()
{
    m_isAutoSetProxy = false;
    m_proxyText1.ShowWindow(TRUE);
    m_proxyText2.ShowWindow(TRUE);
    m_proxyText3.ShowWindow(TRUE);
    m_proxyText4.ShowWindow(TRUE);
    m_proxyServerEdit.ShowWindow(TRUE);
    m_proxyPortEdit.ShowWindow(TRUE);
    m_proxyUserNameEdit.ShowWindow(TRUE);
    m_proxyPswEdit.ShowWindow(TRUE);
}


void demoSetProxyInfoDlg::OnBnClickedRadioProxyAutoSet()
{
    m_proxyText1.ShowWindow(FALSE);
    m_proxyText2.ShowWindow(FALSE);
    m_proxyText3.ShowWindow(FALSE);
    m_proxyText4.ShowWindow(FALSE);
    m_proxyServerEdit.ShowWindow(FALSE);
    m_proxyPortEdit.ShowWindow(FALSE);
    m_proxyUserNameEdit.ShowWindow(FALSE);
    m_proxyPswEdit.ShowWindow(FALSE);
}


void demoSetProxyInfoDlg::OnBnClickedRadioProxyNoSet()
{
    m_isAutoSetProxy = false;
    m_proxyText1.ShowWindow(FALSE);
    m_proxyText2.ShowWindow(FALSE);
    m_proxyText3.ShowWindow(FALSE);
    m_proxyText4.ShowWindow(FALSE);
    m_proxyServerEdit.ShowWindow(FALSE);
    m_proxyPortEdit.ShowWindow(FALSE);
    m_proxyUserNameEdit.ShowWindow(FALSE);
    m_proxyPswEdit.ShowWindow(FALSE);
}
