﻿// demoShowToastDlg.cpp: 实现文件
//

#include "stdafx.h"
#include "demo.h"
#include "demoShowToastDlg.h"

#include <HwmAgentDef.h>
#include <HwmSdkAgent.h>

#include "afxdialogex.h"
#include "demoTools.h"


// demoShowToastDlg 对话框

IMPLEMENT_DYNAMIC(demoShowToastDlg, CDialogEx)

demoShowToastDlg::demoShowToastDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_SHOW_TOAST_DIALOG, pParent)
{

}

demoShowToastDlg::~demoShowToastDlg()
{
}

void demoShowToastDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_TOAST_CONTENT, m_content);
    DDX_Control(pDX, IDC_TOAST_DURATION, m_duration);
}

BOOL demoShowToastDlg::OnInitDialog()
{
    CDialog::OnInitDialog();
    m_duration.SetWindowText(_T("5"));

    return TRUE;
}


BEGIN_MESSAGE_MAP(demoShowToastDlg, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoShowToastDlg::OnBnClickedOk)
    ON_BN_CLICKED(IDCANCEL, &demoShowToastDlg::OnBnClickedCancel)
END_MESSAGE_MAP()


// demoShowToastDlg 消息处理程序

int demoShowToastDlg::showToast()
{
    int ret;
    hwmsdkagent::HwmToastInfo data{};

    CString tempCString;

    m_content.GetWindowText(tempCString);
    strncpy_s(data.content, CTools::UNICODE2UTF(tempCString.GetString()).c_str(), HWM_MAX_TOAST_CONTENT_LEN);
    m_duration.GetWindowText(tempCString);
    data.duration = static_cast<unsigned int>(_ttoi(tempCString));
    ret = ShowToast(&data);
    memset(&data, 0, sizeof(hwmsdkagent::HwmToastInfo));
    return ret;
}

void demoShowToastDlg::OnBnClickedOk()
{
    int ret = showToast();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("showToast error");
        return;
    }
    CDialogEx::OnOK();
}


void demoShowToastDlg::OnBnClickedCancel()
{
    CDialogEx::OnCancel();
}
