﻿// demoSubCycleConfList.cpp: 实现文件
//

#include "stdafx.h"
#include "demoSubCycleConfList.h"

#include <HwmSdkAgent.h>

#include "afxdialogex.h"
#include "demoData.h"
#include "demoEditConfDlg.h"
#include "demoTools.h"
#include "resource.h"


// demoSubCycleConfList 对话框

IMPLEMENT_DYNAMIC(demoSubCycleConfList, CDialogEx)

demoSubCycleConfList::demoSubCycleConfList(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_SUB_CYCLE_CONFLIST_DIALOG, pParent),m_confInfo{0}
{

}

demoSubCycleConfList::~demoSubCycleConfList()
{
}

void demoSubCycleConfList::SetConfInfo(const hwmsdkagent::HwmConfDetail & confInfo, std::vector<hwmsdkagent::HwmSubCycleConfParam>& subCycleConf)
{
 
}

void demoSubCycleConfList::GetConfInfo()
{
    m_confInfo = demoData::GetInstance().GetConfDetail();
    m_subCycleConf.clear();
    m_subCycleConf = demoData::GetInstance().GetSubCycleConfInfo();
}

void demoSubCycleConfList::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
    
    DDX_Control(pDX, IDC_LIST_EDIT_SUB_CYCLE_CONF, m_editSubCycleConf);
    DDX_Control(pDX, IDC_LIST_CANCEL_SUB_CYCLE_CONF, m_cancelSubcycleConf);
    DDX_Control(pDX, IDC_LIST_SUB_CYCLE_CONF_LIST, m_conflistCtrl);
}

BOOL demoSubCycleConfList::OnInitDialog()
{
    const auto ret = CDialogEx::OnInitDialog();
    m_conflistCtrl.InsertColumn(0, _T("子会议UUID"), LVCFMT_CENTER, 200);
    m_conflistCtrl.InsertColumn(1, _T("开始时间"), LVCFMT_CENTER, 200);
    m_conflistCtrl.InsertColumn(2, _T("结束时间"), LVCFMT_CENTER, 200);

    GetConfInfo();
    UpdataSubConfList();
    return ret;
}

void demoSubCycleConfList::UpdataSubConfList()
{
    m_conflistCtrl.SetExtendedStyle(m_conflistCtrl.GetExtendedStyle() | LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES);
    for (int i = 0; i < m_subCycleConf.size(); ++i)
    {
        m_conflistCtrl.InsertItem(i, _T(""));
        m_conflistCtrl.SetItemText(i, 0, CTools::UTF2UNICODE(m_subCycleConf[i].subConfID).c_str());
        CTime startTime = m_subCycleConf[i].startTime + (8 * 60 * 60);
        m_conflistCtrl.SetItemText(i, 1, startTime.Format(_T("%Y-%m-%d %H:%M:%S %A")));
        CTime endTime = m_subCycleConf[i].endTime + (8 * 60 * 60);
        m_conflistCtrl.SetItemText(i, 2, endTime.Format(_T("%Y-%m-%d %H:%M:%S %A")));

    }
}

void demoSubCycleConfList::OnNMClick(NMHDR * pNMHDR, LRESULT * pResult)
{
    int select = m_conflistCtrl.GetSelectionMark();
    CString confId;
    if (select >= 0 && select < m_subCycleConf.size())
    {
        m_subCycleConfID = std::string(m_subCycleConf[select].subConfID);
    }

}

BEGIN_MESSAGE_MAP(demoSubCycleConfList, CDialogEx)
    ON_BN_CLICKED(IDC_LIST_EDIT_SUB_CYCLE_CONF, &demoSubCycleConfList::OnBnClickedOk)
    ON_BN_CLICKED(IDC_LIST_CANCEL_SUB_CYCLE_CONF, &demoSubCycleConfList::OnBnClickedCancel)
    ON_NOTIFY(NM_CLICK, IDC_LIST_SUB_CYCLE_CONF_LIST, OnNMClick)
END_MESSAGE_MAP()


// demoSubCycleConfList 消息处理程序


void demoSubCycleConfList::OnBnClickedOk()
{
    // TODO: 在此添加控件通知处理程序代码

    demoEditConfDlg dlg;
    dlg.setConfInfo(m_confInfo.confListInfo.confId, true, m_subCycleConfID);
    dlg.DoModal();
    CDialogEx::OnOK();
}


void demoSubCycleConfList::OnBnClickedCancel()
{
    // TODO: 在此添加控件通知处理程序代码

    hwmsdkagent::HwmCancelSubCycleConfParam subCycleConfParam{};
    errno_t err = strcpy_s(subCycleConfParam.confId, sizeof(subCycleConfParam.confId), m_confInfo.confListInfo.confId);
    err += strcpy_s(subCycleConfParam.subConfID, sizeof(subCycleConfParam.subConfID), m_subCycleConfID.c_str());
    if (err != S_OK)
    {
        AfxMessageBox(_T("String Copy Error!"));
    }
    subCycleConfParam.endOnlineConf = true;

    hwmsdkagent::CancelSubCycleConf(&subCycleConfParam);
    CDialogEx::OnCancel();
}

