#include "stdafx.h"
#include "demoUploadSelfAvatarDlg.h"
#include "afxdialogex.h"
#include "HwmSdkAgent.h"
#include "demoTools.h"

IMPLEMENT_DYNAMIC(demoUploadSelfAvatarDlg, CDialogEx)

demoUploadSelfAvatarDlg::demoUploadSelfAvatarDlg(CWnd* pParent /*=NULL*/)
    : CDialogEx(demoUploadSelfAvatarDlg::IDD, pParent)
{

}

demoUploadSelfAvatarDlg::~demoUploadSelfAvatarDlg()
{
}

void demoUploadSelfAvatarDlg::DoDataExchange(CDataExchange * pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_AVATAR_PATH, m_edit);
}

BEGIN_MESSAGE_MAP(demoUploadSelfAvatarDlg, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoUploadSelfAvatarDlg::OnBnClickedOk)
END_MESSAGE_MAP()

void demoUploadSelfAvatarDlg::OnBnClickedOk()
{
    // TODO: ڴӿؼ֪ͨ
    CString strEdit;
    m_edit.GetWindowText(strEdit);
    string tempString = CTools::UNICODE2UTF(strEdit.GetString());

    hwmsdkagent::HwmSelfAvatarInfo avatarInfo{};
    if (tempString.empty() || tempString.length() >= sizeof(avatarInfo.path))
    {
        CTools::OutputRetStr("Upload self avatar param error");
        return;
    }
    char path[sizeof(avatarInfo.path) + 1] = { 0 };
    // pathֵ
    strncpy_s(avatarInfo.path, (char *)tempString.c_str(), sizeof(avatarInfo.path));
    int ret = hwmsdkagent::UploadSelfAvatar(&avatarInfo);
    if (ret != hwmsdk::HWM_COMMON_SUCCESS)
    {
        CTools::OutputRetStr("Upload self avatar error");
        return;
    }

    CDialogEx::OnOK();
}
