// demoWindowHandleTest.cpp : ʵļ
//

#include "stdafx.h"
#include "demoWindowHandleTest.h"
#include "afxdialogex.h"
#include "demoTools.h"
#include "demo.h"
#include "demoData.h"
#include "demoCustomMessage.h"
#include <sstream>
#include <iosfwd>
#include <iomanip>
#include "HwmSdkAgent.h"
demoWindowHandleTest::demoWindowHandleTest(CWnd* pParent /*=NULL*/)
    : CDialogEx( IDD_HANDLE_TEST, pParent)
    , m_cbkEditValue(_T(""))
    , m_ntyEditValue(_T(""))
{
    
}

demoWindowHandleTest::~demoWindowHandleTest()
{
}

BOOL demoWindowHandleTest::OnInitDialog()
{
    CDialogEx::OnInitDialog();

    demoData::GetInstance().subscribeWindowHandle(m_hWnd);
    return TRUE;  // ǽõؼ򷵻 TRUE
}
void demoWindowHandleTest::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_CBK_RESULT_EDIT, m_cbkResult);
    DDX_Control(pDX, IDC_NTY_RESULT_EDIT, m_ntyResult);
    DDX_Text(pDX, IDC_CBK_RESULT_EDIT, m_cbkEditValue);
    DDX_Text(pDX, IDC_NTY_RESULT_EDIT, m_ntyEditValue);
}

BEGIN_MESSAGE_MAP(demoWindowHandleTest, CDialogEx)
    ON_MESSAGE(WM_WINDLE_HANDLE_UPDATE, &demoWindowHandleTest::OnWindowHandleListInfoCallback)
    ON_MESSAGE(WM_WINDLE_HANDLE_NOTIFY, &demoWindowHandleTest::OnWindowHandleListInfoNotify)
    ON_BN_CLICKED(IDC_BUTTON_GET_HANDLE_LIST, &demoWindowHandleTest::OnBnClickeGetHandleList)
END_MESSAGE_MAP()



// demoWindowHandleTest Ϣ


void demoWindowHandleTest::OnBnClickeGetHandleList()
{
    // TODO: ڴӿؼ֪ͨ
    hwmsdkagent::GetRenderWindowInfoList();
}

void demoWindowHandleTest::AddEditContent(int id,wstring& content)
{
    CString ch{ "" };
    GetDlgItemText(id, ch);

    wstring result{ ch };
    result += L"\r\n";
    result += content;

    GetDlgItem(id)->SetWindowTextW(result.c_str());
    GetDlgItem(id)->SendMessage(WM_VSCROLL, SB_BOTTOM, 0);  // ײ
}

void demoWindowHandleTest::ClearEditContent(CEdit& edit)
{
    wstring s{ L"" };
    edit.SetWindowTextW(s.c_str());
}

void demoWindowHandleTest::ClearCbkEditContent()
{
    m_cbkEditValue = "";
    UpdateData(FALSE);
}

void demoWindowHandleTest::ClearNtyEditContent()
{
    m_ntyEditValue = "";
    UpdateData(FALSE);
}


LRESULT demoWindowHandleTest::OnWindowHandleListInfoCallback(WPARAM wParam, LPARAM lParam)
{
    ClearEditContent(m_cbkResult);
    AddEditContent(IDC_CBK_RESULT_EDIT, CTools::MultiByte2UNICODE(handleWhndListInfo(wParam, lParam)));
    return 0;
}

LRESULT demoWindowHandleTest::OnWindowHandleListInfoNotify(WPARAM wParam, LPARAM lParam)
{
    ClearEditContent(m_ntyResult);
    AddEditContent(IDC_NTY_RESULT_EDIT, CTools::MultiByte2UNICODE(handleWhndListInfo(wParam, lParam)));
    return 0;
}

string demoWindowHandleTest::handleWhndListInfo(WPARAM wParam, LPARAM lParam)
{
    hwmsdkagent::HwmHwndListInfo* info = reinterpret_cast<hwmsdkagent::HwmHwndListInfo*>(wParam);
    string content = "";
    for (int i = 0; i < info->hwndListLength; i++)
    {
        std::stringstream ost;
        uintptr_t hwnd = (uintptr_t)info->hwndInfoList[i].renderHandle;
        switch (info->hwndInfoList[i].hwndType)
        {
        case hwmsdkagent::HwmHwndType::SCREEN_ID:
            ost << "Type:SCREEN_ID  Handle: 0X" << uppercase << setfill('0') << setw(8) << std::hex << hwnd;
            break;
        case hwmsdkagent::HwmHwndType::SHARE_RENDER:
            ost << "Type:SHARE_RENDER  Handle: 0X" << uppercase << setfill('0') << setw(8) << std::hex << hwnd;
            break;
        case hwmsdkagent::HwmHwndType::VIDEO_WND_TYPE:
            ost << "Type:VIDEO_WND_TYPE  Handle: 0X" << uppercase << setfill('0') << setw(8) << std::hex << hwnd;
            break;
        default:
            break;
        }
        ost << ", isbig: " << boolalpha << info->hwndInfoList[i].isBigView;
        content += ost.str();
        content += "\r\n";
    }
    delete info;
    info = nullptr;
    return content;
}