﻿// demoAddHwmConfAttendeeDlg.cpp: 实现文件
//

#include "stdafx.h"
#include "demoAddHwmConfAttendeeDlg.h"
#include "afxdialogex.h"
#include "resource.h"
#include "demoTools.h"

// demoAddHwmConfAttendeeDlg 对话框

IMPLEMENT_DYNAMIC(demoAddHwmConfAttendeeDlg, CDialogEx)

demoAddHwmConfAttendeeDlg::demoAddHwmConfAttendeeDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_ADD_HWM_CONF_ATTENDEE_DIALOG, pParent)
{

}

demoAddHwmConfAttendeeDlg::~demoAddHwmConfAttendeeDlg()
{
}

void demoAddHwmConfAttendeeDlg::OnOK()
{
    CString input;
    m_editName.GetWindowText(input);
    if (input.IsEmpty())
    {
        AfxMessageBox(_T("name empty!"));
        return;
    }

    CString userId;
    m_editNumber.GetWindowText(input);
    m_editThirdUserId.GetWindowText(userId);
    if (input.IsEmpty() && userId.IsEmpty())
    {
        AfxMessageBox(_T("number or third part userid empty!"));
        return;
    }

    if (!input.IsEmpty()) // 可能有人输入特殊字符导致预约失败
    {
        for (int i = 0; i < input.GetLength(); i++)
        {
            const auto item = input[i];
            if ('0' <= item && item <= '9')
            {
                continue;
            }
            if (i == 0 && item == '+')
            {
                continue;
            }

            AfxMessageBox(_T("number input invalid character"));
            return;
        }
    }

    CTools::GetEditValue(attendeeInfo.name, sizeof(attendeeInfo.name), m_editName);
    CTools::GetEditValue(attendeeInfo.aliasCN, sizeof(attendeeInfo.aliasCN), m_editAliasCN);
    CTools::GetEditValue(attendeeInfo.aliasEN, sizeof(attendeeInfo.aliasEN), m_editAliasEN);
    CTools::GetEditValue(attendeeInfo.number, sizeof(attendeeInfo.number), m_editNumber);
    CTools::GetEditValue(attendeeInfo.accountId, sizeof(attendeeInfo.accountId), m_editAccountId);
    CTools::GetEditValue(attendeeInfo.thirdUserId, sizeof(attendeeInfo.thirdUserId), m_editThirdUserId);
    CTools::GetEditValue(attendeeInfo.orgId, sizeof(attendeeInfo.orgId), m_editOrgId);
    
    attendeeInfo.type = hwmsdkagent::HWM_ATTENDEE_TYPE_NORMAL;
    CString tempCString;
    m_attendeeType.GetWindowText(tempCString);
    if (tempCString == _T("Mobile"))
    {
        attendeeInfo.type = hwmsdkagent::HWM_ATTENDEE_TYPE_MOBILE;
    }

    attendeeInfo.autoInviteType = hwmsdkagent::AUTO_INVITE_NONE;
    m_autoInviteType.GetWindowText(tempCString);
    if (tempCString == _T("Open"))
    {
        attendeeInfo.autoInviteType = hwmsdkagent::AUTO_INVITE_OPEN;
    }
    else if (tempCString == _T("Close"))
    {
        attendeeInfo.autoInviteType = hwmsdkagent::AUTO_INVITE_CLOSE;
    }

    CDialogEx::OnOK();
}

void demoAddHwmConfAttendeeDlg::OnCancel()
{
    CDialogEx::OnCancel();
}

void demoAddHwmConfAttendeeDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);

    DDX_Control(pDX, IDC_EDIT_ADD_ATTENDEE_NAME, m_editName);
    DDX_Control(pDX, IDC_EDIT_ADD_ATTENDEE_ALIASCN, m_editAliasCN);
    DDX_Control(pDX, IDC_EDIT_ADD_ATTENDEE_ALIASEN, m_editAliasEN);
    DDX_Control(pDX, IDC_EDIT_ADD_ATTENDEE_NUMBER, m_editNumber);
    DDX_Control(pDX, IDC_EDIT_ADD_ATTENDEE_ACCOUNT_ID, m_editAccountId);
    DDX_Control(pDX, IDC_EDIT_ADD_ATTENDEE_THIRD_USER_ID, m_editThirdUserId);
    DDX_Control(pDX, IDC_EDIT_ADD_ATTENDEE_ORG_ID, m_editOrgId);
    DDX_Control(pDX, IDC_COMBO_ATTENDEE_TYPE, m_attendeeType);
    DDX_Control(pDX, IDC_COMBO_AUTO_INVITE_TYPE, m_autoInviteType);
}

BOOL demoAddHwmConfAttendeeDlg::OnInitDialog()
{
    CDialog::OnInitDialog();

    m_attendeeType.InsertString(0, _T("Normal"));
    m_attendeeType.InsertString(1, _T("Mobile"));
    m_attendeeType.SetWindowText(_T("Normal"));
    m_autoInviteType.InsertString(0, _T("None"));
    m_autoInviteType.InsertString(1, _T("Open"));
    m_autoInviteType.InsertString(2, _T("Close"));
    m_autoInviteType.SetWindowText(_T("None"));

    return TRUE;
}

// demoAddHwmConfAttendeeDlg 消息处理程序
