// demoGeneralWatchDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "demoGeneralWatchDlg.h"
#include "afxdialogex.h"
#include "resource.h"
#include "demoTools.h"
#include "demoData.h"

#define FRAME_WIDTH 20
#define FRAME_HEIGHT 43

// demoGeneralWatchDlg Ի

IMPLEMENT_DYNAMIC(demoGeneralWatchDlg, CDialogEx)

demoGeneralWatchDlg::demoGeneralWatchDlg(CWnd* pParent /*=NULL*/)
    : CDialogEx(IDD_GENERAL_WATCH, pParent)
{

}

demoGeneralWatchDlg::~demoGeneralWatchDlg()
{
}

void demoGeneralWatchDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_WATCH_WIDTH, m_widthEdit);
    DDX_Control(pDX, IDC_EDIT_WATCH_HEIGHT, m_heigthEdit);
    DDX_Control(pDX, IDC_EDIT_WATCH_USER_ID, m_userIdEdit);
    DDX_Control(pDX, IDC_EDIT_WATCH_PADDING_LEFT, m_paddingLeftEdit);
    DDX_Control(pDX, IDC_EDIT_WATCH_PADDING_TOP, m_paddingTopEdit);
    DDX_Control(pDX, IDC_EDIT_WATCH_PADDING_RIGHT, m_paddingRightEdit);
    DDX_Control(pDX, IDC_EDIT_WATCH_PADDING_BOTTOM, m_paddingBottomEdit);

    DDX_Control(pDX, IDC_COMBO_WATCH_WND_TYPE, m_wndType);
}


BEGIN_MESSAGE_MAP(demoGeneralWatchDlg, CDialogEx)
    ON_BN_CLICKED(IDC_BUTTON_ADD_VIDEO_WND, &demoGeneralWatchDlg::OnBnClickedButtonAddVideoWnd)
    ON_BN_CLICKED(IDC_BUTTON_SEND_GENERAL_WATCH, &demoGeneralWatchDlg::OnBnClickedButtonGeneralWatch)
END_MESSAGE_MAP()


// demoGeneralWatchDlg Ϣ

BOOL demoGeneralWatchDlg::OnInitDialog()
{
    const auto ret = CDialogEx::OnInitDialog();

    m_wndType.InsertString(0, _T("Normal Wnd"));
    m_wndType.InsertString(1, _T("Main Wnd"));
    m_wndType.SetCurSel(0);

    m_widthEdit.SetWindowText(_T("640"));
    m_heigthEdit.SetWindowText(_T("360"));
    m_userIdEdit.SetWindowText(_T("1"));
    m_paddingLeftEdit.SetWindowText(_T("0"));
    m_paddingRightEdit.SetWindowText(_T("0"));
    m_paddingTopEdit.SetWindowText(_T("0"));
    m_paddingBottomEdit.SetWindowText(_T("0"));

    return ret;
}

void demoGeneralWatchDlg::OnBnClickedButtonAddVideoWnd()
{
    CString strWidth;
    m_widthEdit.GetWindowText(strWidth);
    int width = CTools::str2num(CTools::UNICODE2UTF(strWidth.GetString()));

    CString strHeight;
    m_heigthEdit.GetWindowText(strHeight);
    int height = CTools::str2num(CTools::UNICODE2UTF(strHeight.GetString()));

    CString strUserId;
    m_userIdEdit.GetWindowText(strUserId);
    int userId = CTools::str2num(CTools::UNICODE2UTF(strUserId.GetString()));

    CString strPaddingLeft;
    m_paddingLeftEdit.GetWindowText(strPaddingLeft);
    int paddingLeft = CTools::str2num(CTools::UNICODE2UTF(strPaddingLeft.GetString()));

    CString strPaddingRight;
    m_paddingRightEdit.GetWindowText(strPaddingRight);
    int paddingRight = CTools::str2num(CTools::UNICODE2UTF(strPaddingRight.GetString()));

    CString strPaddingTop;
    m_paddingTopEdit.GetWindowText(strPaddingTop);
    int paddingTop = CTools::str2num(CTools::UNICODE2UTF(strPaddingTop.GetString()));

    CString strPaddingBottom;
    m_paddingBottomEdit.GetWindowText(strPaddingBottom);
    int paddingBottom = CTools::str2num(CTools::UNICODE2UTF(strPaddingBottom.GetString()));

    int wndType = m_wndType.GetCurSel();
    hwmsdkagent::HwmWndType type = hwmsdkagent::HwmWndType::HWM_WND_TYPE_NORMAL;
    if (wndType == 1)
    {
        type = hwmsdkagent::HwmWndType::HWM_WND_TYPE_MAIN;
    }

    CustomWnd* videoTemp = new CustomWnd(width + FRAME_WIDTH, height + FRAME_HEIGHT, WS_EX_OVERLAPPEDWINDOW, WS_OVERLAPPEDWINDOW);
    videoTemp->ShowWindow(SW_SHOW);
    videoTemp->UpdateWindow();

    hwmsdkagent::HwmWatchItem item{};
    item.userId = userId;
    item.padding.left = paddingLeft;
    item.padding.right = paddingRight;
    item.padding.top = paddingTop;
    item.padding.bottom = paddingBottom;
    item.renderHandle = videoTemp->m_hWnd;
    item.wndType = type;

    demoData::GetInstance().ModifyWatchList().push_back(item);
}

void demoGeneralWatchDlg::OnBnClickedButtonGeneralWatch()
{
    std::vector<hwmsdkagent::HwmWatchItem> allWatchList = demoData::GetInstance().GetWatchList();
    hwmsdkagent::HwmWatchListInfo watchListInfo{};
    watchListInfo.watchListSize = allWatchList.size();
    watchListInfo.watchList = (hwmsdkagent::HwmWatchItem*)malloc(sizeof(hwmsdkagent::HwmWatchItem) * watchListInfo.watchListSize);
    if (watchListInfo.watchList == nullptr)
    {
        return;
    }
    errno_t err = 0;
    memset(watchListInfo.watchList, 0, sizeof(hwmsdkagent::HwmWatchItem)*watchListInfo.watchListSize);
    for (UINT i = 0; i < allWatchList.size(); i++)
    {
        watchListInfo.watchList[i] = allWatchList[i];
    }

    hwmsdkagent::GeneralWatch(&watchListInfo);
}