// demoLoginBySSO.cpp : ʵļ
//

#include "stdafx.h"
#include <string>
#include "afxdialogex.h"
#include "demo.h"
#include "demoLoginBySSO.h"
#include "HwmSdkAgent.h"
#include "demoTools.h"
#include "demoCustomMessage.h"
#include "demoData.h"


// demoLoginBySSO Ի

IMPLEMENT_DYNAMIC(demoLoginBySSO, CDialogEx)

demoLoginBySSO::demoLoginBySSO(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_LOGIN_BY_SSO, pParent)
{

}

demoLoginBySSO::~demoLoginBySSO()
{
}

void demoLoginBySSO::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_DOMAIN, m_domain);
    DDX_Control(pDX, IDC_EDIT_CODE, m_code);
    DDX_Control(pDX, IDC_COMBO_TYPE, m_type);
}


BEGIN_MESSAGE_MAP(demoLoginBySSO, CDialogEx)
    ON_BN_CLICKED(IDC_BUTTON_GET_SSO_AUTH_URL, &demoLoginBySSO::OnBnClickedButtonGetSsoAuthUrl)
    ON_BN_CLICKED(IDC_BUTTON_LOGIN, &demoLoginBySSO::OnBnClickedButtonLogin)
END_MESSAGE_MAP()


// demoLoginBySSO Ϣ

//ȡȨurl
void demoLoginBySSO::OnBnClickedButtonGetSsoAuthUrl()
{
    CString csDomain;
    //ȡϢ
    m_domain.GetWindowText(csDomain);

    //ת
    string domain = CTools::UNICODE2UTF(csDomain.GetString());
    
    //ûȡurlӿ
    int ret = hwmsdkagent::GetSSOAuthorizeUrl(domain.c_str());
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("GetSSOAuthorizeUrl error");
    }
}

BOOL demoLoginBySSO::OnInitDialog()
{
    CDialogEx::OnInitDialog();
    demoData::GetInstance().SetSSOHwnd(GetSafeHwnd());
    m_type.InsertString(0, _T("¼"));
    m_type.SetCurSel(0);

    return TRUE;  // return TRUE unless you set the focus to a control
                  // 쳣: OCX ҳӦ FALSE
}


void demoLoginBySSO::OnBnClickedButtonLogin()
{
    CString csDomain;
    CString csCode;
    //ȡϢ
    m_domain.GetWindowText(csDomain);
    m_code.GetWindowText(csCode);

    //ת
    string domain = CTools::UNICODE2UTF(csDomain.GetString());
    string code = CTools::UNICODE2UTF(csCode.GetString());

    //ûȡurlӿ
    hwmsdkagent::HwmSSOAuthInfo ssoAuthInfo{};
    auto errCode = strcpy_s(ssoAuthInfo.domain, HWM_MAX_SSO_DOMAIN_LEN,domain.c_str());
    errCode += strcpy_s(ssoAuthInfo.code, HWM_MAX_SSO_CODE_LEN, code.c_str());
    if (errCode != 0)
    {
        AfxMessageBox(_T("ssoAuthInfo copy error"));
    }
    ssoAuthInfo.authServerType = (hwmsdkagent::AuthServerType)m_type.GetCurSel();

    int ret = hwmsdkagent::LoginBySSO(&ssoAuthInfo);
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("LoginBySSO error");
    }
    else
    {
        //رյǰ
        OnOK();
    }
}
