﻿// demoSubtitleSettingDlg.cpp: 实现文件
//

#include "stdafx.h"
#include "demoSubtitleSettingDlg.h"
#include "afxdialogex.h"
#include "demo.h"
#include "demoTools.h"
#include "demoData.h"
#include "demoCustomMessage.h"

// demoSubtitleSettingDlg 对话框

IMPLEMENT_DYNAMIC(demoSubtitleSettingDlg, CDialogEx)

demoSubtitleSettingDlg::demoSubtitleSettingDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_SUBTITLE_SETTING_DIALOG, pParent)
    , m_targetLanguageMap{
        {"DEFAULT", hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_DEFAULT},
        {"CN"     , hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_CN},
        {"EN"     , hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_EN},
        {"GE"     , hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_GE},
        {"FR"     , hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_FR},
        {"RU"     , hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_RU},
        {"JA"     , hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_JA},
        {"KO"     , hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_KO},
        {"ES"     , hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_ES},
        {"PT"     , hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_PT},
        {"AR"     , hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_AR},
        {"IT"     , hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_IT},
        {"TH"     , hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_TH},
        {"ID"     , hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_ID},
        {"MS"     , hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_MS},
        {"TR"     , hwmsdkagent::HwmTargetLanguageType::SUBTITLE_LANGUAGE_TR},
    }
{

}

demoSubtitleSettingDlg::~demoSubtitleSettingDlg()
{
}

void demoSubtitleSettingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_COMBO_OPEN_SUBTITLE_IS_OPEN, m_isOpenCombo);
    DDX_Control(pDX, IDC_COMBO_SCRIBE_SUBTITLE_IS_SCRIBE, m_isSubscribeCombo);
    DDX_Control(pDX, IDC_BUTTON_SUBTITLE_SETTING_IS_SCRIBE, m_updateSubscribeState);
    DDX_Control(pDX, IDC_BUTTON_SUBTITLE_SETTING_IS_OPEN, m_updateOpenState);
    DDX_Control(pDX, IDC_COMBO_SCRIBE_LANGUAGE, m_subtitleLanguageCombo);
    DDX_Control(pDX, IDC_BUTTON_SUBTITLE_SETTING_SCRIBE_LANGUAGE, m_subscribeSubtitleLanguage);
    DDX_Control(pDX, IDC_BUTTON_SUBTITLE_SETTING_GET_LANGUAGE_LIST, m_getSubtitleLanguages);
}

BOOL demoSubtitleSettingDlg::OnInitDialog()
{
    CDialog::OnInitDialog();

    m_isOpenCombo.SetWindowText(_T("Open"));
    m_isOpenCombo.InsertString(0, _T("Open"));
    m_isOpenCombo.InsertString(1, _T("Close"));

    m_isSubscribeCombo.SetWindowText(_T("Subscribe"));
    m_isSubscribeCombo.InsertString(0, _T("Subscribe"));
    m_isSubscribeCombo.InsertString(1, _T("Cancel"));

    demoData::GetInstance().subscribeSubtitleSettingHandle(m_hWnd);

    return TRUE;
}


BEGIN_MESSAGE_MAP(demoSubtitleSettingDlg, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoSubtitleSettingDlg::OnBnClickedOk)
    ON_BN_CLICKED(IDC_BUTTON_SUBTITLE_SETTING_IS_OPEN, &demoSubtitleSettingDlg::OnBnClickedButtonSubtitleSettingIsOpen)
    ON_BN_CLICKED(IDC_BUTTON_SUBTITLE_SETTING_IS_SCRIBE, &demoSubtitleSettingDlg::OnBnClickedButtonSubtitleSettingIsSubscribe)
    ON_BN_CLICKED(IDC_BUTTON_SUBTITLE_SETTING_SCRIBE_LANGUAGE, &demoSubtitleSettingDlg::OnBnClickedButtonSubtitleSettingSubscribeLanguage)
    ON_BN_CLICKED(IDC_BUTTON_SUBTITLE_SETTING_GET_LANGUAGE_LIST, &demoSubtitleSettingDlg::OnBnClickedButtonSubtitleSettingGetLanguageList)
    ON_MESSAGE(WM_UPDATE_SUBTITLE_LANGUAGE_LIST, &demoSubtitleSettingDlg::UpdateSubtitleLanguageList)
END_MESSAGE_MAP()


// demoSubtitleSettingDlg 消息处理程序

int demoSubtitleSettingDlg::ClickOpenSubtitle()
{
    bool isOpen = true;
    CString strIsOpen;
    m_isOpenCombo.GetWindowText(strIsOpen);
    if (_T("Open") == strIsOpen)
    {
        isOpen = true;
    }
    else if (_T("Close") == strIsOpen)
    {
        isOpen = false;
    }

    int ret = hwmsdkagent::OpenSubtitle(isOpen);
    return ret;
}

int demoSubtitleSettingDlg::ClickSubscribeSubtitle()
{
    bool isSubscribe = true;
    CString strIsSubscribe;
    m_isSubscribeCombo.GetWindowText(strIsSubscribe);
    if (_T("Subscribe") == strIsSubscribe)
    {
        isSubscribe = true;
    }
    else if (_T("Cancel") == strIsSubscribe)
    {
        isSubscribe = false;
    }

    int ret = hwmsdkagent::SubscribeSubtitle(isSubscribe);
    return ret;
}

void demoSubtitleSettingDlg::OnBnClickedOk()
{
    CDialogEx::OnOK();
}

void demoSubtitleSettingDlg::OnBnClickedButtonSubtitleSettingIsOpen()
{
    int ret = ClickOpenSubtitle();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("OpenSubtitle error");
        return;
    }
}

void demoSubtitleSettingDlg::OnBnClickedButtonSubtitleSettingIsSubscribe()
{
    int ret = ClickSubscribeSubtitle();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("OpenSubtitle error");
        return;
    }
}

void demoSubtitleSettingDlg::OnBnClickedButtonSubtitleSettingSubscribeLanguage()
{
    if (m_subtitleLanguageCombo.GetCount() <= 0)
    {
        AfxMessageBox(_T("language list is empty"));
        return;
    }
    CString cLanguageName;
    m_subtitleLanguageCombo.GetWindowText(cLanguageName);
    std::string languageName = CTools::UNICODE2UTF(cLanguageName.GetString());
    if (languageName.empty() || !m_targetLanguageMap.count(languageName))
    {
        AfxMessageBox(_T("language name error"));
        return;
    }

    int ret = hwmsdkagent::SubscribeSubtitleLanguage(m_targetLanguageMap[languageName]);
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        AfxMessageBox(_T("Subscribe Subtitle Language error"));
    }
}

void demoSubtitleSettingDlg::OnBnClickedButtonSubtitleSettingGetLanguageList()
{
    int ret = hwmsdkagent::GetSubtitleSupportLanguage();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        AfxMessageBox(_T("Get Subtitle Support Language error"));
        return;
    }
}

LRESULT demoSubtitleSettingDlg::UpdateSubtitleLanguageList(WPARAM wparam, LPARAM lparam)
{
    m_subtitleLanguageCombo.ResetContent();
    auto languages = demoData::GetInstance().GetTargetLanguageTypeList();
    for (const auto& language : languages)
    {
        int index = static_cast<int>(language);
        std::string name = demoData::GetInstance().GetLanguageName(language);
        m_subtitleLanguageCombo.AddString(CTools::UTF2UNICODE(name).c_str());
    }

    return S_OK;
}
