﻿// demoUpdateCustomButtonInfo.cpp: 实现文件
//

#include "stdafx.h"
#include "resource.h"
#include "demoUpdateCustomButtonInfo.h"
#include "afxdialogex.h"
#include "demoTools.h"
#include "HwmSdkAgent.h"


// demoUpdateCustomButtonInfo 对话框

IMPLEMENT_DYNAMIC(demoUpdateCustomButtonInfo, CDialogEx)

demoUpdateCustomButtonInfo::demoUpdateCustomButtonInfo(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_UPDATE_CUSTOM_BUTTON_INFO_DIALOG, pParent)
{

}

demoUpdateCustomButtonInfo::~demoUpdateCustomButtonInfo()
{
}

void demoUpdateCustomButtonInfo::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_BUTTON_POS, m_buttonPosEdit);
    DDX_Control(pDX, IDC_BUTTON_KEY, m_buttonKeyEdit);
    DDX_Control(pDX, IDC_BUTTON_TITLE, m_buttonTitleEdit);
    DDX_Control(pDX, IDC_BUTTON_ICON_PATH, m_buttonIconPathEdit);
}


BEGIN_MESSAGE_MAP(demoUpdateCustomButtonInfo, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoUpdateCustomButtonInfo::OnBnClickedOk)
END_MESSAGE_MAP()


// demoUpdateCustomButtonInfo 消息处理程序

void demoUpdateCustomButtonInfo::OnBnClickedOk()
{
    CString buttonPosCString;
    CString buttonKeyCString;
    CString buttonTitleCString;
    CString buttonIconPathCString;
    m_buttonPosEdit.GetWindowText(buttonPosCString);
    m_buttonKeyEdit.GetWindowText(buttonKeyCString);
    m_buttonTitleEdit.GetWindowText(buttonTitleCString);
    m_buttonIconPathEdit.GetWindowText(buttonIconPathCString);

    hwmsdkagent::HwmCustomButtonInfo btnInfo{};
    btnInfo.buttonPos = static_cast<hwmsdkagent::HwmCustomButtonPos>(_ttoi(buttonPosCString));
    string buttonKey = CTools::UNICODE2UTF(buttonKeyCString.GetString());
    strcpy_s(btnInfo.buttonKey, sizeof(btnInfo.buttonKey), buttonKey.c_str());
    string buttonTitle = CTools::UNICODE2UTF(buttonTitleCString.GetString());
    strcpy_s(btnInfo.buttonTitle, sizeof(btnInfo.buttonTitle), buttonTitle.c_str());
    string buttonIconPath = CTools::UNICODE2UTF(buttonIconPathCString.GetString());
    strcpy_s(btnInfo.buttonImg, sizeof(btnInfo.buttonImg), buttonIconPath.c_str());

    int ret = hwmsdkagent::UpdateCustomButtonInfo(&btnInfo);
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("UpdateCustomButtonInfo error");
    }

    // TODO: 在此添加控件通知处理程序代码
    CDialogEx::OnOK();
}
