﻿/**
 * @file HwmAgentCallbackReserved.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief [en] Callback class.
 *        [cn] 回调类文件(供welink使用)
 */

#ifndef _HWM_AGENT_CALLBACK_RESERVED_H_
#define _HWM_AGENT_CALLBACK_RESERVED_H_

#include "HwmAgentNotifyDef.h"
#include "HwmAgentNotifyDefReserved.h"
#include "HwmErrorCodeDef.h"
#include "HwmAgentCallback.h"
#include "HwmAgentDefReserved.h"

namespace hwmsdkagent
{
    class HwmAgentCallbackReserved
    {
    public:
        /**
         * @brief [en] Callback of SetContactInfo interface.
         *        [cn] 设置联系人信息回调
         *
         * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
         *                                               [cn] 返回值
         * @param [in] const char* reason                [en] Fail reason
         *                                               [cn] 失败原因描述
         * @attention [en] NA
         *            [cn] NA
         **/
        virtual void OnSetContactInfoResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
         * @brief [en] Callback of PopupWindowManager interface.
         *        [cn] 弹出窗口管理器回调
         *
         * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
         *                                               [cn] 返回值
         * @param [in] const char* reason                [en] Fail reason
         *                                               [cn] 失败原因描述
         * @attention [en] NA
         *            [cn] NA
         **/
        virtual void OnPopupWindowResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of AnonymousEnterConfWithVerifyLink interface.
        *        [cn] 匿名链接入会（有验证）回调
        *
        * @param [in] hwmsdk::HwmErrCode ret             [en] Return code
        *                                                [cn] 返回值
        * @param [in] const char* reason                 [en] Fail reason
        *                                                [cn] 失败原因描述
        * @attention [en] Reserved
        *            [cn] 保留接口回调
        **/
        virtual void OnAnonymousJoinConfByVerifyLinkResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
         * @brief [en] Callback of start ctd conf interface.
         *        [cn] 开始ctd会议回调
         *
         * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
         *                                               [cn] 返回值
         * @param [in] const char* reason                [en] Fail reason
         *                                               [cn] 失败原因描述
         * @attention [en] NA
         *            [cn] NA
         **/
        virtual void OnStartCtdConfResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of AnonymousJoinConf interface.
        *        [cn] 匿名id入会回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnJoinConfByAnonymousIdResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
         * @brief [en] Callback of CheckSliderAndGetVerifyCode interface.
         *        [cn] 检验滑块并获取验证码
         *
         * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
         *                                               [cn] 返回值
         * @param [in] const char* reason                [en] Fail reason
         *                                               [cn] 失败原因描述
         * @attention [en] NA
         *            [cn] NA
         **/
        virtual void OnCheckSliderAndGetVerifyCodeResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
         * @brief [en] Callback of RequestVerifyCodeOrGetSlider interface.
         *        [cn] 请求验证码或获取滑块
         *
         * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
         *                                               [cn] 返回值
         * @param [in] const char* reason                [en] Fail reason
         *                                               [cn] 失败原因描述
         * @attention [en] NA
         *            [cn] NA
         **/
        virtual void OnRequestVerifyCodeOrGetSliderResult(hwmsdk::HwmErrCode ret, const char* reason, HwmSliderParam* sliderParam = NULL) {};

        /**
         * @brief [en] Callback of AnonymouseJoinConfByVerifyCode interface.
         *        [cn] 根据验证码入会(匿名)
         *
         * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
         *                                               [cn] 返回值
         * @param [in] const char* reason                [en] Fail reason
         *                                               [cn] 失败原因描述
         * @attention [en] NA
         *            [cn] NA
         **/
        virtual void OnAnonymousJoinConfByVerifyCodeResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of RefreshSlider interface.
        *        [cn] 刷新滑块
        *
        * @param [in] hwmsdk::HwmErrCode ret             [en] Return code
        *                                                [cn] 返回值
        * @param [in] const char* reason                 [en] Fail reason
        *                                                [cn] 失败原因描述
        * @attention [en] Reserved
        *            [cn] 保留接口回调
        **/
        virtual void OnRefreshSliderResult(hwmsdk::HwmErrCode ret, const char* reason, HwmSliderParam* sliderParam = NULL) {};

        /**
        * @brief [en] Callback of SetAvatar interface.
        *        [cn] 设置头像回调
        *
        * @param [in] hwmsdk::HwmErrCode ret             [en] Return code
        *                                                [cn] 返回值
        * @param [in] const char* reason                 [en] Fail reason
        *                                                [cn] 失败原因描述
        * @attention [en] Reserved
        *            [cn] 保留接口回调
        **/
        virtual void OnSetAvatarResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of RefreshMeetingToken interface.
        *        [cn] 刷新usg会议token回调
        *
        * @param [in] hwmsdk::HwmErrCode ret             [en] Return code
        *                                                [cn] 返回值
        * @param [in] const char* reason                 [en] Fail reason
        *                                                [cn] 失败原因描述
        * @attention [en] Reserved
        *            [cn] 保留接口回调
        **/
        virtual void OnRefreshMeetingTokenResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of JoinConfByConfDetail interface.
        *        [cn] 一键入会回调
        *
        * @param [in] hwmsdk::HwmErrCode ret             [en] Return code
        *                                                [cn] 返回值
        * @param [in] const char* reason                 [en] Fail reason
        *                                                [cn] 失败原因描述
        * @attention
        **/
        virtual void OnJoinConfByConfDetailResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of CreateConf interface.
        *        [cn] 创建会议回调(新接口)
        *
        * @param [in] hwmsdk::HwmErrCode ret             [en] Return code
        *                                                [cn] 返回值
        * @param [in] const char* reason                 [en] Fail reason
        *                                                [cn] 失败原因描述
        * @param [in] HwmConfInfo *confInfo              [en] Conf info
        *                                                [cn] 会议信息
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnCreateConfForWelinkResult(hwmsdk::HwmErrCode ret, const char* reason, HwmConfInfo *confInfo) {};

        /**
        * @brief [en] Callback of EnableCAVerification interface.
        *        [cn] 证明书校验开关回调
        *
        * @param [in] hwmsdk::HwmErrCode ret             [en] Return code
        *                                                [cn] 返回值
        * @param [in] const char* reason                 [en] Fail reason
        *                                                [cn] 失败原因描述
        * @attention
        **/
        virtual void OnEnableCAVerificationResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of SetOtherNumber interface.
        *        [cn] 设置其他号码回调
        *
        * @param [in] hwmsdk::HwmErrCode ret             [en] Return code
        *                                                [cn] 返回值
        * @param [in] const char* reason                 [en] Fail reason
        *                                                [cn] 失败原因描述
        * @attention
        **/
        virtual void OnSetOtherNumberResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of GetConfPstnAccessNumber interface.
        *        [cn] 获取会议pstn接入号码结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret             [en] Return code
        *                                                [cn] 返回值
        * @param [in] const char* reason                 [en] Fail reason
        *                                                [cn] 失败原因描述
        * @param [in] const char* pstn access number     [en] Return PstnAccessNumber
        *                                                [cn] 返回的会议pstn接入号码结果
        * @attention
        **/
        virtual void OnGetConfPstnAccessNumberResult(hwmsdk::HwmErrCode ret, const char* reason, const char* pstnAccessNumber) {};

        /**
        * @brief [en] Callback of ClickAnnotationBtn interface.
        *        [cn] 调用点击标注按钮事件结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnClickAnnotationBtnResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of ClickConfCtrlBtn interface.
        *        [cn] 调用点击会控按钮事件结果回调
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        *
        * @param info [type:HwmConfCtrlInfo]
        * [en] Conf control info
        * [cn] 会控操作信息
        *
        * @mac:disable
        **/
        virtual void OnClickConfCtrlBtnResult(hwmsdk::HwmErrCode ret, const char* reason, HwmConfCtrlInfo* info) {};

        /**
        * @brief [en] Callback of GetDeviceInfo interface for mic.
        *        [cn] 获取麦克风设备信息结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @param [in] HwmDeviceInfo* deviceInfoList     [en] Device info
        *                                               [cn] 设备信息
        * @param [in] int listLen                       [en] Length of device info
        *                                               [cn] 设备个数
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnGetMicDeviceInfoResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmDeviceInfo* deviceInfoList, int listLen) {};

        /**
        * @brief [en] Callback of GetDeviceInfo interface for camera.
        *        [cn] 获取摄像头设备信息结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @param [in] HwmDeviceInfo* deviceInfoList     [en] Device info
        *                                               [cn] 设备信息
        * @param [in] int listLen                       [en] Length of device info
        *                                               [cn] 设备个数
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnGetCameraDeviceInfoResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmDeviceInfo* deviceInfoList, int listLen) {};

        /**
        * @brief [en] Callback of GetDeviceInfo interface for speaker.
        *        [cn] 获取扬声器设备信息结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @param [in] HwmDeviceInfo* deviceInfoList     [en] Device info
        *                                               [cn] 设备信息
        * @param [in] int listLen                       [en] Length of device info
        *                                               [cn] 设备个数
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnGetSpeakerDeviceInfoResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmDeviceInfo* deviceInfoList, int listLen) {};

        /**
        * @brief [en] Callback of SetDeviceIndex interface.
        *        [cn] 设置设备结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnSetDeviceIndexResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of GetDeviceVolume interface.
        *        [cn] 获取设备音量结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @param [in] HwmDeviceType deviceType          [en] Device type
        *                                               [cn] 设备类型
        * @param [in] unsigned int volume               [en] Volume
        *                                               [cn] 设备音量
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnGetDeviceVolumeResult(hwmsdk::HwmErrCode ret, const char* reason, HwmDeviceType deviceType, unsigned int volume) {};

        /**
        * @brief [en] Callback of SetDeviceVolume interface.
        *        [cn] 设置设备音量结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnSetDeviceVolumeResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of StartPlayFile interface.
        *        [cn] 开始播放文件结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @param [in] int playHandle                    [en] play handle
        *                                               [cn] 播放文件句柄，作为停止播放文件接口的入参
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnStartPlayFileResult(hwmsdk::HwmErrCode ret, const char* reason, int playHandle) {};

        /**
        * @brief [en] Callback of StopPlayFile interface.
        *        [cn] 停止播放文件结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnStopPlayFileResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of OperateAudioPreview interface.
        *        [cn] 音频预览操作结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnOperateAudioPreviewResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of SetAutoAccept interface.
        *        [cn] 配置自动接听结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnSetAutoAcceptResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of GetConfSettings interface.
        *        [cn] 获取会中配置项结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @param [in] HwmConfSettings confSettings      [en] Conf settings
        *                                               [cn] 会中配置项
        * @param [in] bool isOpen                       [en] Is open
        *                                               [cn] 是否开启
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnGetConfSettingsResult(hwmsdk::HwmErrCode ret, const char* reason, HwmConfSettings confSettings, bool isOpen) {};

        /**
        * @brief [en] Callback of SetConfSettings interface.
        *        [cn] 设置会中配置项结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @param [in] bool isOpen                       [en] Is open
        *                                               [cn] 是否开启
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnSetConfSettingsResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of RemoveDeviceBinding interface.
        *        [cn] 设置会中配置项结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnRemoveDeviceBindingResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of ForceCancelConf interface.
        *        [cn] 强制取消会议回调
        *
        * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
        *                                       [cn] 返回值
        * @param [in] const char* reason        [en] Fail reason
        *                                       [cn] 失败原因描述
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnForceCancelConfResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of JoinConfByNonce interface.
        *        [cn] nonce入会回调
        *
        * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
        *                                       [cn] 返回值
        * @param [in] const char* reason        [en] Fail reason
        *                                       [cn] 失败原因描述
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnJoinConfByNonceResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of SetWinBoardAudioOptimize interface.
        *        [cn] 开启大屏音频接口结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnSetWinBoardAudioOptimizeResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of OnSetClientType interface.
        *        [cn] 设置客户端类型接口结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnSetClientTypeResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of OnSetCfgClientType interface.
        *        [cn] 设置配置文件类型接口结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnSetCfgClientTypeResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of ExtendConfDuration interface.
        *        [cn] 延长会议时间结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnExtendConfDurationResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of SetCpuThreshold interface.
        *        [cn] 设置CPU阈值接口结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnSetCpuThresholdResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of SetEnableCapability interface.
        *        [cn] 设置客户端能力开关接口回调
        *
        * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
        *                                       [cn] 返回值
        * @param [in] const char* reason        [en] Fail reason
        *                                       [cn] 失败原因描述
        * @attention [en] Reserved
        *            [cn] 保留接口回调
        **/
        virtual void OnSetEnableCapabilityResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of ConfigSmartRoomParam interface.
        *        [cn] 配置SmartRoom参数接口回调
        *
        * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
        *                                       [cn] 返回值
        * @param [in] const char* reason        [en] Fail reason
        *                                       [cn] 失败原因描述
        * @attention [en] Reserved
        *            [cn] 保留接口回调
        **/
        virtual void OnConfigSmartRoomParamResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of SetCtdCallNumberInfo interface.
        *        [cn] 设置回呼号码信息接口结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret    [en] Return code
        *                                       [cn] 返回值
        * @param [in] const char* reason        [en] Fail reason
        *                                       [cn] 失败原因描述
        * @attention [en] Reserved
        *            [cn] 保留接口回调
        **/
        virtual void OnSetCtdCallNumberInfoResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of GetCtdCallNumberInfo interface.
        *        [cn] 获取回呼号码信息接口结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @param [in] HwmCtdCallNumberInfo numberInfo   [en] ctd call number info
    *                                                   [cn] 回呼号码信息
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnGetCtdCallNumberInfoResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmCtdCallNumberInfo* numberInfo) {};

        /**
        * @brief [en] Callback of SetDeviceConfigForConfIncoming interface.
        *        [cn] 设置接听会议来电时麦克风/摄像头开关状态结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        **/
        virtual void OnSetDeviceConfigForConfIncomingResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of SetSignalProxy interface.
        *        [cn] 设置信令代理服务地址结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        **/
        virtual void OnSetSignalProxyResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of QueryDocFileLists interface.
        *        [cn] 查询会议文档信息结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @param [in] HwmDocFileInfo docFileList        [en] doc file info list
        *                                               [cn] 会议文档信息列表
        * @param [in] int listLen                       [en] list len
        *                                               [cn] 列表长度
        **/
        virtual void OnQueryDocFileListResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmDocFileInfo* docFileList, int listLen) {};

        /**
        * @brief [en] Callback of DeleteDoc interface.
        *        [cn] 删除会议文档结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        **/
        virtual void OnDeleteDocResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of ApplyDocOperateRight interface.
        *        [cn] 获取协作权限结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @param [in] HwmApplyDocOperRightResult applyDocRightResult        [en] apply doc right result
        *                                                                   [cn] 申请协作权限结果信息
        **/
        virtual void OnApplyDocOperateRightResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmApplyDocOperRightResult* applyDocRightResult) {};

        /**
        * @brief [en] Callback of CreateFolder interface.
        *        [cn] 创建会议文档文件夹结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @param [in] const char* fileGuid              [en] file guid
        *                                               [cn] 文档 guid
        **/
        virtual void OnCreateFolderResult(hwmsdk::HwmErrCode ret, const char* reason, const char* fileGuid) {};

        /**
        * @brief [en] Callback of EnableSaveTempRecordFile interface.
        *        [cn] 设置是否启用 保存临时录制文件 功能结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        **/
        virtual void OnEnableSaveTempRecordFileResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of GetDeviceResource interface.
        *        [cn] 获取设备资源结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @param [in] HwmDeviceResource deviceResource  [en] Device resource
        *                                               [cn] 设备资源信息
        **/
        virtual void OnGetDeviceResourceResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmDeviceResource* deviceResource) {};


        /**
        * @brief [en] Callback of QueryDocAccessUrl interface.
        *        [cn] 查询文档权限链接结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @param [in] const HwmQueryDocAccessUrlResult* queryDocAccessUrlResult    [en] query doc access url result
        *                                                                          [cn] 查询文档链接结果
        **/
        virtual void OnQueryDocAccessUrlResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmQueryDocAccessUrlResult* queryDocAccessUrlResult) {};

        /**
        * @brief [en] Callback of QueryDocAccessUrl interface.
        *        [cn] 批量设置部门信息结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        **/
        virtual void OnSetCorpDepartmentInfoResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of UnInit interface.
        *        [cn] 去初始化结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        **/
        virtual void OnUnInitResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of ConfigUTEventPublicParam interface.
        *        [cn] 配置打点公共参数结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        **/
        virtual void OnConfigUTEventPublicParamResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of AddUserTrack interface.
        *        [cn] 添加用户打点轨迹结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        **/
        virtual void OnAddUserTrackResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of StartEvent interface.
        *        [cn] 打点开始事件结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        **/
        virtual void OnStartEventResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of FinishEvent interface.
        *        [cn] 打点结束事件结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        **/
        virtual void OnFinishEventResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of AnonymousJoinConfBySignature interface.
        *        [cn] 安全会议匿名入会结果回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        **/
        virtual void OnAnonymousJoinConfBySignatureResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of OptimizeShareSmooth interface.
        *        [cn] 提升共享流畅度回调
        *
        * @param [in] SDKERR ret                        [en] Return code
        *                                               [cn] 返回值
        * @param [in] const HWM_CHAR* reason            [en] Fail reason
        *                                               [cn] 失败原因描述
        * @mac:disable
        **/
        virtual void OnOptimizeShareSmoothResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of QueryNonce interface.
        *        [cn] 获取nonce回调
        *
        * @param [in] hwmsdk::HwmErrCode ret            [en] Return code
        *                                               [cn] 返回值
        * @param [in] const char* reason                [en] Fail reason
        *                                               [cn] 失败原因描述
        * @param [in] const HwmQueryNonceResult* queryNonceResult [en] query nonce result
        *                                                         [cn] 获取nonce结果
        *
        * @mac:disable
        **/
        virtual void OnQueryNonceResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmQueryNonceResult* queryNonceResult) {};

        /**
        * @brief [en] Callback of BreakPairLink interface.
        *        [cn] 断开配对链路的接口回调
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        **/
        virtual void OnBreakPairLinkResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of ModifyPairLinkMode interface.
        *        [cn] 修改配对链路模式的接口回调
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        **/
        virtual void OnModifyPairLinkModeResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of SendCustomMsgToPairLink interface.
        *        [cn] 发送自定义消息到配对链路的接口回调
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        **/
        virtual void OnSendCustomMsgToPairLinkResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of SubmitNssSurvey interface.
        *        [cn] 提交满意度评价回调
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        *
        **/
        virtual void OnSubmitNssSurveyResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of GetConfLockedState interface.
        *        [cn] 获取会议锁定状态接口回调
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        *
        * @param state [type:HwmLockedState]
        * [en] state
        * [cn] 会议锁定状态
        *
        * @js:disable
        * @mac:disable
        **/
        virtual void OnGetConfLockedStateResult(hwmsdk::HwmErrCode ret, const char* reason, HwmLockedState state) {};

        /**
        * @brief [en] Callback of GetCpuPerformanceLevel interface.
        *        [cn] 获取cpu表现性能接口回调
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        *
        * @param cpuLevelResult [type:HwmCpuLevelResult*]
        * [en] Cpu Level Result
        * [cn] cpu性能结果信息
        *
        * @js:disable
        * @mac:disable
        **/
        virtual void OnGetCpuPerformanceLevelResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmCpuLevelResult* cpuLevelResult) {};

        /**
        * @brief [en] request media separate log
        *        [cn] 请求媒体分离日志结果
        *
        * @param ret [type:SDKERR]
        * [en]Error code
        * [cn]错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en]Reason
        * [cn]错误描述
        *
        * @mac:disable
        **/
        virtual void OnRequestMediaSeparateLogResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**        
        * @brief [en] Callback of GetNoiseReduceSettings interface.        
        *        [cn] 获取降噪配置项结果回调        
        *        
        * @param ret [type:SDKERR]        
        * [en] Error code        
        * [cn] 错误码        
        *        
        * @param reason [type:HWM_CHAR*]        
        * [en] Reason        
        * [cn] 错误描述        
        *        
        * @param level [type:HwmNoiseReduceSettings*]        
        * [en] Noise reduce level        
        * [cn] 降噪等级        
        *        
        * @mac:disable        
        **/
        virtual void OnGetNoiseReduceSettingsResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmNoiseReduceSettings* noiceReduceSettings) {};

        /**
        * @brief [en] Callback of EndProjection interface.
        *        [cn] 结束投屏回调
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        **/
        virtual void OnEndProjectionResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of SwitchProjectionToConf interface.
        *        [cn] 投屏会议转普通会议回调
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        **/
        virtual void OnSwitchProjectionToConfResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of GetSpesInfo interface.
        *        [cn] 获取Spes信息
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述        *        * @param spesInfo [type:HwmSpesInfoResult*]
        * [en]Spes info
        * [cn]Spes信息
        *
        * @mac:disable
        **/
        virtual void OnGetSpesInfoResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmSpesInfoResult* spesInfo) {};

        /**        * @brief [en] Callback of GetProxy interface.        *        [cn] 获取代理信息回调        *        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述        *        * @param proxyInfo [type:HwmProxyInfo*]        * [en] proxy info        * [cn] proxy信息描述        *        **/
        virtual void OnGetProxyResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmProxyInfo* proxyInfo) {};

        /**
        * @brief [en] Callback of UpdateExternalInviteesList interface.
        *        [cn] 更新外部邀请与会者
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        *
        * @mac:disable
        **/
        virtual void OnUpdateExternalInviteesListResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief
        * [en]Callback of QueryVersionInfo interface.
        * [cn]查询版本信息结果
        *
        * @param ret [type:SDKERR]
        * [en]Error code
        * [cn]错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en]Reason
        * [cn]错误描述
        *
        * @param queryResultInfo [type:HwmQueryVersionInfoResult*]
        * [en]Reason
        * [cn]版本信息查询结果
        *
        * @js:disable
        *
        */
        virtual void OnQueryVersionInfoResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmQueryVersionInfoResult* queryResultInfo) {};

        /**
        * @brief [en] Callback of LoginByThirdUserInfo interface.
        *        [cn] 通过第三方用户信息登录接口回调
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        **/
        virtual void OnLoginByThirdUserInfoResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of StartPlayAudioFile interface.
        *        [cn] 播放音频文件回调
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        **/
        virtual void OnStartPlayAudioFileResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of SetDeployInfo interface.
        *        [cn] 设置部署信息回调
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        *
        **/
        virtual void OnSetDeployInfoResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of SwapScreenContent interface.
        *        [cn] 会中交换屏幕
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        *
        **/
        virtual void OnSwapScreenContentResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of GetScreenContentSwapInfo interface.
        *        [cn] 获取会中屏幕交换信息接口回调
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        *
        * @param info [type:HwmScreenContentSwapInfo*]
        * [en] info
        * [cn] 会中交换屏幕信息
        *
        * @mac:disable
        *
        **/
        virtual void OnGetScreenContentSwapInfoResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmScreenContentSwapInfo* info) {};

        /**
        * @brief [en] Callback of SetInnerHttpProxyInfo interface.
        *        [cn] 设置内部Http代理信息
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        *
        **/
        virtual void OnSetInnerHttpProxyInfoResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of SetMeetingCustomInfo interface.
        *        [cn] 设置会议自定义信息
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        *
        **/
        virtual void OnSetMeetingCustomInfoResult(hwmsdk::HwmErrCode ret, const char* reason) {};

        /**
        * @brief [en] Callback of GetJwtToken interface.
        *        [cn] 获取本地鉴权token信息
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        *
        * @param jwtTokenInfo [type:HwmJwtTokenInfo*]
        * [en] jwt Token info
        * [cn] 本地鉴权token信息
        *
        **/
        virtual void OnGetJwtTokenResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmJwtTokenInfo* jwtTokenInfo) {};

/* auto generate code insert, forbit delete */
    };
}

#endif /* _HWM_AGENT_CALLBACK_RESERVED_H_ */
