﻿/**
 * @file HwmErrorCodeDef.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief [en] error code define file.
 *        [cn] 错误码定义文件
 */

#ifndef _HWM_ERROR_CODE_DEF_H_
#define _HWM_ERROR_CODE_DEF_H_

namespace hwmsdk
{

    /** 
     * [en]This enumeration is used to describe the error code.
     * [cn]错误码
     */
    typedef enum tagHwmErrCode
    {
        HWM_COMMON_SUCCESS = 0,                                       /**< [en]Common success.
                                                                           [cn]通用成功返回值 */
        HWM_COMMON_ERR_FAILED = 1,                                    /**< [en]Common failed.
                                                                           [cn]通用失败返回值 */
        HWM_COMMON_ERR_PARAM_ERROR = 2,                               /**< [en]The param is error.
                                                                           [cn]参数错误 */

        HWM_LOGIN_ERR_ACCOUNT_OR_PASSWORD_ERROR = 10006,              /**< [en]Account or password error.
                                                                           [cn]账号或密码错误 */
        HWM_LOGIN_ERR_ACCOUNT_LOCKED = 10007,                         /**< [en]Account locked.
                                                                           [cn]账号被锁定 */
        HWM_LOGIN_ERR_IP_OR_DEVICE_FORBIDDEN = 10008,                 /**< [en]Ip or device forbiden.
                                                                           [cn]IP或设备被禁止接入 */
        HWM_LOGIN_ERR_ACCOUNT_OR_ENTERPRISE_NOT_ACTIVE = 10009,       /**< [en]Account or enterprise is not activated.
                                                                           [cn]账号或企业未激活 */
        HWM_LOGIN_ERR_ENTERPRISE_NOT_SUPPORT_AUTO_REGISTER = 10010,   /**< [en]Account or enterprise is not activated.
                                                                           [cn]企业不支持自动开户 */
        HWM_LOGIN_ERR_AUTH_INFO_TIMEOUT = 10011,                      /**< [en]Account or enterprise is not activated.
                                                                           [cn]鉴权信息过期（是否使用UTC时间，是否经过校准） */
        HWM_LOGIN_ERR_AUTO_REGISTER_FAILED = 10012,                   /**< [en]Account or enterprise is not activated.
                                                                           [cn]自动开户失败（可能账号资源耗尽） */
        HWM_LOGIN_ERR_ACCOUNT_STOPED = 10013,                         /**< [en]Account or enterprise is not activated.
                                                                           [cn]账号被停用 */

        HWM_CONF_ERR_CONF_ID_OR_PASSWORD_ERROR = 20001,               /**< [en]Join conference with wrong id or password.
                                                                           [cn]会议id或密码错误 */
        HWM_CONF_ERR_CONF_LOCKED = 20002,                             /**< [en]Conference is locked.
                                                                           [cn]会议被锁定 */
        HWM_CONF_ERR_NOT_IN_CONF = 20003,                             /**< [en]Not in conference.
                                                                           [cn]不在会议中 */
        HWM_CONF_ERR_VMR_NOT_BEEN_HOLD = 20004,                       /**< [en]vmr has not been hold.
                                                                           [cn]VMR会议来宾不允许激活会议 */
        HWM_CONF_ERR_SHARE_LOCKED = 20005,                            /**< [en]Share is locked.
                                                                           [cn]共享被锁定 */
        HWM_CONF_ERR_NOT_IN_DATA_CONF = 20006,                        /**< [en]Not in data conference.
                                                                           [cn]不在数据会议中 */
        HWM_CONF_ERR_CONF_ONLY_SAME_ENTERPRISE = 20007,               /**< [en]Only the same enterprise can join the conference.
                                                                           [cn]只允许企业内用户加入会议 */
        HWM_CONF_ERR_CONF_ONLY_INVITED = 20008,                       /**< [en]Only invited participants can join the conference.
                                                                           [cn]只允许被邀请者加入会议 */
        HWM_CALL_ERR_THIRD_USER_ID_NO_EXIST = 20009,                  /**< [en]The third user id is not exist in start call.
                                                                           [cn]发起呼叫的第三方账号不存在 */
        HWM_ERR_NOT_IN_CONF_OR_CALL = 20010,                          /**< [en]Not in conference or in call.
                                                                           [cn]不在会议或呼叫中 */
        HWM_ERR_ALREADY_EXIST_CONF_OR_CALL = 20011,                   /**< [en]Already exist conf or call.
                                                                           [cn]已存在一路会议或呼叫 */
        HWM_CONF_ERR_PASSWORD_ERROR_LOCKED = 20012,                   /**< [en]Wrong password input, conf is locked,.
                                                                           [cn]多次密码错误导致会议暂时被锁定 */
        HWM_CONF_ERR_CONF_ENDED = 20013,                              /**< [en]Conf is ended,.
                                                                           [cn]会议已结束 */
        HWM_CONF_ERR_SAME_PWD_WITH_CHAIR = 20014,                     /**< [en]same password with chair.
                                                                           [cn]来宾密码与主持人密码相同 */
        HWM_CONF_ERR_NUM_OF_PAR_EXCEEDS_UPPER_LIMIT = 20015,          /**< [en]num of par exceeds upper limit.
                                                                           [cn]与会方超出专用VMR套餐的最大与会人数 */
        HWM_CONF_ERR_CONF_NOT_ON_LOCAL_STATION = 20016,               /**< [en]The meeting is not on this site.
                                                                           [cn]会议不在本站点 */
        HWM_CONF_ERR_AUTH_INVALID_SMS = 20017,                        /**< [en]invalid sms
                                                                           [cn]非法的手机号 */
        HWM_CONF_ERR_SDK_SVN_DETECT_FAILE = 411000017,                /**< [en]SVN port detection failed. 
                                                                           [cn]svn端口探测不通 */

        HWM_CONF_ERR_MEDIARES_MEDIA_RESOURCE_NOT_ENOUGH = 115021001,  /**< [en]Insufficient media resource.
                                                                           [cn]媒体资源不足 */
        HWM_CONF_ERR_ENTERPRISE_CONCURRENCY_RESOURCE_NOT_ENOUGH = 115022001, /**< [en]Enterprise concurrency resource not enough
                                                                              [cn]企业并发资源不足 */
        HWM_CONF_ERR_PARTICIPANT_CONF_NOT_SUPPORT = 111084013,        /**< [en]participant conf not support
                                                                           [cn]不支持该会议 */
        HWM_CONF_ERR_AUTH_SLIDE_GET_IMAGE_FAILED = 111100001,         /**< [en]slide get image failed 
                                                                           [cn]获取滑块图片失败 */
        HWM_CONF_ERR_AUTH_SLIDE_VERIFY_CHECK_FAILED = 111100002,      /**< [en]slide verify check failed 
                                                                           [cn]滑块校验失败 */
        HWM_CONF_ERR_AUTH_INVALID_RANDOM = 111100003,                 /**< [en]invalid random 
                                                                           [cn]无效的随机数 */
        HWM_CONF_ERR_AUTH_INVALID_SLIDER_TOKEN = 111100004,           /**< [en]invalid slider token
                                                                           [cn]无效滑块token */
        HWM_CONF_ERR_AUTH_NEED_CHECK_SLIDER = 111100005,              /**< [en]need check slider
                                                                           [cn]需要滑块校验 */
        HWM_CONF_ERR_SEND_VERIFY_CODE_FAIL = 111100007,               /**< [en]send verify code fail 
                                                                           [cn]发送验证码失败 */
        HWM_CONF_ERR_AUTH_VERIFY_CODE_EXPIRED = 111100008,            /**< [en]verify code expired 
                                                                           [cn]验证码已过期 */
        HWM_CONF_ERR_AUTH_VERIFY_CODE_FAIL = 111100009,               /**< [en]verify code fail
                                                                           [cn]验证码错误 */
        HWM_CONF_ERR_AUTH_VERIFY_CODE_FAIL_CNT_EXCEED = 111100010,    /**< [en]verify code fail count exceed 
                                                                           [cn]验证码错误超过最大次数 */
        HWM_CONF_ERR_AUTH_INVALID_UUID = 111100011,                   /**< [en]invalid uuid 
                                                                           [cn]uuid无效,需要重新验证手机号 */
        HWM_CONF_ERR_ATTENDEES_NUMBER_EXCEED_LIMIT = 111071066,       /**< [en]attendees number exceed limit
                                                                           [cn]与会方数量超出上限 */
        HWM_CONF_ERR_VMR_DATA_STATUS_ILLEGAL = 111073007,             /**< [en]vmr data status illegal 
                                                                           [cn]VMR套餐状态非法 */
        HWM_CONF_ERR_WAIT_APPLY_RESOURCE = 115029006,                 /**< [en]wait apply resource
                                                                           [cn]等待申请资源中 */
        HWM_CONF_ERR_VMR_CONF_CONFLICT = 111071106,                   /**< [en]Vmr conf conflict
                                                                           [cn]VMR会议冲突 */
        HWM_ORG_CONCURRENT_PARTICIPANTS_NUMBER_IS_ZERO = 111071060,   /**< [en]The enterprise cannot create meetings because it has not purchased any concurrent meeting resources. 
                                                                           [cn]企业未配置并发会议资源,无法使用个人会议ID和随机会议ID发起会议 */
        HWM_CONF_ERR_MODIFY_FAIL_AS_CONF_ALREADY_STARTED = 111071065, /**< [en]Conf already started, cannot modify. 
                                                                           [cn]正在召开会议,无法编辑会议详情 */
        HWM_CONF_ERR_CANCEL_FAIL_AS_CONF_STARTED = 111071067,         /**< [en]Conf already started, cannot cancel. 
                                                                           [cn]会议正在召开中，不允许取消会议 */
        HWM_CONF_ERR_RTC_NOT_SUPPORT_STG = 411000019,                 /**< [en]RTC not support STG
                                                                           [cn]RTC不支持STG模式 */
        HWM_CONF_ERR_AUDIENCE_VMR_LOGIC_RESOURCE_NOT_ENOUGH = 111072202,    /**< [en]num of audience exceeds upper limit. 
                                                                                 [cn]观众数超过VMR套餐中的观众最大并发资源数 */
        HWM_CONF_ERR_PARTICIPANT_VMR_LOGIC_RESOURCE_NOT_ENOUGH = 111072203,    /**< [en]num of participant exceeds upper limit.
                                                                                    [cn]主持人与嘉宾超过VMR套餐中的最大并发资源数 */
        HWM_CONF_ERR_START_TIME_LESS_THAN_CURRENT_TIME = 111071013,         /**< [en]Start time less than current time.
                                                                                 [cn]开始时间早于当前时间 */
        HWM_CONF_ERR_START_TIME_OVER_MAX_SCHEDULE_TIME = 111071014,         /**< [en]Start time over max schedule time. 
                                                                                 [cn]会议开始时间超出最大预订时间范围 */
        HWM_CONF_PORTAL_PARTICIPANT_UNAVAILABLE = 111076007,                /**< [en]Offline.
                                                                                 [cn]会场离线 */
        HWM_CONF_PORTAL_PARTICIPANT_COMMON_ERROR = 111076099,               /**< [en]Common error.
                                                                                 [cn]通常失败 */
        HWM_CONF_ERR_VMR_PWM_SAME_AS_MEETING_ID = 201080017,                /**< [en]Vmr pwd cannot same as meeting ID.
                                                                                 [cn]来宾密码不能和会议ID相同 */
        HWM_LOGIN_ERR_ACCOUNT_IS_UNBOUND = 206010075,                       /**< [en]Account is unbound.
                                                                                 [cn]账号已经解绑 */
        HWM_CONF_ERR_SERVER_ERROR = 990000018,                              /**< [en]Server error
                                                                                 [cn]连接不上服务器 */
        HWM_CONF_ERR_JOIN_ROOM_FAIL = 990000019,                            /**< [en]Join conf fail
                                                                                 [cn]无法加入会议 */
        HWM_CONF_ERR_SERVER_BUSY = 990000020,                               /**< [en]Server busy
                                                                                 [cn]服务器繁忙 */
        HWM_CONF_ERR_RTC_JOIN_ROOM_AUTH_FAIL = 990000022,                   /**< [en]Join conf auth fail
                                                                                 [cn]会议鉴权信息校验失败 */
        HWM_CONF_ERR_SERVER_CONNECTION_ERROR = 990000025,                   /**< [en]Server connection error
                                                                                 [cn]服务器连接异常 */
        HWM_CONF_ERR_AUTH_NEED_MOBILE_VERIFY = 111100013,                   /**< [en]Indicates xxxx.
                                                                                 [cn]需要验证手机号，海外接入国内，免费企业需要进行手机验证码校验 */
        HWM_CONF_ERR_ROLE_NOT_SUPPORT_OPERATION = 430400017,                /**< [en]Role not support operation
                                                                                 [cn]角色不支持该操作 */
        HWM_CONF_USER_NOT_VMR_OWNER = 111071063,                            /**< [en]Not cloud meeting room owner.
                                                                                 [cn]非云会议室拥有者 */
        HWM_VMR_DATA_STATUS_ILLEGAL = 111073007,                            /**< [en]Invalid cloud meeting room package status.
                                                                                 [cn]VMR套餐状态非法 */
        HWM_VMR_RESOURCE_UNAVAILABLE = 201080000,                           /**< [en]VMR resource unavailable.
                                                                                 [cn]云会议资源不可用 */
        HWM_ARGS_LENGTH_OVERRUN = 430100010,                                /**< [en]Args length overrun.
                                                                                 [cn]参数长度超限 */

        HWM_LOGIN_ERR_CA_VERIFY_FAILED = 412100012,                         /**< [en]Server CA certificate verification failed.
                                                                                 [cn]服务器CA证书校验失败 */
        HWM_LOGIN_ERR_CURLE_EXTERN_CONNECT_TIMEOUT = 412100017,             /**< [en]The proxy communication times out and the TCP link building fails. Probably because the proxy configuration is incorrect.
                                                                                 [cn]代理通信超时，tcp建链失败，大概率是代理配置错误 */
        HWM_LOGIN_ERR_CURLE_EXTERN_CLOSED_BY_PROXY = 412100018,             /**< [en]Disconnected by the proxy. Probably because the server address is misconfigured.
                                                                                 [cn]链接被代理断开，大概率是服务器地址配置错误 */
        HWM_LOGIN_ERR_CURLE_COULDNT_RESOLVE_PROXY = 412100024,              /**< [en]The authentication process failed. Unable to resolve proxy.
                                                                                 [cn]proxy域名解析失败 */
        HWM_LOGIN_ERR_CURLE_COULDNT_RESOLVE_HOST = 412100025,               /**< [en]The authentication process failed. Unable to resolve host.
                                                                                 [cn]服务器域名解析失败 */
        HWM_CONF_ERR_CONF_DATA_NOT_FOUND = 111070005,                       /**< [en]Meeting does not exist. 
                                                                                 [cn]会议不存在 */
        HWM_CONF_ERR_VMR_DATA_NOT_FOUND = 111070006,                        /**< [en]Personal cloud meeting room does not exist. 
                                                                                 [cn]个人云会议室不存在 */
        HWM_CONF_ERR_ACCESS_NUMBER_NOT_FOUND = 111070007,                   /**< [en]Meeting access number does not exist.
                                                                                 [cn]会议接入号不存在 */
        HWM_CONF_ERR_CONF_ROLE_AUTHENTICATION_FAILED = 111070010,           /**< [en]Insufficient permissions to view this meeting. 
                                                                                 [cn]权限不足,无法查看会议 */
        HWM_CONF_ERR_CONF_NUM_UP_TO_LIMIT = 111071082,                      /**< [en]Max meeting amount reached. 
                                                                                 [cn]会议数达到上限 */
        HWM_CONF_ERR_SITE_CALL_NUMBER_ILLEGAL_URI = 111072033,              /**< [en]The format of the number used for joining the meeting is incorrect. (Correct format: User name@Domain name/IP address:Port number or Country code plus phone number)
                                                                                 [cn]与会者的入会号码格式非法(支持SIP、TEL号码格式) */
        HWM_CONF_ERR_GUEST_NO_PERMISSION_OPERATION = 111072070,             /**< [en]The operation is not allowed for guest.
                                                                                 [cn]来宾不允许进行该操作 */
        HWM_CONF_ERR_OVER_MAX_PARTICIPANT_NUMBER = 111072101,               /**< [en]Max participant amount reached.
                                                                                 [cn]超过设置的会议方数 */
        HWM_PARTICIPANT_NOT_SUPPORT_SCREEN_SHOTS = 111072112,               /**< [en]This site does not support screen shots.
                                                                                 [cn]当前会场不支持禁止截屏 */
        HWM_CONF_ERR_STOP_SENSITIVE_WORDS = 111072227,                      /**< [en]Indicates sensitive words.
                                                                                 [cn]信息中包含敏感词 */
        HWM_CONF_ERR_PARTICIPANT_CONF_NOT_EXIST = 111081002,                /**< [en]Site meeting does not exist or is ended.
                                                                                 [cn]会场所在会议不存在或已结束 */
        HWM_CONF_ERR_USER_AUTHENTICATION_FAILED = 118000000,                /**< [en]User authentication failed.
                                                                                 [cn]用户鉴权失败 */
        HWM_CONF_ERR_USER_TOKEN_AUTH_FAILED = 118000001,                    /**< [en]User token authentication failed.
                                                                                 [cn]usg token 鉴权失败 */
        HWM_CONF_ERR_STATUS_ILLEGAL = 111072011,                            /**< [en]Meeting status incorrect. 
                                                                                 [cn]会议状态非法 */
        HWM_LOGIN_ERR_USG_JUMP_LOGIN_FAIL = 206010013,                      /**< [en]Jump login failed. Please contact SRE.
                                                                                 [cn]跳转登录失败 请联系SRE */
        HWM_LOGIN_ERR_USG_SSO_AUTH_FAILED = 206010022,                      /**< [en]SSO login failed. Please contact SRE.
                                                                                 [cn]SSO登录失败 请联系SRE */
        HWM_LOGIN_ERR_USG_AUTH_NOT_SUPPORT_SSO = 206010023,                 /**< [en]SSO login is not supported.
                                                                                 [cn]不支持sso登录 */
        HWM_LOGIN_ERR_USG_APPID_AUTH_FAILED = 206010025,                    /**< [en]APPID verification failed.
                                                                                 [cn]APPID校验失败 */
        HWM_LOGIN_ERR_USG_USER_NOT_EXIST = 206030000,                       /**< [en]The user does not exist.
                                                                                 [cn]系统中不存在该用户 */
        HWM_LOGIN_ERR_USG_USER_NUM_EXCEED = 206010070,                      /**< [en]The number of users has reached the maximum.
                                                                                 [cn]用户数超过上限 */
        HWM_CONF_ERR_SDK_CONF_NOT_EXIST = 411000003,                        /**< [en]Meeting does not exist.
                                                                                 [cn]会议不存在 */
        HWM_CONF_ERR_SDK_CONF_EXIST = 411000004,                            /**< [en]A meeting already exists.
                                                                                 [cn]已经有会议存在 */
        HWM_CONF_ERR_WRITE_FILE_FAILED = 411000018,                         /**< [en]Failed to write file.
                                                                                 [cn]写文件失败 */
        HWM_CONF_ERR_SDK_CHECK_PARAM_NOT_ALLOW_NULL = 411000103,            /**< [en]Parameters cannot be empty.
                                                                                 [cn]参数不许为空 */
        HWM_LOGIN_ERR_TIMEOUT = 412100003,                                  /**< [en]Timeout.
                                                                                 [cn]超时 */
        HWM_LOGIN_ERR_XML_ERROR = 412100005,                                /**< [en]XML parsing error.
                                                                                 [cn]XML解析出错 */
        HWM_LOGIN_ERR_REQUEST_FAILED = 412100007,                           /**< [en]Request message failed.
                                                                                 [cn]请求消息异常 */
        HWM_LOGIN_ERR_NETWORK_ERROR = 412100013,                            /**< [en]Network error.
                                                                                 [cn]网络异常 */
        HWM_LOGIN_ERR_JSON_ERROR = 412100016,                               /**< [en]JSON parsing error.
                                                                                 [cn]JSON解析失败 */
        HWM_LOGIN_ERR_CURLE_COULDNT_CONNECT = 412100026,                    /**< [en]The authentication process failed. Unable to connect.
                                                                                 [cn]认证鉴权过程失败，无法连接 */
        HWM_LOGIN_E_ERR_MNG_FAILED = 412100044,                             /**< [en]manger is diabled
                                                                                 [cn]管理面故障 */
        HWM_LOGIN_ERR_LOGIC_NETWORK_ERROR = 412200004,                      /**< [en]Network Error.
                                                                                 [cn]网络错误 */
        HWM_CONF_ERR_CALL_MEM_ERROR = 413000003,                            /**< [en]Memory allocation error.
                                                                                 [cn]分配内存错误 */
        HWM_CONF_ERR_CALL_MSG_ERROR = 413000005,                            /**< [en]Message sending error.
                                                                                 [cn]发送消息错误 */
        HWM_CONF_ERR_CALL_ALREADY_IN_CALL_ERROR = 413000101,                /**< [en]Already in call.
                                                                                 [cn]已经在呼叫中 */
        HWM_CONF_ERR_CONFCTRL_GENERAL = 414100001,                          /**< [en]Common error.
                                                                                 [cn]一般错误 */
        HWM_CONF_ERR_CONFCTRL_TIMEOUT = 414100003,                          /**< [en]Timeout.
                                                                                 [cn]超时 */
        HWM_CONF_ERR_CONFCTRL_REQUEST_FAILED = 414100006,                   /**< [en]Request message failed.
                                                                                 [cn]请求消息异常 */
        HWM_CONF_ERR_CONFCTRL_AUTH_FAILED = 414100007,                      /**< [en]Authentication failed.
                                                                                 [cn]鉴权失败 */
        HWM_CONF_ERR_CONFCTRL_SERVICE_ERROR = 414100008,                    /**< [en]Server error.
                                                                                 [cn]服务器异常 */
        HWM_CONF_ERR_CONFCTRL_CONF_BLOCK_FULL = 414100011,                  /**< [en]The meeting control block is full. Please release the control block that is not in use.
                                                                                 [cn]会控控制块已满，请释放没在使用的控制块 */
        HWM_CONF_ERR_CONFCTRL_CURLE_EXTERN_CONNECT_TIMEOUT = 414100012,     /**< [en]The proxy communication times out and the TCP link building fails. Probably because the proxy configuration is incorrect.
                                                                                 [cn]代理通信超时，tcp建链失败，大概率是代理配置错误 */
        HWM_CONF_ERR_CONFCTRL_CURLE_EXTERN_USER_OR_PWD_ERROR = 414100016,   /**< [en]The authentication process failed. The proxy user name or password is incorrect.
                                                                                 [cn]认证鉴权过程失败，代理用户名或者密码错误 */
        HWM_CONF_ERR_CONFCTRL_CURLE_EXTERN_AUTH_TYPE_ERROR = 414100017,     /**< [en]The authentication process failed. Incorrect authentication type. User name and password are required. The user needs to be prompted for input.
                                                                                 [cn]认证鉴权过程失败，错误的认证类型，同时需要用户名、密码，需要提示用户输入 */
        HWM_CONF_ERR_CONFCTRL_CURLE_COULDNT_RESOLVE_PROXY = 414100019,      /**< [en]Curl proxy exception.
                                                                                 [cn]curl代理异常 */
        HWM_CONF_ERR_CONFCTRL_CURLE_COULDNT_RESOLVE_HOST = 414100020,       /**< [en]Curl host exception.
                                                                                 [cn]curl主机异常 */
        HWM_CONF_ERR_CONFCTRL_CURLE_COULDNT_CONNECT = 414100021,            /**< [en]Curl connection exception.
                                                                                 [cn]curl连接异常 */
        HWM_CONF_ERR_CONFCTRL_JSON_PARSE_FAILED = 414100026,                /**< [en]JSON parsing failed.
                                                                                 [cn]解析json体失败 */
        HWM_CONF_ERR_CONFCTRL_TOKEN_IS_NULL_ERROR = 414100027,              /**< [en]WS token is empty.
                                                                                 [cn]ws token值为空 */
        HWM_CONF_ERR_CONFCTRL_GET_CONF_BASIC_BY_HANDLE_ERROR = 414100030,   /**< [en]Failed to get meeting control block.
                                                                                 [cn]获取会议控制块失败 */
        HWM_CONF_ERR_COMMON_SQLITE_E_NOT_INITED = 415000001,                /**< [en]DB is not initialized.
                                                                                 [cn]db未初始化 */
        HWM_CONF_ERR_COMMON_E_FAIL = 415000002,                             /**< [en]Common failure.
                                                                                 [cn]失败 */
        HWM_CONF_ERR_RTC_SDK_PARAM_ERROR = 990000005,                       /**< [en]Parameter error.
                                                                                 [cn]参数错误 */
        HWM_CONF_ERR_RTC_SDK_JOIN_ROOM_SERVICE_UNREACHABLE = 990000021,     /**< [en]Failed to join room. Service unavaliable.
                                                                                 [cn]加入房间失败，服务不可达 */
        HWM_CONF_ERR_RTC_SDK_NETWORK_FAILED = 990000053,                    /**< [en]network error.
                                                                                 [cn]网络问题 */

        HWM_AGENT_ERR_CALLBACK_TIMEOUT = 90001,                       /**< [en]Wait callback timeout.
                                                                           [cn]等待回调超时 */
        HWM_AGENT_ERR_IN_PROCESS = 90002,                             /**< [en]In process.
                                                                           [cn]接口正在处理中 */
        HWM_AGENT_ERR_NOT_LOGIN = 90003,                              /**< [en]Valid when not login.
                                                                           [cn]未登录，接口调用非法 */
        HWM_AGENT_ERR_NOT_INITED_END = 90004,                         /**< [en]Not initialized or initialization is not complete.
                                                                           [cn]未初始化或初始化尚未完成。*/
        HWM_AGENT_ERR_NOT_SUPPORT_END = 90005,                        /**< [en]Not supported in this release.
                                                                           [cn]此版本不支持。*/
        HWM_AGENT_ERR_OPERATION_INTERRUPT = 90012,                    /**< [en]Operation interrupt.
                                                                           [cn]操作中断。*/

    } HwmErrCode;

}


#endif /* _HWM_ERROR_CODE_DEF_H_ */
