﻿/**
 * @file HwmSdkAgentReserved.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief [en] Interface file.
 *        [cn] 新接口文件
 */

#ifndef _HWM_SDK_AGENT_RESERVED_H_
#define _HWM_SDK_AGENT_RESERVED_H_

#include "HwmAgentDefReserved.h"
#include "HwmAgentCallbackReserved.h"
#include "HwmAgentNotifyReserved.h"

#ifdef __cplusplus
extern "C" {
#endif

namespace hwmsdkagent
{
    /*********************************************以下是新添加的接口*********************************************/

    /**
    * @brief [en] This interface is used to set callback and notify obj for welink.
    *        [cn] 设置新接口回调和通知对象
    *
    * @param [in] HwmAgentCallbackReserved *callbackReserved           [en] Callback reserved obj
    *                                                                  [cn] 回调对象
    *
    * @param [in] HwmAgentNotifyReserved *notifyReserved               [en] Notify reserved obj
    *                                                                  [cn] 通知对象
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetCallbackAndNotifyObj(HwmAgentCallbackReserved *callbackReserved, HwmAgentNotifyReserved *notifyReserved);

    /**
    * @brief [en] This interface is used to set department info.
    *        [cn] 设置联系人部门信息
    *
    * @param [in] HwmSetDepartmentInfo *setDepartmentInfo              [en] Set contact department Info
    *                                                                  [cn] 设置联系人部门信息
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetContactInfo(HwmSetContactInfo *setContactInfo);

    /**
    * @brief [en] This interface is used to manage popup window.
    *        [cn] 弹出窗口管理器
    *
    * @param [in] HwmPopupWindowType popupWindowType                   [en] Popup window type info
    *                                                                  [cn] 弹出窗口类型参数
    *
    * @param [in] bool isShow                                          [en] IsShow
    *                                                                  [cn] 弹出或关闭
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode PopupWindow(HwmPopupWindowType popupWindowType, bool isShow);

    /**
    * @brief [en] This interface is used to anonymous join conf by verify id.
    *        [cn] 匿名id入会
    *
    * @param [in] HwmAnonymousIdConfInfo *anonymousIdConfInfo          [en] Anonymous id conf info
    *                                                                  [cn] 匿名id入会参数
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode AnonymousJoinConfById(HwmAnonymousIdConfInfo *anonymousIdConfInfo);

    /**
    * @brief [en] This interface is used to check and get slider.
    *        [cn] 校验滑块并获取验证码
    *
    * @param [in] HwmCheckSliderAndGetVerifyCodeInfo *checkSliderAndGetVerifyCodeInfo         [en] Check slider and get verify code info
    *                                                                                         [cn] 校验滑块并获取验证码参数
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode CheckSliderAndGetVerifyCode(HwmCheckSliderAndGetVerifyCodeInfo *checkSliderAndGetVerifyCodeInfo);

    /**
    * @brief [en] This interface is used to request verify code and get slider.
    *        [cn] 请求验证码或获取滑块
    *
    * @param [in] HwmRequestVerifyCodeOrGetSliderInfo *requestVerifyCodeOrGetSliderInfo       [en] Request verify code or get slider info
    *                                                                                         [cn] 请求验证码或获取滑块参数
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode RequestVerifyCodeOrGetSlider(HwmRequestVerifyCodeOrGetSliderInfo *requestVerifyCodeOrGetSliderInfo);

    /**
    * @brief [en] This interface is used to join conf by verify code.
    *        [cn] 根据验证码入会
    *
    * @param [in] HwmAnonymousJoinConfByVerifyCodeInfo *anonymousJoinConfByVerifyCodeInfo     [en] Anonymous join conf by verify code info
    *                                                                                         [cn] 根据验证码入会参数
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode AnonymouseJoinConfByVerifyCode(HwmAnonymousJoinConfByVerifyCodeInfo *anonymousJoinConfByVerifyCodeInfo);

    /**
    * @brief [en] This interface is used to anonymous join conf by verify link.
    *        [cn] 匿名链接入会
    *
    * @param [in] HwmAnonymousVerifyLinkConfInfo *anonymousLinkVerifyConfInfo                 [en] Anonymous link verify conf info
    *                                                                                         [cn] 匿名链接入会参数
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode AnonymousJoinConfByVerifyLink(HwmAnonymousVerifyLinkConfInfo *anonymousLinkVerifyConfInfo);

    /**
    * @brief [en] This interface is used to refresh slider.
    *        [cn] 刷新滑块
    *
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode RefreshSlider();

    /**
    * @brief [en] This interface is used to book ctd conf.
    *        [cn] 预约ctd会议(新内部接口)
    *
    * @param [in] HwmCtdCallInfo *ctdConfInfo                  [en] Ctd call info
    *                                                          [cn] 开始ctd会议参数
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode StartCtdCall(HwmCtdCallInfo *ctdConfInfo);

    /**
    * @brief [en] This interface is used to join conference by conference detail.
    *        [cn] 一键入会
    *
    * @param [in] HwmConfAccessInfo *confAccessInfo            [en] conference access info
    *                                                          [cn] 入会信息
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode JoinConfByConfDetail(HwmConfAccessInfo *confAccessInfo);

    /**
    * @brief [en] This interface is used to set avatar.
    *        [cn] 设置头像
    *
    * @param [in] HwmAvatarParam *pAvatarParam                 [en] avatar param
    *                                                          [cn] 头像参数
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetAvatar(const HwmAvatarParam *pAvatarParam);

    /**
    * @brief [en] This interface is used to refresh meeting token.
    *        [cn] 刷新usg会议token
    *
    * @param
    *
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode RefreshMeetingToken();

    /**
    * @deprecated
    * [en] Deprecated API.
    * [cn] 废弃接口
    *
    * @brief [en] This interface is used to create conf.
    *        [cn] 创建会议(新接口)
    *
    * @param [in] HwmCreateConfInfoForWelink *createConfInfo   [en] Create conf info
    *                                                          [cn] 创建会议参数
    * @param [in] HwmAttendeeInfoForWelink *attendees          [en] Attendee info
    *                                                          [cn] 与会者信息，可以为空
    * @param [in] unsigned int count                           [en] Attendee list count
    *                                                          [cn] 与会者个数，可以为0
    * @attention [en] NA
    *            [cn] NA
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode CreateConfForWelink(HwmCreateConfInfoForWelink *createConfInfo, HwmAttendeeInfoForWelink *attendees, unsigned int count);

    /**
    * @brief [en] This interface is used to verify CA.
    *        [cn] 证明书校验开关
    *
    * @param [in] bool isVerify                                [en] is Verify
    *                                                          [cn] 是否校验
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode EnableCAVerification(bool isVerify);

    /**
    * @brief [en] This interface is used to set other's number.
    *        [cn] 设置其他号码
    *
    * @param [in] HwmOtherNumberInfo* otherNumberInfo          [en] other number info
    *                                                          [cn] 号码信息
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetOtherNumber(HwmOtherNumberInfo* otherNumberInfo);

    /**
    * @brief [en] This interface is used to get conf pstn access number.
    *        [cn] 获取会议pstn接入号码
    *
    *
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode GetConfPstnAccessNumber();

    /**
    * @brief [en] This interface is used to click annotation btn.
    *        [cn] 调用标注按钮点击事件
    *
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode ClickAnnotationBtn();

    /**
    * @brief [en] This interface is used to click conf control btn.
    *        [cn] 调用会控按钮点击事件
    *
    * @param [in] HwmConfCtrlInfo info                         [en] Conf control info
    *                                                          [cn] 会控操作信息
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode ClickConfCtrlBtn(const HwmConfCtrlInfo* info);

    /**
    * @brief [en] This interface is used to get device info.
    *        [cn] 获取设备信息
    *
    * @param [in] HwmDeviceType deviceType                     [en] device type
    *                                                          [cn] 设备类型
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode GetDeviceInfo(HwmDeviceType deviceType);

    /**
    * @brief [en] This interface is used to set device index.
    *        [cn] 设置设备
    *
    * @param [in] HwmDeviceType deviceType                     [en] device type
    *                                                          [cn] 设备类型
    * @param [in] char deviceName                              [en] device name
    *                                                          [cn] 设备名称
    * @param [in] unsigned int deviceIndex                     [en] device index
    *                                                          [cn] 设备编号
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetDeviceIndex(HwmDeviceType deviceType, const char deviceName[MAX_DISPLAY_NAME], unsigned int deviceIndex);

    /**
    * @brief [en] This interface is used to get device volume.
    *        [cn] 获取设备音量
    *
    * @param [in] HwmDeviceType deviceType                     [en] device type
    *                                                          [cn] 设备类型
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode GetDeviceVolume(HwmDeviceType deviceType);

    /**
    * @brief [en] This interface is used to set device volume.
    *        [cn] 设置设备音量
    *
    * @param [in] HwmDeviceType deviceType                     [en] device type
    *                                                          [cn] 设备类型
    * @param [in] unsigned int volume                          [en] volume
    *                                                          [cn] 音量
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetDeviceVolume(HwmDeviceType deviceType, unsigned int volume);

    /**
    * @brief [en] This interface is used to start play file.
    *        [cn] 开始播放文件
    *
    * @param [in] unsigned int loopTime                        [en] loop time
    *                                                          [cn] 循环播放次数，0为一直循环
    * @param [in] const char filePath[HWM_MAX_FILE_PATH_LEN]   [en] file path
    *                                                          [cn] 文件路径
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode StartPlayFile(unsigned int loopTime, const char filePath[HWM_MAX_FILE_PATH_LEN]);

    /**
    * @brief [en] This interface is used to stop play file.
    *        [cn] 停止播放文件
    *
    * @param [in] int playHandle                               [en] play handle
    *                                                          [cn] 播放文件句柄
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode StopPlayFile(int playHandle);

    /**
    * @brief [en] This interface is used to preview audio.
    *        [cn] 音频预览操作
    *
    * @param [in] bool isStop                                  [en] is stop
    *                                                          [cn] 是否停止
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode OperateAudioPreview(bool isStop);

    /**
    * @brief [en] This interface is used to set auto accept.
    *        [cn] 配置自动接听
    *
    * @param [in] bool isOpen                                  [en] is open
    *                                                          [cn] 是否开启
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetAutoAccept(bool isOpen);

    /**
    * @brief [en] This interface is used to get conf settings.
    *        [cn] 获取会中配置项
    *
    * @param [in] HwmConfSettings confSettings                 [en] conf settings
    *                                                          [cn] 会中配置项
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode GetConfSettings(HwmConfSettings confSettings);

    /**
    * @brief [en] This interface is used to set conf settings.
    *        [cn] 设置会中配置项
    *
    * @param [in] HwmConfSettings confSettings                 [en] conf settings
    *                                                          [cn] 会中配置项
    * @param [in] bool isOpen                                  [en] is open
    *                                                          [cn] 是否开启
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetConfSettings(HwmConfSettings confSettings, bool isOpen);

    /**
    * @brief [en] This interface is used to remove device bingding.
    *        [cn] 解除绑定
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode RemoveDeviceBinding();

    /**
    * @brief [en] This interface is used to force cancel a conference.
    *        [cn] 强制取消会议
    *
    * @param [in] const char confId[HWM_MAX_CONF_ID_LEN]            [en] the id of the conference
    *                                                               [cn] 需要取消的会议的id
    *
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode ForceCancelConf(const char confId[HWM_MAX_CONF_ID_LEN]);

    /**
    * @brief [en] This interface is used to join conf by nonce.
    *        [cn] nonce入会
    *
    * @param [in] HwmJoinConfByNonceInfo *joinConfByNonceInfo                 [en] Nonce conf info
    *                                                                         [cn] nonce入会参数
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode JoinConfByNonce(const HwmJoinConfByNonceInfo *joinConfByNonceInfo);

    /**
    * @brief [en] This interface is used to set win board audio optimize.
    *        [cn] 启用大屏音频接口
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetWinBoardAudioOptimize(bool isEnable);

    /**
    * @brief [en] This interface is used to set client type.
    *        [cn] 设置客户端类型接口
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetClientType(HwmClientType clientType);

    /**
    * @brief [en] This interface is used to set cfg client type.
    *        [cn] 设置配置文件类型接口
    *
    * @attention [en] Reserved
    *            [cn] 保留接口
    *
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetCfgClientType(const char cfgClientType[HWM_MAX_CFG_CLIENT_TYPE_LEN]);

    /**
    * @brief [en]This interface is used to extend conf duration
    *        [cn]延长会议时间
    *
    * @param [in] HwmExtendConfDurationInfo *extendInfo                       [en] Extend conf duration info
    *                                                                         [cn] 延长会议时长信息
    * @attention [en] Reserved
    *            [cn] 保留接口
    *
    * @return [type:HwmErrCode]
    */
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode ExtendConfDuration(const HwmExtendConfDurationInfo *extendInfo);

    /**
    * @brief [en] This interface is used to set cpu threshold.
    *        [cn] 设置CPU阈值接口
    * @param [in] CpuThresholdInfo info                        [en] cpu threshold info
    *                                                          [cn] CPU 阈值信息
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetCpuThreshold(const HwmCpuThresholdInfo *info);

    /**
    * @brief [en] This interface is used to enable capability
    *        [cn] 设置客户端能力开关
    *
    * @param [in] HwmCapabilityType type                            [en] Capability type
    *                                                               [cn] 能力类型枚举
    * @param [in] bool isEnable                                     [en] Enable state
    *                                                               [cn] 开启状态
    * @attention  [en] Reserved
    *             [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetEnableCapability(HwmCapabilityType type, bool isEnable);

    /**
    * @brief [en] This interface is used to config smart room param
    *        [cn] 配置SmartRoom参数
    *
    * @param [in] HwmUtilsSmartRoomParam utilsCustomParam           [en] utils smartRoom custom param
    *                                                               [cn] SmartRoom 参数
    * @attention  [en] Reserved
    *             [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode ConfigSmartRoomParam(const HwmUtilsSmartRoomParam* utilsCustomParam);

    /**
    * @brief [en] This interface is used to set is reason include code
    *        [cn] 配置接口回调中的reason字段是否包含原始错误码信息
    *
    * @param [in] bool isInclude                                    [en] Is Include code
    *                                                               [cn] 是否包含原始错误码
    * @attention  [en] Reserved
    *             [cn] 保留接口
    * @Synchronized
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetIsReasonIncludeCode(bool isInclude);

    /**
    * @brief [en] This interface is used to set ctd call number info
    *        [cn] 设置回呼号码信息
    *
    * @param [in] HwmCtdCallNumberInfo numberInfo                   [en] ctd call number info
    *                                                               [cn] 回呼号码信息
    * @attention  [en] Reserved
    *             [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetCtdCallNumberInfo(HwmCtdCallNumberInfo* numberInfo);

    /**
    * @brief [en] This interface is used to get ctd call number info
    *        [cn] 获取回呼号码信息
    *
    * @attention  [en] Reserved
    *             [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode GetCtdCallNumberInfo();

    /**
    * @brief [en] This interface is used to set device config for conf incoming.
    *        [cn] 设置接听会议来电时麦克风/摄像头开关状态
    *
    * @param [in] HwmDeviceConfig deviceConfig                   [en] Device config info
    *                                                            [cn] 设备配置信息
    * @attention [en] NA
    *            [cn] NA
    * @win:todo
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetDeviceConfigForConfIncoming(const HwmDeviceConfig* deviceConfig);

    /**
    * @brief [en] This interface is used to set signal proxy.
    *        [cn] 设置信令代理服务地址
    *
    * @param [in] const char domain[HWM_MAX_URL_LEN]                [en] domain
    *                                                               [cn] 代理域名
    * @attention [en] NA
    *            [cn] NA
    * @win:todo
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetSignalProxy(const char domain[HWM_MAX_URL_LEN]);

    /**
    * @brief [en] This interface is used to query doc file lists.
    *        [cn] 查询会议文档信息
    *
    * @param [in] HwmQueryFileListsParam docParam                   [en] query doc file lists param
    *                                                               [cn] 查询文档需要的参数信息
    * @attention [en] NA
    *            [cn] NA
    * @win:todo
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode QueryDocFileList(const HwmQueryFileListParam* docParam);

    /**
    * @brief [en] This interface is used to delete document.
    *        [cn] 删除会议文档
    *
    * @param [in] HwmDeleteFileParam deleteParam                    [en] delete file param
    *                                                               [cn] 删除文档需要的参数信息
    * @attention [en] NA
    *            [cn] NA
    * @win:todo
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode DeleteDoc(const HwmDeleteFileParam* deleteParam);

    /**
    * @brief [en] This interface is used to apply doc operateRight.
    *        [cn] 获取协作权限
    *
    * @param [in] HwmApplyDocOperRightParam applyDocOperParam       [en] apply doc operate param
    *                                                               [cn] 申请协作权限需要的参数信息
    * @attention [en] NA
    *            [cn] NA
    * @win:todo
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode ApplyDocOperateRight(const HwmApplyDocOperRightParam* applyDocOperParam);

    /**
    * @brief [en] This interface is used to create folder.
    *        [cn] 创建会议文档文件夹
    *
    * @param [in] HwmCreateFolderParam confDcoParam                 [en] conf dco param
    *                                                               [cn] 创建会议文档需要的参数信息
    * @attention [en] NA
    *            [cn] NA
    * @win:todo
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode CreateFolder(const HwmCreateFolderParam* confDcoParam);

    /**
    * @brief [en] This interface is used to enable save temp record file function.
    *        [cn] 设置是否启用 保存临时录制文件 功能
    *
    * @param [in] bool isEnable                                [en] is Enable
    *                                                          [cn] 是否启用
    * @attention [en] Reserved
    *            [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode EnableSaveTempRecordFile(bool isEnable);

    /**
    * @brief [en] This interface is used to set cloud desktop mode
    *        [cn] 设置云桌面模式
    *
    * @attention  [en] Reserved
    *             [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetClientMode(HwmClientMode clientMode);

    /**
    * @brief [en] This interface is used to getting the device resource
    *        [cn] 获取设备资源
    *
    * @attention  [en] Reserved
    *             [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode GetDeviceResource();

    /**
    * @brief [en] Default Custom Shared Frame Rate Mode on the Configuration Settings Page.
    *        [cn] 配置设置界面默认自定义共享帧率方式
    *
    * @attention  [en] Reserved
    *             [cn] 保留接口
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode ConfigDefaultShareFrameRate(bool enabled, HWMShareFrameRateType frameRateType);

    /**
    * @brief [en] This interface is used to query doc accessUrl.
    *        [cn] 查询文档权限链接
    *
    * @param [in] HwmQueryDocAccessUrlParam queryDocAccessUrlParam       [en] query doc access url param
    *                                                                    [cn] 查询文档权限链接参数
    * @attention [en] NA
    *            [cn] NA
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode QueryDocAccessUrl(const HwmQueryDocAccessUrlParam* queryDocAccessUrlParam);
    
    /**
    * @brief [en] This interface is used to get data conf state.
    *        [cn] 获取数据会议状态
    *
    * @param [in] bool isInDataConf                                      [en] is in data conf
    *                                                                    [cn] 是否在数据会议中
    * @attention [en] NA
    *            [cn] NA
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode GetDataConfState(bool &isInDataConf);

    /**
    * @brief [en] Enable Crash Collection.
    *        [cn] 启用崩溃收集
    *
    * @attention [en] NA
    *            [cn] NA
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode EnableCrashCollection();

    /**
    * @brief [en] Set Corp Department Info.
    *        [cn] 批量设置用户部门信息
    *
    * @param [in] HwmSetCorpDepartmentInfo corpDepartmentInfo       [en] corp department info param
    *                                                               [cn] 企业部门信息参数
    * @param [in] int infoCount                                     [en] info count param
    *                                                               [cn] 部门信息数量
    * @attention [en] NA
    *            [cn] NA
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetCorpDepartmentInfo(const HwmSetCorpDepartmentInfo* corpDepartmentInfo, unsigned int infoCount);

    /**
    * @brief
    * [en]
    * [cn]查询联系人头像
    *
    * @detail
    * [en]
    * [cn]该接口用于查询联系人头像
    *
    * @param avatarParam [type:HwmQueryContactAvatarParam][cs_allowNull:N]
    * [en]
    * [cn]查询联系人头像参数
    *
    * @synchronized
    * @mac:disable
    */
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode QueryContactAvatar(const HwmQueryContactAvatarParam* avatarParam);

    /**
    * @brief
    * [en]Deinitialize
    * [cn]去初始化
    *
    * @detail
    * [en]
    * [cn]该接口用于清空初始化时设置的回调指针
    *
    * @mac:disable
    */
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode UnInit();

    /**
    * @brief
    * [en]Config UTEvent Public Param
    * [cn]配置打点公共参数
    *
    * @detail
    * [en]
    * [cn]该接口用于配置打点公共参数
    *
    * @param publicParam [type:HwmUTEventPublicParam][cs_allowNull:N]
    * [en]
    * [cn]打点公共参数
    *
    * @mac:disable
    */
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode ConfigUTEventPublicParam(const HwmUTEventPublicParam* publicParam);

    /**
    * @brief
    * [en]Add user track
    * [cn]添加用户打点轨迹
    *
    * @detail
    * [en]
    * [cn]该接口用于用户打点
    *
    * @param trackParam [type:HwmUserTrackParam][cs_allowNull:N]
    * [en]
    * [cn]用户打点轨迹参数
    *
    * @mac:disable
    */
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode AddUserTrack(const HwmUserTrackParam* trackParam);

    /**
    * @brief
    * [en]Start event
    * [cn]打点开始事件
    *
    * @detail
    * [en]
    * [cn]该接口用于记录事件打点开始时间和打点结束事件配套使用统计耗时
    *
    * @param keyInfo [type:HwmEventKeyInfo][cs_allowNull:N]
    * [en]
    * [cn]事件名称
    *
    * @mac:disable
    */
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode StartEvent(const HwmEventKeyInfo* keyInfo);

    /**
    * @brief
    * [en]Finish event
    * [cn]打点结束事件
    *
    * @detail
    * [en]
    * [cn]该接口用于记录事件打点结束时间和打点开始事件配套使用统计耗时
    *
    * @param keyInfo [type:HwmEventKeyInfo][cs_allowNull:N]
    * [en]
    * [cn]事件名称
    * @param trackParam [type:HwmUserTrackParam][cs_allowNull:N]
    * [en]
    * [cn]用户打点轨迹参数
    *
    * @mac:disable
    */
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode FinishEvent(const HwmEventKeyInfo* keyInfo,const HwmUserTrackParam* trackParam);

    /**
    * @brief [en] This interface is used to anonymous join conf by signature.
    *        [cn] 安全会议匿名入会
    *
    * @param [in] HwmAnonymousSignatureConfInfo *anonymousSignatureConfInfo         [en] Anonymous join conf by signature info
    *                                                                               [cn] 安全会议匿名入会参数
    * @mac:disable
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode AnonymousJoinConfBySignature(const HwmAnonymousSignatureConfInfo* anonymousSignatureConfInfo);

    /**
    * @brief
    * [en]Custom UI Configuration
    * [cn]自定义UI配置
    *
    * @detail
    * [en]
    * [cn]该接口用于自定义UI样式、交互等
    *
    * @param cfg [type:HwmCustomizedConfig][cs_allowNull:N]
    * [en]
    * [cn]配置信息
    *
    * @mac:disable
    * @synchronized
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode CustomizeConfig(const HwmCustomizedConfig* cfg);

    /**
    * @brief
    * [en]Optimize Share Smooth
    * [cn]提升共享流畅度
    *
    * @detail
    * [en]This interface is used to optimize share smooth
    * [cn]该接口用于提升共享流畅度
    *
    * @param cfg [type:HwmOptimizeShareConfig][cs_allowNull:N]
    * [en]Configuration information.
    * [cn]共享配置参数
    *
    * @mac:disable
    */
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode OptimizeShareSmooth(const HwmOptimizeShareConfig* cfg);

    /**
    * @brief
    * [en]Set indicates enable sparkrtc flag
    * [cn]设置是否支持sparkrtc会议
    *
    * @param enableRtc [type:bool]
    * [en]Indicates enable sparkrtc flag.
    * [cn]是否支持sparkrtc会议
    *
    * @mac:disable
    */
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetEnableRtc(bool enableRtc);

    /**

    * @brief

    * [en] This interface is used to apply json config.

    * [cn] 获取json配置

    *

    * @detail

    * [en] This interface is used to apply json config

    * [cn] 该接口用于获取json配置。

    *

    * @param [cs_allowNull:Y]

    *

    * @synchronized

    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode ApplyObsJsonConfigFromDB();

    /**
    * @brief
    * [en]Query nonce
    * [cn]获取nonce
    *
    * @detail
    * [en]This interface is used to Query nonce
    * [cn]该接口用于获取nonce
    *
    * @mac:disable
    */
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode QueryNonce();

    /**
    * @brief
    * [en] This interface is used to break pair link.
    * [cn] 断开配对链路
    *
    * @param pairLinkInfo [type:HwmPairLinkInfo*][cs_allowNull:N]
    * [en] The pair link info
    * [cn] 配对链路信息
    *

    * @mac:disable
    * @js:disable

    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode BreakPairLink(const HwmPairLinkInfo* pairLinkInfo);

    /**
    * @brief
    * [en] This interface is modify pair link mode.
    * [cn] 修改配对链路模式,临时/固定
    *
    * @param pairLinkInfo [type:HwmPairLinkInfo*][cs_allowNull:N]
    * [en] The pair link info
    * [cn] 配对链路信息
    *
    * @mac:disable
    * @js:disable

    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode ModifyPairLinkMode(const HwmPairLinkInfo* pairLinkInfo);

    /**
    * @brief
    * [en] This interface is send custom msg to pair link.
    * [cn] 发送自定义消息到配对链路
    *
    * @param customMsg [type:HWM_CHAR*][cs_allowNull:N]
    * [en] The custom msg
    * [cn] 自定义消息
    *
    * @mac:disable
    * @js:disable
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SendCustomMsgToPairLink(const char* customMsg);

    /**
    * [en]submit nss survey
    * [cn]提交满意度评价
    *
    * @detail
    * [en]This interface is used to submit nss survey
    * [cn]该接口用于提交满意度评价
    *
    * @param info [type:HwmNssSurveyInfo*][cs_allowNull:N]
    * [en]Nss survey info.
    * [cn]NSS满意度评价信息
    *
    * @mac:disable
    */
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SubmitNssSurvey(const HwmNssSurveyInfo* info);

    /**
    * @brief
    * [en] This interface is stop refresh pair verify code
    * [cn] 停止刷新配对验证码
    *
    * @mac:disable
    * @js:disable
    * @synchronized
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode StopRefreshPairVerifyCode();

    /**
    * @brief
    * [en]get conf locked state
    * [cn]获取会议锁定状态
    *
    * @detail
    * [en]This interface is used to get conf locked state
    * [cn]该接口用于获取会议锁定状态
    *
    * @js:disable
    * @mac:disable
    */
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode GetConfLockedState();

    /**
    * @brief [en] This interface is used to get cpu performance level.
    *        [cn] 获取cpu表现性能
    *
    * @js:disable
    * @mac:disable
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode GetCpuPerformanceLevel();

    /**
    * @brief
    * [en]request media separate log
    * [cn]获取媒体分离日志
    *
    * @detail
    * [en]This interface is used to request media separate log.
    * [cn]该接口用于获取媒体分离日志
    *
    * @mac:disable    */
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode RequestMediaSeparateLog();

    /**
    * @brief
    * [en] This interface is used to get error tip info.
    * [cn] 获取动态错误提示信息
    *
    * @param errorCode [type:HWM_INT32]
    * [en] Error code
    * [cn] 错误码
    *
    * @param errorInfo [type:HwmErrorInfo*]
    * [en] error info
    * [cn] 错误信息
    *
    * @synchronized
    * @paramOut
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode GetRemoteErrorInfo(int errorCode, HwmErrorInfo* errorInfo);

    /**
    * @brief
    * [en] This interface is used to set custom path.
    * [cn] 设置自定义路径
    *
    * @detail
    * [en]
    * [cn] 该接口用于设置自定义路径。
    *
    * @param customPathInfo [type:HwmCustomPathInfo*]
    * [en] Custom path info
    * [cn] 自定义路径信息
    *
    * @synchronized
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetCustomPath(const HwmCustomPathInfo* customPathInfo);

    /**    
    * @brief [en] This interface is used to get noise reduce settings.    
    *        [cn] 获取降噪配置项    
    *    
    * @mac:disable    
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode GetNoiseReduceSettings();

    /**    
    * @brief [en] This interface is used to set noise reduce settings.    
    *        [cn] 设置降噪配置项    *    
    * @param settings [type:HwmNoiseReduceSettings]    
    * [en] settings    
    * [cn] 降噪配置项    
    *    
    * @synchronized    
    * @mac:disable    
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetNoiseReduceSettings(const HwmNoiseReduceSettings* settings);

    /**
    * @brief
    * [en] This interface is used to end projection.
    * [cn] 结束投屏
    *
    * @detail
    * [en] This interface is used to end projection.
    * [cn] 该接口用于结束投屏。注意事项：1、只能在会议中使用。
    *
    * @param endProjectionParam [type:HwmEndProjectionParam*][cs_allowNull:N]
    * [en] End projection param
    * [cn] 发起投屏的参数体
    *
    * @js:disable
    * @mac:disable
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode EndProjection(const HwmEndProjectionParam* endProjectionParam);

    /**
    * @brief
    * [en] This interface is used to switch projection to conf.
    * [cn] 投屏会议转普通会议
    *
    * @detail
    * [en] This interface is used to switch projection to conf.
    * [cn] 该接口用于投屏会议转普通会议。注意事项：1、只能在会议中使用。
    *
    * @js:disable
    * @mac:disable
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SwitchProjectionToConf();

    /**
    * @brief    * [en] This interface is used to get spes info.
    * [cn] 获取Spes信息
    *
    * @mac:disable
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode GetSpesInfo();

    /**
     * @brief
     * [en] This interface is used to get proxy info.
     * [cn] 获取代理信息
     **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode GetProxy();

    /**
    * @brief
    * [en] This interface is update external invitees info.
    * [cn] 更新外部邀请者
    *
    * @mac:disable
    * @js:disable
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode UpdateExternalInviteesList(const HwmExternalInviteesInfo* list);

    /**
    * @brief
    * [en]This interface is used to query version info.
    * [cn]查询版本信息
    *
    * @param versionInfo[cs_allowNull:N]
    * [en]
    * [cn]查询版本请求信息
    *
    * @js:disable
    */
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode QueryVersionInfo(const HwmVersionInfo* versionInfo);

    /**
    * @brief
    * [en] This interface is auto optimize experience.
    * [cn] 开启体验自动优化
    *
    * @mac:disable
    * @js:disable
    * @synchronized
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode AutoOptimizeExperience(const HwmAutoOptimiseInfo* info);

    /**
    * @brief [en] This interface is used to login by third user info.
    *        [cn] 通过第三方用户信息登录
    *
    * @param thirdUserInfo [type: HwmThirdUserInfo*]
    * [en] Third user info
    * [cn] 第三方用户信息
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode LoginByThirdUserInfo(const HwmThirdUserInfo* thirdUserInfo);

    /**
    * @brief
    * [en] This interface is used to playing the audio file.
    * [cn] 开始播放音频文件
    *
    * @detail
    * [en]
    * [cn] 该接口用于播放音频文件
    *
    * @param param [type:HwmStartPlayAudioFileParam*]
    * [en] param
    * [cn] 播放音频文件参数
    *
    * @mac:disable
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode StartPlayAudioFile(const HwmStartPlayAudioFileParam* audioFileParam);

    /**
    * @brief
    * [en] This interface is used to stop playing audio files.
    * [cn] 停止播放音频文件
    *
    * @detail
    * [en]
    * [cn] 该接口用于停止播放音频文件
    *
    * @mac:disable
    * @synchronized
    */
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode StopPlayAudioFile();

    /**
    * @brief [en] This interface is used to set deploy info.
    *        [cn] 设置部署信息

    * @detail
    * [en] This interface is used to set deploy info.
    * [cn] 该接口用于设置部署模式

    * @param deployInfo [type:HwmDeployInfo*]
    * [en] Deploy Info
    * [cn] 部署信息
    *
    * @mac:transToSync
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetDeployInfo(const HwmDeployInfo* deployInfo);

    /**
    * @brief
    * [en] This interface is swap screen content in conf
    * [cn] 会中交换屏幕
    *
    * @mac:disable
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SwapScreenContent();

    /**
    * @brief
    * [en] This interface is get screen content swap info in conf
    * [cn] 获取会中屏幕交换信息
    *
    * @mac:disable
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode GetScreenContentSwapInfo();

    /**
    * @brief
    * [en] This interface is set inner http proxy info
    * [cn] 设置内部Http代理信息
    *
    * @doc:disable
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetInnerHttpProxyInfo(const HwmInnerHttpProxyInfo* innerHttpProxyInfo);

    /**
    * @brief
    * [en] This interface is set meeting custom info
    * [cn] 设置会议自定义信息
    *
    * @doc:disable
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode SetMeetingCustomInfo(const HwmMeetingCustomInfo* meetingCustomInfo);

    /**
    * @brief
    * [en] This interface is get JwtToken info.
    * [cn] 获取本地鉴权token信息
    *
    * @doc:disable
    * @mac:transToSync
    **/
    HWM_SDK_AGENT_API hwmsdk::HwmErrCode GetJwtToken();

/* auto generate code insert, forbit delete */
}
#ifdef __cplusplus
}
#endif

#endif /* _HWM_SDK_AGENT_H_ */

