// HwmEncryptionDemoBase64.cpp :  DLL ĳʼ̡
//

#include "HwmEncryptionDemo.h"
#include "base64.h"

void VideoEncryptionFunc(HwmMediaFrameBuffer* data)
{
    CHECK_MEDIA_DATA(data);

    std::string pcBase64;
    RtcBase64Encode(data->buffer, data->dataSize, pcBase64);
    SafeCopy(data, (const unsigned char*)pcBase64.c_str(), pcBase64.size());
}

void AudioEncryptionFunc(HwmMediaFrameBuffer* data)
{
    CHECK_MEDIA_DATA(data);

    std::string pcBase64;
    RtcBase64Encode(data->buffer, data->dataSize, pcBase64);
    SafeCopy(data, (const unsigned char*)pcBase64.c_str(), pcBase64.size());
}

void VideoDecryptionFunc(HwmMediaFrameBuffer* data)
{
    CHECK_MEDIA_DATA(data);

    unsigned char* pcBase64 = nullptr;
    unsigned int size = RtcBase64Decode(data->buffer, data->dataSize, &pcBase64);
    SafeCopy(data, pcBase64, size);
    if (pcBase64 != nullptr)
    {
        free(pcBase64);
        pcBase64 = nullptr;
    }
}

void AudioDecryptionFunc(HwmMediaFrameBuffer* data)
{
    CHECK_MEDIA_DATA(data);

    unsigned char* pcBase64 = nullptr;
    unsigned int size = RtcBase64Decode(data->buffer, data->dataSize, &pcBase64);
    SafeCopy(data, pcBase64, size);
    if (pcBase64 != nullptr)
    {
        free(pcBase64);
        pcBase64 = nullptr;
    }
}