//
//  demoNotifyAndCallBackProc.cpp
//  EC_SDK_DEMO
//
//  Created by EC Open support team.
//  Copyright(C), 2018, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
//

#include "stdafx.h"
#include <map>
#include <string>
#include <sstream>
#include "demoCallbackProc.h"
#include "demo.h"
#include "demoBeforeLoginDlg.h"
#include "demoCustomMessage.h"
#include "demoData.h"
#include "demoMainMenuDlg.h"
#include "HwmAgentDef.h"
#include "demoTools.h"
#include "demoLoginBySSO.h"

// LOGINLOGIC_E_ERR_CURLE_EXTERN_CONNECT_TIMEOUT = 10066,                   /* ͨųʱtcpʧܣǴô */
// LOGINLOGIC_E_ERR_CURLE_EXTERN_CLOSED_BY_PROXY = 10067,                   /* ӱϿǷַô */
// LOGINLOGIC_E_ERR_CURLE_EXTERN_PROXY_ADDR_OR_PORT_ERROR = 10068,          /* tcpʱproxy߶˿ô */
// LOGINLOGIC_E_ERR_CURLE_EXTERN_PROXY_PERMISSION_DENIED = 10069,           /* ֤ȨʧܣûûproxyȨޣҪproxyȨ */
// LOGINLOGIC_E_ERR_CURLE_EXTERN_USER_OR_PWD_ERROR = 10070,                 /* ֤Ȩʧܣû */
// LOGINLOGIC_E_ERR_CURLE_EXTERN_AUTH_TYPE_ERROR = 10071,                   /* ֤Ȩʧܣ֤ͣͬʱҪû룬Ҫʾû */
// LOGINLOGIC_E_ERR_CURLE_EXTERN_AUTH_ERROR = 10072,                        /* ֤Ȩʧܣδ֪пǲ֧֤ʽ鵯ʾû· */

static map<int, string> proxyErr{
    {10066, "ͨųʱtcpʧܣǴô"},
    {10067, "ӱϿǷַô"},
    {10068, "tcpʱproxy߶˿ô"},
    {10069, "֤ȨʧܣûûproxyȨޣҪproxyȨޡ"},
    {10070, "֤ȨʧܣûȡѡԶû롣"},
    {10071, "֤Ȩʧܣ֤ͣȡѡԶû롣"},
    {10072, "֤Ȩʧܣδ֪пǲ֧֤ʽ鵯ʾû·"},
};

demoCallbackProc::demoCallbackProc(void)
{
}

demoCallbackProc::~demoCallbackProc(void)
{
}

/**
* ʼص
*/
void demoCallbackProc::OnInitResult(hwmsdk::HwmErrCode ret, const char* reason, HwmSdkInfo *sdkInfo)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string verStr = sdkInfo != nullptr ? sdkInfo->version : "";
    string tips = "----- OnInitResult= " + retStream.str() + ", msg= " + msgStr.c_str() + ", version= " + verStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* ˳ص
*/
void demoCallbackProc::OnExitResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnExitResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* ýӿڻص
*/
void demoCallbackProc::OnConfigResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnConfigResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* ýӿڻص
*/
void demoCallbackProc::OnCleanConfigResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnCleanConfigResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* ¼ӿڻص
*/
void demoCallbackProc::OnLoginResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmLoginResult* loginResult)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    // Ϊʧ
    if (msgStr.empty() && proxyErr.find(ret) != proxyErr.end())
    {
        msgStr = proxyErr[ret];
    }
    string tips = "----- OnLoginResult = " + retStream.str() + ", msg = " + msgStr.c_str();
    if (nullptr != loginResult)
    {
        tips = tips + ", userUuid = [" + loginResult->userUuid + "]"
             + ", account = [" + loginResult->account + "]"
             + ", thirdAccount = [" + loginResult->thirdAccount + "]";
    }
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);

    Cdemo* app = (Cdemo*)AfxGetApp();
    if (nullptr == app) 
    {
        //Ѿر
        return;
    }
    CdemoBeforeLoginDlg* logindlg = dynamic_cast<CdemoBeforeLoginDlg *>(app->m_pCurDlgWnd);
    if (nullptr == logindlg) 
    {
        return;
    }
    ::PostMessage(logindlg->GetSafeHwnd(), WM_LOGIN_RESULT, (WPARAM)ret, NULL);
}

/**
* ÷Ϣӿڻص
*/
void demoCallbackProc::OnSetServerAddressResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetServerAddressResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* ӿڻص
*/
void demoCallbackProc::OnCreateConfResult(hwmsdk::HwmErrCode ret, const char* reason, HwmConfInfo *confInfo)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string confId = confInfo != nullptr ? confInfo->confId : "";
    string tips = "----- OnCreateConfResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    if (confInfo != NULL)
    {
        tips = tips + ", confId= " + confInfo->confId;
        tips = tips + ", startTimeStamp= " + std::to_string(confInfo->startTimeStamp);
        tips = tips + ", endTimeStamp= " + std::to_string(confInfo->endTimeStamp);
    }

    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* idӿڻص
*/
void demoCallbackProc::OnJoinConfByIdResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    // Ϊʧ
    if (msgStr.empty() && proxyErr.find(ret) != proxyErr.end())
    {
        msgStr = proxyErr[ret];
    }
    string tips = "----- OnJoinConfByIdResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnJoinConfByRandomResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    // Ϊʧ
    if (msgStr.empty() && proxyErr.find(ret) != proxyErr.end())
    {
        msgStr = proxyErr[ret];
    }
    string tips = "----- OnJoinConfByRandomResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* ӿڻص
*/
void demoCallbackProc::OnJoinConfByLinkResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    // Ϊʧ
    if (msgStr.empty() && proxyErr.find(ret) != proxyErr.end())
    {
        msgStr = proxyErr[ret];
    }
    string tips = "----- OnJoinConfByLinkResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* עӿڻص
*/
void demoCallbackProc::OnLogoutResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmLogoutResult* logoutResult)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnLogoutResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    if (nullptr != logoutResult)
    {
        tips = tips + ", userUuid = [" + logoutResult->userUuid + "]"
             + ", account = [" + logoutResult->account + "]"
             + ", thirdAccount = [" + logoutResult->thirdAccount + "]";
    }
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);

    Cdemo* app = (Cdemo*)AfxGetApp();
    if (app == nullptr) {
        //Ѿر
        return;
    }
    //ע󷵻ص¼ǰ
    demoMainMenuDlg* dlg = dynamic_cast<demoMainMenuDlg *>(app->m_pCurDlgWnd);
    if (nullptr == dlg) {
        return;
    }
    ::PostMessage(dlg->GetSafeHwnd(), WM_LOGOUT_RESULT, (WPARAM)ret, NULL);
}

/**
* ߽ӿڻص
*/
void demoCallbackProc::OnAddAttendeeResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnAddAttendeeResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* ýԽӿڻص
*/
void demoCallbackProc::OnSetLanguageResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetLanguageResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* 뿪ӿڻص
*/
void demoCallbackProc::OnLeaveConfResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnLeaveConfResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* ӿڻص
*/
void demoCallbackProc::OnEndConfResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnEndConfResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* ӿڻص
*/
void demoCallbackProc::OnStartShareResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnStartShareResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* ֹͣӿڻص
*/
void demoCallbackProc::OnStopShareResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnStopShareResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnBookConfResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmConfDetail* confDetail)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnBookConfResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    if (confDetail != NULL)
    {
        HwmConfListInfo confListInfo = confDetail->confListInfo;
        tips = tips + ", confId= " + confListInfo.confId;
        tips = tips + ", startTimeStamp= " + std::to_string(confListInfo.startTimeStamp);
        tips = tips + ", endTimeStamp= " + std::to_string(confListInfo.endTimeStamp);
        tips = tips + ", customInfo= " + std::string(confDetail->confListInfo.customInfo);
    }
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnCancelConfResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnCancelConfResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnEditConfResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnEditConfResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnGetVmrInfoListResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmVmrListInfo* vmrListInfo)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnGetVmrListResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);

    if (ret != 0 || vmrListInfo == nullptr || vmrListInfo->vmrs == nullptr)
    {
        return;
    }

    VmrListInfo info{};
    info.vmrList = std::vector<HwmVmrInfo>(vmrListInfo->vmrs, vmrListInfo->vmrs + vmrListInfo->numOfVmrs);
    info.isEnableShareVmr = vmrListInfo->isEnableShareVmr;
    demoData::GetInstance().UpdateVmrListInfo(info);
}

void demoCallbackProc::OnGetConfDetailResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmConfDetail* confDetail)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnGetConfDetailResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    if (confDetail != NULL)
    {
        HwmConfListInfo confListInfo = confDetail->confListInfo;
        tips = tips + ", confId= " + confListInfo.confId;
        tips = tips + ", startTimeStamp= " + std::to_string(confListInfo.startTimeStamp);
        tips = tips + ", endTimeStamp= " + std::to_string(confListInfo.endTimeStamp);
    }
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);

    if (ret != 0 || confDetail == nullptr)
    {
        return;
    }
    demoData::GetInstance().SetConfDetail(*confDetail);
}

void demoCallbackProc::OnChangeVmrInfoResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnChangeVmrInfoResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSetWaterMarkInjectInfoResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetWaterMarkInjectInfoResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnStartCallResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnStartCallResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* ôϢӿڻص
*/
void demoCallbackProc::OnSetProxyInfoResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    if (msgStr.empty() && proxyErr.find(ret) != proxyErr.end())
    {
        msgStr = proxyErr[ret];
    }
    string tips = "----- OnSetProxyInfoResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* ӿڻص
*/
void demoCallbackProc::OnRenameSelfResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnRenameSelfResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* Թܽӿڻص
*/
void demoCallbackProc::OnEnablePairResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnEnablePairResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* token¼ӿڻص
*/
void demoCallbackProc::OnLoginByTokenResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    // Ϊʧ
    if (msgStr.empty() && proxyErr.find(ret) != proxyErr.end())
    {
        msgStr = proxyErr[ret];
    }
    string tips = "----- OnLoginByTokenResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);

    Cdemo* app = (Cdemo*)AfxGetApp();
    if (nullptr == app) {
        //Ѿر
        return;
    }
    //¼ɹתҳ
    CdemoBeforeLoginDlg* logindlg = dynamic_cast<CdemoBeforeLoginDlg *>(app->m_pCurDlgWnd);
    if (nullptr == logindlg) {
        return;
    }
    ::PostMessage(logindlg->GetSafeHwnd(), WM_LOGIN_RESULT, (WPARAM)ret, NULL);
}

/**
* ù͸ڽӿڻص
*/
void demoCallbackProc::OnSetTransparentWndResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetTransparentWndResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSetCustomUITextResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetCustomUITextResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

/**
* ܿýӿڻص
*/
void demoCallbackProc::OnEnableFeature(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnEnableFeature= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSetFrameWndTopmostResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetFrameWndTopmostResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSetCallIncomingAnswerResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetCallIncomingAnswerResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSetConfIncomingAnswerResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetConfIncomingAnswerResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnShowMeetingWindowResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnShowMeetingWindowResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSetUserSavePath(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetUserSavePath= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnStartP2pConfResult(hwmsdk::HwmErrCode ret, const char * reason, HwmConfInfo * confInfo)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnStartP2pConfResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnGetUserStateResult(hwmsdk::HwmErrCode ret, const char* reason, HwmUserState userState)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    CString strUserState;
    strUserState.Format(_T("%d"), userState);
    string tips = "----- OnGetUserStateResult= " + retStream.str() + ", msg= " + msgStr.c_str() 
        + ", userState= " + CTools::UNICODE2UTF(strUserState.GetString());
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSetShareStrategyResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetShareStrategyResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSetShareAudioResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetShareAudioResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnGetAttendeeListResult(const HwmAttendeeInfo* attendeeList, unsigned int length)
{
    string tips = "----- OnGetAttendeeListResult  size= " + std::to_string(length) + "\r\n";
    for (int i = 0;i < length; ++i )
    {
        tips += "number = " + std::string(attendeeList[i].number);
        tips += " ,name = " + std::string(attendeeList[i].name);
        tips += " ,aliasCN = " + std::string(attendeeList[i].aliasCN);
        tips += " ,aliasEN = " + std::string(attendeeList[i].aliasEN);
        tips += " ,userId = " + std::to_string(attendeeList[i].userId);
        tips += " ,thirdUserId = " + std::string(attendeeList[i].thirdUserId);
        tips += " ,email = " + std::string(attendeeList[i].email);
        tips += " ,sms = " + std::string(attendeeList[i].sms);
        tips += " ,isMute = " + std::to_string(attendeeList[i].isMute);
        tips += " ,isAutoInvite = " + std::to_string(attendeeList[i].isAutoInvite);
        tips += " ,role = " + std::to_string(attendeeList[i].role);
        tips += " ,orgId = " + std::string(attendeeList[i].orgId);
        tips += " ,callStatus = " + std::to_string(attendeeList[i].callStatus);
        tips += " ,accountId = " + std::string(attendeeList[i].accountId);
        tips += " ,isAnonymous = " + std::to_string(attendeeList[i].isAnonymous) + "\r\n";
    }
    CTools::OutputRetStr(tips);
}

void demoCallbackProc::OnGetAudienceListResult(const HwmAttendeeInfo* audidenceList, unsigned int length)
{
    string tips = "----- OnGetAudienceListResult  size = " + std::to_string(length) + "\r\n";
    for (int i = 0; i < length; ++i)
    {
        tips += "number = " + std::string(audidenceList[i].number);
        tips += " ,name = " + std::string(audidenceList[i].name);
        tips += " ,aliasCN = " + std::string(audidenceList[i].aliasCN);
        tips += " ,aliasEN = " + std::string(audidenceList[i].aliasEN);
        tips += " ,userId = " + std::to_string(audidenceList[i].userId);
        tips += " ,thirdUserId = " + std::string(audidenceList[i].thirdUserId);
        tips += " ,email = " + std::string(audidenceList[i].email);
        tips += " ,sms = " + std::string(audidenceList[i].sms);
        tips += " ,isMute = " + std::to_string(audidenceList[i].isMute);
        tips += " ,isAutoInvite = " + std::to_string(audidenceList[i].isAutoInvite);
        tips += " ,role = " + std::to_string(audidenceList[i].role);
        tips += " ,orgId = " + std::string(audidenceList[i].orgId);
        tips += " ,callStatus = " + std::to_string(audidenceList[i].callStatus);
        tips += " ,accountId = " + std::string(audidenceList[i].accountId);
        tips += " ,isAnonymous = " + std::to_string(audidenceList[i].isAnonymous) + "\r\n";
    }
    CTools::OutputRetStr(tips);
}

void demoCallbackProc::OnGetRenderWindowInfoListResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmHwndListInfo* hwndInfo)
{
    demoData::GetInstance().SetWindowHandleInfo(WM_WINDLE_HANDLE_UPDATE,*hwndInfo);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnGetSSOAuthorizeUrlResult(hwmsdk::HwmErrCode ret, const char* reason, const char* ssoAuthorizeUrl)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string url = ssoAuthorizeUrl != nullptr ? ssoAuthorizeUrl : "";
    string tips = "----- OnGetSSOAuthorizeUrlResult= " + retStream.str() + ", msg= " + msgStr.c_str()
        + ", ssoAuthorizeUrl= " + url.c_str();
    CTools::OutputRetStr(tips);

    if (ret != S_OK)
    {
        CTools::ShowErrMsg(ret, reason);
        return;
    }

    Cdemo* app = (Cdemo*)AfxGetApp();
    if (nullptr == app) {
        //Ѿر
        return;
    }

    //ȡɹתҳ
    HWND ssoHwnd = demoData::GetInstance().GetSSOHwnd();
    if (!IsWindow(ssoHwnd))
    {
        return;
    }
    char *cUrl = new(std::nothrow) char[url.length() + 1]{0};
    if (cUrl == nullptr)
    {
        return;
    }
    auto errCode = strcpy_s(cUrl, url.length() + 1, url.c_str());
    if (errCode != 0)
    {
        AfxMessageBox(_T("url copy error"));
        return;
    }

    AfxMessageBox(L"ʾɨɹurlпcodeֵճ\"Ȩ\"ٵ\"¼\"");
    HINSTANCE execRet = ShellExecuteW(NULL, L"open",
        CTools::UTF2UNICODE(url).c_str(), NULL, NULL, SW_SHOWNORMAL);
    int execRetInt = (int)(intptr_t)execRet;
    // 32Ϊɹmsdn
    if (execRetInt <= 32)
    {
        string msg = "----- ShellExecute failed, error= " + std::to_string(GetLastError()) + ", execRet= " + std::to_string(execRetInt);
        CTools::OutputRetStr(msg);
    }
}

void demoCallbackProc::OnLoginBySSOResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmLoginResult* loginResult)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnGetSSOAuthorizeUrlResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    if (nullptr != loginResult)
    {
        tips = tips + ", userUuid = [" + loginResult->userUuid + "]"
             + ", account = [" + loginResult->account + "]"
             + ", thirdAccount = [" + loginResult->thirdAccount + "]";
    }
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);

    Cdemo* app = (Cdemo*)AfxGetApp();
    if (nullptr == app) {
        //Ѿر
        return;
    }
    //¼ɹתҳ
    CdemoBeforeLoginDlg* logindlg = dynamic_cast<CdemoBeforeLoginDlg *>(app->m_pCurDlgWnd);
    if (nullptr == logindlg) {
        return;
    }
    ::PostMessage(logindlg->GetSafeHwnd(), WM_LOGIN_RESULT, (WPARAM)ret, NULL);
}

void demoCallbackProc::OnAVDeviceCtrlResult(hwmsdk::HwmErrCode ret, const char* reason, HwmDeviceType deviceType)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    CString strDeviceType;
    strDeviceType.Format(_T("%d"), deviceType);
    string tips = "----- OnAVDeviceCtrlResult= " + retStream.str() + ", msg= " + msgStr.c_str()
        + ", deviceType= " + CTools::UNICODE2UTF(strDeviceType.GetString());
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSetAudioRawDataOutputConfigResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetAudioRawDataOutputConfigResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnUpdateCustomButtonInfoResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnUpdateCustomButtonInfoResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnDisableVoicePromptsResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnDisableVoicePromptsResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnUploadSelfAvatarResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnUploadSelfAvatarResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnDeleteSelfAvatarResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnDeleteSelfAvatarResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnGetUserSavePathResult(hwmsdk::HwmErrCode ret, const char * reason, const HwmUserSavePathInfo * pathInfo)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr;
    if (reason != nullptr)
    {
        msgStr.append(reason).append("; ");
    }
    if (pathInfo != nullptr && ret == hwmsdk::HwmErrCode::HWM_COMMON_SUCCESS)
    {
        msgStr.append("type: ").append(to_string(pathInfo->pathType));
        msgStr.append("; path: ").append(pathInfo->path);
    }
    string tips = "----- OnGetUserSavePathResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnGeneralWatchResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnGeneralWatchResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnStartAnnotationResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnStartAnnotationResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSetAnnotationWindowResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetAnnotationWindowResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSaveAnnotationResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSaveAnnotationResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnStopAnnotationResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnStopAnnotationResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnStartProjectionResult(hwmsdk::HwmErrCode ret, const char * reason, const HwmStartProjectionResult * startProjectionResult)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string randomNumberStr = startProjectionResult != nullptr ? startProjectionResult->randomNumber : "";
    string tips = "----- OnStartProjectionResult= " + retStream.str() + ", msg= " + msgStr.c_str() + ", randomNumber = " + randomNumberStr.c_str();
    CTools::OutputRetStr(tips);

    if (startProjectionResult != nullptr && strlen(startProjectionResult->randomNumber) > 0 && IsWindow(demoData::GetInstance().GetStartProjectionHwnd()))
    {
        UINT32 len = sizeof(startProjectionResult->randomNumber);
        char* randomNumber = new(std::nothrow) char[len+1]{};
        if (randomNumber != nullptr)
        {
            auto errCode = strcpy_s(randomNumber, len+1, startProjectionResult->randomNumber);
            if (errCode != 0)
            {
                AfxMessageBox(_T("url copy error"));

                delete[] randomNumber;
                randomNumber = nullptr;
            }
            else
            {
                ::PostMessage(demoData::GetInstance().GetStartProjectionHwnd(), WM_START_PROJECTION_RANDOM_NUMBER, reinterpret_cast<WPARAM>(randomNumber), NULL);
            }
        }
        return;
    }

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSetCAVerifyInfoResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetCAVerifyInfoResult = " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSetAnswerTypeResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetAnswerTypeResult = " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnAcceptConfResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnAcceptConfResult = " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnRejectConfResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnRejectConfResult = " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSetGlobalGuaranteedIpAddressesResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetGlobalGuaranteedIpAddressesResult = " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnGetSelfShareStateResult(hwmsdk::HwmErrCode ret, const char * reason, const HwmSelfShareStateInfo * selfShareStateInfo)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnGetSelfShareStateResult = " + retStream.str() + ", msg= " + msgStr.c_str();
    if (selfShareStateInfo != nullptr)
    {
        tips += ", state= " + std::to_string(selfShareStateInfo->state);
    }
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnGetLoginStateResult(hwmsdk::HwmErrCode ret, const char * reason, const HwmLoginStateInfo * loginStateInfo)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnGetLoginStateResult = " + retStream.str() + ", msg= " + msgStr.c_str();
    if (loginStateInfo != nullptr)
    {
        tips += ", state= " + std::to_string(loginStateInfo->loginState);
    }
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnGetLoginTokenResult(hwmsdk::HwmErrCode ret, const char * reason, const HwmLoginTokenInfo* loginTokenInfo)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnGetLoginTokenResult = " + retStream.str() + ", msg= " + msgStr.c_str();
    if (loginTokenInfo != nullptr)
    {
        tips += ", token= " + std::string(loginTokenInfo->loginToken);
    }
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnOpenSubtitleResult(hwmsdk::HwmErrCode ret, const char * reason, bool isOpen)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnOpenSubtitleResult = " + retStream.str() + ", msg= " + msgStr.c_str() + ", isOpen= " + (isOpen ? "open" : "close");
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnOpenWaitingRoomResult(hwmsdk::HwmErrCode ret, const char * reason, bool isOpen)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnOpenWaitingRoomResult = " + retStream.str() + ", msg= " + msgStr.c_str() + ", isOpen= " + (isOpen ? "open" : "close");
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnOperateLocalRecordResult(hwmsdk::HwmErrCode ret, const char * reason, HwmLocalRecordOperateType type)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnOperateLocalRecordResult = " + retStream.str() + ", msg= " + msgStr.c_str();
    string typeStr = "start";
    if (type == HwmLocalRecordOperateType::LOCAL_RECORD_OPERATE_TYPE_STOP)
    {
        typeStr = "stop";
    }
    else if (type == HwmLocalRecordOperateType::LOCAL_RECORD_OPERATE_TYPE_PAUSE)
    {
        typeStr = "pause";
    }
    else if (type == HwmLocalRecordOperateType::LOCAL_RECORD_OPERATE_TYPE_RESUME)
    {
        typeStr = "resume";
    }
    typeStr = ", type = " + typeStr;
    CTools::OutputRetStr(tips+ typeStr);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnOpenVirtualBackgroundSettingPageResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnOpenVirtualBackgroundSettingPageResult = " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnGetConfLocalRecordStatusResult(hwmsdk::HwmErrCode ret, const char * reason, const HwmLocalRecordStatusInfo * state)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnGetConfLocalRecordStatusResult = " + retStream.str() + ", msg= " + msgStr.c_str();
    if (state != nullptr)
    {
        std::string stateStr = "start";
        if (state->state == HwmLocalRecordStatus::LOCAL_RECORD_STATUS_STOPPED)
        {
            stateStr = "stopped";
        }
        else if (state->state == HwmLocalRecordStatus::LOCAL_RECORD_STATUS_PAUSED)
        {
            stateStr = "paused";
        }
        else if (state->state == HwmLocalRecordStatus::LOCAL_RECORD_STATUS_RESUMED)
        {
            stateStr = "resumed";
        }
        tips += (", state= " + stateStr);
    }
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnGetSelfHasLocalRecordPermissionResult(hwmsdk::HwmErrCode ret, const char * reason, const HwmLocalRecordPermissionInfo * permission)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnGetSelfHasLocalRecordPermissionResult = " + retStream.str() + ", msg= " + msgStr.c_str();
    if (permission != nullptr)
    {
        tips += ", hasPermission= " + std::to_string(permission->hasPermission);
    }
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnRequestLocalRecordPermissionResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnRequestLocalRecordPermissionResult = " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnApplyHostRoleResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnApplyHostRoleResult = " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnGetSubtitlePageOpenedResult(hwmsdk::HwmErrCode ret, const char * reason, bool isOpen)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnGetSubtitlePageOpenedResult = " + retStream.str() + ", msg= " + msgStr.c_str() + ", isOpened= " + (isOpen ? "open" : "close");
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnGetWaitingRoomOpenedResult(hwmsdk::HwmErrCode ret, const char * reason, bool isOpen)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnGetWaitingRoomOpenedResult = " + retStream.str() + ", msg= " + msgStr.c_str() + ", isOpened= " + (isOpen ? "open" : "close");
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnGetVirtualBackgroundSettingPageOpenedResult(hwmsdk::HwmErrCode ret, const char * reason, bool isOpen)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnGetVirtualBackgroundSettingPageOpenedResult = " + retStream.str() + ", msg= " + msgStr.c_str() + ", isOpened= " + (isOpen ? "open" : "close");
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSubscribeSubtitleLanguageResult(hwmsdk::HwmErrCode ret, const char * reason, HwmTargetLanguageType targetLanguageType)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSubscribeSubtitleLanguageResult = " + retStream.str() + ", msg= " + msgStr.c_str() + ", language= " + std::to_string(targetLanguageType);
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSubscribeSubtitleResult(hwmsdk::HwmErrCode ret, const char * reason, bool isSubscirbe)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSubscribeSubtitleResult = " + retStream.str() + ", msg= " + msgStr.c_str() + ", isSubscirbe= " + std::to_string(isSubscirbe);
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnGetSubtitleSupportLanguageResult(hwmsdk::HwmErrCode ret, const char * reason, const HwmTargetLanguageTypeList* targetLanguageTypeList)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnGetSubtitleSupportLanguageResult = " + retStream.str() + ", msg= " + msgStr.c_str();
    if (targetLanguageTypeList != nullptr)
    {
        int size = targetLanguageTypeList->targetLanguageTypeSize;
        tips += ", language list size = " + std::to_string(size) + ":\r\n";
        for (int i = 0; i < size; i++)
        {
            auto typeInfo = targetLanguageTypeList->targetLanguageTypes[i];
            auto name = demoData::GetInstance().GetLanguageName(typeInfo.targetLanguageType);
            tips += ", langugae(" + std::to_string(i + 1) + "): " + name.c_str();
        }
    }
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);

    if (ret != 0 || targetLanguageTypeList == nullptr)
    {
        return;
    }
    demoData::GetInstance().SetTargetLanguageTypeList(*targetLanguageTypeList);
}

void demoCallbackProc::OnBookCycleConfResult(hwmsdk::HwmErrCode result, const char* reasonDesc, const HwmConfDetail* confDetail)
{
    if(confDetail == nullptr)
    {
        return;
    }
    ostringstream retStream;
    retStream << result;
    string msgStr = reasonDesc != nullptr ? reasonDesc : "";
    string tips = "----- OnBookCycleConfResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    if (confDetail != NULL)
    {
        HwmConfListInfo confListInfo = confDetail->confListInfo;
        tips += ", confId= " + std::string(confListInfo.confId);
        tips += ", startTimeStamp= " + std::to_string(confListInfo.startTimeStamp);
        tips += ", endTimeStamp= " + std::to_string(confListInfo.endTimeStamp);
        tips += ", subConfParam = ";

        for (UINT i = 0; i < confDetail->confListInfo.subConfSize; i++)
        {
            if (i > 0)
            {
                tips += " , ";
            }
            HwmSubCycleConfParam subConf = confDetail->confListInfo.subConfParam[i];
            tips += "{ startTimeStamp: " + std::to_string(subConf.startTimeStamp);
            tips += ", endTimeStamp: " + std::to_string(subConf.endTimeStamp);
            tips += " }";
        }
    }

    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(result, reasonDesc);
}

void demoCallbackProc::OnModifyCycleConfResult(hwmsdk::HwmErrCode result, const char * reasonDesc)
{
    ostringstream retStream;
    retStream << result;
    string msgStr = reasonDesc != nullptr ? reasonDesc : "";
    string tips = "----- OnEditCycleConfResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(result, reasonDesc);
}

void demoCallbackProc::OnModifySubCycleConfResult(hwmsdk::HwmErrCode result, const char * reasonDesc)
{
    ostringstream retStream;
    retStream << result;
    string msgStr = reasonDesc != nullptr ? reasonDesc : "";
    string tips = "----- OnEditSubCycleConfResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(result, reasonDesc);
}

void demoCallbackProc::OnCancelCycleConfResult(hwmsdk::HwmErrCode result, const char * reasonDesc)
{
    ostringstream retStream;
    retStream << result;
    string msgStr = reasonDesc != nullptr ? reasonDesc : "";
    string tips = "----- OnCancelCycleConfResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(result, reasonDesc);
}

void demoCallbackProc::OnCancelSubCycleConfResult(hwmsdk::HwmErrCode result, const char * reasonDesc)
{
    ostringstream retStream;
    retStream << result;
    string msgStr = reasonDesc != nullptr ? reasonDesc : "";
    string tips = "----- OnCancelSubCycleConfResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(result, reasonDesc);
}

void demoCallbackProc::OnSetNetworkModeResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetNetworkModeResult= " + retStream.str() + ", msg= " + msgStr.c_str();
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSetRawDataExternalConfigResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetRawDataExternal = [" + retStream.str() + "], msg = [" + msgStr.c_str() + "]";
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnConfigSettingWindowResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnConfigSettingWindowResult = [" + retStream.str() + "], msg = [" + msgStr.c_str() + "]";
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnShowSettingWindowResult(hwmsdk::HwmErrCode ret, const char* reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnShowSettingWindowResult = [" + retStream.str() + "], msg = [" + msgStr.c_str() + "]";
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnGetMainWindowInfoResult(hwmsdk::HwmErrCode ret, const char* reason, const HwmMainWindowInfo* mainWindowInfo)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    if (mainWindowInfo != nullptr && ret == hwmsdk::HwmErrCode::HWM_COMMON_SUCCESS)
    {
        msgStr.append("x: ").append(to_string(mainWindowInfo->x));
        msgStr.append("; y: ").append(to_string(mainWindowInfo->y));
        msgStr.append("; width: ").append(to_string(mainWindowInfo->width));
        msgStr.append("; height: ").append(to_string(mainWindowInfo->height));
        msgStr.append("; hwnd: ").append(to_string((UINT64)(uintptr_t)(mainWindowInfo->handle)));
    }
    string tips = "----- OnGetMainWindowInfoResult = [" + retStream.str() + "], msg = [" + msgStr.c_str() + "]";
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}

void demoCallbackProc::OnSetAvatarStyleResult(hwmsdk::HwmErrCode ret, const char * reason)
{
    ostringstream retStream;
    retStream << ret;
    string msgStr = reason != nullptr ? reason : "";
    string tips = "----- OnSetAvatarStyleResult = [" + retStream.str() + "], msg = [" + msgStr.c_str() + "]";
    CTools::OutputRetStr(tips);

    CTools::ShowErrMsg(ret, reason);
}
