// demoConfInfoDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "demoConfInfoDlg.h"
#include "afxdialogex.h"
#include "resource.h"
#include "demoData.h"
#include "demoCustomMessage.h"
#include "demoTools.h"


// demoConfInfoDlg Ի

IMPLEMENT_DYNAMIC(demoConfInfoDlg, CDialogEx)

demoConfInfoDlg::demoConfInfoDlg(CWnd* pParent /*=NULL*/)
    : CDialogEx(IDD_CONF_INFO_DIALOG, pParent)
    , m_bTracking(false)
    , confInfo{0}
{

}

demoConfInfoDlg::~demoConfInfoDlg()
{
}


void demoConfInfoDlg::DoDataExchange(CDataExchange* pDX)
{
    DDX_Control(pDX, IDC_STATIC_CONF_INFO_SUBJECT, m_subject);
    DDX_Control(pDX, IDC_STATIC_CONF_INFO_ID, m_id);
    CDialogEx::DoDataExchange(pDX);
}

//OnCancelٴڵصOnCancel
void demoConfInfoDlg::OnCancel()
{
    DestroyWindow();
}

//ģ̬ԻʱҪͷָ
void demoConfInfoDlg::PostNcDestroy()
{
    CDialogEx::PostNcDestroy();
}

BOOL demoConfInfoDlg::OnInitDialog()
{
    const auto ret = CDialogEx::OnInitDialog();
    demoData::GetInstance().subscribeConfInfo(m_hWnd);
    confInfo = demoData::GetInstance().GetConfInfo();

    m_subject.SetWindowTextW(CTools::UTF2UNICODE(confInfo.subject).c_str());
    m_id.SetWindowTextW(CTools::UTF2UNICODE(confInfo.confId).c_str());
    return ret;
}


BEGIN_MESSAGE_MAP(demoConfInfoDlg, CDialogEx)
    ON_MESSAGE(WM_CONFINFO_UPDATE,&demoConfInfoDlg::OnConfInfo)

    ON_WM_MOUSEMOVE()
    ON_WM_MOUSELEAVE()
    ON_WM_MOUSEHOVER()
END_MESSAGE_MAP()


// demoConfInfoDlg Ϣ

void demoConfInfoDlg::OnMouseMove(UINT nFlags, CPoint point)
{
    // TODO: ڴϢ/Ĭֵ
    if (!m_bTracking)
    {
        TRACKMOUSEEVENT   t_MouseEvent;
        t_MouseEvent.cbSize = sizeof(TRACKMOUSEEVENT);
        t_MouseEvent.dwFlags = TME_HOVER | TME_LEAVE;
        t_MouseEvent.hwndTrack = m_hWnd;
        t_MouseEvent.dwHoverTime = 30;

        if (::_TrackMouseEvent(&t_MouseEvent))
        {
            m_bTracking = true;
        }
    }
    

    CDialogEx::OnMouseMove(nFlags, point);
}


void demoConfInfoDlg::OnMouseLeave()
{
    // TODO: ڴϢ/Ĭֵ

    m_bTracking = false;
    CDialogEx::OnMouseLeave();
    ::PostMessageW(::GetParent(m_hWnd), WM_DESTROY_EXTERNAL_CONF_INFO_WND, NULL, NULL);
}


void demoConfInfoDlg::OnMouseHover(UINT nFlags, CPoint point)
{
    // TODO: ڴϢ/Ĭֵ
    m_bTracking = false;
    CDialogEx::OnMouseHover(nFlags, point);
}

LRESULT demoConfInfoDlg::OnConfInfo(WPARAM wParam, LPARAM lParam)
{
    confInfo = demoData::GetInstance().GetConfInfo();
    m_subject.SetWindowTextW(CTools::UTF2UNICODE(confInfo.subject).c_str());
    m_id.SetWindowTextW(CTools::UTF2UNICODE(confInfo.confId).c_str());
    return 0;
}
