﻿// demoEditConfDlg.cpp: 实现文件
//

#include "stdafx.h"
#include "demo.h"
#include "demoEditConfDlg.h"
#include <HwmSdkAgent.h>
#include "afxdialogex.h"
#include "demoData.h"
#include "demoCustomMessage.h"
#include <algorithm>

#include "demoAddAttendeeDlg2.h"
#include "demoAddCycleConf.h"
#include "demoSubCycleConfList.h"
#include "demoTools.h"

// demoEditConfDlg 对话框

IMPLEMENT_DYNAMIC(demoEditConfDlg, CDialogEx)

demoEditConfDlg::demoEditConfDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_EDIT_CONF_DIALOG, pParent), confInfo{0}
    , m_isCycleConf(false), m_cycleConfParam{0}, m_isSubCycleConf(false)
    , m_customInfo(_T(""))
{

}

demoEditConfDlg::~demoEditConfDlg()
{
}

void demoEditConfDlg::setConfId(const std::string & newConfId, bool isCycleConf)
{
   confId = newConfId;
   m_isCycleConf = isCycleConf;
}

void demoEditConfDlg::setConfInfo(const std::string & newConfId, bool isSubCycleConf, std::string subConfID)
{
    confId = newConfId;
    m_isCycleConf = isSubCycleConf;
    m_isSubCycleConf = isSubCycleConf;
    m_subConfID = subConfID;
}


void demoEditConfDlg::OnBnClickedCancel()
{
    CDialogEx::OnCancel();
}

void demoEditConfDlg::OnBnClickedOk()
{
    CTime beginDate;
    m_confStartDateCtrl.GetTime(beginDate);
    CTime beginTime;
    m_confStartTimeCtrl.GetTime(beginTime);
    CTime confStart(beginDate.GetYear(), beginDate.GetMonth(), beginDate.GetDay(), beginTime.GetHour(), beginTime.GetMinute(), 0);
    const auto now = time(nullptr);
    if (now > confStart.GetTime())
    {
        AfxMessageBox(_T("conference start time earlier than now!"));
        return;
    }

    UpdateData(1);
    int ret = EditConf();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        AfxMessageBox(_T("Modify conf error"));
        return;
    }
    CDialogEx::OnOK();
}

void demoEditConfDlg::OnBnClickedAddAttendee()
{
    bool isAddSuc = m_addAttendeeLogic.AddAttendee();
    if (isAddSuc)
    {
        fillAttendees();
    }
}

void demoEditConfDlg::OnBnClickedDeleteAttendee()
{
    CString input;
    m_editDeleteAttendee.GetWindowText(input);
    bool isDeleteSuc = m_addAttendeeLogic.DeleteAttendee(input);
    if (isDeleteSuc)
    {
        fillAttendees();
    }
}

LRESULT demoEditConfDlg::OnConfDetail(WPARAM wparam, LPARAM lparam)
{
    confInfo = demoData::GetInstance().GetConfDetail();

    std::vector<hwmsdkagent::HwmAttendeeInfo>& attendees = m_addAttendeeLogic.GetAttendeeList();
    attendees.clear();
    attendees.insert(attendees.end(), confInfo.attendees, confInfo.attendees + confInfo.attendeeLen);
    confInfo.attendeeLen = 0;
    confInfo.attendees = nullptr;
    m_subCycleConf.clear();
    m_subCycleConf = demoData::GetInstance().GetSubCycleConfInfo();
    updateData();
    return 0;
}

void demoEditConfDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);

    DDX_Control(pDX, IDC_EDIT_BOOK_MEETING_WITH_MEMBERS_SUBJECT2, m_confSubjectEdit);
    DDX_Control(pDX, IDC_COMBO_BOOK_MEETING_WITH_MEMBERS_TYPE2, m_confTypeCombo);
    DDX_Control(pDX, IDC_EDIT_BOOK_MEETING_ATTENDEE_LIST2, m_attendeesEdit);
    DDX_Control(pDX, IDC_CHECK_BOOK_MEETING_WITH_MEMBERS_NEED_PASSWORD2, m_needPasswordCheck);
    DDX_Control(pDX, IDC_CHECK_BOOK_MEETING_WITH_MEMBERS_ALLOW_RECORD, m_allowRecordCheck);
    DDX_Control(pDX, IDC_CHECK_BOOK_MEETING_WITH_MEMBERS_IS_AUTORECORD, m_isAutoRecordCheck);
    DDX_Control(pDX, IDC_CHECK_EDIT_CONF_DEFAULT_SUMMARY_STATE, m_defaultSummaryState);
    DDX_Control(pDX, IDC_CHECK_EDIT_CONF_AUTO_PUBLISH_SUMMARY, m_autoPublishSummary);
    DDX_Control(pDX, IDC_DATE_BOOK_MEETING_START_TIME2, m_confStartDateCtrl);
    DDX_Control(pDX, IDC_TIME_BOOK_MEETING_START_TIME2, m_confStartTimeCtrl);
    DDX_Control(pDX, IDC_COMBO_BOOK_MEETING_TIME_ZONE2, m_timeZoneCtrl);
    DDX_Control(pDX, IDC_COMBO_BOOK_MEETING_DURATION_HOUR2, m_durationHourCtrl);
    DDX_Control(pDX, IDC_COMBO_BOOK_MEETING_DURATION_MINUTE2, m_durationMinuteCtrl);
    DDX_Control(pDX, IDC_COMBO_BOOK_CONF_CONF_ID_TYPE2, m_confIdTypeCtrl);
    DDX_Control(pDX, IDC_COMBO_BOOK_MEETING_ADMISSION2, m_confAdmissionCtrl);
    DDX_Control(pDX, IDC_CHECK_BOOK_MEETING_SEND_MESSAGE2, m_sendMsgCheck);
    DDX_Control(pDX, IDC_CHECK_BOOK_MEETING_SEND_EMAIL2, m_sendEmailCheck);
    DDX_Control(pDX, IDC_CHECK_BOOK_MEETING_MAIL_CALENDAR2, m_sendCalendarCheck);
    DDX_Control(pDX, IDC_CHECK_BOOK_WAITING_ROOM2, m_openWaitingRoomCheck);
    DDX_Control(pDX, IDC_EDIT_BOOK_MEETING_PASS2, m_confPassEdit);
    DDX_Control(pDX, IDC_EDIT_EDIT_CONF_CONF_ID, m_confIdEdit);
    DDX_Control(pDX, IDC_BUTTON_EDIT_CONF_ADD_ATTENDEE, m_btnAddAttendee);
    DDX_Control(pDX, IDC_BUTTON_EDIT_CONF_DELETE_ATTENDEE, m_btnDeleteAttendee);
    DDX_Control(pDX, IDC_EDIT_EDIT_CONF_DELETE_ATTENDEE, m_editDeleteAttendee);
    DDX_Control(pDX, IDC_BUTTON_EDIT_CYCLE_CONF, m_btneEditCycleConf);
    DDX_Control(pDX, IDC_BUTTON_SUB_CYCLE_CONF_LIST, m_btnSubCycleConfList);
    DDX_Control(pDX, IDC_COMBO_EDIT_MEETING_GUESTS_JOIN_TIME, m_allowGuestBeforeJoinTimeCtrl);
    DDX_Control(pDX, IDC_CHECK_FORBIDDEN_SCREEN_SHOTS1, m_forbiddenScreenShots);
    DDX_Control(pDX, IDC_ALLOW_GUESTS_BEFORE_JOIN_EDIT_MEETING, m_allowGuestbeforeJoinCheckBox);
    DDX_Control(pDX, IDC_EDIT_EDIT_MEETING_CONCURRENTPARTICIPANTS, m_conCurrentParticipantsEdit);
    DDX_Control(pDX, IDC_EDIT_TEXT_MEETING_CONCURRENTPARTICIPANTS, m_conCurrentParticipantsText);
    DDX_Control(pDX, IDC_COMBO_SOFT_AUTO_MUTE3, m_softTerminalAutoMuteCtrl);
    DDX_Control(pDX, IDC_COMBO_HARD_AUTO_MUTE3, m_hardTerminalAutoMuteCtrl);
    DDX_Control(pDX, IDC_CHECK_CONF_WATERMARK2, m_supportWatermark);
    DDX_Control(pDX, IDC_CHECK_EDIT_CONF_EXCLUDE_SELF, m_attendeesExcludeSelf);

    hwmsdkagent::GetVmrList();
    demoData::GetInstance().subscribeVmrList(m_hWnd);
    DDX_Text(pDX, IDC_EDIT1, m_customInfo);
    DDV_MaxChars(pDX, m_customInfo, 64);
    DDX_Control(pDX, IDC_EDIT1, m_editCustomInfo);
}

BOOL demoEditConfDlg::OnInitDialog()
{
    const auto ret = CDialogEx::OnInitDialog();
    m_confTypeCombo.InsertString(0, _T("Video"));
    m_confTypeCombo.InsertString(1, _T("Audio"));
    m_confTypeCombo.SetCurSel(0);
    m_confSubjectEdit.SetWindowText(_T("默认会议主题"));

    const auto &timeZoneList = demoData::GetInstance().GetTimeZoneList();
    for (int i = 0; i < timeZoneList.size(); i++)
    {
        m_timeZoneCtrl.InsertString(i, CTools::UTF2UNICODE(timeZoneList[i].first).c_str());
    }
    m_timeZoneCtrl.SetCurSel(55);

   for (int i = 0; i < 24; i ++)
    {
        CString item;
        item.Format(_T("%d小时"), i);
        m_durationHourCtrl.InsertString(i, item);
    }
    m_durationHourCtrl.SetCurSel(0);

    m_durationMinuteCtrl.InsertString(0, _T("0分钟"));
    m_durationMinuteCtrl.InsertString(1, _T("15分钟"));
    m_durationMinuteCtrl.InsertString(2, _T("30分钟"));
    m_durationMinuteCtrl.InsertString(3, _T("45分钟"));
    m_durationMinuteCtrl.SetCurSel(2);

    m_confAdmissionCtrl.InsertString(0, _T("所有用户"));
    m_confAdmissionCtrl.InsertString(1, _T("企业内部"));
    m_confAdmissionCtrl.InsertString(2, _T("仅被邀请的人"));
    m_confAdmissionCtrl.SetCurSel(0);

    // 编辑会议此处不可选，使用会议详情信息，具体值参考预约会议
    m_confIdTypeCtrl.InsertString(0, _T("随机会议id"));
    m_confIdTypeCtrl.SetCurSel(0);

    m_conCurrentParticipantsEdit.SetWindowText(_T("0"));

    m_allowGuestbeforeJoinCheckBox.SetCheck(1);
    m_allowGuestBeforeJoinTimeCtrl.InsertString(0, _T("任何时间"));
    m_allowGuestBeforeJoinTimeCtrl.InsertString(1, _T("5分钟"));
    m_allowGuestBeforeJoinTimeCtrl.InsertString(2, _T("10分钟"));
    m_allowGuestBeforeJoinTimeCtrl.InsertString(3, _T("15分钟"));
    m_allowGuestBeforeJoinTimeCtrl.InsertString(4, _T("30分钟"));
    m_allowGuestBeforeJoinTimeCtrl.SetCurSel(0);

    m_softTerminalAutoMuteCtrl.InsertString(0, _T("Default"));
    m_softTerminalAutoMuteCtrl.InsertString(1, _T("Mute"));
    m_softTerminalAutoMuteCtrl.InsertString(2, _T("UnMute"));
    m_softTerminalAutoMuteCtrl.SetCurSel(0);
    m_hardTerminalAutoMuteCtrl.InsertString(0, _T("Default"));
    m_hardTerminalAutoMuteCtrl.InsertString(1, _T("Mute"));
    m_hardTerminalAutoMuteCtrl.InsertString(2, _T("UnMute"));
    m_hardTerminalAutoMuteCtrl.SetCurSel(0);

    if (!demoData::GetInstance().HasRecordPermission())
    {
	    m_allowRecordCheck.EnableWindow(0);
        m_isAutoRecordCheck.EnableWindow(0);
    }
    if (!demoData::GetInstance().GetCorpEnableSummary())
    {
        m_defaultSummaryState.EnableWindow(0);
        m_autoPublishSummary.EnableWindow(0);
    }
    if (!demoData::GetInstance().IsSmsEnable())
    {
        m_sendMsgCheck.EnableWindow(0);
    }

    initData();

    if(!confId.empty())
    {
        char confIdParam[HWM_MAX_CONF_ID_LEN];
        errno_t err = strcpy_s(confIdParam, HWM_MAX_CONF_ID_LEN, confId.c_str());
        if (err != S_OK)
        {
            AfxMessageBox(_T("String Copy Error!"));
        }
        hwmsdkagent::GetConfDetail(confIdParam);
        demoData::GetInstance().subscribeConfDetail(m_hWnd);
    }

    return ret;
}

int demoEditConfDlg::EditConf()
{
    hwmsdkagent::HwmEditConfParam editConfParam{0};
    errno_t err = strcpy_s(editConfParam.confId, sizeof(editConfParam.confId), confId.c_str());
    editConfParam.vmrFlag = confInfo.vmrFlag;
    err += strcpy_s(editConfParam.vmrId, sizeof(editConfParam.vmrId), confInfo.vmrId);
    editConfParam.isEmailCalendarOn = confInfo.isEmailCalenderOn;
    editConfParam.isMailOn = confInfo.isMailOn;
    editConfParam.isSmsOn = confInfo.isSmsOn;
    editConfParam.isLiveOn = confInfo.isLiveOn;
    editConfParam.isNeedConfPwd = !confInfo.isGuestFreePwd;
    editConfParam.timeZone = m_timeZoneCtrl.GetCurSel() + 1;
    // vmrConferenceId有值是固定ID,为空则是随机id
    editConfParam.vmrConfIdType = (strlen(confInfo.confListInfo.vmrConferenceId) != 0) ?
        hwmsdkagent::HwmVmrConfIdType::HWM_VMR_CONF_ID_TYPE_FIXED : hwmsdkagent::HwmVmrConfIdType::HWM_VMR_CONF_ID_TYPE_RANDOM;

    CString tempCString;
    m_confSubjectEdit.GetWindowText(tempCString);
    const auto meetingSubjectStr = CTools::UNICODE2UTF(tempCString.GetString());
    err += strcpy_s(editConfParam.subject, HWM_MAX_SUBJECT_LEN, meetingSubjectStr.c_str());
    if (err != S_OK)
    {
        AfxMessageBox(_T("String Copy Error!"));
    }
    const int confType = m_confTypeCombo.GetCurSel();
    editConfParam.confType = hwmsdkagent::HWM_VIDEO_AND_DATA;
    if (confType == 1)
    {
        editConfParam.confType = hwmsdkagent::HWM_AUDIO_AND_DATA;
    }

    editConfParam.isAutoRecordOn = m_isAutoRecordCheck.GetCheck() == 1;
    editConfParam.defaultSummaryState = m_defaultSummaryState.GetCheck() == 1 ? hwmsdkagent::SUMMARY_STATE_OPEN : hwmsdkagent::SUMMARY_STATE_CLOSE;
    editConfParam.autoPublishSummary = m_autoPublishSummary.GetCheck() == 1 ? true : false;
    editConfParam.isRecordOn = m_allowRecordCheck.GetCheck() == 1;
    editConfParam.isOpenWaitingRoom = m_openWaitingRoomCheck.GetCheck() == 1;
    editConfParam.autoMuteMode = static_cast<hwmsdkagent::HwmAutoMuteType>(m_softTerminalAutoMuteCtrl.GetCurSel());
    editConfParam.hardTerminalAutoMuteMode = static_cast<hwmsdkagent::HwmAutoMuteType>(m_hardTerminalAutoMuteCtrl.GetCurSel());
    editConfParam.supportWatermark = m_supportWatermark.GetCheck() == 1 ? true : false;
    editConfParam.attendeesExcludeSelf = m_attendeesExcludeSelf.GetCheck() == 1 ? true : false;

    CString conCurrentParticipants;
    m_conCurrentParticipantsEdit.GetWindowText(conCurrentParticipants);
    editConfParam.concurrentParticipants = _ttoi(conCurrentParticipants);

    CTime beginDate;
    m_confStartDateCtrl.GetTime(beginDate);
    CTime beginTime;
    m_confStartTimeCtrl.GetTime(beginTime);
    CTime confStart(beginDate.GetYear(), beginDate.GetMonth(), beginDate.GetDay(), beginTime.GetHour(), beginTime.GetMinute(), 0);

    editConfParam.startTimeStamp = confStart.GetTime();

    if (confInfo.confListInfo.conferenceType == hwmsdkagent::CONF_TYPE_CYCLE)
    {
        m_cycleConfParam.startTimeStamp = editConfParam.startTimeStamp;
    }
    int hour = m_durationHourCtrl.GetCurSel();
    int minute = m_durationMinuteCtrl.GetCurSel() * 15;
    editConfParam.duration = hour * 60 + minute;
    // combobox框内不显示匿名入会用户限制
    if (m_confAdmissionCtrl.GetCurSel() == 0)
    {
        editConfParam.joinConfRestrictionType = static_cast<hwmsdkagent::HwmJoinConfPermissionType>(m_confAdmissionCtrl.GetCurSel());
    }
    else
    {
        editConfParam.joinConfRestrictionType = static_cast<hwmsdkagent::HwmJoinConfPermissionType>(m_confAdmissionCtrl.GetCurSel() + 1);
    }

    editConfParam.allowGuestStartConf = m_allowGuestbeforeJoinCheckBox.GetCheck() == 1;
    editConfParam.forbiddenScreenShots = m_forbiddenScreenShots.GetCheck() == 1;
    ChangeVmrInfo(editConfParam.vmrFlag, editConfParam.vmrId);

    switch (m_allowGuestBeforeJoinTimeCtrl.GetCurSel())
    {
    case 0:
    case 1:
    case 2:
    case 3:
        {
            editConfParam.allowGuestStartConfTime = m_allowGuestBeforeJoinTimeCtrl.GetCurSel() * 5;
        }
        break;
    case 4:
        {
            editConfParam.allowGuestStartConfTime = 30;
        }
        break;
    default:
        editConfParam.allowGuestStartConfTime = 0;
    }

    std::vector<hwmsdkagent::HwmAttendeeInfo>& attendees = m_addAttendeeLogic.GetAttendeeList();
    if (!attendees.empty())
    {
        editConfParam.attendees = attendees.data();
        editConfParam.attendeeLen = attendees.size();
    }

    if (!m_customInfo.IsEmpty())
    {
        auto customInfo = CTools::UNICODE2UTF(m_customInfo.GetString());
        if (customInfo.length() >= HWM_MAX_CUSTOM_INFO_LEN)
        {
            AfxMessageBox(_T("content too long: not more than 64 byte in utf-8 encoding."));
            return -1;
        }
        errno_t err = strcpy_s(editConfParam.customInfo, HWM_MAX_CUSTOM_INFO_LEN, customInfo.c_str());
        if (err != 0)
        {
            AfxMessageBox(_T("String Copy Error!"));
        }
    }

    if(confInfo.confListInfo.conferenceType == hwmsdkagent::CONF_TYPE_CYCLE)
    {
        if(m_isSubCycleConf)
        {
            hwmsdkagent::HwmModifySubCycleConfParam SubCycleConfParam{};
            err = strcpy_s(SubCycleConfParam.confId, sizeof(SubCycleConfParam.confId), confId.c_str());
            err += strcpy_s(SubCycleConfParam.subConfID, sizeof(SubCycleConfParam.subConfID), m_subConfID.c_str());
            if (err != S_OK)
            {
                AfxMessageBox(_T("String Copy Error!"));
            }
            SubCycleConfParam.confMediaType = editConfParam.confType;
            SubCycleConfParam.startTimeStamp = editConfParam.startTimeStamp;
            SubCycleConfParam.confLen = editConfParam.duration;
            SubCycleConfParam.isAutoRecord = editConfParam.isAutoRecordOn;
            SubCycleConfParam.callInRestriction = editConfParam.joinConfRestrictionType;
            SubCycleConfParam.allowGuestStartConf = editConfParam.allowGuestStartConf;
            SubCycleConfParam.allowGuestStartConfTime = editConfParam.allowGuestStartConfTime;
            return hwmsdkagent::ModifySubCycleConf(&SubCycleConfParam);
        }

        hwmsdkagent::HwmModifyCycleConfParam editCycleConfParam{};
        editCycleConfParam.editConfParam = editConfParam;
        editCycleConfParam.cycleParam = m_cycleConfParam;
        return hwmsdkagent::ModifyCycleConf(&editCycleConfParam);
    }

    return hwmsdkagent::EditConf(&editConfParam);
}

void demoEditConfDlg::initData()
{
    const auto confList = demoData::GetInstance().GetConfList();
    const auto it = std::find_if(confList.begin(), confList.end(), [this](const auto &item) { return item.confId == confId;});

    m_confIdEdit.SetWindowTextW(CTools::UTF2UNICODE(confId).c_str());
    if (it != confList.end())
    {
        confInfo.confListInfo = *it;
        updateData();
    }
}

void demoEditConfDlg::updateData()
{
    const auto basicInfo = confInfo.confListInfo;
    m_confSubjectEdit.SetWindowTextW(CTools::UTF2UNICODE(basicInfo.confSubject).c_str());
    m_conCurrentParticipantsEdit.SetWindowTextW(CTools::UTF2UNICODE(CTools::num2str(confInfo.concurrentParticipants)).c_str());
    m_confTypeCombo.SetCurSel(0);
    if (basicInfo.mediaType == hwmsdkagent::HWM_MEDIA_TYPE_AUDIO)
    {
        m_confTypeCombo.SetCurSel(1);
    }
    m_needPasswordCheck.SetCheck(confInfo.isGuestFreePwd ? 0 : 1);
    m_allowRecordCheck.SetCheck(confInfo.isRecordOn ? 1 : 0);
    m_isAutoRecordCheck.SetCheck(confInfo.isAutoRecord);
    m_defaultSummaryState.SetCheck(confInfo.defaultSummaryState);
    m_autoPublishSummary.SetCheck(confInfo.autoPublishSummary);
    m_openWaitingRoomCheck.SetCheck(confInfo.isOpenWaitingRoom);
    // combobox框内不显示匿名入会用户限制
    if (confInfo.joinConfRestrictionType == hwmsdkagent::RESTRICTION_CALL_IN_ALL)
    {
        m_confAdmissionCtrl.SetCurSel(confInfo.joinConfRestrictionType);
    }
    else
    {
        m_confAdmissionCtrl.SetCurSel(confInfo.joinConfRestrictionType - 1);
    }

    CTime startTimeStamp = basicInfo.startTimeStamp;
    m_confStartDateCtrl.SetTime(&startTimeStamp);
    m_confStartTimeCtrl.SetTime(&startTimeStamp);
    CTime endTimeStamp = basicInfo.endTimeStamp;
    auto duration = endTimeStamp - startTimeStamp;
    if (confInfo.confListInfo.conferenceType == hwmsdkagent::CONF_TYPE_CYCLE)
    {
        if(m_isSubCycleConf)
        {
            for (auto i : m_subCycleConf)
            {
                if (m_subConfID == std::string(i.subConfID))
                {
                    CTime startTimeStamp = i.startTimeStamp;
                    m_confStartDateCtrl.SetTime(&startTimeStamp);
                    m_confStartTimeCtrl.SetTime(&startTimeStamp);
                    CTime endTimeStamp = i.endTimeStamp;
                    duration = endTimeStamp - startTimeStamp;

                    m_confTypeCombo.SetCurSel(i.confMediaType == hwmsdkagent::HWM_MEDIA_TYPE_AUDIO ? 1 : 0);
                    m_confAdmissionCtrl.SetCurSel(i.callInRestriction == 0 ? 0 : (i.callInRestriction -1));
                    m_isAutoRecordCheck.SetCheck(i.isAutoRecord);
                    break;
                }
            }
        }
    }

    int hour = duration.GetHours();
    if (hour > 23 || hour < 0)
    {
        hour = 0;
    }
    m_durationHourCtrl.SetCurSel(hour);
    int minute = 0;
    switch (duration.GetMinutes())
    {
    case 0: minute = 0; break;
    case 15: minute = 1; break;
    case 30: minute = 2; break;
    case 45: minute = 3; break;
    }
    m_durationMinuteCtrl.SetCurSel(minute);
    
    int timeZone = 56;
    char * pctr = nullptr;
    timeZone = strtod(basicInfo.timeZone, &pctr);
    if (pctr == basicInfo.timeZone)
    {
        timeZone = 56;
    }
    m_timeZoneCtrl.SetCurSel(timeZone - 1);

    m_sendMsgCheck.SetCheck(confInfo.isSmsOn);
    m_sendEmailCheck.SetCheck(confInfo.isMailOn);
    m_sendCalendarCheck.SetCheck(confInfo.isEmailCalenderOn);
    m_openWaitingRoomCheck.SetCheck(confInfo.isOpenWaitingRoom);
    m_softTerminalAutoMuteCtrl.SetCurSel(confInfo.autoMuteMode);
    m_hardTerminalAutoMuteCtrl.SetCurSel(confInfo.hardTerminalAutoMuteMode);

    bool isShowBtn = (confInfo.confListInfo.conferenceType == hwmsdkagent::CONF_TYPE_CYCLE) && !m_isSubCycleConf;
    m_btneEditCycleConf.EnableWindow(isShowBtn);
    m_btnSubCycleConfList.EnableWindow(isShowBtn);
    m_conCurrentParticipantsEdit.ShowWindow(!m_isSubCycleConf);
    m_conCurrentParticipantsText.ShowWindow(!m_isSubCycleConf);
    m_softTerminalAutoMuteCtrl.EnableWindow(!m_isSubCycleConf);
    m_hardTerminalAutoMuteCtrl.EnableWindow(!m_isSubCycleConf);
    m_openWaitingRoomCheck.EnableWindow(!m_isSubCycleConf);
    m_defaultSummaryState.EnableWindow(confInfo.confListInfo.conferenceType == hwmsdkagent::CONF_TYPE_COMMON);
    m_autoPublishSummary.EnableWindow(confInfo.confListInfo.conferenceType == hwmsdkagent::CONF_TYPE_COMMON);
    m_btnAddAttendee.EnableWindow(!m_isSubCycleConf);
    m_btnDeleteAttendee.EnableWindow(!m_isSubCycleConf);
    m_confSubjectEdit.EnableWindow(isShowBtn || (confInfo.confListInfo.conferenceType == hwmsdkagent::CONF_TYPE_COMMON));
    m_editCustomInfo.EnableWindow(!m_isSubCycleConf);
    m_customInfo = CTools::UTF2UNICODE(confInfo.confListInfo.customInfo).c_str();
    m_allowGuestBeforeJoinTimeCtrl.EnableWindow(!confInfo.vmrFlag);
    m_allowGuestbeforeJoinCheckBox.SetCheck(confInfo.allowGuestStartConf);
    m_forbiddenScreenShots.SetCheck(confInfo.forbiddenScreenShots);
    m_supportWatermark.SetCheck(confInfo.supportWatermark);

    switch (confInfo.allowGuestStartConfTime)
    {
    case 0:
    case 5:
    case 10:
    case 15:
        {
            m_allowGuestBeforeJoinTimeCtrl.SetCurSel(confInfo.allowGuestStartConfTime / 5);
        }
        break;
    case 30:
        {
            m_allowGuestBeforeJoinTimeCtrl.SetCurSel(4);
        }
        break;
    default:
            m_allowGuestBeforeJoinTimeCtrl.SetCurSel(0);

    }
    
    // 还原与会者列表
    fillAttendees();

    // 周期会议参数赋值
    m_cycleConfParam = confInfo.confListInfo.cycleParam;
    UpdateData(0);
}

void demoEditConfDlg::fillAttendees()
{
    std::string attendeeStr = m_addAttendeeLogic.GetAttendeeStr();
    if (attendeeStr.empty())
    {
        attendeeStr.assign("Please add at least one attendee. The first one added will be the chariman of the conf. So add yourself first");
    }
    m_attendeesEdit.SetWindowTextW(CTools::UTF2UNICODE(attendeeStr).c_str());
}

void demoEditConfDlg::ChangeVmrInfo(bool isVmrConf, const std::string& vmrId)
{
    if (isVmrConf && !vmrId.empty() && !demoData::GetInstance().GetVmrList().empty())
    {
        for (auto &vmrInfo : demoData::GetInstance().GetVmrList())
        {
            if (std::string(vmrInfo.vmrId) == vmrId)
            {
                vmrInfo.allowGuestStartConf = m_allowGuestbeforeJoinCheckBox.GetCheck() == 1;
                hwmsdkagent::ChangeVmrInfoParam info{};
                errno_t err = strcpy_s(info.vmrId, sizeof info.vmrId, vmrInfo.vmrId);
                err += strcpy_s(info.chairPwd, sizeof info.chairPwd, vmrInfo.chairmanPwd);
                err += strcpy_s(info.guestPwd, sizeof info.guestPwd, vmrInfo.guestPwd);
                err += strcpy_s(info.vmrName, sizeof info.vmrName, vmrInfo.name);

                if (err != S_OK)
                {
                    AfxMessageBox(_T("String Copy Error!"));
                }
                info.allowGuestStartConf = m_allowGuestbeforeJoinCheckBox.GetCheck() == 1;
                // 这两个值不需要改变
                info.joinConfRestrictionType = vmrInfo.joinConfRestrictionType;
                info.isOpenWaitingRoom = vmrInfo.isOpenWaitingRoom;
                hwmsdkagent::ChangeVmrInfo(&info);
            }
        }
    }
}

BEGIN_MESSAGE_MAP(demoEditConfDlg, CDialogEx)
    ON_MESSAGE(WM_CONFDETAIL_UPDATE, &demoEditConfDlg::OnConfDetail)

    ON_BN_CLICKED(IDC_BUTTON_EDIT_CONF_OK, &demoEditConfDlg::OnBnClickedOk)
    ON_BN_CLICKED(IDC_BUTTON_EDIT_CONF_CANCEL, &demoEditConfDlg::OnBnClickedCancel)
    ON_BN_CLICKED(IDC_BUTTON_EDIT_CONF_ADD_ATTENDEE, &demoEditConfDlg::OnBnClickedAddAttendee)
    ON_BN_CLICKED(IDC_BUTTON_EDIT_CONF_DELETE_ATTENDEE, &demoEditConfDlg::OnBnClickedDeleteAttendee)
    ON_BN_CLICKED(IDC_BUTTON_EDIT_CYCLE_CONF, &demoEditConfDlg::OnBnClickedCycleConf)
    ON_BN_CLICKED(IDC_BUTTON_SUB_CYCLE_CONF_LIST, &demoEditConfDlg::OnBnClickedSubCycleConf)
END_MESSAGE_MAP()


// demoEditConfDlg 消息处理程序


void demoEditConfDlg::OnBnClickedCycleConf()
{
    // TODO: 在此添加控件通知处理程序代码

    demoAddCycleConf dlg;
    dlg.SetIsEditCycleConf(true);
    const auto ret = dlg.DoModal();
    if (ret == IDOK)
    {
        m_cycleConfParam = dlg.GetCycleConfParam();
    }
}


void demoEditConfDlg::OnBnClickedSubCycleConf()
{
    // TODO: 在此添加控件通知处理程序代码
    demoSubCycleConfList dlg;
    dlg.SetConfInfo(confInfo, m_subCycleConf);
    const auto ret = dlg.DoModal();

    CDialogEx::OnCancel();
}
