﻿#pragma once
#include <HwmAgentCallback.h>
#include <vector>
#include "AddAttendeeLogic.h"
#include "demoAddAttendeeDlg2.h"

// demoEditConfDlg 对话框

class demoEditConfDlg : public CDialogEx
{
	DECLARE_DYNAMIC(demoEditConfDlg)

public:
	demoEditConfDlg(CWnd* pParent = nullptr);   // 标准构造函数
	virtual ~demoEditConfDlg();

// 对话框数据
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_EDIT_CONF_DIALOG };
#endif

    void setConfId(const std::string &newConfId, bool isCycleConf = false);
    void setConfInfo(const std::string &newConfId, bool isSubCycleConf ,std::string subConfID);

    afx_msg void OnBnClickedCancel();
    afx_msg void OnBnClickedOk();
    afx_msg void OnBnClickedAddAttendee();
    afx_msg void OnBnClickedDeleteAttendee();
    afx_msg LRESULT OnConfDetail(WPARAM wparam, LPARAM lparam);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 支持
    virtual BOOL OnInitDialog();

	DECLARE_MESSAGE_MAP()

    int EditConf();
    void initData();
    void updateData();
    void fillAttendees();
    void ChangeVmrInfo(bool isVmrConf, const std::string& vmrId);
    
protected:
    CEdit m_confSubjectEdit;
    CComboBox m_confTypeCombo;
    CButton m_needPasswordCheck;
    CButton m_allowRecordCheck;
    CButton m_isAutoRecordCheck;  // 是否自动录制会议checkBox
    CButton m_defaultSummaryState; // 会议云录制是否包含纪要，初始值
    CButton m_autoPublishSummary; // 是否自动发布纪要
    CDateTimeCtrl m_confStartDateCtrl;
    CDateTimeCtrl m_confStartTimeCtrl;
    CComboBox m_timeZoneCtrl;
    CComboBox m_durationHourCtrl;
    CComboBox m_durationMinuteCtrl;
    CComboBox m_confIdTypeCtrl;
    CComboBox m_vmrConfIdTypeCtrl;  // 云会议室的会议Id类型
    CComboBox m_confAdmissionCtrl;
    CButton m_sendMsgCheck;
    CButton m_sendEmailCheck;
    CButton m_sendCalendarCheck;
    CButton m_openWaitingRoomCheck; // 是否开启等候室
    CEdit m_attendeesEdit;
    CEdit m_confPassEdit;

    CEdit m_confIdEdit;
    CButton m_btnAddAttendee;
    CButton m_btnDeleteAttendee;
    CEdit m_editDeleteAttendee;
    CButton m_btneEditCycleConf;
    CButton m_btnSubCycleConfList;
    CComboBox m_allowGuestBeforeJoinTimeCtrl;
    CButton m_allowGuestbeforeJoinCheckBox;
    CButton m_forbiddenScreenShots; // 是否禁止截屏
    CEdit m_editCustomInfo;
    CComboBox m_softTerminalAutoMuteCtrl;
    CComboBox m_hardTerminalAutoMuteCtrl;
    CButton m_supportWatermark;
    CButton m_attendeesExcludeSelf;
private:
    std::string confId;
    hwmsdkagent::HwmConfDetail confInfo;
    bool m_isCycleConf;
    hwmsdkagent::HwmCycleConfParam m_cycleConfParam;
    std::vector<hwmsdkagent::HwmSubCycleConfParam> m_subCycleConf;
    bool m_isSubCycleConf;
    std::string m_subConfID;
    CString m_customInfo;
    CEdit m_conCurrentParticipantsEdit;
    CStatic m_conCurrentParticipantsText;

    AddAttendeeLogic<hwmsdkagent::HwmAttendeeInfo, demoAddAttendeeDlg2> m_addAttendeeLogic;
public:
    afx_msg void OnBnClickedCycleConf();
    afx_msg void OnBnClickedSubCycleConf();
};
