// demoStartShareDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "demo.h"
#include "demoStartShareDlg.h"
#include "afxdialogex.h"
#include "demoTools.h"
#include "HwmSdkAgent.h"

// demotartShareDlg Ի

IMPLEMENT_DYNAMIC(demoStartShareDlg, CDialogEx)

demoStartShareDlg::demoStartShareDlg(CWnd* pParent /*=NULL*/)
    : CDialogEx(IDD_START_SHARE_DIALOG, pParent)
{

}

demoStartShareDlg::~demoStartShareDlg()
{
}

void demoStartShareDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_SHARE_HWND, m_shareHwndEdit);
    DDX_Control(pDX, IDC_COMBO_IS_PRIMARY_MONITOR, m_isPrimaryMonitorCombo);
    DDX_Control(pDX, IDC_COMBO_SHARE_TYPE, m_shareTypeCombo);
    DDX_Control(pDX, IDC_COMBO_SET_UICONTROL_MONITOR, m_setUIControlMonitor);

    DDX_Control(pDX, IDC_COMBO_MONITOR_MODE, m_setMonitorMode);
    DDX_Control(pDX, IDC_EDIT_MONITOR_INDEX, m_setMonitorIndex);
    DDX_Control(pDX, IDC_COMBO_UI_MONITOR_MODE, m_setUIMonitorMode);
    DDX_Control(pDX, IDC_EDIT_UI_MONITOR_INDEX, m_setUIMonitorIndex);
}

BOOL demoStartShareDlg::OnInitDialog()
{
    CDialog::OnInitDialog();

    m_shareHwndEdit.SetWindowText(_T("0"));

    m_isPrimaryMonitorCombo.InsertString(0, _T("Yes"));
    m_isPrimaryMonitorCombo.InsertString(1, _T("No"));
    m_isPrimaryMonitorCombo.SetWindowText(_T("Yes"));

    m_shareTypeCombo.InsertString(0, _T("Monitor"));
    m_shareTypeCombo.InsertString(1, _T("App"));
    m_shareTypeCombo.InsertString(2, _T("WhiteBoard"));
    m_shareTypeCombo.InsertString(3, _T("All"));
    m_shareTypeCombo.SetWindowText(_T("Monitor"));

    m_setUIControlMonitor.InsertString(0, _T("Default"));
    m_setUIControlMonitor.InsertString(1, _T("ForcePrimaryMonitor"));
    m_setUIControlMonitor.InsertString(2, _T("ForceSecondaryMonitor"));
    m_setUIControlMonitor.SetWindowText(_T("Default"));

    m_setMonitorMode.InsertString(0, _T("PRIMARY_SECONDARY"));
    m_setMonitorMode.InsertString(1, _T("MULTI_MONITOR"));
    m_setMonitorMode.SetWindowText(_T("PRIMARY_SECONDARY"));

    m_setMonitorIndex.SetWindowText(_T("0"));

    m_setUIMonitorMode.InsertString(0, _T("PRIMARY_SECONDARY"));
    m_setUIMonitorMode.InsertString(1, _T("MULTI_MONITOR"));
    m_setUIMonitorMode.SetWindowText(_T("PRIMARY_SECONDARY"));

    m_setUIMonitorIndex.SetWindowText(_T("0"));

    return TRUE;
}

BEGIN_MESSAGE_MAP(demoStartShareDlg, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoStartShareDlg::OnBnClickedOk)
    ON_BN_CLICKED(IDCANCEL, &demoStartShareDlg::OnBnClickedCancel)
END_MESSAGE_MAP()


int demoStartShareDlg::clickStartShare()
{
    hwmsdkagent::HwmStartShareInfo data;
    memset(&data, 0, sizeof(hwmsdkagent::HwmStartShareInfo));
    
    //ù
    CString strShareType;
    m_shareTypeCombo.GetWindowText(strShareType);
    if(_T("Monitor") == strShareType)
    {
        data.shareType = hwmsdkagent::HwmShareType::HWM_SHARE_TYPE_MONITOR;
    }
    else if(_T("App") == strShareType)
    {
        data.shareType = hwmsdkagent::HwmShareType::HWM_SHARE_TYPE_APP;
    }
    else if (_T("WhiteBoard") == strShareType)
    {
        data.shareType = hwmsdkagent::HwmShareType::HWM_SHARE_TYPE_WHITE_BOARD;
    }
    else if (_T("All") == strShareType)
    {
        data.shareType = hwmsdkagent::HwmShareType::HWM_SHARE_TYPE_ALL;
    }

    //ôھ
    CString strShareHwnd;
    m_shareHwndEdit.GetWindowText(strShareHwnd);
    string shareHwnd = CTools::UNICODE2UTF(strShareHwnd.GetString());
    data.appShareInfo.appHandle = CTools::str2hwnd(shareHwnd);
    
    //ùĻģʽ
    CString strShareMonitorMode;
    m_setMonitorMode.GetWindowText(strShareMonitorMode);
    if (_T("PRIMARY_SECONDARY") == strShareMonitorMode)
    {
        data.monitorShareInfo.monitorMode = hwmsdkagent::HWM_MONITOR_MODE_PRIMARY_SECONDARY;
    }
    else if (_T("MULTI_MONITOR") == strShareMonitorMode)
    {
        data.monitorShareInfo.monitorMode = hwmsdkagent::HWM_MONITOR_MODE_MULTI_MONITOR;
    }

    //Ƿ
    CString strIsPrimaryMonitor;
    m_isPrimaryMonitorCombo.GetWindowText(strIsPrimaryMonitor);
    if (_T("Yes") == strIsPrimaryMonitor)
    {
        data.monitorShareInfo.monitor = hwmsdkagent::HWM_MONITOR_MAIN;
    }
    else if (_T("No") == strIsPrimaryMonitor)
    {
        data.monitorShareInfo.monitor = hwmsdkagent::HWM_MONITOR_SECONDARY;
    }

    //Ļ
    CString strShareMonitorIndex;
    m_setMonitorIndex.GetWindowText(strShareMonitorIndex);
    string shareMonitorIndex = CTools::UNICODE2UTF(strShareMonitorIndex.GetString());
    data.monitorShareInfo.monitorIndex = CTools::str2num(shareMonitorIndex);


    //ÿɲUIĻ̶ģʽ
    CString strUIMonitorMode;
    m_setUIMonitorMode.GetWindowText(strUIMonitorMode);
    if (_T("PRIMARY_SECONDARY") == strUIMonitorMode)
    {
        data.operatableUiMonitor.monitorMode = hwmsdkagent::HWM_MONITOR_MODE_PRIMARY_SECONDARY;
    }
    else if (_T("MULTI_MONITOR") == strUIMonitorMode)
    {
        data.operatableUiMonitor.monitorMode = hwmsdkagent::HWM_MONITOR_MODE_MULTI_MONITOR;
    }

    //ÿɲUIǷ̶ָĻ
    CString strSetUIControlMonitor;
    m_setUIControlMonitor.GetWindowText(strSetUIControlMonitor);
    if (_T("Default") == strSetUIControlMonitor)
    {
        data.operatableUiMonitor.monitor = hwmsdkagent::HWM_MONITOR_BUTT;
    }
    else if (_T("ForcePrimaryMonitor") == strSetUIControlMonitor)
    {
        data.operatableUiMonitor.monitor = hwmsdkagent::HWM_MONITOR_MAIN;
    }
    else if (_T("ForceSecondaryMonitor") == strSetUIControlMonitor)
    {
        data.operatableUiMonitor.monitor = hwmsdkagent::HWM_MONITOR_SECONDARY;
    }

    //ÿɲUIĻ̶
    CString strUIMonitorIndex;
    m_setUIMonitorIndex.GetWindowText(strUIMonitorIndex);
    string uiMonitorIndex = CTools::UNICODE2UTF(strUIMonitorIndex.GetString());
    data.operatableUiMonitor.monitorIndex = CTools::str2num(uiMonitorIndex);

    int ret = hwmsdkagent::StartShare(&data);
    return ret;
}

void demoStartShareDlg::OnBnClickedOk()
{
    int ret = clickStartShare();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        AfxMessageBox(_T("Start Share error"));
        return;
    }
    CDialogEx::OnOK();
}


void demoStartShareDlg::OnBnClickedCancel()
{
    // TODO: ڴӿؼ֪ͨ
    CDialogEx::OnCancel();
}

