// demoWaterMarkInfoDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "demo.h"
#include "demoWaterMarkInfoDlg.h"
#include "afxdialogex.h"
#include "HwmSdkAgent.h"
#include "demoTools.h"


// demoWaterMarkInfoDlg Ի

IMPLEMENT_DYNAMIC(demoWaterMarkInfoDlg, CDialogEx)

demoWaterMarkInfoDlg::demoWaterMarkInfoDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_SET_WATERMARKINFO_DIALOG, pParent)
{

}

demoWaterMarkInfoDlg::~demoWaterMarkInfoDlg()
{
}

BOOL demoWaterMarkInfoDlg::OnInitDialog()
{
    CDialogEx::OnInitDialog();
    m_comboboxColor.InsertString(0, _T("HWM_WATERMARK_COLOR_TYPE_LIGHT"));
    m_comboboxColor.InsertString(1, _T("HWM_WATERMARK_COLOR_TYPE_STANDARD"));
    m_comboboxColor.InsertString(2, _T("HWM_WATERMARK_COLOR_TYPE_DARKER"));
    m_comboboxColor.SetCurSel(0);
    return 0;
}

void demoWaterMarkInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_INJECT_CONTENT, m_editInjectContent);
    DDX_Control(pDX, IDC_COMBO_COLOR, m_comboboxColor);
}


BEGIN_MESSAGE_MAP(demoWaterMarkInfoDlg, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoWaterMarkInfoDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// demoWaterMarkInfoDlg Ϣ



void demoWaterMarkInfoDlg::OnBnClickedOk()
{
    // TODO: ڴӿؼ֪ͨ
    int ret = SetWaterMarkInjectInfo();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret) {
        AfxMessageBox(_T("Set WaterMark InjectInfo error"));
    }
    else
    {
        CDialogEx::OnOK();
    }
}

int demoWaterMarkInfoDlg::SetWaterMarkInjectInfo()
{
    hwmsdkagent::HwmWaterMarkInfo injectInfo = {0};

    CString contentCStr;
    m_editInjectContent.GetWindowText(contentCStr);
    std::string content = CTools::UNICODE2UTF(contentCStr.GetString());
    errno_t err = strcpy_s(injectInfo.content, HWM_MAX_WATERMARK_CONTENT_LEN, content.c_str());
    if (err != S_OK)
    {
        AfxMessageBox(_T("String Copy Error!"));
    }
    CString colorCStr;
    unsigned int color = hwmsdkagent::HWM_WATERMARK_COLOR_TYPE_LIGHT;
    color = (unsigned int)m_comboboxColor.GetCurSel();
    injectInfo.color = (hwmsdkagent::HwmWaterMarkColorType)color;
    int ret = hwmsdkagent::SetWaterMark(&injectInfo);
    return ret;
}
