﻿// demoAVDeviceCtrlDlg.cpp: 实现文件
//

#include "stdafx.h"
#include "demoAVDeviceCtrlDlg.h"
#include "afxdialogex.h"
#include "demo.h"
#include "demoTools.h"
#include "HwmSdkAgent.h"


// demoAVDeviceCtrlDlg 对话框

IMPLEMENT_DYNAMIC(demoAVDeviceCtrlDlg, CDialogEx)

demoAVDeviceCtrlDlg::demoAVDeviceCtrlDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_AVDEVICE_CTRL_DIALOG, pParent)
{

}

demoAVDeviceCtrlDlg::~demoAVDeviceCtrlDlg()
{
}

void demoAVDeviceCtrlDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_COMBO_DEVICE_TYPE, m_deviceTypeCombo);
    DDX_Control(pDX, IDC_COMBO_AVDEVICE_IS_OPEN, m_isOpenCombo);
}

BOOL demoAVDeviceCtrlDlg::OnInitDialog()
{
    CDialog::OnInitDialog();

    m_deviceTypeCombo.SetWindowText(_T("Mic"));
    m_deviceTypeCombo.InsertString(0, _T("Mic"));
    m_deviceTypeCombo.InsertString(1, _T("Speaker"));
    m_deviceTypeCombo.InsertString(2, _T("Camera"));

    m_isOpenCombo.SetWindowText(_T("Open"));
    m_isOpenCombo.InsertString(0, _T("Open"));
    m_isOpenCombo.InsertString(1, _T("Close"));

    return TRUE;
}

int demoAVDeviceCtrlDlg::ClickAVDeviceCtrl()
{
    hwmsdkagent::HwmDeviceType deviceType = hwmsdkagent::HwmDeviceType::HWM_DEVICE_TYPE_MIC;
    CString strDeviceType;
    m_deviceTypeCombo.GetWindowText(strDeviceType);
    if (_T("Speaker") == strDeviceType)
    {
        deviceType = hwmsdkagent::HwmDeviceType::HWM_DEVICE_TYPE_SPEAKER;
    }
    else if (_T("Camera") == strDeviceType)
    {
        deviceType = hwmsdkagent::HwmDeviceType::HWM_DEVICE_TYPE_CAMERA;
    }

    bool isOpen = true;
    CString strIsOpen;
    m_isOpenCombo.GetWindowText(strIsOpen);
    if (_T("Open") == strIsOpen)
    {
        isOpen = true;
    }
    else if (_T("Close") == strIsOpen)
    {
        isOpen = false;
    }

    int ret = hwmsdkagent::AVDeviceCtrl(deviceType, isOpen);
    return ret;
}

void demoAVDeviceCtrlDlg::OnBnClickedOk()
{
    int ret = ClickAVDeviceCtrl();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("AVDeviceCtrl error");
        return;
    }
    CDialogEx::OnOK();
}

BEGIN_MESSAGE_MAP(demoAVDeviceCtrlDlg, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoAVDeviceCtrlDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// demoAVDeviceCtrlDlg 消息处理程序
