﻿// demoSetAvatarStyleDlg.cpp: 实现文件
//

#include "stdafx.h"
#include "demo.h"
#include "demoSetAvatarStyleDlg.h"
#include "afxdialogex.h"
#include "HwmSdkAgent.h"
#include "demoTools.h"


// demoSetAvatarStyleDlg 对话框

IMPLEMENT_DYNAMIC(demoSetAvatarStyleDlg, CDialogEx)

demoSetAvatarStyleDlg::demoSetAvatarStyleDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_SET_AVATAR_STYLE_DIALOG, pParent)
{

}

demoSetAvatarStyleDlg::~demoSetAvatarStyleDlg()
{
}

BOOL demoSetAvatarStyleDlg::OnInitDialog()
{
    CDialogEx::OnInitDialog();
    m_editBKColor.SetWindowText(_T("#ff59aaff"));
    m_editTextColor.SetWindowText(_T("#ffffffff"));
    m_comboboxNameShowType.InsertString(0, _T("FIRST_LETTER"));
    m_comboboxNameShowType.InsertString(1, _T("FAMILY_NAME"));
    m_comboboxNameShowType.SetCurSel(0);
    m_comboboxAvatarType.InsertString(0, _T("CIRCLE"));
    m_comboboxAvatarType.SetCurSel(0);

    return 0;
}

void demoSetAvatarStyleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_BK_COLOR_CONTENT, m_editBKColor);
    DDX_Control(pDX, IDC_EDIT_TEXT_COLOR_CONTENT, m_editTextColor);
    DDX_Control(pDX, IDC_EDIT_PHONE_ICON_PATH_CONTENT, m_editPhoneIconPath);
    DDX_Control(pDX, IDC_EDIT_BOARD_ICON_PATH_CONTENT, m_editBoardIconPath);
    DDX_Control(pDX, IDC_COMBO_NAME_SHOW_TYPE, m_comboboxNameShowType);
    DDX_Control(pDX, IDC_COMBO_AVATAR_SHAPE, m_comboboxAvatarType);
}


BEGIN_MESSAGE_MAP(demoSetAvatarStyleDlg, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoSetAvatarStyleDlg::OnBnClickedOk)
END_MESSAGE_MAP()


void demoSetAvatarStyleDlg::OnBnClickedOk()
{
    int ret = SetAvatarStyle();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret) {
        AfxMessageBox(_T("Set Avatar Style error"));
    }
    else
    {
        CDialogEx::OnOK();
    }
}

int demoSetAvatarStyleDlg::SetAvatarStyle()
{
    hwmsdkagent::HwmAvatarStyle avatarStyle{};
    CString contentCStr;
    m_editBKColor.GetWindowText(contentCStr);
    std::string content = CTools::UNICODE2UTF(contentCStr.GetString());
    errno_t err = strcpy_s(avatarStyle.backgroundColor, sizeof(avatarStyle.backgroundColor), content.c_str());

    m_editTextColor.GetWindowText(contentCStr);
    content = CTools::UNICODE2UTF(contentCStr.GetString());
    err += strcpy_s(avatarStyle.textColor, sizeof(avatarStyle.textColor), content.c_str());

    m_editPhoneIconPath.GetWindowText(contentCStr);
    content = CTools::UNICODE2UTF(contentCStr.GetString());
    err += strcpy_s(avatarStyle.phoneIconPath, sizeof(avatarStyle.phoneIconPath), content.c_str());

    m_editBoardIconPath.GetWindowText(contentCStr);
    content = CTools::UNICODE2UTF(contentCStr.GetString());
    err += strcpy_s(avatarStyle.boardIconPath, sizeof(avatarStyle.boardIconPath), content.c_str());

    if (err != S_OK)
    {
        AfxMessageBox(_T("String Copy Error!"));
    }

    unsigned int nameShowType = hwmsdkagent::HwmNameShowType::FIRST_LETTER;
    nameShowType = (unsigned int)m_comboboxNameShowType.GetCurSel();
    avatarStyle.nameShowType = static_cast<hwmsdkagent::HwmNameShowType>(nameShowType);

    unsigned int avatarShape = hwmsdkagent::HwmAvatarShape::CIRCLE;
    avatarShape = (unsigned int)m_comboboxAvatarType.GetCurSel();
    avatarStyle.avatarShape = static_cast<hwmsdkagent::HwmAvatarShape>(avatarShape);

    int ret = hwmsdkagent::SetAvatarStyle(&avatarStyle);
    return ret;
}
