﻿// demoSetLogPathDlg.cpp: 实现文件
//

#include "stdafx.h"
#include "demoSetLogPathDlg.h"
#include "afxdialogex.h"
#include "resource.h"
#include "HwmSdkAgent.h"
#include "demoTools.h"


// demoSetLogPathDlg 对话框

IMPLEMENT_DYNAMIC(demoSetLogPathDlg, CDialogEx)

demoSetLogPathDlg::demoSetLogPathDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_DIALOG_SET_LOG_PATH, pParent)
{

}

demoSetLogPathDlg::~demoSetLogPathDlg()
{
}

void demoSetLogPathDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_LOG_PATH, m_logPathEdit);
}


BEGIN_MESSAGE_MAP(demoSetLogPathDlg, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoSetLogPathDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// demoSetLogPathDlg 消息处理程序


void demoSetLogPathDlg::OnBnClickedOk()
{
    CString logPathCString;
    m_logPathEdit.GetWindowText(logPathCString);
    string logPath = CTools::UNICODE2UTF(logPathCString.GetString());
    hwmsdkagent::HwmLogPathInfo pathInfo{};
    errno_t res = strcpy_s(pathInfo.path, sizeof(pathInfo.path), logPath.c_str());
    if (res != 0)
    {
        AfxMessageBox(_T("logPath copy error"));
    }
    int ret = hwmsdkagent::SetLogPath(&pathInfo);
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("SetLogPath error, ret=" + std::to_string(ret));
        return;
    }
    CDialogEx::OnOK();
}
