﻿// demoStartP2pConfDlg.cpp: 实现文件
//

#include "stdafx.h"
#include "demo.h"
#include "demoStartP2pConfDlg.h"

#include <HwmAgentDef.h>
#include <HwmSdkAgent.h>

#include "afxdialogex.h"
#include "demoTools.h"


// demoStartP2pConfDlg 对话框

IMPLEMENT_DYNAMIC(demoStartP2pConfDlg, CDialogEx)

demoStartP2pConfDlg::demoStartP2pConfDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_START_P2PCONF_DIALOG, pParent)
    , m_customInfo(_T(""))
{

}

demoStartP2pConfDlg::~demoStartP2pConfDlg()
{
}

void demoStartP2pConfDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_CALLER_NICKNAME, m_callerNickName);
    DDX_Control(pDX, IDC_CALLER_ALIASCN, m_callerAliasCN);
    DDX_Control(pDX, IDC_CALLER_ALIASEN, m_callerAliasEN);
    DDX_Control(pDX, IDC_CALLEE_NICKNAME, m_calleeNickName);
    DDX_Control(pDX, IDC_CALLEE_ALIASCN, m_calleeAliasCN);
    DDX_Control(pDX, IDC_CALLEE_ALIASEN, m_calleeAliasEN);
    DDX_Control(pDX, IDC_CALLEE_NUMBER, m_calleeNumber);
    DDX_Control(pDX, IDC_CALLEE_NUMBER_TYPE, m_calleeNumberType);
    DDX_Control(pDX, IDC_CALLEE_THIRDUSERID, m_calleeThirdUserId);
    DDX_Control(pDX, IDC_CALLEE_ORGID, m_calleeOrgId);
    DDX_Control(pDX, IDC_MEDIA_TYPE, m_mediaType);
    DDX_Text(pDX, IDC_CUSTOM_INFO, m_customInfo);
}

BOOL demoStartP2pConfDlg::OnInitDialog()
{
    CDialog::OnInitDialog();

    m_mediaType.InsertString(0, _T("Video"));
    m_mediaType.InsertString(1, _T("Audio"));
    m_mediaType.SetWindowText(_T("Video"));

    m_calleeNumberType.InsertString(0, _T("Normal"));
    m_calleeNumberType.InsertString(1, _T("Mobile"));
    m_calleeNumberType.SetWindowText(_T("Normal"));

    return TRUE;
}


BEGIN_MESSAGE_MAP(demoStartP2pConfDlg, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoStartP2pConfDlg::OnBnClickedOk)
    ON_BN_CLICKED(IDCANCEL, &demoStartP2pConfDlg::OnBnClickedCancel)
END_MESSAGE_MAP()


// demoStartP2pConfDlg 消息处理程序

int demoStartP2pConfDlg::clickStartP2pConf()
{
    int ret;
    hwmsdkagent::HwmP2PStartCallInfo data{};

    CString tempCString;

    // 主叫
    m_callerNickName.GetWindowText(tempCString);
    strncpy_s(data.callerInfo.nickName, CTools::UNICODE2UTF(tempCString.GetString()).c_str(), HWM_MAX_DISPLAY_NAME_LEN);
    if (tempCString.IsEmpty())
    {
        AfxMessageBox(_T("callerNickName empty!"));
        return 1;
    }

    m_callerAliasCN.GetWindowText(tempCString);
    strncpy_s(data.callerInfo.aliasCN, CTools::UNICODE2UTF(tempCString.GetString()).c_str(), HWM_MAX_DISPLAY_NAME_LEN);
    m_callerAliasEN.GetWindowText(tempCString);
    strncpy_s(data.callerInfo.aliasEN, CTools::UNICODE2UTF(tempCString.GetString()).c_str(), HWM_MAX_DISPLAY_NAME_LEN);

    // 被叫
    m_calleeNickName.GetWindowText(tempCString);
    strncpy_s(data.calleeInfo.nickName, CTools::UNICODE2UTF(tempCString.GetString()).c_str(), HWM_MAX_DISPLAY_NAME_LEN);
    if (tempCString.IsEmpty())
    {
        AfxMessageBox(_T("calleeNickName empty!"));
        return 1;
    }

    m_calleeAliasCN.GetWindowText(tempCString);
    strncpy_s(data.calleeInfo.aliasCN, CTools::UNICODE2UTF(tempCString.GetString()).c_str(), HWM_MAX_DISPLAY_NAME_LEN);
    m_calleeAliasEN.GetWindowText(tempCString);
    strncpy_s(data.calleeInfo.aliasEN, CTools::UNICODE2UTF(tempCString.GetString()).c_str(), HWM_MAX_DISPLAY_NAME_LEN);
    m_calleeNumber.GetWindowText(tempCString);
    strncpy_s(data.calleeInfo.number, CTools::UNICODE2UTF(tempCString.GetString()).c_str(), HWM_MAX_NUMBER_LEN);
    m_calleeNumberType.GetWindowText(tempCString);
    if (tempCString == _T("Normal"))
    {
        data.calleeInfo.type = hwmsdkagent::HWM_ATTENDEE_TYPE_NORMAL;
    }
    else if (tempCString == _T("Mobile"))
    {
        data.calleeInfo.type = hwmsdkagent::HWM_ATTENDEE_TYPE_MOBILE;
    }
    m_calleeThirdUserId.GetWindowText(tempCString);
    strncpy_s(data.calleeInfo.thirdUserId, CTools::UNICODE2UTF(tempCString.GetString()).c_str(), HWM_MAX_USER_ID_LEN);
    m_calleeOrgId.GetWindowText(tempCString);
    strncpy_s(data.calleeInfo.orgId, CTools::UNICODE2UTF(tempCString.GetString()).c_str(), sizeof(data.calleeInfo.orgId) - 1);
    m_mediaType.GetWindowText(tempCString);
    data.mediaType = _T("Video") == tempCString ? hwmsdkagent::HWM_MEDIA_TYPE_VIDEO : hwmsdkagent::HWM_MEDIA_TYPE_AUDIO;
    strncpy_s(data.customInfo, CTools::UNICODE2UTF(m_customInfo.GetBuffer()).c_str(), sizeof(data.customInfo) - 1);
    ret = StartP2pConf(&data);
    memset(&data, 0, sizeof(hwmsdkagent::HwmP2PStartCallInfo));
    return ret;
}

void demoStartP2pConfDlg::OnBnClickedOk()
{
    UpdateData(TRUE);
    int ret = clickStartP2pConf();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("Create conf with attendee error");
        return;
    }
    CDialogEx::OnOK();
}


void demoStartP2pConfDlg::OnBnClickedCancel()
{
    CDialogEx::OnCancel();
}