// demoStartProjectionDlg.cpp : ʵļ
//

#include <string>
#include "stdafx.h"
#include "demoStartProjectionDlg.h"
#include "afxdialogex.h"
#include "resource.h"
#include "demoTools.h"
#include "HwmSdkAgent.h"
#include "demoData.h"
#include "demoCustomMessage.h"

// demoStartProjectionDlg Ի

IMPLEMENT_DYNAMIC(demoStartProjectionDlg, CDialogEx)

demoStartProjectionDlg::demoStartProjectionDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_START_PROJECTION_DIALOG, pParent)
{

}

demoStartProjectionDlg::~demoStartProjectionDlg()
{
}

void demoStartProjectionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_PAIR_CODE, m_pairCodeEdit);
    DDX_Control(pDX, IDC_EDIT_RANDOM_NUMBER, m_randomNumberEdit);
    DDX_Control(pDX, IDC_EDIT_VERIFY_CODE, m_verifyCodeEdit);
}

BOOL demoStartProjectionDlg::OnInitDialog()
{
    CDialogEx::OnInitDialog();

    demoData::GetInstance().SetStartProjectionHwnd(m_hWnd);
    return TRUE;  // ǽõؼ򷵻 TRUE
}

BEGIN_MESSAGE_MAP(demoStartProjectionDlg, CDialogEx)
    ON_MESSAGE(WM_START_PROJECTION_RANDOM_NUMBER, &demoStartProjectionDlg::OnStartProjectionResult)
    ON_BN_CLICKED(IDOK, &demoStartProjectionDlg::OnBnClickedOk)
    ON_BN_CLICKED(IDCANCEL, &demoStartProjectionDlg::OnBnClickedCancel)
END_MESSAGE_MAP()


// demoStartProjectionDlg Ϣ

void demoStartProjectionDlg::OnBnClickedOk()
{
    m_pairCodeEdit.GetWindowText(m_pairCode);
    m_randomNumberEdit.GetWindowText(m_randomNumber);
    m_verifyCodeEdit.GetWindowText(m_verifyCode);

    std::string pairCode = CTools::UNICODE2UTF(m_pairCode.GetString());
    std::string randomNumber = CTools::UNICODE2UTF(m_randomNumber.GetString());
    std::string verifyCode = CTools::UNICODE2UTF(m_verifyCode.GetString());

    hwmsdkagent::HwmStartProjectionParam data{};
    strncpy_s(data.pairCode, pairCode.c_str(), sizeof(data.pairCode));
    strncpy_s(data.randomNumber, randomNumber.c_str(), sizeof(data.randomNumber));
    strncpy_s(data.verifyCode, verifyCode.c_str(), sizeof(data.verifyCode));
    hwmsdk::HwmErrCode ret = hwmsdkagent::StartProjection(&data);

    if (ret != hwmsdk::HWM_COMMON_SUCCESS)
    {
        CTools::OutputRetStr("Start projection error");
        return;
    }
}

void demoStartProjectionDlg::OnBnClickedCancel()
{
    CDialogEx::OnCancel();
}

LRESULT demoStartProjectionDlg::OnStartProjectionResult(WPARAM wParam, LPARAM lParam)
{
    if (wParam == NULL)
    {
        return 0L;
    }

    char* randomNumber = reinterpret_cast<char*>(wParam);
    m_randomNumberEdit.SetWindowTextW(CTools::UTF2UNICODE(randomNumber).c_str());

    delete[] randomNumber;
    randomNumber = nullptr;

    return 0L;
}