﻿/**
 * @file HwmAgentNotify.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief [en] Notify class file.
 *        [cn] 通知类
 */

#ifndef _HWM_AGENT_NOTIFY_H_
#define _HWM_AGENT_NOTIFY_H_

#include "HwmAgentNotifyDef.h"

namespace hwmsdkagent
{
    //通知类
    class HwmAgentNotify
    {
    public:
        /**
         * @brief [en] Notify of sdk disconnected.
         *        [cn] 连接断开通知
         *
         * @attention [en] NA
         *            [cn] NA
         **/
        virtual void OnSdkDisconnected() {};

        /**
         * @brief [en] Notify of be kicked out.
         *        [cn] 登录被踢通知
         *
         * @attention [en] NA
         *            [cn] NA
         **/
        virtual void OnKickedOut() {};

        /**
        * @brief [en] Notify of the config of corporation.
        *        [cn] 企业配置通知
        *
        * @param [in] HwmCorpConfigInfo* data                 [en] Config data
        *                                                     [cn] 配置信息
        * @attention [en] More details of data in doc file
        *            [cn] data结构体定义见文档
        **/
        virtual void OnCorpConfig(HwmCorpConfigInfo* data) {};

        /**
        * @brief [en] Notify of the info of corporation.
        *        [cn] 客户企业信息变化通知
        *
        * @param [in] HwmCorpInfoNotifyType type                 [en] user corp info type
        *                                                        [cn] 客户企业信息变化通知类型
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnUserCorpInfo(HwmUserCorpInfoNotifyType type) {};

        /**
        * @brief [en] Notify of the conf incoming
        *        [cn] 会议来电通知
        *
        * @param [in] HwmConfIncomingInfo* data                 [en] Conf incoming info
        *                                                       [cn] 会议来电信息
        * @attention NA
        **/
        virtual void OnConfIncoming(HwmConfIncomingInfo* data) {};

        /**
        * @brief [en] Notify of conf state.
        *        [cn] 会议状态通知
        *
        * @param [in] HwmConfStateInfo *confStateInfo             [en] Conf state info
        *                                                         [cn] 会议状态信息
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnConfState(HwmConfStateInfo *confStateInfo) {};

        /**
        * @brief [en] Notify of conf info.
        *        [cn] 会议信息通知
        *
        * @param [in] HwmConfInfo *confInfo             [en] Conf info
        *                                               [cn] 会议信息
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnConfInfo(HwmConfInfo *confInfo) {};

        /**
         * @brief [en] Notify of share state.
         *        [cn] 共享状态通知
         *
         * @param [in] HwmShareStateInfo *shareStateInfo             [en] Share state info
         *                                                           [cn] 共享状态信息
         * @attention [en] NA
         *            [cn] NA
         **/
        virtual void OnShareState(HwmShareStateInfo *shareStateInfo) {};

        /**
         * @brief [en] Notify of receive share state.
         *        [cn] 收到共享状态通知
         *
         * @param [in] HwmShareStateInfo *shareStateInfo             [en] Share state info
         *                                                           [cn] 共享状态信息
         * @attention [en] NA
         *            [cn] NA
         **/
        virtual void OnRecvShareState(HwmRecvShareStateInfo *shareStateInfo) {};

        /**
         * @brief [en] Notify of start share.
         *        [cn] 点击注入按钮通知
         *
         * @param [in] HwmClickInjectBtn injectBtn             [en] Button type
         *                                                     [cn] 按钮类型
         * @param [in] void* data                              [en] Notify data
         *                                                     [cn] 通知所带参数
         * @param [in] const char* id                          [en] User custome menu id
         *                                                     [cn] 用户自定义菜单id
         * @attention [en] NA
         *            [cn] NA
         **/
        virtual void OnClickInjectBtn(HwmClickInjectBtn injectBtn, void* data, const char* id) {};

        /**
         * @brief [en] This class is about the callback of transfering point to point call to conference.
         *        [cn] 立即会议记录回调
         *
         * @param [in] HwmP2PConfRecordInfo *recordInfo             [en] P2P conf record info
         *                                                             [cn] 会议记录信息
         */
        virtual void OnP2PConfRecordNotify(HwmP2PConfRecordInfo *recordInfo) {};
        
        /**
         * @brief [en] conf list notify. when login / bookconf / cancelconf, will receive this notify  
         *        [cn] 会议列表通知，预约会议或者获取会议列表时收到此通知，更新会议列表
         *
         * @param [in] HwmConflistUpdateType updateType                [en] Update type of conf list
         *                                                             [cn] 会议信息更新类型
         * @param [in] const HwmConfListInfo *confInfoList             [en] conf info list
         *                                                             [cn] 会议信息列表
         * @param [in] unsigned int confInfoLen                        [en] the size of conf list
         *                                                             [cn] 会议信息列表长度
         */
        virtual void OnConfList(HwmConflistUpdateType updateType, const HwmConfListInfo *confInfoList, unsigned int confInfoLen) {};

        /**
        * @brief [en] Notify of call state.
        *        [cn] 通话状态通知
        *
        * @param [in] HwmCallStateInfo              [en] call state
        *                                           [cn] 通话状态
        * @attention [en] NA
        *            [cn] NA
        */
        virtual void OnCallState(const HwmCallStateInfo *callStateInfo) {};

        /**
        * @brief [en] Notify of call info
        *        [cn] 通话信息通知
        *
        * @param [in] HwmCallInfo               [en] call info
        *                                       [cn] 通话信息
        * @attention [en] NA
        *            [cn] NA
        */
        virtual void OnCallInfo(const HwmCallInfo *callInfo) {};

        /**
        * @brief [en] Notify of login error
        *        [cn] 登录凭证失效通知
        *
        * @param [in] unsigned int reason           [en] reason
        *                                           [cn] 登录凭证失效原因
        * @attention [en] NA
        *            [cn] NA
        */
        virtual void OnAuthenticateExpired(unsigned int reason) {};

        /**
        * @brief [en] Notify of AVDevice control state
        *        [cn] 音视频设备控制状态变化通知
        *
        * @param [in] HwmDeviceType deviceType          [en] Device type
        *                                               [cn] 设备类型
        * @param [in] bool isOpen                       [en] is open
        *                                               [cn] 是否开启
        * @attention [en] NA
        *            [cn] NA
        */
        virtual void OnAVDeviceCtrlStateChanged(HwmDeviceType deviceType, bool isOpen) {};

        /**
        * @brief [en] Notify of audio famme
        *        [cn] 上报音频码流帧数据通知
        *
        * @param [in] AudioFrameData* pFrame             [en] Report audio stream frame data.
        *                                                [cn] 上报音频码流帧数据通知
        * @attention [en] NA
        *            [cn] NA
        */
        virtual void OnAudioFrameNotify(const AudioFrameData* pFrame) {};

        /**
        * @brief [en] Notify of conf share locked state changed
        *        [cn] 会议是否共享锁定状态变化通知
        *
        * @param [in] bool isShareLocked                 [en] Is share locked
        *                                                [cn] 是否共享锁定
        * @attention [en] NA
        *            [cn] NA
        */
        virtual void OnConfIsShareLockedChanged(bool isShareLocked) {};
        /*********************************************以下是保留的通知*********************************************/

        /**
         * @brief [en] Notify of pair code refresh.
         *        [cn] 配对码刷新通知
         *
         * @param [in] HwmPairCodeInfo* data                   [en] Pair code data
         *                                                     [cn] 配对码
         * @attention [en] Reserved
         *            [cn] 保留通知，仅供大屏版本使用
         **/
        virtual void OnRefreshPairCode(HwmPairCodeInfo* data) {};

        /**
        * @brief [en] Notify of remote control state.
        *        [cn] 得到远程控制状态通知
        *
        * @param [in] HwmRemoteControlStateInfo *remoteControlStateInfo             [en] Remote control state
        *                                                                           [cn] 远程控制状态信息
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnRemoteControlState(HwmRemoteControlStateInfo *remoteControlStateInfo) {};

        /**
        * @brief [en] Notify of be remote controled state.
        *        [cn] 授予他人远程控制状态通知
        *
        * @param [in] HwmRemoteControlStateInfo *remoteControlStateInfo             [en] Remote control state
        *                                                                           [cn] 远程控制状态信息
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnBeRemoteControledState(HwmRemoteControlStateInfo *remoteControlStateInfo) {};

        /**
        * @brief [en] Notify of the call incoming
        *        [cn] 呼叫来电通知
        *
        * @param [in] HwmCallIncomingInfo* data                 [en] Call incoming info
        *                                                       [cn] 呼叫来电信息
        * @attention [en] Reserved
        *            [cn] 保留通知
        */
        virtual void OnCallIncoming(const HwmCallIncomingInfo* callIncomingInfo) {};

        /**
        * @brief [en] Notify of call end recode info
        *        [cn] 通话结束通知
        *
        * @param [in] callRecordInfo                [en] call end record info
        *                                           [cn] 结束通话的记录信息
        * @attention [en] Reserved
        *            [cn] 保留通知
        */
        virtual void OnCallRecordInfo(const HwmCallRecordInfo *callRecordInfo) {};
        /**
        * @brief [en] Notify of show external conf info wnd
        *        [cn] 显示外部会议信息框通知
        *
        * @param [in] left                          [en] conf info wnd's left pos.
        *                                           [cn] 会议信息框左坐标
        * @param [in] top                           [en] conf info wnd's top pos.
        *                                           [cn] 会议信息框顶部坐标
        * @attention [en] Reserved
        *            [cn] 保留通知
        */
        virtual void OnShowExternalConfInfoWnd(int left, int top) {};
        /**
        * @brief [en] Notify of destroy external conf info wnd
        *        [cn] 销毁外部会议信息框通知
        * @attention [en] Reserved
        *            [cn] 保留通知
        */
        virtual void OnDestroyExternalConfInfoWnd() {};
        /**
        * @brief [en] Notify of query external contact avatar
        *        [cn] 查询外部通讯录头像通知
        * @param [in] account                       [en] account info
        *                                           [cn] 账户信息
        * @param [in] thirdUserId                   [en] thirdUserId info
        *                                           [cn] 第三方账户信息
        * @param [in] sipNumber                     [en] sipNumber info
        *                                           [cn] sip号码信息
        * @param [in] avatarPath                    [en] avatarPath info
        *                                           [cn] 头像路径信息
        * @param [in] pathLen                       [en] pathLen info
        *                                           [cn] 路径长度信息
        * @attention [en] Reserved
        *            [cn] 保留通知
        */
        virtual void OnQueryContactAvatar(const char account[HWM_MAX_ACCOUNT_LEN], const char thirdUserId[HWM_MAX_ACCOUNT_LEN], const char sipNumber[HWM_MAX_NUMBER_LEN], char* avatarPath,int pathLen) {};
        /*********************************************以上是保留的通知*********************************************/

        /**
        * @brief [en] window handle list notify. when window handle changed, will receive this notify
        *        [cn] 窗口句柄信息通知
        *
        * @param [in] const HwmHwndListInfo* hwndInfo           [en] window handle info
        *                                                       [cn] 窗口句柄信息
        */
        virtual void OnRenderWindowInfoList(const HwmHwndListInfo* hwndInfo) {};

        /**
        * @brief
        * [en] This class is about the notification of an ended conference.
        * [cn] 会议结束通知
        *
        * @detail
        * [en]
        * [cn] 收到该通知时，表示会议已结束。
        *
        * @param ret [type:SDKERR]
        * [en] Error code
        * [cn] 错误码
        *
        * @param reason [type:HWM_CHAR*]
        * [en] Reason
        * [cn] 错误描述
        *
        * @param confEndInfo [type:HwmConfEndInfo*]
        * [en] Conf end info
        * [cn] 已结束的会议信息
        */
        virtual void OnConfEndedNotify(const HwmConfEndInfo* confEndInfo) {};

        /**
        * @brief [en] Notify of show voiceprint statement
        *        [cn] 功能声明显示通知
        *
        * @param [in] HwmShowVoiceprintStatementInfo* info     [en] info of show voiceprint statement
        *                                                      [cn] 打开声纹降噪功能声明信息
        * @mac:disable
        */
        virtual void OnShowVoiceprintStatement(const HwmShowVoiceprintStatementInfo* info) {};

        /**
        * @brief
        * [en] This class is about the notification of low quality network.
        * [cn] 弱网提示通知
        *
        * @param lowNetWorkType [type:HwmPoorNetWorkQualityInfo*]
        * [en] Weak Network Type
        * [cn] 弱网类型
        */
        virtual void OnPoorNetworkQualityInfoNotify(const HwmPoorNetWorkQualityInfo* poorNetWorkInfo) {};

        /**
        * @brief
        * [en]Notify of speaker list
        * [cn]发言人变更的通知
        *
        * @param speakerList [type:HwmSpeakerList]
        * [en]Speaker list
        * [cn]发言人列表
        */
        virtual void OnSpeakerListChanged(const HwmSpeakerList* speakerList) {};

        /**
        * @brief
        * [en]Notify of video stream type info
        * [cn]视频流类型的变化通知
        *
        * @param videoStreamTypeInfo [type:HwmVideoStreamTypeInfo]
        * [en]video stream type info
        * [cn]视频流类型信息
        */
        virtual void OnVideoStreamTypeChanged(const HwmVideoStreamTypeInfo* videoStreamTypeInfo) {};

        /**
        * @brief
        * [en]Notify of video attendee list change
        * [cn]视频与会者列表变更的通知
        *
        * @js:disable
        */
        virtual void OnVideoAttendeeListChanged() {};

        /**
        * @brief
        * [en]This is about share vmr info notify.
        * [cn]共享vmr信息通知
        *
        * @detail
        * [en]
        * [cn] 收到该通知时，表示共享vmr信息变更
        *
        * @param shareVmrInfo[type:HwmShareVmrInfo*]
        * [en]Share vmr info
        * [cn]共享vmr信息
        **/
        virtual void OnShareVmrInfoNotify(const HwmShareVmrInfo* shareVmrInfo) {};

        /**
        * @brief
        * [en]Notify of annotation state change
        * [cn]标注状态变化通知
        *
        * @param stateInfo [type:HwmAnnotationStateInfo*]
        * [en]Annotation state info
        * [cn]标注状态信息
        *
        * @js:disable
        */
        virtual void OnAnnotationStateChanged(const HwmAnnotationStateInfo* stateInfo) {};

        /**
        * @brief
        * [en]Notify of conf info
        * [cn]会中信息更新通知
        *
        * @param meetingInfo [type:HwmMeetingInfo*]
        * [en]Conf info
        * [cn]会中信息
        */
        virtual void OnMeetingInfoChanged(const HwmMeetingInfo* meetingInfo) {};

        /**
        * @brief
        * [en] Notify of the waiting list
        * [cn] 等候室成员列表变更的通知
        *
        * @param waitingList [type:HwmAttendeeListInfo*]
        * [en] Waiting list
        * [cn] 等候室成员列表
        */
        virtual void OnWaitingListChanged(const HwmAttendeeListInfo* waitingList) {};

        /**
        * @brief[en] User data path change notification
        *       [cn] 用户数据路径变化通知
        *
        * @param userSavePathInfo [type:HwmUserSavePathInfo*]
        * [en] Path Info
        * [cn] 路径信息
        *
        * @mac:disable
        * @js:disable
        */
        virtual void OnUserSavePathChanged(const HwmUserSavePathInfo* userSavePathInfo) {};

        /**
        * @brief
        * [en] Notify of the add attendee
        * [cn] 添加与会者结果通知
        *
        * @detail
        * [en]
        * [cn] 添加多人时，可能会上报多次。
        *
        * @param addAttendeeResultList [type:HwmAddAttendeeResultList*]
        * [en] add attendee result list
        * [cn] 添加与会者结果列表
        **/
        virtual void OnAddAttendeeNotify(const HwmAddAttendeeResultList* addAttendeeResultList) {};

        /**
        * @brief
        * [en] Notify of local record state
        * [cn] 本地录制状态通知
        *
        * @param localRecordStateInfo [type:HwmLocalRecordStateInfo*]
        * [en] Local record state info
        * [cn] 本地录制状态信息
        */
        virtual void OnSelfLocalRecordStateNotify(const HwmLocalRecordStateInfo* localRecordStateInfo) {};

        /**
        * @brief
        * [en] Notify of double click participant list item
        * [cn] 双击与会者项通知
        *
        * @detail
        * [en]
        * [cn] 收到该通知时，用户双击了与会者列表中的与会者项。
        *
        * @param participantInfo [type:HwmParticipantItemInfo*]
        * [en] Participant info
        * [cn] 与会者信息
        */
        virtual void OnDoubleClickParticipantListItemNotify(const HwmParticipantItemInfo* participantInfo) {};

        /**
        * @brief
        * [en] Notify of the attendee list
        * [cn] 与会者列表变更的通知
        *
        * @param attendeeList [type:HwmAttendeeListInfo*]
        * [en] Attendee list
        * [cn] 与会者列表
        **/
        virtual void OnAttendeeListChanged(const HwmAttendeeListInfo* attendeeList) {};

        /**
        * @brief
        * [en] Notify of the real time subtitle info
        * [cn] 实时字幕信息的通知
        *
        * @param realTimeSubtitleInfo [type:HwmRealTimeSubtitleInfo*]
        * [en] Real Time Subtitle Info
        * [cn] 实时字幕信息
        **/
        virtual void OnRealTimeSubtitleInfoNotify(const HwmRealTimeSubtitleInfo* realTimeSubtitleInfo) {};

        /**
        * @brief
        * [en] Notify of the subtitle record info
        * [cn] 字幕记录消息的通知
        *
        * @param subtitleRecordInfo [type:HwmSubtitleRecordInfo*]
        * [en] Subtitle Record Info
        * [cn] 字幕记录信息
        **/
        virtual void OnSubtitleRecordNotify(const HwmSubtitleRecordInfo* subtitleRecordInfo) {};

        /**
        * @brief
        * [en] Notify of subtitle state change
        * [cn] 字幕状态变更通知
        *
        * @detail
        * [en] Notify of subtitle state change
        * [cn] 收到该通知时，表示当前字幕状态发生变化。
        *
        * @param isOpen [type:bool]
        * [en] Is open
        * [cn] 是否开启
        **/
        virtual void OnSubtitleStateChanged(bool isOpen) {};

        /**
        * @brief
        * [en] Notify of waiting room state change
        * [cn] 等候室状态变更通知
        *
        * @detail
        * [en] Notify of waiting room state change
        * [cn] 收到该通知时，表示当前等候室状态发生变化。
        *
        * @param isOpen [type:HWM_BOOL]
        * [en] Is open
        * [cn] 是否开启
        **/
        virtual void OnWaitingRoomStateChanged(bool isOpen) {};

        /**
        * @brief
        * [en] Notify of local record operation interrupt notify
        * [cn] 本地录制操作中断通知
        *
        * @detail
        * [en] Notify of waiting room state change
        * [cn] 收到该通知时，表示当前本地录制操作中断。
        *
        * @param info [type:HwmInterruptInfo]
        * [en] Interrupt info
        * [cn] 中断信息
        **/
        virtual void OnStartLocalRecordOperationInterruptNotify(const HwmInterruptInfo* info) {};

        /**
        * @brief
        * [en] Create Conf Finished Notify. when create conf, will receive this notify
        * [cn] 完成创建会议通知
        *
        * @detail
        * [en]
        * [cn] 收到该通知时，表示完成创建会议操作。
        *
        * @param ret [type:hwmsdk::HwmErrCode]
        * [en] Return code
        * [cn] 返回值
        *
        * @param reason [type:const char*]
        * [en] Reason
        * [cn] 错误描述
        *
        * @param createConfResult [type:HwmCreateConfResult*]
        * [en] Create Conf Result
        * [cn] 创建会议结果
        */
        virtual void OnCreateConfFinishedNotify(hwmsdk::HwmErrCode ret, const char* reason, HwmCreateConfResult *confInfo) {};

        /**
        * @brief
        * [en]This is about login state change notify.
        * [cn]登录状态变化通知
        *
        * @detail
        * [en]
        * [cn] 收到该通知时，表示登录状态变更
        *
        * @param loginStateInfo[type:HwmLoginStateInfo*]
        * [en]Login state info
        * [cn]登录状态信息
        **/
        virtual void OnLoginStateChangeNotify(const HwmLoginStateInfo* loginStateInfo) {};

        /**
        * @brief
        * [en]Notify of forbidden screenshots enabletype changed
        * [cn]禁止截屏开关状态变更
        *
        * @param enableType [type:HwmForbiddenScreenShotsEnableType]
        * [en]
        * [cn]禁止截屏开关状态
        *
        * @mac:disable
        */
        virtual void OnConfForbiddenScreenShotsEnableChanged(HwmForbiddenScreenShotsEnableType enableType) {};

/* auto generate code insert, forbit delete */
    };
}

#endif /* _HWM_AGENT_NOTIFY_H_ */