﻿/**
 * @file HwmAgentNotifyDefReserved.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief [en] define file.
 *        [cn] 通知结构体、枚举定义文件
 */

#ifndef _HWM_AGENT_NOTIFY_DEF_RESERVED_H_
#define _HWM_AGENT_NOTIFY_DEF_RESERVED_H_

#include "HwmBaseMacroDef.h"

namespace hwmsdkagent
{

/********************************************以下是枚举定义*****************************************************************/   

    typedef struct tagHwmConfListInfoForWelink
    {
        HwmConfListInfo confListInfo;
        char chairJoinUri[HWM_MAX_URL_LEN];         /**< [en]the uri used by chairman to join conference. [cn]主持人加入会议uri链接 */
        char guestJoinUri[HWM_MAX_URL_LEN];         /**< [en]the uri used by guest to join conference. [cn]普通与会者加入会议uri链接 */
        char audienceJoinUri[HWM_MAX_URL_LEN];      /**< [en]the uri used by guest to join conference. [cn]观众与会者加入会议uri链接 */
    } HwmConfListInfoForWelink;

    /**
     * [en]This structure is used to describe the device information.
     * [cn]设备信息
     */
    typedef struct tagHwmDeviceInfo
    {
        unsigned int index;                             /**< [en]Indicates device index. [cn]设备对应的index */
        char strName[MAX_DISPLAY_NAME];                 /**< [en]Indicates device name. [cn]设备名称 */
        unsigned int cameraOrient;                      /**< [en]Indicates the camera orient, only the mobile platform camera device has a value. [cn]摄像头角度, 仅移动平台摄像头设备有值 */
        unsigned int deviceId;                          /**< [en]Indicates device ID used by UI. [cn]设备ID，供UI使用的设备的唯一标识符 */
        bool isUsing;                                   /**< [en]Indicates whether the device is using. [cn]设备是否正在使用 */
    } HwmDeviceInfo;

    /**
     * [en]This enum is used to describe the attendee count type.
     * [cn]与会者数量类型
     */
    typedef enum tagHwmAttendeeCountType
    {
        ATTENDEE_COUNT_TYPE_ATTENDEE,                   /**< [en]Indicates attendee count. [cn]在线与会者列表数量 */
        ATTENDEE_COUNT_TYPE_AUDIENCE,                   /**< [en]Indicates audience count. [cn]观众列表数量 */
        ATTENDEE_COUNT_TYPE_WAITING,                    /**< [en]Indicates waiting count. [cn]等候室列表数量 */
        ATTENDEE_COUNT_TYPE_BUTT
    }HwmAttendeeCountType;

    /**
     * [en]This struct is used to describe the attendee count info.
     * [cn]与会者数量
     */
    typedef struct tagHwmAttendeeCountInfo
    {
        unsigned int count;                             /**< [en]Indicates count. [cn]数量 */
        HwmAttendeeCountType type;
    }HwmAttendeeCountInfo;

    /**
    * [en]This structure is used to describe the refresh login result.
    * [cn]刷新登录结果
    */
    typedef struct tagHwmRefreshLoginResult
    {
        char strUuid[HWM_MAX_DEVICE_UUID_LEN];          /**< [en]Indicates uuid. [cn] 个人统一标识符 */
        char confToken[HWM_MAX_TOKEN_LEN];              /**< [en]Indicates conf token. [cn] 会议token */
        int isUsgEnable;                                /**< [en]Indicates isUsgEnable[en] is usg enable. [cn] usg是否可用 */
        int isCallEnable;                               /**< [en]isCallEnable[en] is call enable [cn] 呼叫是否可用*/
        bool basicCallAbility;                          /**< [en]Indicates has call ability. [cn]是否有点对点呼叫能力 */
    } HwmRefreshLoginResult;

    /**
    * [en]Conf Control type.
    * [cn]会控操作类型
    */
    typedef enum tagConfCtrlType
    {
        CONFCTRL_TYPE_ATTENDEE,                                 /**< [en]Attendee
                                                                     [cn]查看与会者 */
        CONFCTRL_TYPE_LOCK_CONF,                                /**< [en]Lock conf
                                                                     [cn]锁定/解锁会议 */
    }ConfCtrlType;

    /**
    * [en]This struct is used to describe conference conflict info.
    * [cn]会议冲突信息
    */
    typedef struct tagHwmConfConflictInfo
    {
        char conflictConfId[HWM_MAX_CONF_ID_LEN];          /**< [en]Indicates conference id.
                                                                [cn]冲突的会议ID */
        char conflictConfSubject[HWM_MAX_SUBJECT_LEN];     /**< [en]Indicates conference subject.
                                                                [cn]冲突的会议主题 */
        char conflictConfOwnerName[HWM_MAX_APPNAME_LEN];   /**< [en]Indicates xxx.
                                                                [cn]预订人 */
        bool isConflictConfOwner;                          /**< [en]Indicates xxx.
                                                                [cn]本人是否是冲突的会议的所有者，如果是，才有权限强制结束冲突会议 */
        char confId[HWM_MAX_CONF_ID_LEN];                  /**< [en]Indicates conference id.
                                                                [cn]会议id */
        char confPwd[HWM_MAX_CONF_PASSWORD_LEN];           /**< [en]Indicates conference password.
                                                                [cn]会议密码 */
        char accessNumber[HWM_MAX_CONF_ACCESS_LEN];        /**< [en]Indicates conference access number.
                                                                [cn]会议接入码 */
        HwmMediaType mediaType;                            /**< [en]Indicates media type
                                                                [cn]媒体类型*/
        bool supportTerminal;                              /**< [en]Indicates whether is support invite Terminal.
                                                                [cn]是否支持邀请硬终端入会 */
    }HwmConfConflictInfo;

    /**
    * [en]Reserved click inject button type.
    * [cn]保留的点击注入按钮类型
    */
    typedef enum tagHwmReservedClickInjectBtn
    {
        HWM_RESERVED_CLICK_INJECT_BTN_CUSTOM_CHECKBOX,      /**< [en]Custom checkbox button
                                                                 [cn]自定义复选框按钮 */
        HWM_RESERVED_CLICK_INJECT_BTN_CTD,                  /**< [en]CTD button
                                                                 [cn]自动回呼按钮 */
        HWM_RESERVED_CLICK_INJECT_BTN_LANGUAGE,             /**< [en]Language button
                                                                 [cn]语言设置按钮 */
        HWM_RESERVED_CLICK_INJECT_BTN_CUSTOM_INPUT,         /**< [en]Custom input button
                                                                 [cn]用户自定义输入框按钮 */
                        
        HWM_RESERVED_CLICK_INJECT_BTN_BUTT
    } HwmReservedClickInjectBtn;

    /**
    * [en]Custom checkbox inject info.
    * [cn]自定义复选框点击注入信息
    */
    typedef struct tagHwmCustomCheckBoxInjectInfo
    {
        bool isChecked;                              /**< [en]Is checked
                                                          [cn]是否勾选 */
    }HwmCustomCheckBoxInjectInfo;

    /**
    * [en]CTD button inject info.
    * [cn]自动回呼按钮点击注入信息
    */
    typedef struct tagHwmCTDBtnInjectInfo
    {
        bool isOpen;                                  /**< [en]Is open
                                                           [cn]是否开启 */
        char defaultNumber[HWM_MAX_PHONE_NUM_LEN];    /**< [en]Default num
                                                           [cn]默认号码 */
        char customNumber[HWM_MAX_PHONE_NUM_LEN];     /**< [en]Custom num
                                                           [cn]自定义号码 */  
        char callbackNumber[HWM_MAX_PHONE_NUM_LEN];   /**< [en]Callback num
                                                           [cn]回呼号码 */  
    }HwmCTDBtnInjectInfo;

    /**
    * [en]Language button inject info.
    * [cn]语言按钮点击注入信息
    */
    typedef struct tagHwmLanguageBtnInjectInfo
    {
        HwmLanguage language;            /**< [en]Language type
                                              [cn]语言类型 */
    }HwmLanguageBtnInjectInfo;

    /**
    * [en]Custom input inject info.
    * [cn]自定义输入框点击注入信息
    */
    typedef struct HwmCustomInputInjectInfo
    {
        char value[MAX_DISPLAY_NAME];     /**< [en]Value of input
                                               [cn]输入框显示的值 */
    }HwmCustomInputInjectInfo;

    /**
    * [en]Device config info
    * [cn]设备配置信息
    */
    typedef struct tagHwmDeviceConfig
    {
        bool isMicOn;                                         /**< [en]Is mic on
                                                              [cn]是否开启麦克风 */
        bool isCameraOn;                                      /**< [en]Is camera on
                                                              [cn]是否开启摄像头 */
    }HwmDeviceConfig;

    /**
    * [en]
    * [cn]文档服务对接服务信息
    */
    typedef enum tagHwmDocServerType
    {
        HWM_DOC_SHIMO_SERVER = 0                 /**< [en]xxxx. [cn]石墨文档服务 */
    }HwmDocServerType;

    typedef enum tagHwmQueryDocType
    {
        HWM_QUERY_DOC_USED = 0,    /**< [en]Indicates used.   [cn]最近使用  */
        HWM_QUERY_DOC_UPDATED,     /**< [en]Indicates update. [cn]最近更新  */
        HWM_QUERY_DOC_Created,     /**< [en]Indicates create by myself. [cn]自己创建的  */
        HWM_QUERY_DOC_SHARED,      /**< [en]Indicates shared to me. [cn]共享给我的  */
    }HwmQueryDocType;

    /**
    * [en]This struct is used to describe query doc dictionary info<br>
    * [cn]查询文档
    */
    typedef struct tagHwmQueryFileListParam
    {
        HwmDocServerType   serverType;                     /**< [en]Indicates doc server type. [cn]文档服务类型 */
        char               folder[HWM_MAX_CONF_UUID_LEN];  /**< [en]Indicates father file. [cn]父级文件夹id  */
        unsigned int       limit;                          /**< [en]Indicates limit file number. [cn]文件数目，非必填  */
        long long          lastTimeStamp;                  /**< [en]Indicates limit file before lastTimeStamp. [cn]时间戳，非必填 表示这次只查询这个时间戳之前的文件 */
        HwmQueryDocType    queryDocType;                   /**< [en]Indicates limit file number. [cn]文件数目，非必填  */
    }HwmQueryFileListParam;


    /**
    * [en]This struct is used to describe query doc dictionary info<br>
    * [cn]删除文档
    */
    typedef struct tagHwmDeleteFileParam
    {
        HwmDocServerType   serverType;                     /**< [en]Indicates doc server type. [cn]文档服务类型 */
        char        docGuid[HWM_MAX_CONF_UUID_LEN];        /**< [en]Indicates file guid. [cn]文件或文件夹guid  */
    }HwmDeleteFileParam;

    /**
    * [en]This struct is used to describe create doc dictionary info<br>
    * [cn]申请权限用户类型
    */
    typedef enum tagHwmApplyDocIdentityType
    {
        HWM_QUERY_OPER_USER_APP = 0,    /**< [en]Indicates used.   [cn]用户app  */
        HWM_QUERY_OPER_USER_TMP,        /**< [en]Indicates update. [cn]临时使用  */
    }HwmApplyDocIdentityType;

    /**
    * [en]This enum is used to describe audio quality level
    * [cn]音频质量等级
    */
    typedef enum tagHwmAudioQualityLevel
    {
        AUDIO_QUALITY_NORMAL = 0,                           /**< [en]Indicates normal value
                                                                 [cn]默认值。音频质量正常或没有音频信息*/
        AUDIO_QUALITY_NOT_GOOD,                             /**< [en]Indicates audio quality not good
                                                                 [cn]音频质量不好 */
        AUDIO_QUALITY_BAD,                                  /**< [en]Indicates audio quality bad
                                                                 [cn]音频质量较差 */
        AUDIO_QUALITY_VERY_BAD                              /**< [en]Indicates audio quality very bad
                                                                 [cn]音频质量非常差 */
    }HwmAudioQualityLevel;

    /**
    * [en]This structure is used to describe custom thread type.
    * [cn]自定义线程类型
    */
    typedef enum tagHwmCustomThreadType
    {
        HWM_CUSTOM_THREAD_OFF = 0,      /**< [en]Indicates custom thread off
                                             [cn]关闭自定义线程 */
        HWM_CUSTOM_THREAD_ON = 1        /**< [en]Indicates custom thread on
                                             [cn]开启自定义线程 */
    }HwmCustomThreadType;

    /**
    * [en]Pair Mode
    * [cn]配对模式
    */
    typedef enum tagHwmPairMode
    {
        HWM_PAIR_MODE_TMP = 1,                             /**< [en]Temp pair mode
                                                                [cn]临时配对关系 */
        HWM_PAIR_MODE_FIXED,                               /**< [en]Fixed pair mode
                                                                [cn]固定配对关系 */
    }HwmPairMode;

    /**
    * [en]Locked state
    * [cn]会议锁定状态
    */
    typedef enum tagHwmLockedState
    {
        HWM_LOCKED_STATE_UNLOCK,                     /**< [en]unlock
                                                          [cn]未锁定 */
        HWM_LOCKED_STATE_LOCK,                       /**< [en]lock
                                                          [cn]锁定 */
    }HwmLockedState;

    /**
    * [en]Cpu level
    * [cn]cpu性能等级
    */
    typedef enum tagHwmCpuLevel
    {
        CALL_CPU_LEVEL_BUTT = 0,
        CALL_CPU_LEVEL_SUPER_LOW = 9,               /**< [en]Super low
                                                         [cn]性能极低 */
        CALL_CPU_LEVEL_LOW = 10,                    /**< [en]Low
                                                         [cn]性能低 */
        CALL_CPU_LEVEL_MIDDLE,                      /**< [en]Middle
                                                         [cn]性能中等 */
        CALL_CPU_LEVEL_HIGH                         /**< [en]High
                                                         [cn]性能高 */
    }HwmCpuLevel;

    /**
    * [en]Error show type
    * [cn]错误提示类型
    */
    typedef enum tagHwmErrorShowType
    {
        HWM_ERROR_SHOW_BUTT = 0,
        HWM_ERROR_SHOW_TYPE_TOAST,               /**< [en]Toast
                                                      [cn]toast */
        HWM_ERROR_SHOW_TYPE_SURE,                /**< [en]Confirm，i see
                                                      [cn]弹窗，确定*/
        HWM_ERROR_SHOW_TYPE_I_SEE,               /**< [en]Confirm，i see
                                                      [cn]弹窗，我知道了*/
    }HwmErrorShowType;

    /**
    * [en]Custom path type
    * [cn]自定义路径枚举
    */
    typedef enum tagHwmCustomPathType
    {
        HWM_CUSTOM_PATH_PNR,                          /**< [en]pnr path
                                                           [cn]本地录制文件保存路径 */
    
        HWM_CUSTOM_PATH_TYPE_BUTT
    
    } HwmCustomPathType;

    /**
    * [en]Noise reduce level
    * [cn]降噪等级
    */
    typedef enum tagHwmNoiseReduceLevel
    {
        NOISE_REDUCE_LEVEL_AUTO = 0,                    /**< [en]Auto
                                                         [cn]自动挡 */
        NOISE_REDUCE_LEVEL_LOW,                         /**< [en]Low
                                                         [cn]低挡  */
        NOISE_REDUCE_LEVEL_MIDDLE,                      /**< [en]Middle
                                                         [cn]中挡 */
        NOISE_REDUCE_LEVEL_HIGH                         /**< [en]High
                                                         [cn]高挡 */
    }HwmNoiseReduceLevel;

    /**
    * [en]End projection conf mode
    * [cn]结束投屏会议类型枚举
    */
    typedef enum tagHwmEndProjectionConfMode
    {
        END_PROJECTION_MODE_CANCEL = 0,                          /**< [en]Indicates end projection for cancel.
                                                                      [cn]投屏协商中大屏取消 */
        END_PROJECTION_MODE_BY_SENDER_WITH_TWO_MEMBERS = 1,      /**< [en]Indicates end projection by sender with two members.
                                                                      [cn]两方投屏端结束投屏 */
        END_PROJECTION_MODE_BY_RECEIVER = 2,                     /**< [en]Indicates end projection by receiver.
                                                                      [cn]大屏端结束投屏 */
        END_PROJECTION_MODE_BY_SENDER_WITH_MULTI_MEMBERS = 3,    /**< [en]Indicates end projection by sender with multi members.
                                                                      [cn]多方投屏会议投屏端结束投屏 */
    } HwmEndProjectionConfMode;

    /**
    * [en]This enum is used to describe Client DeviceType
    * [cn]私有成员类型
    */
    typedef enum tagHwmPrivateClientDeviceType
    {
        PRIVATE_CLIENT_DEVICE_DESKTOP = 0,    /**< [en]desktop
                                               <br>[cn]pc登录*/
        PRIVATE_CLIENT_DEVICE_MOBILE,         /**< [en]mobile
                                               <br>[cn]移动端登录*/
        PRIVATE_CLIENT_DEVICE_PAD,            /**< [en]pad
                                               <br>[cn]平板登录*/
        PRIVATE_CLIENT_DEVICE_SMARTROOM,      /**< [en]smart room
                                               <br>[cn]smart room版*/
        PRIVATE_CLIENT_DEVICE_MINI,           /**< [en]MiniPrograms
                                               <br>[cn]小程序*/
        PRIVATE_CLIENT_DEVICE_WEB,            /**< [en]Web
                                               <br>[cn]浏览器*/
        PRIVATE_CLIENT_DEVICE_TV,             /**< [en]TV
                                               <br>[cn]TV版*/
        PRIVATE_CLIENT_DEVICE_HARD,           /**< [en]HardTerminal
                                               <br>[cn]硬终端*/
        PRIVATE_CLIENT_DEVICE_TYPE_THIRD,     /**< [en]ThirdTerminal
                                               <br>[cn]友商终端*/
        PRIVATE_CLIENT_DEVICE_PSTN,           /**< [en]PSTN
                                               <br>[cn]PSTN*/
        PRIVATE_CLIENT_DEVICE_MCU,           /**< [en]MCU
                                              <br>[cn]MCU*/
        PRIVATE_CLIENT_DEVICE_OTHER,           /**<[en]other*/
        PRIVATE_CLIENT_DEVICE_UNKNOWN = 99    /**<[en]unkown
                                              <br>[cn]未知 */
    }HwmPrivateClientDeviceType;

    /**
    * [en]This enum is used to describe attendee type
    * [cn]私有成员类型
    */
    typedef enum tagHwmPrivateAttendeeType
    {
        PRIVATE_ATTENDEE_TYPE_NORMAL = 0,      /**< [en]Indicates conference soft terminal user
                                                <br>[cn]会议软终端用户*/
        PRIVATE_ATTENDEE_TYPE_CUSTOMNUMBER,    /**< [en]Indicates custom number
                                                <br>[cn]自定义号码*/
        PRIVATE_ATTENDEE_TYPE_MOBILE,          /**< [en]Indicates user mobile phone number
                                                <br>[cn]用户手机号码*/   
        PRIVATE_ATTENDEE_TYPE_TELEPHONE,       /**< [en]Indicates user telephone
                                                <br>[cn]用户固定电话*/
    }HwmPrivateAttendeeType;

    /**
    * [en]This enum is used to describe external state
    * [cn]外部成员状态
    */
    typedef enum tagHwmInviteeState
    {
        EXTERNAL_ATTENDEE_STATE_WAITING = 0,            /**< [en]Indicates exteranal attendee state waiting
                                                         <br>[cn]外部用户呼叫中*/
        EXTERNAL_ATTENDEE_STATE_TIMEOUT,                /**< [en]Indicates exteranal attendee state timeout
                                                         <br>[cn]外部用户呼叫超时*/
        EXTERNAL_ATTENDEE_STATE_BUSY,                   /**< [en]Indicates exteranal attendee state busy
                                                         <br>[cn]外部用户呼叫忙*/
        EXTERNAL_ATTENDEE_STATE_DENIED,                 /**< [en]Indicates exteranal attendee state denied
                                                         <br>[cn]外部用户呼叫拒接*/
        EXTERNAL_ATTENDEE_STATE_CONNECTING,             /**< [en]Indicates exteranal attendee state connecting
                                                         <br>[cn]外部用户入会中*/
        EXTERNAL_ATTENDEE_STATE_SUCCESS,                 /**< [en]Indicates exteranal attendee state success
                                                         <br>[cn]外部用户入会成功*/
        EXTERNAL_ATTENDEE_STATE_FAILED,                 /**< [en]Indicates exteranal attendee state failed
                                                         <br>[cn]外部用户入会失败*/
        EXTERNAL_ATTENDEE_STATE_REMOVED,                /**< [en]Indicates exteranal attendee state removed
                                                         <br>[cn]外部用户移除*/
        EXTERNAL_ATTENDEE_STATE_HANGUP,                 /**< [en]Indicates exteranal attendee state hangup
                                                         <br>[cn]外部用户被挂断*/
    }HwmInviteeState;

    /**
    * [en]This enum is used to describe operate exteranl invitee type
    * [cn]
    */
    typedef enum tagHwmOperateExternalInviteeType
    {
        OPERATE_EXTERNAL_INVITEE_CALL = 0,      /**< [en]Indicates call external invitee
                                                 <br>[cn]呼叫外部邀请者*/
        OPERATE_EXTERNAL_INVITEE_HANGUP,        /**< [en]Indicates hangup external hang up
                                                 <br>[cn]挂断外部邀请者*/
        OPERATE_EXTERNAL_INVITEE_REMOVE,        /**< [en]Indicates hangup external remove
                                                 <br>[cn]移除外部邀请者*/
        OPERATE_EXTERNAL_INVITEE_OTHER_NUMBER   /**< [en]Indicates hangup external
                                                 <br>[cn]呼叫其他号码*/
    }HwmOperateExternalInviteeType;

    /**
    * [en]This struct is used to describe integrator type
    * [cn]集成方类型
    */
    typedef enum tagHwmIntegratorType
    {
        HWM_INTEGRATOR_INVALID = 0,             /**< [en]Invalid
                                                     [cn]无效类型 */
        HWM_INTEGRATOR_WELINK_BOARD             /**< [en]Welink board
                                                     [cn]公司局大屏 */
    }HwmIntegratorType;

    /**
    * [en]This enum is used to describe multi-share type
    * [cn]多人共享类型
    */
    typedef enum tagHwmAllowMultiShareType
    {
        ALLOW_MULTI_SHARE_TYPE_SINGAL = 1,         /**< [en]Indicates only one user can share.
                                                        [cn]只允许单人共享 */
        ALLOW_MULTI_SHARE_TYPE_MULTI,              /**< [en]Indicates not only one user can share.
                                                        [cn]允许多人共享 */
    }HwmAllowMultiShareType;

/* auto generate code insert, forbit delete */

    /**
    * [en]This struct is used to describe query doc dictionary info<br>
    * [cn]申请协作权限
    */
    typedef struct tagHwmApplyDocOperRightParam
    {
        unsigned int      appType;                                /**< [en]Indicates app type. [cn]appType 石墨填0  */
        char              confId[HWM_MAX_CONF_ID_LEN];            /**< [en]Indicates conference id. [cn]会议id**/
        HwmApplyDocIdentityType    requesterIdentity;             /**< [en]Indicates requesterIdentity. [cn]0-应用用户申请，1-临时用户申请  */
    }HwmApplyDocOperRightParam;

    /**
    * [en]This struct is used to describe doc permission type<br>
    * [cn] 文档权限类型
    */
    typedef enum tagHwmDocPermissionType
    {
        HWM_DOC_PERMISSION_READER = 0,     /**< [en]Indicates reader.   [cn]reader  */
        HWM_DOC_PERMISSION_EDITOR,         /**< [en]Indicates editor.   [cn]editor  */
        HWM_DOC_PERMISSION_COMMENTATOR     /**< [en]Indicates editor.   [cn]commentator  */
    }HwmDocPermissionType;

    /**
    * [en]This struct is used to describe create conf doc info<br>
    * [cn]创建会议关联文档或者单独文档
    */
    typedef struct tagHwmCreateFolderParam
    {
        char        confId[HWM_MAX_CONF_ID_LEN];            /**< [en]Indicates conference id. [cn]会议id**/
        HwmDocPermissionType  permissionType;               /**< [en]Indicates doc permission. [cn]文档权限**/
        char        name[HWM_MAX_NAME_LEN];                 /**< [en]Indicates file or dic name. [cn]文件夹名字 */
    }HwmCreateFolderParam;

    /**
    * [en]Query other number info
    * [cn]请求其他号码信息
    */
    typedef struct tagHwmQueryOtherNumberInfo
    {
        char sipNumber[HWM_MAX_NUMBER_LEN];                 /**< [en]sipNumber
                                                                 [cn]sip号，跨企业场景下优先使用此字段 */
        char extendedField[HWM_MAX_EXTENDED_FIELD_LEN];     /**< [en]Indicates extended field.
                                                                 [cn]扩展字段 */
    }HwmQueryOtherNumberInfo;

    /**
    * [en]Contact info
    * [cn]联系人信息
    */
    typedef struct tagHwmContactInfo
    {
        char accountId[MAX_ACCOUNT_ID_LEN];                 /**< [en]Indicates account id.
                                                                 [cn]账号，账号密码登录场景下优先使用此字段 */
        char thirdUserId[HWM_MAX_USER_ID_LEN];              /**< [en]The attendee's third account
                                                                 [cn]与会者三方账号，appid登录场景下优先使用此字段 */
        char number[HWM_MAX_NUMBER_LEN];                    /**< [en]number
                                                                 [cn]号码，跨企业场景下优先使用此字段 */
        char userUuid[HWM_MAX_DEVICE_UUID_LEN];             /**< [en]Indicates UUID.
                                                                 [cn]UUID(由系统分配的真实的唯一用户标识) */
        char extendedField[HWM_MAX_EXTENDED_FIELD_LEN];     /**< [en]Indicates extended field.
                                                                 [cn]扩展字段 */
        char realNameAccount[HWM_MAX_NAME_LEN];             /**< [en]Indicates real name account.
                                                                 [cn]真实账号或名字 */
        char orgId[HWM_MAX_ORG_ID_LENGTH];                  /**< [en]Indicates org id.
                                                                 [cn]企业id */
    }HwmContactInfo;

    /**
    * [en]This struct is used to describe query doc access url<br>
    * [cn]查询文档链接参数
    */
    typedef struct tagHwmQueryDocAccessUrlParam
    {
        char           confId[HWM_MAX_CONF_ID_LEN];                  /**< [en]Indicates conference id. [cn]会议id**/
        bool           isCollaborator;                               /**< [en]Indicates is collaborator. [cn]是否有协作权限 */
        char           folderGuid[HWM_MAX_CONF_UUID_LEN];            /**< [en]Indicates folder guid. [cn]文件夹id **/
        HwmDocPermissionType  permissionType;                        /**< [en]Indicates doc permission. [cn]文档权限 获取不到填1**/
        unsigned int         appType;                                /**< [en]Indicates app type. [cn]appType 石墨填0  **/
    }HwmQueryDocAccessUrlParam;

    /**
    * [en]This struct is used to query corp department info<br>
    * [cn]批量查询企业部门信息
    */
    typedef struct tagHwmQueryCorpDepartmentInfoParam
    {
        char            userUuid[HWM_MAX_DEVICE_UUID_LEN];           /**< [en]user uuid. [cn]用户uuid **/
        char            sipNumber[HWM_MAX_NUMBER_LEN];               /**< [en]sipNumber [cn]sip号,跨企业场景下优先使用此字段 **/
    }HwmQueryCorpDepartmentInfoParam;

    /**
    * [en]This structure is used to describe the query avatar result info.
    * [cn]查询头像结果参数
    */
    typedef struct tagHwmContactAvatarInfo
    {
        char number[HWM_MAX_NUMBER_LEN];                    /**< [en]number
                                                                 [cn]号码 */
        char thirdUserId[HWM_MAX_USER_ID_LEN];              /**< [en]The third user id
                                                                 [cn]三方账号 */
        char userUuid[HWM_MAX_DEVICE_UUID_LEN];              /**<[en]Indicates UUID
                                                                 [cn]UUID(由系统分配的真实的唯一用户标识) */
        char avatarPath[HWM_MAX_FILE_PATH_LEN];             /**< [en]avatar path
                                                                 [cn]头像路径 */
    } HwmContactAvatarInfo;

    /**
    * [en]This struct is used to describe query avatar param
    * [cn]查询联系人头像参数
    */
    typedef struct tagHwmQueryContactAvatarParam
    {
        char number[HWM_MAX_NUMBER_LEN];                    /**< [en]number
                                                                 [cn]号码
                                                                 [cs_allowNull:N] */
        char userUuid[HWM_MAX_DEVICE_UUID_LEN];              /**<[en]Indicates UUID
                                                                 [cn]UUID(由系统分配的真实的唯一用户标识) 
                                                                 [cs_allowNull:N] */
    } HwmQueryContactAvatarParam;

    /**
    * [en]This enumeration is used to describe domain mode.
    * [cn]域名模式
    */
    typedef enum tagHwmServerDomainStrategyMode
    {
        SERVER_DOMAIN_STRATEGY_MODE_COM = 0,                         /**< [en]Indicates server domain com strategy. [cn]COM模式 */
        SERVER_DOMAIN_STRATEGY_MODE_CN,                              /**< [en]Indicates server domain cn strategy. [cn]CN模式 */
    }HwmServerDomainStrategyMode;

    /**
    * [en]This structure is used to describe the domain.
    * [cn]域名模式信息
    */
    typedef struct tagHwmServerDomainStrategy
    {
        HwmServerDomainStrategyMode mode;                            /**< [en]Indicates the server domain strategy. [cn]域名模式 */
    }HwmServerDomainStrategy;

    /**
    * [en]This structure is used to describe the domain.
    * [cn]录制提示定制
    */
    typedef struct tagHwmRecordingConfirm {
        int action;   /**< [en]Actions: 1 I know; 2 Leave the meeting. [cn]执行动作：1 我知道了；2 离开会议 */
        int timeout;  /**< [en]Automatic shutdown time (s). < = 0: The automatic shutdown is not enabled. [cn]自动关闭时间 s，<=0 不自动关闭 */
    } HwmRecordingConfirm;

    /**
    * [en]Value of diminish message box.
    * [cn]弹窗削减类型
    */
    typedef enum
    {
        MSGBOX_DIMINISHED_NONE,     /**< [en]Donot diminish. [cn]不削减 */
        MSGBOX_DIMINISHED_NORMAL,   /**< [en]As Normal. [cn]普通 */
    } MsgboxDiminishType;

    /**
    * [en]Config diminish message box.
    * [cn]弹窗削减配置
    */
    typedef struct tagHwmMsgboxDiminish
    {
        MsgboxDiminishType type;    /**< [en]Message Box Diminish Type. [cn]削减类型 */

        int timeout;                /**< [en]Automatic shutdown time (s). < = 0: The automatic shutdown is not enabled. [cn]自动关闭时间 s，<=0 不自动关闭 */

    } HwmMsgboxDiminish;

    /**
    * [en]Config toast.
    * [cn]Toast提示配置
    */
    typedef struct tagHwmToastOption
    {
        bool isHide;    /**< [en]Is hide. [cn]是否隐藏 */
    } HwmToastOption;

    /**
    * [en]Config small window of float mode.
    * [cn]悬浮视图小窗配置
    */
    typedef struct tagHwmFloatSmallWnd
    {
        bool isDefaultCollapsed;    /**< [en]Is default collapsed. [cn]是否默认收起 */
    } HwmFloatSmallWnd;

    /**< [en]Interaction Custom Mask. [cn] 交互定制掩码 */
    typedef enum {
        MASK_RECORDINGCONFIRM = 1 << 0, /**< [en]Customizing Using Recording Prompts [cn]使用录制提示定制 */
        MASK_MSGBOX_DIMINISH = 1 << 1,  /**< [en]Customizing Using Message Box Diminish Configuration. [cn]使用弹窗削减配置 */
        MASK_TOAST_OPTION = 1 << 2,     /**< [en]Customizing Using Toast Configuration. [cn]使用Toast提示配置 */
        MASK_FLOAT_SMALL_WND = 1 << 3,  /**< [en]Customizing Using Small Window of Float Mode Configuration. [cn]使用悬浮窗视图小窗配置 */
    } HwmInteractionMask;

    /**
    * [en]This structure is used to describe the domain.
    * [cn]交互定制
    */
    typedef struct tagHwmInteraction {
        unsigned mask;                                  /**< [en]Custom Function Mask [cn]定制功能掩码 */
        HwmRecordingConfirm recordingConfirm;           /**< [en]Recording Tips. [cn]录制提示 */
        HwmMsgboxDiminish msgboxDiminish;               /**< [en]Message Box Diminish Configuration. [cn]弹窗削减配置 */
        HwmToastOption toastOption;                     /**< [en]Toast Option Configuration. [cn]Toast提示配置 */
        HwmFloatSmallWnd floatSmallWnd;                 /**< [en]Small Window of Float Mode Configuration. [cn]悬浮视图小窗配置 */
    } HwmInteraction;

    /**
    * [en]This structure is used to describe the domain.
    * [cn]自定义信息
    */
    typedef struct tagHwmCustomizedConfig
    {
        HwmInteraction interaction; /**< [en]Customized interaction information. [cn]定制的交互信息 */
    }HwmCustomizedConfig;

    /**
    * [en]This struct is used to describe conference audio quality info.
    * [cn]音频质量信息
    */
    typedef struct tagAudioQualityInfo
    {
        HwmAudioQualityLevel sendQuality;                           /**< [en]Indicates sender quality. [cn]发送端质量 */
        HwmAudioQualityLevel recvQuality;                           /**< [en]Indicates receiving terminal quality. [cn]接收端质量 */
    }AudioQualityInfo;

    /**
    * [en]Proxy account info.
    * [cn]代理账号信息
    */
    typedef struct tagHwmProxyAccountInfo
    {
        char account[HWM_MAX_USERNAME_LEN];              /**< [en]The account
                                                              [cn]代理账号 */
        char password[HWM_MAX_PASSWORD_LEN];             /**< [en]The password
                                                              [cn]代理密码 */
    }HwmProxyAccountInfo;

    /**
    * [en]This structure is used to describe data conf thread info.
    * [cn]数据会议线程信息
    */
    typedef struct tagHwmDataConfThreadInfo
    {
        unsigned int threadNum;                 /**< [en]Indicates thread num.
                                                     [cn]线程数，目前仅支持2至4线程，建议设置为2，数值越大，流畅度越高、性能消耗越大
                                                     [cs_allowNull:N] */
        HwmCustomThreadType customThreadType;   /**< [en]custom thread type.
                                                     [cn]自定义线程类型
                                                     [cs_allowNull:N] */
    }HwmDataConfThreadInfo;

    /**
    * [en]This structure is used to describe optimize share config.
    * [cn]共享配置参数
    */
    typedef struct tagHwmOptimizeShareConfig
    {
        HwmDataConfThreadInfo threadInfo;       /**< [en]DataConfThreadInfo.
                                                     [cn]线程信息
                                                     [cs_allowNull:N]*/
    }HwmOptimizeShareConfig;

    /**
    * [en]Scan join conf result info.
    * [cn]扫码入会结果信息
    */
    typedef struct tagHwmScanJoinConfResult
    {
        char signature[HWM_MAX_SIGNATURE_LEN];          /**< [en]Indicates signature string. [cn]签名串 */
        char confId[HWM_MAX_CONF_ID_LEN];               /**< [en]Indicates conference id. [cn]会议id */
        char password[HWM_MAX_CONF_PASSWORD_LEN];       /**< [en]Indicates conference password. [cn]会议密码 */
    }HwmScanJoinConfResult;

    /**
    * [en]This structure is used to describe query nonce result.
    * [cn]nonce信息
    */
    typedef struct tagHwmQueryNonceResult
    {
        char nonce[HWM_MAX_NONCE_LEN];              /**< [en]Indicates nonce. [cn]随机数 */
        char url[HWM_MAX_URL_LEN];                  /**< [en]Indicates url. [cn]url */
    }HwmQueryNonceResult;

    /**
    * [en]Pair link info
    * [cn]配对链路信息
    */
    typedef struct tagHwmPairLinkInfo
    {
        char userId[HWM_MAX_USER_ID_LEN];              /**< [en]User Id.
                                                            [cn]userId 控制（手机号码或邮箱）
                                                            [cs_allowNull:N] */
        char userAgent[HWM_MAX_USERAGENT_LEN];         /**< [en]userAgent. 
                                                            [cn]用户类型，用于区分端类型
                                                            [cs_allowNull:N]*/
        char deviceId[HWM_MAX_DEVICE_UUID_LEN];        /**< [en]Device ID.
                                                            [cn]设备ID */
        char deviceName[HWM_MAX_USER_NAME_LEN];        /**< [en]Device name.
                                                            [cn]设备名称 */
        char userName[HWM_MAX_USER_NAME_LEN];          /**< [en]User name.
                                                            [cn]用户名称 */
        HwmPairMode pairMode;                          /**< [en]PairMode
                                                            [cn]临时/固定配对关系 */
        bool isOffline;                                /**< [en]Is offline
                                                            [cn]是否离线 */
    } HwmPairLinkInfo;

    /**
    * [en]Pair link list info
    * [cn]配对链路列表信息
    */
    typedef struct tagHwmPairLinkListInfo
    {
        unsigned int  numOfPairLinks;                 /**< [en]Num of pairLinks
                                                         [cn]配对链路个数
                                                         [length for pairLinks] */
        HwmPairLinkInfo* pairLinks;                 /**< [en]PairLinks info. 
                                                         [cn]绑定的列表 */
    } HwmPairLinkListInfo;

    /**
    * [en]This struct is used to describe Nss survey info.
    * [cn]NSS满意度评价信息
    */
    typedef struct tagHwmNssSurveyInfo
    {
        char confId[HWM_MAX_CONF_ID_LEN];        /**< [en]Indicates when creating a meeting, add the create request ID in the call-id field to differentiate multiple sessions created simultaneously.
                                                      [cn]在创建会议时，在call-id字段添加创建请求ID，用于区分同时创建的多个会议 */
        char subName[HWM_MAX_SUBNAME_LEN];       /**< [en]Indicates question description. [cn]问题描述 */
        char subRemark[HWM_MAX_SUBREMARK_LEN];   /**< [en]Indicates remark. [cn]备注 */
    }HwmNssSurveyInfo;

    /**
    * [en]Pair verify code info
    * [cn]配对验证码信息
    */
    typedef struct tagHwmPairVerifyCodeInfo
    {
        char verifyCode[HWM_MAX_VER_CODE_LEN];                  /**< [en]Verify code
                                                                         [cn]验证码 */
        int expireTime;                                       /**< [en]Expire time
                                                                         [cn]过期时间 */
        HwmState displayState;                                      /**< [en]Display state
                                                                         [cn]显示状态 */
    } HwmPairVerifyCodeInfo;

    /**
    * [en]This struct is used to describe conference control info.
    * [cn]会控操作信息
    */
    typedef struct tagHwmConfCtrlInfo
    {
        ConfCtrlType confCtrlType;                             /**< [en]Indicates conference control type.
                                                                    [cn]会控操作类型 */
        bool isOpen;                                       /**< [en] Is open
                                                                    [cn] 是否开启 */
    }HwmConfCtrlInfo;

    /**
    * [en]This structure is used to describe get cpu performance level result.
    * [cn]获取cpu表现性能的结果
    */
    typedef struct tagHwmCpuLevelResult
    {
        HwmCpuLevel cpuLevel;               /**< [en]Cpu level
                                                 [cn]cpu等级 */
    }HwmCpuLevelResult;

    /**
    * [en]This structure is used to describe get error code and error describe result.
    * [cn]错误码和错误描述的结果
    */
    typedef struct tagHwmErrorResult
    {
        int result;                               /**< [en]Error code.
                                                             [cn]错误码 */
        char reasonDesc[HWM_MAX_REASON_LEN];        /**< [en]Error describe.
                                                             [cn]错误描述 */
    }HwmErrorResult;

    /**
    * [en]Error info.
    * [cn]错误信息
    */
    typedef struct tagHwmErrorInfo
    {
        HwmErrorShowType errorShowType;                         /**< [en]Error show type
                                                                     [cn]错误提示类型 */
        char errorMessage[HWM_MAX_ERROR_MESSAGE_LEN];           /**< [en]Error message
                                                                     [cn]错误提示，注：UTF8编码 */
    }HwmErrorInfo;

    /**
    * [en]Custom path info.
    * [cn]自定义路径信息
    */
    typedef struct tagHwmCustomPathInfo
    {
        HwmCustomPathType customPathType;                   /**< [en]custom path type
                                                                 [cn]自定义路径类型
                                                                 [cs_allowNull:N] */
        char path[HWM_MAX_FILE_PATH_LEN];               /**< [en]custom path
                                                                 [cn]保存路径，注：绝对路径，需要UTF8编码
                                                                 [cs_allowNull:N] */
    }HwmCustomPathInfo;

    /**
    * [en]Noise reduce setting.
    * [cn]降噪配置项
    */
    typedef struct tagHwmNoiseReduceSettings
    {
        HwmNoiseReduceLevel level;               /**< [en]Noise reduce level
                                                 [cn]降噪等级 */
    }HwmNoiseReduceSettings;

    /**
    * [en]This structure is used to describe end projection param.
    * [cn]结束投屏参数体
    */
    typedef struct tagHwmEndProjectionParam
    {
        HwmEndProjectionConfMode mode;                  /**< [en]Indicates end projection conf mode.
                                                             [cn]结束投屏类型
                                                             [cs_allowNull:N] */
    }HwmEndProjectionParam;

    /**
    * [en]This structure is used to describe query spes info result
    * [cn]查询Spes信息结果
    */
    typedef struct tagHwmSpesInfoResult {
        bool                isSpesExternalAccess;                              /**< [en]Indicates whether is spes external access.
                                                                                        [cn]是否spes外网接入*/
    }HwmSpesInfoResult;

    /**
    * [en]This struct is used to describe abnormal leave meeting info
    * [cn]异常断开的会议信息
    */
    typedef struct tagHwmAbnormalLeaveMeetingInfo
    {
        char  confId[HWM_MAX_CONF_ID_LEN];                                     /**< [en]Indicates conference id.
                                                                                        [cn]会议id */
        char  confPwd[HWM_MAX_PASSWORD_LEN];                                   /**< [en]Indicates conference password.
                                                                                        [cn]会议密码 */
    }HwmAbnormalLeaveMeetingInfo;

    /**
    * [en]This structure is used to describe external invitee info
    * [cn]外部与会者信息
    */
    typedef struct tagHwmExternalInvitee {
        char name[HWM_MAX_USER_NAME_LEN];              /**< [en]Indicates name.
                                                            [cn]可选，与会者名称 */
        char aliasCN[HWM_MAX_DISPLAY_NAME_LEN];        /**< [en]Indicates chinese alias.
                                                            [cn]可选，中文别名 */
        char aliasEN[HWM_MAX_DISPLAY_NAME_LEN];        /**< [en]Indicates english alias.
                                                            [cn]可选，英文别名 */
        char extendedField[HWM_MAX_EXTENDED_FIELD_LEN];/**< [en]Indicates extended field.
                                                            [cn]扩展字段 */
        char acountId[HWM_MAX_ACCOUNT_LEN];            /**< [en]Indicates account id.
                                                            [cn]可选，华为云会议账号 */
        char number[HWM_MAX_NUMBER_LEN];               /**< [en]Indicates number.
                                                            [cn]号码 */
        char userUuid[HWM_MAX_USER_NAME_LEN];          /**< [en]Indicates user account
                                                            [cn]与会唯一标识 */
        char orgId[HWM_MAX_ORG_ID_LENGTH];             /**< [en]Indicates org id.
                                                            [cn]企业id */   
        HwmPrivateClientDeviceType clientDeviceType;   /**< [en]Indicates client device type.
                                                            [cn]终端登录类型  */
        HwmPrivateAttendeeType attendeeType;           /**< [en]Indicates attendee type.
                                                            [cn]成员类型 */
        HwmInviteeState state;                         /**< [en]Indicates attendee state.
                                                            [cn]成员状态 */
    }HwmExternalInvitee;

    /**
    * [en]This struct is used to update exteranl invitees.
    * [cn]外部与会者列表信息
    */
    typedef struct tagHwmExternalInviteesInfo
    {
        HwmExternalInvitee* inviteesList;             /**< [en]inviteesList list
                                                           [cn]外部被邀请者 */
        unsigned int inviteesLength;                    /**< [en]Num of inviteesList
                                                           [cn]外部被邀人数
                                                           [length for inviteesList] */
    }HwmExternalInviteesInfo;

    /**
    * [en]This struct is used to operate exteranl invitees.
    * [cn]外部与会者操作信息
    */
    typedef struct tagHwmOperateExternalInviteeInfo
    {
        HwmOperateExternalInviteeType type;              /**< [en]operate type
                                                           [cn]邀请类型
                                                           [cs_allowNull:N]*/
        HwmExternalInvitee invitee;                   /**< [en]external invite
                                                           [cn]邀请者信息
                                                           [cs_allowNull:N]*/
    }HwmOperateExternalInviteeInfo;

    /**
    * [en]This struct is used to describe complain info
    * [cn]举报投诉信息结果
    */
    typedef struct tagHwmComplainInfo
    {
        char  deviceId[HWM_MAX_DEVICE_ID_LEN];                                 /**< [en]Indicates device id.
                                                                                        [cn]当前设备id */
        char  confId[HWM_MAX_CONF_ID_LEN];                                     /**< [en]Indicates conference id.
                                                                                        [cn]会议id */
        char  confSubject[HWM_MAX_SUBJECT_LEN];                                /**< [en]Indicates conference subject.
                                                                                        [cn]会议主题 */
        char  userUuid[HWM_MAX_USER_NAME_LEN];                                /**< [en]Indicates complain user uuid.
                                                                                        [cn]被举报的用户uuid */
        char  userName[HWM_MAX_USERNAME_LEN];                                /**< [en]Indicates complain user name.
                                                                                        [cn]被举报的用户名称 */
        int centerX;                                                         /**< [en]Indicates the x-coordinate of the center position.
                                                                                        [cn]建议举报弹窗显示的中心位置x坐标*/
        int centerY;                                                         /**< [en]Indicates the y-coordinate of the center position.
                                                                                        [cn]建议举报弹窗显示的中心位置y坐标*/
        bool isAIGC;                                                         /**< [en]Indicates is aigc or not.
                                                                                        [cn]是否AIGC内容*/
    }HwmComplainInfo;

    /**
    * [en]This structure is used to describe query version info
    * [cn]查询版本请求信息
    */
    typedef struct tagHwmVersionInfo {
        unsigned int            serverPort;                                          /**< [en]Indicates the server port. 
                                                                                        [cn]服务器端口号 
                                                                                        [cs_allowNull:Y] */
        char              serverUrl[HWM_MAX_URL_LEN];                          /**< [en]Indicates the server address. 
                                                                                        [cn]服务器地址 
                                                                                        [cs_allowNull:Y][cs_length:0-256] */
        char              userAccount[HWM_MAX_NAME_LEN];                       /**< [en]Indicates the account. 
                                                                                        [cn]账号 
                                                                                        [cs_allowNull:Y][cs_length:0-256] */
        char              softwareType[HWM_MAX_PRODUCT_NAME_LEN];              /**< [en]Indicates the software type. 
                                                                                        [cn]软终端类型
                                                                                        [cs_allowNull:Y][cs_length:0-256] */
        char              currentVersion[HWM_MAX_SOFTWARE_VER_LEN];            /**< [en]Indicates the server version. 
                                                                                        [cn]当前软终端版本号版本 
                                                                                        [cs_allowNull:Y][cs_length:0-128] */
        unsigned int            lastestLoginedType;                                  /**< [en]Indicates the latest logined server type, 1 indicate mdx, 2 indicate cms. 
                                                                                        [cn]上次登录服务器类型,1表示cms,2表示mdx
                                                                                        [cs_allowNull:Y] */
    }HwmVersionInfo;

    /**
    * [en]This structure is used to describe org name info
    * [cn]组织名信息
    */
    typedef struct tagHwmOrgNameInfo {
        char              name[HWM_MAX_ORG_NAME_LEN];                          /**< [en]Indicates the org name
                                                                                        [cn]组织名
                                                                                        [cs_allowNull:Y][cs_length:0-512] */
    }HwmOrgNameInfo;

    /**
    * [en]This structure is used to describe query version result
    * [cn]查询版本请求结果
    */
    typedef struct tagHwmQueryVersionInfoResult {
        char              userAccount[HWM_MAX_NAME_LEN];                          /**<  [en]Indicates the account. 
                                                                                            [cn]账号 */
        char              softwareType[HWM_MAX_PRODUCT_NAME_LEN];                 /**<  [en]Indicates the software type. 
                                                                                            [cn]软终端类型*/
        char              upgradingVersion[HWM_MAX_SOFTWARE_VER_LEN];             /**<  [en]Indicates the version to be upgrading. 
                                                                                            [cn]待升级软终端版本号*/
        char              versionPath[HWM_MAX_URL_LEN];                           /**<  [en]Indicates the upgrading file path. 
                                                                                            [cn]待升级软终端版本路径*/
        char              versionDescription[HWM_MAX_VERSION_DESCRIPTION_LEN];    /**<  [en]Indicates the version modification description. 
                                                                                            [cn]版本修改描述*/
        bool              isForceUpgrade;                                         /**<  [en]Indicates whether is mandatory upgrade. 
                                                                                            [cn]是否为强制升级*/
        bool              isConsistent;                                           /**<  [en]Indicates whether is the same with newest version. 
                                                                                            [cn]是否版本一致*/
        char              redirectUrl[HWM_MAX_URL_LEN];                           /**<  [en]Indicates the redirect url. 
                                                                                            [cn]重定向地址 */
        char              serviceDomain[HWM_MAX_DOMAIN_LENGTH];                   /**<  [en]Indicates the service domain. 
                                                                                            [cn]服务器地址 */
        char              serviceIpList[HWM_MAX_DOMAIN_LENGTH];                   /**<  [en]IP list. 
                                                                                            [cn]ip列表，可能存在多个ip */
        char              versionDescriptionEn[HWM_MAX_VERSION_DESCRIPTION_LEN];  /**<  [en]Indicates the version modification description. 
                                                                                            [cn]版本修改英文描述*/
        char              minUpgradeVersion[HWM_MAX_UPGRADE_VERSION_LEN];         /**<  [en]Indicates the minimal upgrade version. 
                                                                                            [cn]最小升级版本*/
        char              minPlatformVersion[HWM_MAX_UPGRADE_VERSION_LEN];        /**<  [en]Indicates the minimal platform version. 
                                                                                            [cn]最小平台版本*/
        bool              isTrialVersion;                                         /**<  [en]Indicates whether is trial version. 
                                                                                            [cn]是否为试用版本*/
        unsigned int            orgNameLen;                                             /**<  [en]The size of orgNameList
                                                                                            [cn]组织名列表长度
                                                                                            [length for orgNameList] */
        HwmOrgNameInfo*       orgNameList;                                            /**<  [en]Indicates org name list.
                                                                                            [cn]组织名列表*/
    }HwmQueryVersionInfoResult;

    /**
    * [en]This struct is used to describe auto optimise info
    * [cn]自动优化信息
    */
    typedef struct tagHwmAutoOptimiseInfo
    {
        HwmIntegratorType type;                 /**< [en]Integrator type
                                                     [cn]集成方类型 */
    }HwmAutoOptimiseInfo;

    /**
    * [en]Third user info.
    * [cn]第三方用户信息
    */
    typedef struct tagHwmThirdUserInfo
    {
        char thirdUserInfoKey[HWM_MAX_THIRD_USER_INFO_KEY_LENGTH]; /**< [en]The third user info key.
                                                                            [cn]第三方用户信息key */
    }HwmThirdUserInfo;

    /**
    * [en]This struct is used to operate exteranl invitees.
    * [cn]外部与会者批量操作信息
    */
    typedef struct tagHwmCallAllExternalAttendeesInfo
    {
        HwmExternalInvitee *invitee;                    /**< [en]external invite
                                                             [cn]邀请者信息
                                                             [cs_allowNull:N]*/
        unsigned int count;                               /**< [en]size of 'invitee'
                                                             [cn]invitee 字段中与会者数量
                                                             [length for invitee]
                                                             [cs_allowNull:N]*/
    }HwmCallAllExternalAttendeesInfo;

    /**
    * [en]Start play audio file param
    * [cn]播放音频文件参数
    */
    typedef struct tagHwmStartPlayAudioFileParam
    {
        unsigned int loopTimes;                           /**< [en]loop time
                                                             [cn]循环次数 
                                                             [cs_allowNull:Y] */
        char filePath[HWM_MAX_FILE_PATH_LEN];       /**< [en]file path
                                                             [cn]文件路径，注：绝对路径，需要UTF8编码 */
    }HwmStartPlayAudioFileParam;

    /**
    * [en]Share audio state info
    * [cn]共享音频状态信息
    */
    typedef struct tagHwmShareAudioStateInfo
    {
        bool isOpen;                            /**< [en]Is open
                                                         [cn]是否开启 */
    } HwmShareAudioStateInfo;

    /**
    * [en]This structure is used to describe screen content swap state info
    * [cn]会中交换屏幕信息
    */
    typedef struct tagHwmScreenContentSwapInfo {
        bool                isSwapped;          /**< [en]Indicates whether is screen content swapped.
                                                         [cn]屏幕是否已交换 */
    }HwmScreenContentSwapInfo;

    /**
    * [en]This struct is used to describe jwt token info.
    * [cn]本地鉴权token信息
    */
    typedef struct tagHwmJwtTokenInfo
    {
        char jwtToken[HWM_MAX_JWT_TOKEN_LEN];            /**< [en]Indicates the jwt token
                                                                  [cn]本地鉴权token */
    }HwmJwtTokenInfo;

/* auto generate code insert 1, forbit delete */
}

#endif /* _HWM_AGENT_NOTIFY_DEF_H_ */
