#pragma once

#include <sstream>

#ifdef TEST_DEBUG
#include "HwmEncryptionDemoDebug.h"
#endif

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif /*  __cpluscplus */
#endif /*  __cpluscplus */

#include <string.h>

#define API_EXPORT __declspec(dllexport)

#ifndef TEST_DEBUG
#define CHECK_MEDIA_DATA(data) { if (data == nullptr || data->buffer == nullptr || data->dataSize == 0 || data->bufferSize == 0) return ; }
#define TEST_LOG() std::ostringstream os; os
#endif

#define MEDIA_DATA_SUCC             0       /* 成功 */
#define MEDIA_DATA_IS_NULL          -1      /* data为空或长度为0 */
#define MEDIA_DATA_SEC_FAILED       -2      /* 安全函数失败 */
#define MEDIA_DATA_OVERFLOW         -3      /* 超过最大缓冲区长度, 溢出 */
typedef struct tagHwmMediaFrameBuffer
{
    unsigned char *buffer;     /**< [en]Indicates media frame buffer. [cn]音视频码流缓冲区地址 */
    unsigned int dataSize;     /**< [en]Indicates size of media frame buffer. [cn]音视频原始码流长度 */
    unsigned int bufferSize;   /**< [en]Indicates size of media frame buffer. [cn]音视频码流缓冲区长度，加解密后不能超出这个长度 */
}HwmMediaFrameBuffer;


API_EXPORT void VideoEncryptionFunc(HwmMediaFrameBuffer* data);
API_EXPORT void AudioEncryptionFunc(HwmMediaFrameBuffer* data);
API_EXPORT void VideoDecryptionFunc(HwmMediaFrameBuffer* data);
API_EXPORT void AudioDecryptionFunc(HwmMediaFrameBuffer* data);

#ifdef __cplusplus
#if __cplusplus
}
#endif /*  __cpluscplus */
#endif /*  __cpluscplus */

static int SafeCopy(HwmMediaFrameBuffer* data, const unsigned char* input, unsigned int inputSize)
{
    if (data == nullptr || input == nullptr || inputSize == 0)
    {
        TEST_LOG() << "SafeCopy data is null!\n";
        if (data != nullptr)
        {
            TEST_LOG() << "buf data size: " << data->dataSize << ", input size: " << inputSize << "\n";
        }
        return MEDIA_DATA_IS_NULL;
    }

    if (data->bufferSize < inputSize)
    {
        TEST_LOG() << "SafeCopy overflow!\n";
        return MEDIA_DATA_OVERFLOW;
    }

    errno_t secRet = memcpy_s(data->buffer, sizeof(unsigned char) * inputSize, input, sizeof(unsigned char) * inputSize);
    if (secRet != 0)
    {
        TEST_LOG() << "SafeCopy sec failed!\n";
        data->dataSize = 0;
        return MEDIA_DATA_SEC_FAILED;
    }
    data->dataSize = inputSize;
    return MEDIA_DATA_SUCC;
} 