/*
 * Copyright 2019-2022 The OpenSSL Project Authors. All Rights Reserved.
 *
 * Licensed under the Apache License 2.0 (the "License").  You may not use
 * this file except in compliance with the License.  You can obtain a copy
 * in the file LICENSE in the source distribution or at
 * https://www.openssl.org/source/license.html
 */

#ifndef OPENSSL_ISO19790_H
# define OPENSSL_ISO19790_H
#ifdef OPENSSL_PRAGMA_ONCE
# pragma once
#endif

# include <openssl/types.h>
# ifdef __cplusplus
extern "C" {
# endif

# define OSSL_SELF_TEST_PHASE_OPERATION     "Operation"

#define OSSL_OPERATION_TYPE_SIGN                "OPERATION_Sign"
#define OSSL_OPERATION_TYPE_VERIFY              "OPERATION_Verify"
#define OSSL_OPERATION_TYPE_VERIFYRECOVER       "OPERATION_Verifyrecover"
#define OSSL_OPERATION_TYPE_ENCAPSULATE         "OPERATION_ENCAPSULATE"
#define OSSL_OPERATION_TYPE_DECAPSULATE         "OPERATION_DECAPSULATE"
#define OSSL_OPERATION_TYPE_KEY_GEN             "OPERATION_Gen_Keypair"
#define OSSL_OPERATION_TYPE_KEY_DERIVE          "OPERATION_Key_Derive"
#define OSSL_OPERATION_TYPE_KDF_DERIVE          "OPERATION_Kdf_Derive"
#define OSSL_OPERATION_TYPE_ENCRYPT             "OPERATION_Encrypt"
#define OSSL_OPERATION_TYPE_DECRYPT             "OPERATION_Decrypt"
#define OSSL_OPERATION_TYPE_ASYM_ENCRYPT        "OPERATION_Asym_Encrypt"
#define OSSL_OPERATION_TYPE_ASYM_DECRYPT        "OPERATION_Asym_Decrypt"
#define OSSL_OPERATION_TYPE_DIGEST              "OPERATION_Digest"
#define OSSL_OPERATION_TYPE_MAC                 "OPERATION_Mac"
#define OSSL_OPERATION_TYPE_CSP_ZERO            "OPERATION_CSP_Zero"
#define OSSL_OPERATION_TYPE_RAND_INSTANTIACE    "OPERATION_Rand_Instantiace"
#define OSSL_OPERATION_TYPE_RAND_RESEED         "OPERATION_Rand_Reseed"
#define OSSL_OPERATION_TYPE_RAND_GENERATE       "OPERATION_Rand_Generate"

#define OSSL_OPERATION_ALG_TYPE_CTR_DRBG        "CTR-DRBG"
#define OSSL_OPERATION_ALG_TYPE_HASH_DRBG       "HASH-DRBG"
#define OSSL_OPERATION_ALG_TYPE_HMAC_DRBG       "HMAC-DRBG"
#define OSSL_OPERATION_ALG_TYPE_RSA             "RSA"
#define OSSL_OPERATION_ALG_TYPE_ECC             "ECC"
#define OSSL_OPERATION_ALG_TYPE_ECDSA           "ECDSA"
#define OSSL_OPERATION_ALG_TYPE_ECDH            "ECDH"
#define OSSL_OPERATION_ALG_TYPE_EDDSA           "EDDSA"
#define OSSL_OPERATION_ALG_TYPE_ECX             "ECX"
#define OSSL_OPERATION_ALG_TYPE_ECXDH           "ECXDH"
#define OSSL_OPERATION_ALG_TYPE_DH              "DH"
#define OSSL_OPERATION_ALG_TYPE_DSA             "DSA"
#define OSSL_OPERATION_ALG_TYPE_KDF             "KDF"
#define OSSL_OPERATION_ALG_TYPE_HASH            "HASH"
#define OSSL_OPERATION_ALG_TYPE_CIPHER          "CIPHER"
#define OSSL_OPERATION_ALG_TYPE_HMAC            "HMAC"
#define OSSL_OPERATION_ALG_TYPE_GMAC            "GMAC"
#define OSSL_OPERATION_ALG_TYPE_CMAC            "CMAC"

# define OSSL_SELF_TEST_TYPE_MAC                "KAT_MAC"

# define OSSL_SELF_TEST_DESC_KA_ECXDH           "ECXDH"
# define OSSL_SELF_TEST_DESC_MAC_HMAC           "HMAC"
# define OSSL_SELF_TEST_DESC_PCT_EDDSA          "EDDSA"

typedef struct iso_test_cb_param_st {
    void *arg;
    const OSSL_DISPATCH *seed_dispatch;
    double rate; // entropy rate
} ISO_TEST_CB_PARAM;

# ifdef __cplusplus
}
# endif
#endif /* OPENSSL_ISO19790_H */
