// demoJoinConfByIdDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "demo.h"
#include "demoJoinConfByIdDlg.h"
#include "afxdialogex.h"
#include "demoTools.h"
#include "HwmSdkAgent.h"

// demoJoinConfByIdDlg Ի

IMPLEMENT_DYNAMIC(demoJoinConfByIdDlg, CDialogEx)

demoJoinConfByIdDlg::demoJoinConfByIdDlg(CWnd* pParent /*=NULL*/)
    : CDialogEx(IDD_JOIN_CONF_BY_ID_DIALOG, pParent)
    , m_enterType(0)
    , m_confPrefix(_T(""))
    , m_isCascadingMeeting(FALSE)
{

}

demoJoinConfByIdDlg::~demoJoinConfByIdDlg()
{
}

void demoJoinConfByIdDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_JOIN_MEETING_ID, m_confIdEdit);
    DDX_Control(pDX, IDC_EDIT_JOIN_MEETING_PASSWORD, m_psdEdit);
    DDX_Control(pDX, IDC_EDIT_JOIN_CONF_DOMAIN, m_domainEdit);
    DDX_Control(pDX, IDC_EDIT_JOIN_MEETING_NAME, m_nameEdit);
    DDX_Control(pDX, IDC_EDIT_JOIN_MEETING_ALIASCN, m_aliasCNEdit);
    DDX_Control(pDX, IDC_EDIT_JOIN_MEETING_ALIASEN, m_aliasENEdit);
    DDX_Control(pDX, IDC_EDIT_JOIN_MEETING_CORPTRUSTAPPID, m_corpTrustAppIdEdit);
    DDX_Radio(pDX, IDC_RADIO_ENTER_TYPE_ACCOUNT2, m_enterType);
    DDX_Control(pDX, IDC_CHECK_ID_CAM, m_CamCheck);
    DDX_Control(pDX, IDC_CHECK_ID_MIC, m_MicCheck);
    DDX_Control(pDX, IDC_CHECK_ID_SPK, m_SpkCheck);
    DDX_Control(pDX, IDC_CHECK_STOP_CONFICTCONF, m_IsStopConflictConf);
    DDX_Text(pDX, IDC_EDIT_CONF_PREFIX, m_confPrefix);
    DDX_Check(pDX, IDC_IS_CASCADING_MEETING, m_isCascadingMeeting);
}


BEGIN_MESSAGE_MAP(demoJoinConfByIdDlg, CDialogEx)
    ON_BN_CLICKED(IDCANCEL, &demoJoinConfByIdDlg::OnBnClickedCancel)
    ON_BN_CLICKED(IDOK, &demoJoinConfByIdDlg::OnBnClickedOk)
    ON_BN_CLICKED(IDC_RADIO_ENTER_TYPE_ACCOUNT2, &demoJoinConfByIdDlg::OnBnClickedRadioEnterTypeAccount2)
    ON_BN_CLICKED(IDC_RADIO_ENTER_TYPE_RANDOM2, &demoJoinConfByIdDlg::OnBnClickedRadioEnterTypeRandom2)
END_MESSAGE_MAP()


// demoJoinConfByIdDlg Ϣ


void demoJoinConfByIdDlg::OnBnClickedCancel()
{
    // TODO: ڴӿؼ֪ͨ
    CDialogEx::OnCancel();
}

int demoJoinConfByIdDlg::clickJoinConfById()
{
    UpdateData(1);
    m_confIdEdit.GetWindowText(m_confId);
    m_psdEdit.GetWindowText(m_psd);
    m_domainEdit.GetWindowText(m_domain);
    m_nameEdit.GetWindowText(m_name);
    m_aliasCNEdit.GetWindowText(m_aliasCN);
    m_aliasENEdit.GetWindowText(m_aliasEN);
    m_corpTrustAppIdEdit.GetWindowText(m_corpTrustAppId);    

    string meetingID = CTools::UNICODE2UTF(m_confId.GetString());
    string accessCode = CTools::UNICODE2UTF(m_psd.GetString());
    string domain = CTools::UNICODE2UTF(m_domain.GetString());
    string name = CTools::UNICODE2UTF(m_name.GetString());
    string aliasCN = CTools::UNICODE2UTF(m_aliasCN.GetString());
    string aliasEN = CTools::UNICODE2UTF(m_aliasEN.GetString());
    string corpTrustAppId = CTools::UNICODE2UTF(m_corpTrustAppId.GetString());
    string confPrefix = CTools::UNICODE2UTF(m_confPrefix.GetString());

    bool isOpenCam = m_CamCheck.GetCheck() == 1 ? true : false;
    bool isOpenMic = m_MicCheck.GetCheck() == 1 ? true : false;
    bool isCloseSpk = m_SpkCheck.GetCheck() == 1 ? false : true;
    bool isStopConflictConf = m_IsStopConflictConf.GetCheck() == 1;

    int ret = 0;
    if (m_enterType == 0){
        if (accessCode.length() >= HWM_MAX_CONF_PASSWORD_LEN || meetingID.length() >= HWM_MAX_CONF_ID_LEN)
        {
            return 1;
        }
        hwmsdkagent::HwmJoinConfByIdInfo data;
        memset(&data, 0, sizeof(hwmsdkagent::HwmJoinConfByIdInfo));
        strncpy_s(data.confId, meetingID.c_str(), HWM_MAX_CONF_ID_LEN);
        strncpy_s(data.password, accessCode.c_str(), HWM_MAX_CONF_PASSWORD_LEN);
        data.isCloseSpk = isCloseSpk;
        data.isStopConflictConf = isStopConflictConf;
        data.isCascadingMeeting = m_isCascadingMeeting;
        strncpy_s(data.name, name.c_str(), HWM_MAX_DISPLAY_NAME_LEN);
        strncpy_s(data.aliasCN, aliasCN.c_str(), HWM_MAX_DISPLAY_NAME_LEN);
        strncpy_s(data.aliasEN, aliasEN.c_str(), HWM_MAX_DISPLAY_NAME_LEN);
        strncpy_s(data.corpTrustAppId, corpTrustAppId.c_str(), HWM_MAX_CORP_TRUST_APP_ID_LEN);
        strncpy_s(data.confPrefix, confPrefix.c_str(), HWM_MAX_CORP_TRUST_APP_ID_LEN);
        //˷ͷ
        ret = EnableFeature(hwmsdkagent::HWM_ENABLE_FEATURE_TYPE_MIC_SWITCH, isOpenMic);
        if (hwmsdk::HWM_COMMON_SUCCESS != ret)
        {
            CTools::OutputRetStr("set enable micphone failed");
            return 1;
        }
        ret = EnableFeature(hwmsdkagent::HWM_ENABLE_FEATURE_TYPE_CAM_SWITCH, isOpenCam);
        if (hwmsdk::HWM_COMMON_SUCCESS != ret)
        {
            CTools::OutputRetStr("set enable camera failed");
            return 1;
        }
        ret = hwmsdkagent::JoinConfById(&data);
        memset(&data, 0, sizeof(hwmsdkagent::HwmJoinConfByIdInfo));
    } else {
        if (accessCode.length() > HWM_MAX_RANDOM_LEN || meetingID.length() > HWM_MAX_CONF_ID_LEN) {
            return 1;
        }
        hwmsdkagent::HwmJoinConfByRandomInfo data;
        memset(&data, 0, sizeof(hwmsdkagent::HwmJoinConfByRandomInfo));
        strncpy_s(data.confId, meetingID.c_str(), HWM_MAX_CONF_ID_LEN);
        strncpy_s(data.random, accessCode.c_str(), HWM_MAX_RANDOM_LEN);
        strncpy_s(data.domain, domain.c_str(), HWM_MAX_DOMAIN_LEN);
        strncpy_s(data.name, name.c_str(), HWM_MAX_DISPLAY_NAME_LEN);
        data.isCloseSpk = isCloseSpk;
        //˷ͷ
        ret = EnableFeature(hwmsdkagent::HWM_ENABLE_FEATURE_TYPE_MIC_SWITCH, isOpenMic);
        if (hwmsdk::HWM_COMMON_SUCCESS != ret)
        {
            CTools::OutputRetStr("set enable micphone failed");
            return 1;
        }
        ret = EnableFeature(hwmsdkagent::HWM_ENABLE_FEATURE_TYPE_CAM_SWITCH, isOpenCam);
        if (hwmsdk::HWM_COMMON_SUCCESS != ret)
        {
            CTools::OutputRetStr("set enable camera failed");
            return 1;
        }
        ret = hwmsdkagent::JoinConfByRandom(&data);
        memset(&data, 0, sizeof(hwmsdkagent::HwmJoinConfByRandomInfo));
    }

    accessCode = "******";
    
    return ret;
}

void demoJoinConfByIdDlg::OnBnClickedOk()
{
    int ret = clickJoinConfById();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("Join meeting error");
        return;
    }
    CDialogEx::OnOK();
}


void demoJoinConfByIdDlg::OnBnClickedRadioEnterTypeAccount2()
{
    // TODO: ڴӿؼ֪ͨ
    m_enterType = 0;
}


void demoJoinConfByIdDlg::OnBnClickedRadioEnterTypeRandom2()
{
    // TODO: ڴӿؼ֪ͨ
    m_enterType = 1;
}


BOOL demoJoinConfByIdDlg::OnInitDialog()
{
    CDialogEx::OnInitDialog();

    // TODO:  ڴӶĳʼ
    //˷硢Ĭϴ򿪣ͷĬϹر
    m_CamCheck.SetCheck(FALSE);
    m_MicCheck.SetCheck(TRUE);
    m_SpkCheck.SetCheck(TRUE);
    m_IsStopConflictConf.SetCheck(FALSE);
    return TRUE;  // return TRUE unless you set the focus to a control
                  // 쳣: OCX ҳӦ FALSE
}